package software.amazon.awscdk.services.cloudwatch;

/**
 * Factory functions for standard statistics strings.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Dashboard dashboard;
 * Metric executionCountMetric;
 * Metric errorCountMetric;
 * dashboard.addWidgets(GraphWidget.Builder.create()
 *         .title("Executions vs error rate")
 *         .left(List.of(executionCountMetric))
 *         .right(List.of(errorCountMetric.with(MetricOptions.builder()
 *                 .statistic(Stats.AVERAGE)
 *                 .label("Error rate")
 *                 .color(Color.GREEN)
 *                 .build())))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:47.564Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.Stats")
public abstract class Stats extends software.amazon.jsii.JsiiObject {

    protected Stats(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Stats(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AVERAGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudwatch.Stats.class, "AVERAGE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        IQM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudwatch.Stats.class, "IQM", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        MAXIMUM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudwatch.Stats.class, "MAXIMUM", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        MINIMUM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudwatch.Stats.class, "MINIMUM", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SAMPLE_COUNT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudwatch.Stats.class, "SAMPLE_COUNT", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        SUM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudwatch.Stats.class, "SUM", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Stats() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * A shorter alias for <code>percentile()</code>.
     * <p>
     * @param percentile This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String p(final @org.jetbrains.annotations.NotNull java.lang.Number percentile) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Stats.class, "p", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(percentile, "percentile is required") });
    }

    /**
     * Percentile indicates the relative standing of a value in a dataset.
     * <p>
     * Percentiles help you get a better understanding of the distribution of your metric data.
     * <p>
     * For example, <code>p(90)</code> is the 90th percentile and means that 90% of the data
     * within the period is lower than this value and 10% of the data is higher
     * than this value.
     * <p>
     * @param percentile This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String percentile(final @org.jetbrains.annotations.NotNull java.lang.Number percentile) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Stats.class, "percentile", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(percentile, "percentile is required") });
    }

    /**
     * Percentile rank (PR) is the percentage of values that meet a fixed threshold.
     * <p>
     * <ul>
     * <li>If two numbers are given, they define the lower and upper bounds in absolute values,
     * respectively.</li>
     * <li>If one number is given, it defines the upper bound (the lower bound is assumed to
     * be 0).</li>
     * </ul>
     * <p>
     * For example, <code>percentileRank(300)</code> returns the percentage of data points that have a value of 300 or less.
     * <code>percentileRank(100, 2000)</code> returns the percentage of data points that have a value between 100 and 2000.
     * <p>
     * @param v1 This parameter is required.
     * @param v2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String percentileRank(final @org.jetbrains.annotations.NotNull java.lang.Number v1, final @org.jetbrains.annotations.Nullable java.lang.Number v2) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Stats.class, "percentileRank", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(v1, "v1 is required"), v2 });
    }

    /**
     * Percentile rank (PR) is the percentage of values that meet a fixed threshold.
     * <p>
     * <ul>
     * <li>If two numbers are given, they define the lower and upper bounds in absolute values,
     * respectively.</li>
     * <li>If one number is given, it defines the upper bound (the lower bound is assumed to
     * be 0).</li>
     * </ul>
     * <p>
     * For example, <code>percentileRank(300)</code> returns the percentage of data points that have a value of 300 or less.
     * <code>percentileRank(100, 2000)</code> returns the percentage of data points that have a value between 100 and 2000.
     * <p>
     * @param v1 This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String percentileRank(final @org.jetbrains.annotations.NotNull java.lang.Number v1) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Stats.class, "percentileRank", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(v1, "v1 is required") });
    }

    /**
     * Shorter alias for <code>percentileRank()</code>.
     * <p>
     * @param v1 This parameter is required.
     * @param v2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String pr(final @org.jetbrains.annotations.NotNull java.lang.Number v1, final @org.jetbrains.annotations.Nullable java.lang.Number v2) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Stats.class, "pr", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(v1, "v1 is required"), v2 });
    }

    /**
     * Shorter alias for <code>percentileRank()</code>.
     * <p>
     * @param v1 This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String pr(final @org.jetbrains.annotations.NotNull java.lang.Number v1) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Stats.class, "pr", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(v1, "v1 is required") });
    }

    /**
     * Shorter alias for <code>trimmedCount()</code>.
     * <p>
     * @param p1 This parameter is required.
     * @param p2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String tc(final @org.jetbrains.annotations.NotNull java.lang.Number p1, final @org.jetbrains.annotations.Nullable java.lang.Number p2) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Stats.class, "tc", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(p1, "p1 is required"), p2 });
    }

    /**
     * Shorter alias for <code>trimmedCount()</code>.
     * <p>
     * @param p1 This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String tc(final @org.jetbrains.annotations.NotNull java.lang.Number p1) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Stats.class, "tc", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(p1, "p1 is required") });
    }

    /**
     * A shorter alias for <code>trimmedMean()</code>.
     * <p>
     * @param p1 This parameter is required.
     * @param p2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String tm(final @org.jetbrains.annotations.NotNull java.lang.Number p1, final @org.jetbrains.annotations.Nullable java.lang.Number p2) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Stats.class, "tm", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(p1, "p1 is required"), p2 });
    }

    /**
     * A shorter alias for <code>trimmedMean()</code>.
     * <p>
     * @param p1 This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String tm(final @org.jetbrains.annotations.NotNull java.lang.Number p1) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Stats.class, "tm", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(p1, "p1 is required") });
    }

    /**
     * Trimmed count (TC) is the number of data points in the chosen range for a trimmed mean statistic.
     * <p>
     * <ul>
     * <li>If two numbers are given, they define the lower and upper bounds in percentages,
     * respectively.</li>
     * <li>If one number is given, it defines the upper bound (the lower bound is assumed to
     * be 0).</li>
     * </ul>
     * <p>
     * For example, <code>tc(90)</code> returns the number of data points not including any
     * data points that fall in the highest 10% of the values. <code>tc(10, 90)</code>
     * returns the number of data points not including any data points that fall
     * in the lowest 10% of the values and the highest 90% of the values.
     * <p>
     * @param p1 This parameter is required.
     * @param p2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String trimmedCount(final @org.jetbrains.annotations.NotNull java.lang.Number p1, final @org.jetbrains.annotations.Nullable java.lang.Number p2) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Stats.class, "trimmedCount", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(p1, "p1 is required"), p2 });
    }

    /**
     * Trimmed count (TC) is the number of data points in the chosen range for a trimmed mean statistic.
     * <p>
     * <ul>
     * <li>If two numbers are given, they define the lower and upper bounds in percentages,
     * respectively.</li>
     * <li>If one number is given, it defines the upper bound (the lower bound is assumed to
     * be 0).</li>
     * </ul>
     * <p>
     * For example, <code>tc(90)</code> returns the number of data points not including any
     * data points that fall in the highest 10% of the values. <code>tc(10, 90)</code>
     * returns the number of data points not including any data points that fall
     * in the lowest 10% of the values and the highest 90% of the values.
     * <p>
     * @param p1 This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String trimmedCount(final @org.jetbrains.annotations.NotNull java.lang.Number p1) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Stats.class, "trimmedCount", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(p1, "p1 is required") });
    }

    /**
     * Trimmed mean (TM) is the mean of all values that are between two specified boundaries.
     * <p>
     * Values outside of the boundaries are ignored when the mean is calculated.
     * You define the boundaries as one or two numbers between 0 and 100, up to 10
     * decimal places. The numbers are percentages.
     * <p>
     * <ul>
     * <li>If two numbers are given, they define the lower and upper bounds in percentages,
     * respectively.</li>
     * <li>If one number is given, it defines the upper bound (the lower bound is assumed to
     * be 0).</li>
     * </ul>
     * <p>
     * For example, <code>tm(90)</code> calculates the average after removing the 10% of data
     * points with the highest values; <code>tm(10, 90)</code> calculates the average after removing the
     * 10% with the lowest and 10% with the highest values.
     * <p>
     * @param p1 This parameter is required.
     * @param p2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String trimmedMean(final @org.jetbrains.annotations.NotNull java.lang.Number p1, final @org.jetbrains.annotations.Nullable java.lang.Number p2) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Stats.class, "trimmedMean", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(p1, "p1 is required"), p2 });
    }

    /**
     * Trimmed mean (TM) is the mean of all values that are between two specified boundaries.
     * <p>
     * Values outside of the boundaries are ignored when the mean is calculated.
     * You define the boundaries as one or two numbers between 0 and 100, up to 10
     * decimal places. The numbers are percentages.
     * <p>
     * <ul>
     * <li>If two numbers are given, they define the lower and upper bounds in percentages,
     * respectively.</li>
     * <li>If one number is given, it defines the upper bound (the lower bound is assumed to
     * be 0).</li>
     * </ul>
     * <p>
     * For example, <code>tm(90)</code> calculates the average after removing the 10% of data
     * points with the highest values; <code>tm(10, 90)</code> calculates the average after removing the
     * 10% with the lowest and 10% with the highest values.
     * <p>
     * @param p1 This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String trimmedMean(final @org.jetbrains.annotations.NotNull java.lang.Number p1) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Stats.class, "trimmedMean", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(p1, "p1 is required") });
    }

    /**
     * Trimmed sum (TS) is the sum of the values of data points in a chosen range for a trimmed mean statistic.
     * <p>
     * It is equivalent to <code>(Trimmed Mean) * (Trimmed count)</code>.
     * <p>
     * <ul>
     * <li>If two numbers are given, they define the lower and upper bounds in percentages,
     * respectively.</li>
     * <li>If one number is given, it defines the upper bound (the lower bound is assumed to
     * be 0).</li>
     * </ul>
     * <p>
     * For example, <code>ts(90)</code> returns the sum of the data points not including any
     * data points that fall in the highest 10% of the values.  <code>ts(10, 90)</code>
     * returns the sum of the data points not including any data points that fall
     * in the lowest 10% of the values and the highest 90% of the values.
     * <p>
     * @param p1 This parameter is required.
     * @param p2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String trimmedSum(final @org.jetbrains.annotations.NotNull java.lang.Number p1, final @org.jetbrains.annotations.Nullable java.lang.Number p2) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Stats.class, "trimmedSum", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(p1, "p1 is required"), p2 });
    }

    /**
     * Trimmed sum (TS) is the sum of the values of data points in a chosen range for a trimmed mean statistic.
     * <p>
     * It is equivalent to <code>(Trimmed Mean) * (Trimmed count)</code>.
     * <p>
     * <ul>
     * <li>If two numbers are given, they define the lower and upper bounds in percentages,
     * respectively.</li>
     * <li>If one number is given, it defines the upper bound (the lower bound is assumed to
     * be 0).</li>
     * </ul>
     * <p>
     * For example, <code>ts(90)</code> returns the sum of the data points not including any
     * data points that fall in the highest 10% of the values.  <code>ts(10, 90)</code>
     * returns the sum of the data points not including any data points that fall
     * in the lowest 10% of the values and the highest 90% of the values.
     * <p>
     * @param p1 This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String trimmedSum(final @org.jetbrains.annotations.NotNull java.lang.Number p1) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Stats.class, "trimmedSum", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(p1, "p1 is required") });
    }

    /**
     * Shorter alias for <code>trimmedSum()</code>.
     * <p>
     * @param p1 This parameter is required.
     * @param p2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String ts(final @org.jetbrains.annotations.NotNull java.lang.Number p1, final @org.jetbrains.annotations.Nullable java.lang.Number p2) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Stats.class, "ts", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(p1, "p1 is required"), p2 });
    }

    /**
     * Shorter alias for <code>trimmedSum()</code>.
     * <p>
     * @param p1 This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String ts(final @org.jetbrains.annotations.NotNull java.lang.Number p1) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Stats.class, "ts", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(p1, "p1 is required") });
    }

    /**
     * Winsorized mean (WM) is similar to trimmed mean.
     * <p>
     * However, with winsorized mean, the values that are outside the boundary are
     * not ignored, but instead are considered to be equal to the value at the
     * edge of the appropriate boundary.  After this normalization, the average is
     * calculated. You define the boundaries as one or two numbers between 0 and
     * 100, up to 10 decimal places.
     * <p>
     * <ul>
     * <li>If two numbers are given, they define the lower and upper bounds in percentages,
     * respectively.</li>
     * <li>If one number is given, it defines the upper bound (the lower bound is assumed to
     * be 0).</li>
     * </ul>
     * <p>
     * For example, <code>tm(90)</code> calculates the average after removing the 10% of data
     * points with the highest values; <code>tm(10, 90)</code> calculates the average after removing the
     * 10% with the lowest and 10% with the highest values.
     * <p>
     * For example, <code>wm(90)</code> calculates the average while treating the 10% of the
     * highest values to be equal to the value at the 90th percentile.
     * <code>wm(10, 90)</code> calculates the average while treaing the bottom 10% and the
     * top 10% of values to be equal to the boundary values.
     * <p>
     * @param p1 This parameter is required.
     * @param p2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String winsorizedMean(final @org.jetbrains.annotations.NotNull java.lang.Number p1, final @org.jetbrains.annotations.Nullable java.lang.Number p2) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Stats.class, "winsorizedMean", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(p1, "p1 is required"), p2 });
    }

    /**
     * Winsorized mean (WM) is similar to trimmed mean.
     * <p>
     * However, with winsorized mean, the values that are outside the boundary are
     * not ignored, but instead are considered to be equal to the value at the
     * edge of the appropriate boundary.  After this normalization, the average is
     * calculated. You define the boundaries as one or two numbers between 0 and
     * 100, up to 10 decimal places.
     * <p>
     * <ul>
     * <li>If two numbers are given, they define the lower and upper bounds in percentages,
     * respectively.</li>
     * <li>If one number is given, it defines the upper bound (the lower bound is assumed to
     * be 0).</li>
     * </ul>
     * <p>
     * For example, <code>tm(90)</code> calculates the average after removing the 10% of data
     * points with the highest values; <code>tm(10, 90)</code> calculates the average after removing the
     * 10% with the lowest and 10% with the highest values.
     * <p>
     * For example, <code>wm(90)</code> calculates the average while treating the 10% of the
     * highest values to be equal to the value at the 90th percentile.
     * <code>wm(10, 90)</code> calculates the average while treaing the bottom 10% and the
     * top 10% of values to be equal to the boundary values.
     * <p>
     * @param p1 This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String winsorizedMean(final @org.jetbrains.annotations.NotNull java.lang.Number p1) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Stats.class, "winsorizedMean", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(p1, "p1 is required") });
    }

    /**
     * A shorter alias for <code>winsorizedMean()</code>.
     * <p>
     * @param p1 This parameter is required.
     * @param p2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String wm(final @org.jetbrains.annotations.NotNull java.lang.Number p1, final @org.jetbrains.annotations.Nullable java.lang.Number p2) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Stats.class, "wm", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(p1, "p1 is required"), p2 });
    }

    /**
     * A shorter alias for <code>winsorizedMean()</code>.
     * <p>
     * @param p1 This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String wm(final @org.jetbrains.annotations.NotNull java.lang.Number p1) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Stats.class, "wm", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(p1, "p1 is required") });
    }

    /**
     * The value of Sum / SampleCount during the specified period.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String AVERAGE;

    /**
     * Interquartile mean (IQM) is the trimmed mean of the interquartile range, or the middle 50% of values.
     * <p>
     * It is equivalent to <code>trimmedMean(25, 75)</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String IQM;

    /**
     * The highest value observed during the specified period.
     * <p>
     * You can use this value to determine high volumes of activity for your application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String MAXIMUM;

    /**
     * The lowest value observed during the specified period.
     * <p>
     * You can use this value to determine low volumes of activity for your application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String MINIMUM;

    /**
     * The count (number) of data points used for the statistical calculation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String SAMPLE_COUNT;

    /**
     * All values submitted for the matching metric added together.
     * <p>
     * This statistic can be useful for determining the total volume of a metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String SUM;

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.cloudwatch.Stats {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
