package software.amazon.awscdk.services.codebuild;

/**
 * The compute type of the fleet.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.Size;
 * Fleet fleet = Fleet.Builder.create(this, "MyFleet")
 *         .baseCapacity(1)
 *         .computeType(FleetComputeType.ATTRIBUTE_BASED)
 *         .environmentType(EnvironmentType.LINUX_CONTAINER)
 *         .computeConfiguration(ComputeConfiguration.builder()
 *                 .vCpu(2)
 *                 .memory(Size.gibibytes(4))
 *                 .disk(Size.gibibytes(10))
 *                 .machineType(MachineType.GENERAL)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:47.707Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.MachineType")
public enum MachineType {
    /**
     * General purpose compute type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GENERAL,
    /**
     * Non-Volatile Memory Express (NVMe) storage optimized compute type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NVME,
}
