package software.amazon.awscdk.services.codebuild;

/**
 * Construction properties for <code>S3Artifacts</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * Project project = Project.Builder.create(this, "MyProject")
 *         .buildSpec(BuildSpec.fromObject(Map.of(
 *                 "version", "0.2")))
 *         .artifacts(Artifacts.s3(S3ArtifactsProps.builder()
 *                 .bucket(bucket)
 *                 .includeBuildId(false)
 *                 .packageZip(true)
 *                 .path("another/path")
 *                 .identifier("AddArtifact1")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:47.719Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.S3ArtifactsProps")
@software.amazon.jsii.Jsii.Proxy(S3ArtifactsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface S3ArtifactsProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codebuild.ArtifactsProps {

    /**
     * The name of the output bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getBucket();

    /**
     * If this is false, build output will not be encrypted.
     * <p>
     * This is useful if the artifact to publish a static website or sharing content with others
     * <p>
     * Default: true - output will be encrypted
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEncryption() {
        return null;
    }

    /**
     * Indicates if the build ID should be included in the path.
     * <p>
     * If this is set to true,
     * then the build artifact will be stored in "<path>/<build-id>/<name>".
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIncludeBuildId() {
        return null;
    }

    /**
     * The name of the build output ZIP file or folder inside the bucket.
     * <p>
     * The full S3 object key will be "<path>/<build-id>/<name>" or
     * "<path>/<name>" depending on whether <code>includeBuildId</code> is set to true.
     * <p>
     * If not set, <code>overrideArtifactName</code> will be set and the name from the
     * buildspec will be used instead.
     * <p>
     * Default: undefined, and use the name from the buildspec
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * If this is true, all build output will be packaged into a single .zip file. Otherwise, all files will be uploaded to <path>/<name>.
     * <p>
     * Default: true - files will be archived
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPackageZip() {
        return null;
    }

    /**
     * The path inside of the bucket for the build output .zip file or folder. If a value is not specified, then build output will be stored at the root of the bucket (or under the <build-id> directory if <code>includeBuildId</code> is set to true).
     * <p>
     * Default: the root of the bucket
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link S3ArtifactsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link S3ArtifactsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<S3ArtifactsProps> {
        software.amazon.awscdk.services.s3.IBucket bucket;
        java.lang.Boolean encryption;
        java.lang.Boolean includeBuildId;
        java.lang.String name;
        java.lang.Boolean packageZip;
        java.lang.String path;
        java.lang.String identifier;

        /**
         * Sets the value of {@link S3ArtifactsProps#getBucket}
         * @param bucket The name of the output bucket. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link S3ArtifactsProps#getEncryption}
         * @param encryption If this is false, build output will not be encrypted.
         *                   This is useful if the artifact to publish a static website or sharing content with others
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(java.lang.Boolean encryption) {
            this.encryption = encryption;
            return this;
        }

        /**
         * Sets the value of {@link S3ArtifactsProps#getIncludeBuildId}
         * @param includeBuildId Indicates if the build ID should be included in the path.
         *                       If this is set to true,
         *                       then the build artifact will be stored in "<path>/<build-id>/<name>".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeBuildId(java.lang.Boolean includeBuildId) {
            this.includeBuildId = includeBuildId;
            return this;
        }

        /**
         * Sets the value of {@link S3ArtifactsProps#getName}
         * @param name The name of the build output ZIP file or folder inside the bucket.
         *             The full S3 object key will be "<path>/<build-id>/<name>" or
         *             "<path>/<name>" depending on whether <code>includeBuildId</code> is set to true.
         *             <p>
         *             If not set, <code>overrideArtifactName</code> will be set and the name from the
         *             buildspec will be used instead.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link S3ArtifactsProps#getPackageZip}
         * @param packageZip If this is true, all build output will be packaged into a single .zip file. Otherwise, all files will be uploaded to <path>/<name>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packageZip(java.lang.Boolean packageZip) {
            this.packageZip = packageZip;
            return this;
        }

        /**
         * Sets the value of {@link S3ArtifactsProps#getPath}
         * @param path The path inside of the bucket for the build output .zip file or folder. If a value is not specified, then build output will be stored at the root of the bucket (or under the <build-id> directory if <code>includeBuildId</code> is set to true).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link S3ArtifactsProps#getIdentifier}
         * @param identifier The artifact identifier.
         *                   This property is required on secondary artifacts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identifier(java.lang.String identifier) {
            this.identifier = identifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3ArtifactsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public S3ArtifactsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link S3ArtifactsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3ArtifactsProps {
        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private final java.lang.Boolean encryption;
        private final java.lang.Boolean includeBuildId;
        private final java.lang.String name;
        private final java.lang.Boolean packageZip;
        private final java.lang.String path;
        private final java.lang.String identifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.includeBuildId = software.amazon.jsii.Kernel.get(this, "includeBuildId", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.packageZip = software.amazon.jsii.Kernel.get(this, "packageZip", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.identifier = software.amazon.jsii.Kernel.get(this, "identifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
            this.encryption = builder.encryption;
            this.includeBuildId = builder.includeBuildId;
            this.name = builder.name;
            this.packageZip = builder.packageZip;
            this.path = builder.path;
            this.identifier = builder.identifier;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.bucket;
        }

        @Override
        public final java.lang.Boolean getEncryption() {
            return this.encryption;
        }

        @Override
        public final java.lang.Boolean getIncludeBuildId() {
            return this.includeBuildId;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Boolean getPackageZip() {
            return this.packageZip;
        }

        @Override
        public final java.lang.String getPath() {
            return this.path;
        }

        @Override
        public final java.lang.String getIdentifier() {
            return this.identifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucket", om.valueToTree(this.getBucket()));
            if (this.getEncryption() != null) {
                data.set("encryption", om.valueToTree(this.getEncryption()));
            }
            if (this.getIncludeBuildId() != null) {
                data.set("includeBuildId", om.valueToTree(this.getIncludeBuildId()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getPackageZip() != null) {
                data.set("packageZip", om.valueToTree(this.getPackageZip()));
            }
            if (this.getPath() != null) {
                data.set("path", om.valueToTree(this.getPath()));
            }
            if (this.getIdentifier() != null) {
                data.set("identifier", om.valueToTree(this.getIdentifier()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.S3ArtifactsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            S3ArtifactsProps.Jsii$Proxy that = (S3ArtifactsProps.Jsii$Proxy) o;

            if (!bucket.equals(that.bucket)) return false;
            if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
            if (this.includeBuildId != null ? !this.includeBuildId.equals(that.includeBuildId) : that.includeBuildId != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.packageZip != null ? !this.packageZip.equals(that.packageZip) : that.packageZip != null) return false;
            if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
            return this.identifier != null ? this.identifier.equals(that.identifier) : that.identifier == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucket.hashCode();
            result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
            result = 31 * result + (this.includeBuildId != null ? this.includeBuildId.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.packageZip != null ? this.packageZip.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
            return result;
        }
    }
}
