package software.amazon.awscdk.services.codedeploy;

/**
 * The Deployment Configuration of an ECS Deployment Group.
 * <p>
 * If you're managing the Deployment Configuration alongside the rest of your CDK resources,
 * use the <code>EcsDeploymentConfig</code> class.
 * <p>
 * If you want to reference an already existing deployment configuration,
 * or one defined in a different CDK Stack,
 * use the <code>EcsDeploymentConfig#fromEcsDeploymentConfigName</code> method.
 * <p>
 * The default, pre-defined Configurations are available as constants on the <code>EcsDeploymentConfig</code> class
 * (for example, <code>EcsDeploymentConfig.AllAtOnce</code>).
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:47.820Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.IEcsDeploymentConfig")
@software.amazon.jsii.Jsii.Proxy(IEcsDeploymentConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IEcsDeploymentConfig extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codedeploy.IBaseDeploymentConfig {

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The ARN of the Deployment Configuration.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigArn() {
            return software.amazon.jsii.Kernel.get(this, "deploymentConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The physical, human-readable name of the Deployment Configuration.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigName() {
            return software.amazon.jsii.Kernel.get(this, "deploymentConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }

    /**
     * Internal default implementation for {@link IEcsDeploymentConfig}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IEcsDeploymentConfig, software.amazon.awscdk.services.codedeploy.IBaseDeploymentConfig.Jsii$Default {

        /**
         * The ARN of the Deployment Configuration.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigArn() {
            return software.amazon.jsii.Kernel.get(this, "deploymentConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The physical, human-readable name of the Deployment Configuration.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigName() {
            return software.amazon.jsii.Kernel.get(this, "deploymentConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
