package software.amazon.awscdk.services.codepipeline;

/**
 * The conditions for making checks for the stage.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodeStarConnectionsSourceAction sourceAction;
 * CodeBuildAction buildAction;
 * Pipeline.Builder.create(this, "Pipeline")
 *         .pipelineType(PipelineType.V2)
 *         .stages(List.of(StageProps.builder()
 *                 .stageName("Source")
 *                 .actions(List.of(sourceAction))
 *                 .build(), StageProps.builder()
 *                 .stageName("Build")
 *                 .actions(List.of(buildAction))
 *                 // BeforeEntry condition - checks before entering the stage
 *                 .beforeEntry(Conditions.builder()
 *                         .conditions(List.of(Condition.builder()
 *                                 .rules(List.of(Rule.Builder.create()
 *                                         .name("LambdaCheck")
 *                                         .provider("LambdaInvoke")
 *                                         .version("1")
 *                                         .configuration(Map.of(
 *                                                 "FunctionName", "LambdaFunctionName"))
 *                                         .build()))
 *                                 .result(Result.FAIL)
 *                                 .build()))
 *                         .build())
 *                 // OnSuccess condition - checks after successful stage completion
 *                 .onSuccess(Conditions.builder()
 *                         .conditions(List.of(Condition.builder()
 *                                 .result(Result.FAIL)
 *                                 .rules(List.of(Rule.Builder.create()
 *                                         .name("CloudWatchCheck")
 *                                         .provider("LambdaInvoke")
 *                                         .version("1")
 *                                         .configuration(Map.of(
 *                                                 "AlarmName", "AlarmName1",
 *                                                 "WaitTime", "300",  // 5 minutes
 *                                                 "FunctionName", "funcName2"))
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 // OnFailure condition - handles stage failure
 *                 .onFailure(FailureConditions.builder()
 *                         .conditions(List.of(Condition.builder()
 *                                 .result(Result.ROLLBACK)
 *                                 .rules(List.of(Rule.Builder.create()
 *                                         .name("RollBackOnFailure")
 *                                         .provider("LambdaInvoke")
 *                                         .version("1")
 *                                         .configuration(Map.of(
 *                                                 "AlarmName", "Alarm",
 *                                                 "WaitTime", "300",  // 5 minutes
 *                                                 "FunctionName", "funcName1"))
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:47.910Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.Conditions")
@software.amazon.jsii.Jsii.Proxy(Conditions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Conditions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The conditions that are configured as entry conditions, making check to succeed the stage, or fail the stage.
     * <p>
     * Default: - No conditions are configured
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codepipeline.Condition> getConditions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Conditions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Conditions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<Conditions> {
        java.util.List<software.amazon.awscdk.services.codepipeline.Condition> conditions;

        /**
         * Sets the value of {@link Conditions#getConditions}
         * @param conditions The conditions that are configured as entry conditions, making check to succeed the stage, or fail the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder conditions(java.util.List<? extends software.amazon.awscdk.services.codepipeline.Condition> conditions) {
            this.conditions = (java.util.List<software.amazon.awscdk.services.codepipeline.Condition>)conditions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Conditions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public Conditions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Conditions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Conditions {
        private final java.util.List<software.amazon.awscdk.services.codepipeline.Condition> conditions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Condition.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.conditions = (java.util.List<software.amazon.awscdk.services.codepipeline.Condition>)builder.conditions;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codepipeline.Condition> getConditions() {
            return this.conditions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getConditions() != null) {
                data.set("conditions", om.valueToTree(this.getConditions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.Conditions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Conditions.Jsii$Proxy that = (Conditions.Jsii$Proxy) o;

            return this.conditions != null ? this.conditions.equals(that.conditions) : that.conditions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.conditions != null ? this.conditions.hashCode() : 0;
            return result;
        }
    }
}
