package software.amazon.awscdk.services.codepipeline;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * S3SourceAction sourceAction;
 * Artifact sourceOutput;
 * Bucket deployBucket;
 * // Pipeline-level variable
 * Variable variable = Variable.Builder.create()
 *         .variableName("bucket-var")
 *         .description("description")
 *         .defaultValue("sample")
 *         .build();
 * Pipeline.Builder.create(this, "Pipeline")
 *         .pipelineType(PipelineType.V2)
 *         .variables(List.of(variable))
 *         .stages(List.of(StageProps.builder()
 *                 .stageName("Source")
 *                 .actions(List.of(sourceAction))
 *                 .build(), StageProps.builder()
 *                 .stageName("Deploy")
 *                 .actions(List.of(
 *                     S3DeployAction.Builder.create()
 *                             .actionName("DeployAction")
 *                             // can reference the variables
 *                             .objectKey(String.format("%s.txt", variable.reference()))
 *                             .input(sourceOutput)
 *                             .bucket(deployBucket)
 *                             .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:47.923Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.PipelineProps")
@software.amazon.jsii.Jsii.Proxy(PipelineProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PipelineProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The S3 bucket used by this Pipeline to store artifacts.
     * <p>
     * Default: - A new S3 bucket will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getArtifactBucket() {
        return null;
    }

    /**
     * Create KMS keys for cross-account deployments.
     * <p>
     * This controls whether the pipeline is enabled for cross-account deployments.
     * <p>
     * By default cross-account deployments are enabled, but this feature requires
     * that KMS Customer Master Keys are created which have a cost of $1/month.
     * <p>
     * If you do not need cross-account deployments, you can set this to <code>false</code> to
     * not create those keys and save on that cost (the artifact bucket will be
     * encrypted with an AWS-managed key). However, cross-account deployments will
     * no longer be possible.
     * <p>
     * Default: false - false if the feature flag `CODEPIPELINE_CROSS_ACCOUNT_KEYS_DEFAULT_VALUE_TO_FALSE`
     * is true, true otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCrossAccountKeys() {
        return null;
    }

    /**
     * A map of region to S3 bucket name used for cross-region CodePipeline.
     * <p>
     * For every Action that you specify targeting a different region than the Pipeline itself,
     * if you don't provide an explicit Bucket for that region using this property,
     * the construct will automatically create a Stack containing an S3 Bucket in that region.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket> getCrossRegionReplicationBuckets() {
        return null;
    }

    /**
     * Enable KMS key rotation for the generated KMS keys.
     * <p>
     * By default KMS key rotation is disabled, but will add an additional $1/month
     * for each year the key exists when enabled.
     * <p>
     * Default: - false (key rotation is disabled)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableKeyRotation() {
        return null;
    }

    /**
     * The method that the pipeline will use to handle multiple executions.
     * <p>
     * Default: - ExecutionMode.SUPERSEDED
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.ExecutionMode getExecutionMode() {
        return null;
    }

    /**
     * Name of the pipeline.
     * <p>
     * Default: - AWS CloudFormation generates an ID and uses that for the pipeline name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPipelineName() {
        return null;
    }

    /**
     * Type of the pipeline.
     * <p>
     * Default: - PipelineType.V2 if the feature flag `CODEPIPELINE_DEFAULT_PIPELINE_TYPE_TO_V2`
     * is true, PipelineType.V1 otherwise
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/pipeline-types-planning.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/pipeline-types-planning.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.PipelineType getPipelineType() {
        return null;
    }

    /**
     * Indicates whether to rerun the AWS CodePipeline pipeline after you update it.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRestartExecutionOnUpdate() {
        return null;
    }

    /**
     * Reuse the same cross region support stack for all pipelines in the App.
     * <p>
     * Default: - true (Use the same support stack for all pipelines in App)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReuseCrossRegionSupportStacks() {
        return null;
    }

    /**
     * The IAM role to be assumed by this Pipeline.
     * <p>
     * Default: a new IAM role will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * The list of Stages, in order, to create this Pipeline with.
     * <p>
     * You can always add more Stages later by calling <code>Pipeline#addStage</code>.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codepipeline.StageProps> getStages() {
        return null;
    }

    /**
     * The trigger configuration specifying a type of event, such as Git tags, that starts the pipeline.
     * <p>
     * When a trigger configuration is specified, default change detection for repository
     * and branch commits is disabled.
     * <p>
     * <code>triggers</code> can only be used when <code>pipelineType</code> is set to <code>PipelineType.V2</code>.
     * You can always add more triggers later by calling <code>Pipeline#addTrigger</code>.
     * <p>
     * Default: - No triggers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codepipeline.TriggerProps> getTriggers() {
        return null;
    }

    /**
     * Use pipeline service role for actions if no action role configured.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUsePipelineRoleForActions() {
        return null;
    }

    /**
     * A list that defines the pipeline variables for a pipeline resource.
     * <p>
     * <code>variables</code> can only be used when <code>pipelineType</code> is set to <code>PipelineType.V2</code>.
     * You can always add more variables later by calling <code>Pipeline#addVariable</code>.
     * <p>
     * Default: - No variables
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codepipeline.Variable> getVariables() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PipelineProps> {
        software.amazon.awscdk.services.s3.IBucket artifactBucket;
        java.lang.Boolean crossAccountKeys;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket> crossRegionReplicationBuckets;
        java.lang.Boolean enableKeyRotation;
        software.amazon.awscdk.services.codepipeline.ExecutionMode executionMode;
        java.lang.String pipelineName;
        software.amazon.awscdk.services.codepipeline.PipelineType pipelineType;
        java.lang.Boolean restartExecutionOnUpdate;
        java.lang.Boolean reuseCrossRegionSupportStacks;
        software.amazon.awscdk.services.iam.IRole role;
        java.util.List<software.amazon.awscdk.services.codepipeline.StageProps> stages;
        java.util.List<software.amazon.awscdk.services.codepipeline.TriggerProps> triggers;
        java.lang.Boolean usePipelineRoleForActions;
        java.util.List<software.amazon.awscdk.services.codepipeline.Variable> variables;

        /**
         * Sets the value of {@link PipelineProps#getArtifactBucket}
         * @param artifactBucket The S3 bucket used by this Pipeline to store artifacts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactBucket(software.amazon.awscdk.services.s3.IBucket artifactBucket) {
            this.artifactBucket = artifactBucket;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getCrossAccountKeys}
         * @param crossAccountKeys Create KMS keys for cross-account deployments.
         *                         This controls whether the pipeline is enabled for cross-account deployments.
         *                         <p>
         *                         By default cross-account deployments are enabled, but this feature requires
         *                         that KMS Customer Master Keys are created which have a cost of $1/month.
         *                         <p>
         *                         If you do not need cross-account deployments, you can set this to <code>false</code> to
         *                         not create those keys and save on that cost (the artifact bucket will be
         *                         encrypted with an AWS-managed key). However, cross-account deployments will
         *                         no longer be possible.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossAccountKeys(java.lang.Boolean crossAccountKeys) {
            this.crossAccountKeys = crossAccountKeys;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getCrossRegionReplicationBuckets}
         * @param crossRegionReplicationBuckets A map of region to S3 bucket name used for cross-region CodePipeline.
         *                                      For every Action that you specify targeting a different region than the Pipeline itself,
         *                                      if you don't provide an explicit Bucket for that region using this property,
         *                                      the construct will automatically create a Stack containing an S3 Bucket in that region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder crossRegionReplicationBuckets(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.s3.IBucket> crossRegionReplicationBuckets) {
            this.crossRegionReplicationBuckets = (java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket>)crossRegionReplicationBuckets;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getEnableKeyRotation}
         * @param enableKeyRotation Enable KMS key rotation for the generated KMS keys.
         *                          By default KMS key rotation is disabled, but will add an additional $1/month
         *                          for each year the key exists when enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableKeyRotation(java.lang.Boolean enableKeyRotation) {
            this.enableKeyRotation = enableKeyRotation;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getExecutionMode}
         * @param executionMode The method that the pipeline will use to handle multiple executions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionMode(software.amazon.awscdk.services.codepipeline.ExecutionMode executionMode) {
            this.executionMode = executionMode;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getPipelineName}
         * @param pipelineName Name of the pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineName(java.lang.String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getPipelineType}
         * @param pipelineType Type of the pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineType(software.amazon.awscdk.services.codepipeline.PipelineType pipelineType) {
            this.pipelineType = pipelineType;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getRestartExecutionOnUpdate}
         * @param restartExecutionOnUpdate Indicates whether to rerun the AWS CodePipeline pipeline after you update it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartExecutionOnUpdate(java.lang.Boolean restartExecutionOnUpdate) {
            this.restartExecutionOnUpdate = restartExecutionOnUpdate;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getReuseCrossRegionSupportStacks}
         * @param reuseCrossRegionSupportStacks Reuse the same cross region support stack for all pipelines in the App.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reuseCrossRegionSupportStacks(java.lang.Boolean reuseCrossRegionSupportStacks) {
            this.reuseCrossRegionSupportStacks = reuseCrossRegionSupportStacks;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getRole}
         * @param role The IAM role to be assumed by this Pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getStages}
         * @param stages The list of Stages, in order, to create this Pipeline with.
         *               You can always add more Stages later by calling <code>Pipeline#addStage</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder stages(java.util.List<? extends software.amazon.awscdk.services.codepipeline.StageProps> stages) {
            this.stages = (java.util.List<software.amazon.awscdk.services.codepipeline.StageProps>)stages;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getTriggers}
         * @param triggers The trigger configuration specifying a type of event, such as Git tags, that starts the pipeline.
         *                 When a trigger configuration is specified, default change detection for repository
         *                 and branch commits is disabled.
         *                 <p>
         *                 <code>triggers</code> can only be used when <code>pipelineType</code> is set to <code>PipelineType.V2</code>.
         *                 You can always add more triggers later by calling <code>Pipeline#addTrigger</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder triggers(java.util.List<? extends software.amazon.awscdk.services.codepipeline.TriggerProps> triggers) {
            this.triggers = (java.util.List<software.amazon.awscdk.services.codepipeline.TriggerProps>)triggers;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getUsePipelineRoleForActions}
         * @param usePipelineRoleForActions Use pipeline service role for actions if no action role configured.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder usePipelineRoleForActions(java.lang.Boolean usePipelineRoleForActions) {
            this.usePipelineRoleForActions = usePipelineRoleForActions;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getVariables}
         * @param variables A list that defines the pipeline variables for a pipeline resource.
         *                  <code>variables</code> can only be used when <code>pipelineType</code> is set to <code>PipelineType.V2</code>.
         *                  You can always add more variables later by calling <code>Pipeline#addVariable</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder variables(java.util.List<? extends software.amazon.awscdk.services.codepipeline.Variable> variables) {
            this.variables = (java.util.List<software.amazon.awscdk.services.codepipeline.Variable>)variables;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PipelineProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PipelineProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipelineProps {
        private final software.amazon.awscdk.services.s3.IBucket artifactBucket;
        private final java.lang.Boolean crossAccountKeys;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket> crossRegionReplicationBuckets;
        private final java.lang.Boolean enableKeyRotation;
        private final software.amazon.awscdk.services.codepipeline.ExecutionMode executionMode;
        private final java.lang.String pipelineName;
        private final software.amazon.awscdk.services.codepipeline.PipelineType pipelineType;
        private final java.lang.Boolean restartExecutionOnUpdate;
        private final java.lang.Boolean reuseCrossRegionSupportStacks;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.util.List<software.amazon.awscdk.services.codepipeline.StageProps> stages;
        private final java.util.List<software.amazon.awscdk.services.codepipeline.TriggerProps> triggers;
        private final java.lang.Boolean usePipelineRoleForActions;
        private final java.util.List<software.amazon.awscdk.services.codepipeline.Variable> variables;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.artifactBucket = software.amazon.jsii.Kernel.get(this, "artifactBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.crossAccountKeys = software.amazon.jsii.Kernel.get(this, "crossAccountKeys", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.crossRegionReplicationBuckets = software.amazon.jsii.Kernel.get(this, "crossRegionReplicationBuckets", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class)));
            this.enableKeyRotation = software.amazon.jsii.Kernel.get(this, "enableKeyRotation", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.executionMode = software.amazon.jsii.Kernel.get(this, "executionMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ExecutionMode.class));
            this.pipelineName = software.amazon.jsii.Kernel.get(this, "pipelineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pipelineType = software.amazon.jsii.Kernel.get(this, "pipelineType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.PipelineType.class));
            this.restartExecutionOnUpdate = software.amazon.jsii.Kernel.get(this, "restartExecutionOnUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.reuseCrossRegionSupportStacks = software.amazon.jsii.Kernel.get(this, "reuseCrossRegionSupportStacks", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.stages = software.amazon.jsii.Kernel.get(this, "stages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.StageProps.class)));
            this.triggers = software.amazon.jsii.Kernel.get(this, "triggers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.TriggerProps.class)));
            this.usePipelineRoleForActions = software.amazon.jsii.Kernel.get(this, "usePipelineRoleForActions", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.variables = software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Variable.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.artifactBucket = builder.artifactBucket;
            this.crossAccountKeys = builder.crossAccountKeys;
            this.crossRegionReplicationBuckets = (java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket>)builder.crossRegionReplicationBuckets;
            this.enableKeyRotation = builder.enableKeyRotation;
            this.executionMode = builder.executionMode;
            this.pipelineName = builder.pipelineName;
            this.pipelineType = builder.pipelineType;
            this.restartExecutionOnUpdate = builder.restartExecutionOnUpdate;
            this.reuseCrossRegionSupportStacks = builder.reuseCrossRegionSupportStacks;
            this.role = builder.role;
            this.stages = (java.util.List<software.amazon.awscdk.services.codepipeline.StageProps>)builder.stages;
            this.triggers = (java.util.List<software.amazon.awscdk.services.codepipeline.TriggerProps>)builder.triggers;
            this.usePipelineRoleForActions = builder.usePipelineRoleForActions;
            this.variables = (java.util.List<software.amazon.awscdk.services.codepipeline.Variable>)builder.variables;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getArtifactBucket() {
            return this.artifactBucket;
        }

        @Override
        public final java.lang.Boolean getCrossAccountKeys() {
            return this.crossAccountKeys;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket> getCrossRegionReplicationBuckets() {
            return this.crossRegionReplicationBuckets;
        }

        @Override
        public final java.lang.Boolean getEnableKeyRotation() {
            return this.enableKeyRotation;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.ExecutionMode getExecutionMode() {
            return this.executionMode;
        }

        @Override
        public final java.lang.String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.PipelineType getPipelineType() {
            return this.pipelineType;
        }

        @Override
        public final java.lang.Boolean getRestartExecutionOnUpdate() {
            return this.restartExecutionOnUpdate;
        }

        @Override
        public final java.lang.Boolean getReuseCrossRegionSupportStacks() {
            return this.reuseCrossRegionSupportStacks;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codepipeline.StageProps> getStages() {
            return this.stages;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codepipeline.TriggerProps> getTriggers() {
            return this.triggers;
        }

        @Override
        public final java.lang.Boolean getUsePipelineRoleForActions() {
            return this.usePipelineRoleForActions;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codepipeline.Variable> getVariables() {
            return this.variables;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getArtifactBucket() != null) {
                data.set("artifactBucket", om.valueToTree(this.getArtifactBucket()));
            }
            if (this.getCrossAccountKeys() != null) {
                data.set("crossAccountKeys", om.valueToTree(this.getCrossAccountKeys()));
            }
            if (this.getCrossRegionReplicationBuckets() != null) {
                data.set("crossRegionReplicationBuckets", om.valueToTree(this.getCrossRegionReplicationBuckets()));
            }
            if (this.getEnableKeyRotation() != null) {
                data.set("enableKeyRotation", om.valueToTree(this.getEnableKeyRotation()));
            }
            if (this.getExecutionMode() != null) {
                data.set("executionMode", om.valueToTree(this.getExecutionMode()));
            }
            if (this.getPipelineName() != null) {
                data.set("pipelineName", om.valueToTree(this.getPipelineName()));
            }
            if (this.getPipelineType() != null) {
                data.set("pipelineType", om.valueToTree(this.getPipelineType()));
            }
            if (this.getRestartExecutionOnUpdate() != null) {
                data.set("restartExecutionOnUpdate", om.valueToTree(this.getRestartExecutionOnUpdate()));
            }
            if (this.getReuseCrossRegionSupportStacks() != null) {
                data.set("reuseCrossRegionSupportStacks", om.valueToTree(this.getReuseCrossRegionSupportStacks()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getStages() != null) {
                data.set("stages", om.valueToTree(this.getStages()));
            }
            if (this.getTriggers() != null) {
                data.set("triggers", om.valueToTree(this.getTriggers()));
            }
            if (this.getUsePipelineRoleForActions() != null) {
                data.set("usePipelineRoleForActions", om.valueToTree(this.getUsePipelineRoleForActions()));
            }
            if (this.getVariables() != null) {
                data.set("variables", om.valueToTree(this.getVariables()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.PipelineProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PipelineProps.Jsii$Proxy that = (PipelineProps.Jsii$Proxy) o;

            if (this.artifactBucket != null ? !this.artifactBucket.equals(that.artifactBucket) : that.artifactBucket != null) return false;
            if (this.crossAccountKeys != null ? !this.crossAccountKeys.equals(that.crossAccountKeys) : that.crossAccountKeys != null) return false;
            if (this.crossRegionReplicationBuckets != null ? !this.crossRegionReplicationBuckets.equals(that.crossRegionReplicationBuckets) : that.crossRegionReplicationBuckets != null) return false;
            if (this.enableKeyRotation != null ? !this.enableKeyRotation.equals(that.enableKeyRotation) : that.enableKeyRotation != null) return false;
            if (this.executionMode != null ? !this.executionMode.equals(that.executionMode) : that.executionMode != null) return false;
            if (this.pipelineName != null ? !this.pipelineName.equals(that.pipelineName) : that.pipelineName != null) return false;
            if (this.pipelineType != null ? !this.pipelineType.equals(that.pipelineType) : that.pipelineType != null) return false;
            if (this.restartExecutionOnUpdate != null ? !this.restartExecutionOnUpdate.equals(that.restartExecutionOnUpdate) : that.restartExecutionOnUpdate != null) return false;
            if (this.reuseCrossRegionSupportStacks != null ? !this.reuseCrossRegionSupportStacks.equals(that.reuseCrossRegionSupportStacks) : that.reuseCrossRegionSupportStacks != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.stages != null ? !this.stages.equals(that.stages) : that.stages != null) return false;
            if (this.triggers != null ? !this.triggers.equals(that.triggers) : that.triggers != null) return false;
            if (this.usePipelineRoleForActions != null ? !this.usePipelineRoleForActions.equals(that.usePipelineRoleForActions) : that.usePipelineRoleForActions != null) return false;
            return this.variables != null ? this.variables.equals(that.variables) : that.variables == null;
        }

        @Override
        public final int hashCode() {
            int result = this.artifactBucket != null ? this.artifactBucket.hashCode() : 0;
            result = 31 * result + (this.crossAccountKeys != null ? this.crossAccountKeys.hashCode() : 0);
            result = 31 * result + (this.crossRegionReplicationBuckets != null ? this.crossRegionReplicationBuckets.hashCode() : 0);
            result = 31 * result + (this.enableKeyRotation != null ? this.enableKeyRotation.hashCode() : 0);
            result = 31 * result + (this.executionMode != null ? this.executionMode.hashCode() : 0);
            result = 31 * result + (this.pipelineName != null ? this.pipelineName.hashCode() : 0);
            result = 31 * result + (this.pipelineType != null ? this.pipelineType.hashCode() : 0);
            result = 31 * result + (this.restartExecutionOnUpdate != null ? this.restartExecutionOnUpdate.hashCode() : 0);
            result = 31 * result + (this.reuseCrossRegionSupportStacks != null ? this.reuseCrossRegionSupportStacks.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.stages != null ? this.stages.hashCode() : 0);
            result = 31 * result + (this.triggers != null ? this.triggers.hashCode() : 0);
            result = 31 * result + (this.usePipelineRoleForActions != null ? this.usePipelineRoleForActions.hashCode() : 0);
            result = 31 * result + (this.variables != null ? this.variables.hashCode() : 0);
            return result;
        }
    }
}
