package software.amazon.awscdk.services.codestarnotifications;

/**
 * Information about the SNS topic or AWS Chatbot client associated with a notification target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codestarnotifications.*;
 * NotificationRuleTargetConfig notificationRuleTargetConfig = NotificationRuleTargetConfig.builder()
 *         .targetAddress("targetAddress")
 *         .targetType("targetType")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:48.086Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codestarnotifications.NotificationRuleTargetConfig")
@software.amazon.jsii.Jsii.Proxy(NotificationRuleTargetConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NotificationRuleTargetConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic or AWS Chatbot client.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetAddress();

    /**
     * The target type.
     * <p>
     * Can be an Amazon SNS topic or AWS Chatbot client.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetType();

    /**
     * @return a {@link Builder} of {@link NotificationRuleTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NotificationRuleTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NotificationRuleTargetConfig> {
        java.lang.String targetAddress;
        java.lang.String targetType;

        /**
         * Sets the value of {@link NotificationRuleTargetConfig#getTargetAddress}
         * @param targetAddress The Amazon Resource Name (ARN) of the Amazon SNS topic or AWS Chatbot client. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetAddress(java.lang.String targetAddress) {
            this.targetAddress = targetAddress;
            return this;
        }

        /**
         * Sets the value of {@link NotificationRuleTargetConfig#getTargetType}
         * @param targetType The target type. This parameter is required.
         *                   Can be an Amazon SNS topic or AWS Chatbot client.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetType(java.lang.String targetType) {
            this.targetType = targetType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NotificationRuleTargetConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NotificationRuleTargetConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NotificationRuleTargetConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotificationRuleTargetConfig {
        private final java.lang.String targetAddress;
        private final java.lang.String targetType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.targetAddress = software.amazon.jsii.Kernel.get(this, "targetAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetType = software.amazon.jsii.Kernel.get(this, "targetType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.targetAddress = java.util.Objects.requireNonNull(builder.targetAddress, "targetAddress is required");
            this.targetType = java.util.Objects.requireNonNull(builder.targetType, "targetType is required");
        }

        @Override
        public final java.lang.String getTargetAddress() {
            return this.targetAddress;
        }

        @Override
        public final java.lang.String getTargetType() {
            return this.targetType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("targetAddress", om.valueToTree(this.getTargetAddress()));
            data.set("targetType", om.valueToTree(this.getTargetType()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codestarnotifications.NotificationRuleTargetConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NotificationRuleTargetConfig.Jsii$Proxy that = (NotificationRuleTargetConfig.Jsii$Proxy) o;

            if (!targetAddress.equals(that.targetAddress)) return false;
            return this.targetType.equals(that.targetType);
        }

        @Override
        public final int hashCode() {
            int result = this.targetAddress.hashCode();
            result = 31 * result + (this.targetType.hashCode());
            return result;
        }
    }
}
