package software.amazon.awscdk.services.cognito;

/**
 * Properties for defining a <code>CfnUserPoolResourceServer</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * CfnUserPoolResourceServerProps cfnUserPoolResourceServerProps = CfnUserPoolResourceServerProps.builder()
 *         .identifier("identifier")
 *         .name("name")
 *         .userPoolId("userPoolId")
 *         // the properties below are optional
 *         .scopes(List.of(ResourceServerScopeTypeProperty.builder()
 *                 .scopeDescription("scopeDescription")
 *                 .scopeName("scopeName")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:48.190Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolResourceServerProps")
@software.amazon.jsii.Jsii.Proxy(CfnUserPoolResourceServerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnUserPoolResourceServerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A unique resource server identifier for the resource server.
     * <p>
     * The identifier can be an API friendly name like <code>solar-system-data</code> . You can also set an API URL like <code>https://solar-system-data-api.example.com</code> as your identifier.
     * <p>
     * Amazon Cognito represents scopes in the access token in the format <code>$resource-server-identifier/$scope</code> . Longer scope-identifier strings increase the size of your access tokens.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html#cfn-cognito-userpoolresourceserver-identifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html#cfn-cognito-userpoolresourceserver-identifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdentifier();

    /**
     * A friendly name for the resource server.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html#cfn-cognito-userpoolresourceserver-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html#cfn-cognito-userpoolresourceserver-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The ID of the user pool where you want to create a resource server.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html#cfn-cognito-userpoolresourceserver-userpoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html#cfn-cognito-userpoolresourceserver-userpoolid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId();

    /**
     * A list of scopes.
     * <p>
     * Each scope is a map with keys <code>ScopeName</code> and <code>ScopeDescription</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html#cfn-cognito-userpoolresourceserver-scopes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html#cfn-cognito-userpoolresourceserver-scopes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getScopes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnUserPoolResourceServerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnUserPoolResourceServerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnUserPoolResourceServerProps> {
        java.lang.String identifier;
        java.lang.String name;
        java.lang.String userPoolId;
        java.lang.Object scopes;

        /**
         * Sets the value of {@link CfnUserPoolResourceServerProps#getIdentifier}
         * @param identifier A unique resource server identifier for the resource server. This parameter is required.
         *                   The identifier can be an API friendly name like <code>solar-system-data</code> . You can also set an API URL like <code>https://solar-system-data-api.example.com</code> as your identifier.
         *                   <p>
         *                   Amazon Cognito represents scopes in the access token in the format <code>$resource-server-identifier/$scope</code> . Longer scope-identifier strings increase the size of your access tokens.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identifier(java.lang.String identifier) {
            this.identifier = identifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolResourceServerProps#getName}
         * @param name A friendly name for the resource server. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolResourceServerProps#getUserPoolId}
         * @param userPoolId The ID of the user pool where you want to create a resource server. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolId(java.lang.String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolResourceServerProps#getScopes}
         * @param scopes A list of scopes.
         *               Each scope is a map with keys <code>ScopeName</code> and <code>ScopeDescription</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scopes(software.amazon.awscdk.IResolvable scopes) {
            this.scopes = scopes;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolResourceServerProps#getScopes}
         * @param scopes A list of scopes.
         *               Each scope is a map with keys <code>ScopeName</code> and <code>ScopeDescription</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scopes(java.util.List<? extends java.lang.Object> scopes) {
            this.scopes = scopes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUserPoolResourceServerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnUserPoolResourceServerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnUserPoolResourceServerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUserPoolResourceServerProps {
        private final java.lang.String identifier;
        private final java.lang.String name;
        private final java.lang.String userPoolId;
        private final java.lang.Object scopes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.identifier = software.amazon.jsii.Kernel.get(this, "identifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userPoolId = software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scopes = software.amazon.jsii.Kernel.get(this, "scopes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.identifier = java.util.Objects.requireNonNull(builder.identifier, "identifier is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.userPoolId = java.util.Objects.requireNonNull(builder.userPoolId, "userPoolId is required");
            this.scopes = builder.scopes;
        }

        @Override
        public final java.lang.String getIdentifier() {
            return this.identifier;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final java.lang.Object getScopes() {
            return this.scopes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("identifier", om.valueToTree(this.getIdentifier()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("userPoolId", om.valueToTree(this.getUserPoolId()));
            if (this.getScopes() != null) {
                data.set("scopes", om.valueToTree(this.getScopes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnUserPoolResourceServerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUserPoolResourceServerProps.Jsii$Proxy that = (CfnUserPoolResourceServerProps.Jsii$Proxy) o;

            if (!identifier.equals(that.identifier)) return false;
            if (!name.equals(that.name)) return false;
            if (!userPoolId.equals(that.userPoolId)) return false;
            return this.scopes != null ? this.scopes.equals(that.scopes) : that.scopes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.identifier.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.userPoolId.hashCode());
            result = 31 * result + (this.scopes != null ? this.scopes.hashCode() : 0);
            return result;
        }
    }
}
