package software.amazon.awscdk.services.cognito;

/**
 * The user pool feature plan, or tier.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool.Builder.create(this, "myuserpool")
 *         .signInPolicy(SignInPolicy.builder()
 *                 .allowedFirstAuthFactors(AllowedFirstAuthFactors.builder().password(true).build())
 *                 .build())
 *         .featurePlan(FeaturePlan.LITE)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-sign-in-feature-plans.html">https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-sign-in-feature-plans.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:48.216Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.FeaturePlan")
public enum FeaturePlan {
    /**
     * Lite feature plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LITE,
    /**
     * Essentials feature plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ESSENTIALS,
    /**
     * Plus feature plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PLUS,
}
