package software.amazon.awscdk.services.config;

/**
 * Construction properties for a CustomRule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function fn;
 * String samplePolicyText;
 * ManagedRule.Builder.create(this, "ManagedRule")
 *         .identifier(ManagedRuleIdentifiers.API_GW_XRAY_ENABLED)
 *         .evaluationModes(EvaluationMode.DETECTIVE_AND_PROACTIVE)
 *         .build();
 * CustomRule.Builder.create(this, "CustomRule")
 *         .lambdaFunction(fn)
 *         .evaluationModes(EvaluationMode.PROACTIVE)
 *         .build();
 * CustomPolicy.Builder.create(this, "CustomPolicy")
 *         .policyText(samplePolicyText)
 *         .evaluationModes(EvaluationMode.DETECTIVE)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:48.380Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CustomRuleProps")
@software.amazon.jsii.Jsii.Proxy(CustomRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CustomRuleProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.config.RuleProps {

    /**
     * The Lambda function to run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction getLambdaFunction();

    /**
     * Whether to run the rule on configuration changes.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getConfigurationChanges() {
        return null;
    }

    /**
     * Whether to run the rule on a fixed frequency.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPeriodic() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CustomRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CustomRuleProps> {
        software.amazon.awscdk.services.lambda.IFunction lambdaFunction;
        java.lang.Boolean configurationChanges;
        java.lang.Boolean periodic;
        java.lang.String configRuleName;
        java.lang.String description;
        software.amazon.awscdk.services.config.EvaluationMode evaluationModes;
        java.util.Map<java.lang.String, java.lang.Object> inputParameters;
        software.amazon.awscdk.services.config.MaximumExecutionFrequency maximumExecutionFrequency;
        software.amazon.awscdk.services.config.RuleScope ruleScope;

        /**
         * Sets the value of {@link CustomRuleProps#getLambdaFunction}
         * @param lambdaFunction The Lambda function to run. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaFunction(software.amazon.awscdk.services.lambda.IFunction lambdaFunction) {
            this.lambdaFunction = lambdaFunction;
            return this;
        }

        /**
         * Sets the value of {@link CustomRuleProps#getConfigurationChanges}
         * @param configurationChanges Whether to run the rule on configuration changes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationChanges(java.lang.Boolean configurationChanges) {
            this.configurationChanges = configurationChanges;
            return this;
        }

        /**
         * Sets the value of {@link CustomRuleProps#getPeriodic}
         * @param periodic Whether to run the rule on a fixed frequency.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder periodic(java.lang.Boolean periodic) {
            this.periodic = periodic;
            return this;
        }

        /**
         * Sets the value of {@link CustomRuleProps#getConfigRuleName}
         * @param configRuleName A name for the AWS Config rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configRuleName(java.lang.String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        /**
         * Sets the value of {@link CustomRuleProps#getDescription}
         * @param description A description about this AWS Config rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CustomRuleProps#getEvaluationModes}
         * @param evaluationModes The modes the AWS Config rule can be evaluated in.
         *                        The valid values are distinct objects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationModes(software.amazon.awscdk.services.config.EvaluationMode evaluationModes) {
            this.evaluationModes = evaluationModes;
            return this;
        }

        /**
         * Sets the value of {@link CustomRuleProps#getInputParameters}
         * @param inputParameters Input parameter values that are passed to the AWS Config rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder inputParameters(java.util.Map<java.lang.String, ? extends java.lang.Object> inputParameters) {
            this.inputParameters = (java.util.Map<java.lang.String, java.lang.Object>)inputParameters;
            return this;
        }

        /**
         * Sets the value of {@link CustomRuleProps#getMaximumExecutionFrequency}
         * @param maximumExecutionFrequency The maximum frequency at which the AWS Config rule runs evaluations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumExecutionFrequency(software.amazon.awscdk.services.config.MaximumExecutionFrequency maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
            return this;
        }

        /**
         * Sets the value of {@link CustomRuleProps#getRuleScope}
         * @param ruleScope Defines which resources trigger an evaluation for an AWS Config rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleScope(software.amazon.awscdk.services.config.RuleScope ruleScope) {
            this.ruleScope = ruleScope;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CustomRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CustomRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomRuleProps {
        private final software.amazon.awscdk.services.lambda.IFunction lambdaFunction;
        private final java.lang.Boolean configurationChanges;
        private final java.lang.Boolean periodic;
        private final java.lang.String configRuleName;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.config.EvaluationMode evaluationModes;
        private final java.util.Map<java.lang.String, java.lang.Object> inputParameters;
        private final software.amazon.awscdk.services.config.MaximumExecutionFrequency maximumExecutionFrequency;
        private final software.amazon.awscdk.services.config.RuleScope ruleScope;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.lambdaFunction = software.amazon.jsii.Kernel.get(this, "lambdaFunction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.configurationChanges = software.amazon.jsii.Kernel.get(this, "configurationChanges", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.periodic = software.amazon.jsii.Kernel.get(this, "periodic", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.configRuleName = software.amazon.jsii.Kernel.get(this, "configRuleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.evaluationModes = software.amazon.jsii.Kernel.get(this, "evaluationModes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.EvaluationMode.class));
            this.inputParameters = software.amazon.jsii.Kernel.get(this, "inputParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.maximumExecutionFrequency = software.amazon.jsii.Kernel.get(this, "maximumExecutionFrequency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.MaximumExecutionFrequency.class));
            this.ruleScope = software.amazon.jsii.Kernel.get(this, "ruleScope", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.RuleScope.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.lambdaFunction = java.util.Objects.requireNonNull(builder.lambdaFunction, "lambdaFunction is required");
            this.configurationChanges = builder.configurationChanges;
            this.periodic = builder.periodic;
            this.configRuleName = builder.configRuleName;
            this.description = builder.description;
            this.evaluationModes = builder.evaluationModes;
            this.inputParameters = (java.util.Map<java.lang.String, java.lang.Object>)builder.inputParameters;
            this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
            this.ruleScope = builder.ruleScope;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getLambdaFunction() {
            return this.lambdaFunction;
        }

        @Override
        public final java.lang.Boolean getConfigurationChanges() {
            return this.configurationChanges;
        }

        @Override
        public final java.lang.Boolean getPeriodic() {
            return this.periodic;
        }

        @Override
        public final java.lang.String getConfigRuleName() {
            return this.configRuleName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.config.EvaluationMode getEvaluationModes() {
            return this.evaluationModes;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getInputParameters() {
            return this.inputParameters;
        }

        @Override
        public final software.amazon.awscdk.services.config.MaximumExecutionFrequency getMaximumExecutionFrequency() {
            return this.maximumExecutionFrequency;
        }

        @Override
        public final software.amazon.awscdk.services.config.RuleScope getRuleScope() {
            return this.ruleScope;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("lambdaFunction", om.valueToTree(this.getLambdaFunction()));
            if (this.getConfigurationChanges() != null) {
                data.set("configurationChanges", om.valueToTree(this.getConfigurationChanges()));
            }
            if (this.getPeriodic() != null) {
                data.set("periodic", om.valueToTree(this.getPeriodic()));
            }
            if (this.getConfigRuleName() != null) {
                data.set("configRuleName", om.valueToTree(this.getConfigRuleName()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEvaluationModes() != null) {
                data.set("evaluationModes", om.valueToTree(this.getEvaluationModes()));
            }
            if (this.getInputParameters() != null) {
                data.set("inputParameters", om.valueToTree(this.getInputParameters()));
            }
            if (this.getMaximumExecutionFrequency() != null) {
                data.set("maximumExecutionFrequency", om.valueToTree(this.getMaximumExecutionFrequency()));
            }
            if (this.getRuleScope() != null) {
                data.set("ruleScope", om.valueToTree(this.getRuleScope()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CustomRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomRuleProps.Jsii$Proxy that = (CustomRuleProps.Jsii$Proxy) o;

            if (!lambdaFunction.equals(that.lambdaFunction)) return false;
            if (this.configurationChanges != null ? !this.configurationChanges.equals(that.configurationChanges) : that.configurationChanges != null) return false;
            if (this.periodic != null ? !this.periodic.equals(that.periodic) : that.periodic != null) return false;
            if (this.configRuleName != null ? !this.configRuleName.equals(that.configRuleName) : that.configRuleName != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.evaluationModes != null ? !this.evaluationModes.equals(that.evaluationModes) : that.evaluationModes != null) return false;
            if (this.inputParameters != null ? !this.inputParameters.equals(that.inputParameters) : that.inputParameters != null) return false;
            if (this.maximumExecutionFrequency != null ? !this.maximumExecutionFrequency.equals(that.maximumExecutionFrequency) : that.maximumExecutionFrequency != null) return false;
            return this.ruleScope != null ? this.ruleScope.equals(that.ruleScope) : that.ruleScope == null;
        }

        @Override
        public final int hashCode() {
            int result = this.lambdaFunction.hashCode();
            result = 31 * result + (this.configurationChanges != null ? this.configurationChanges.hashCode() : 0);
            result = 31 * result + (this.periodic != null ? this.periodic.hashCode() : 0);
            result = 31 * result + (this.configRuleName != null ? this.configRuleName.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.evaluationModes != null ? this.evaluationModes.hashCode() : 0);
            result = 31 * result + (this.inputParameters != null ? this.inputParameters.hashCode() : 0);
            result = 31 * result + (this.maximumExecutionFrequency != null ? this.maximumExecutionFrequency.hashCode() : 0);
            result = 31 * result + (this.ruleScope != null ? this.ruleScope.hashCode() : 0);
            return result;
        }
    }
}
