package software.amazon.awscdk.services.connect;

/**
 * Contains information about a hierarchy structure.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connect.*;
 * CfnUserHierarchyStructure cfnUserHierarchyStructure = CfnUserHierarchyStructure.Builder.create(this, "MyCfnUserHierarchyStructure")
 *         .instanceArn("instanceArn")
 *         // the properties below are optional
 *         .userHierarchyStructure(UserHierarchyStructureProperty.builder()
 *                 .levelFive(LevelFiveProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .hierarchyLevelArn("hierarchyLevelArn")
 *                         .hierarchyLevelId("hierarchyLevelId")
 *                         .build())
 *                 .levelFour(LevelFourProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .hierarchyLevelArn("hierarchyLevelArn")
 *                         .hierarchyLevelId("hierarchyLevelId")
 *                         .build())
 *                 .levelOne(LevelOneProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .hierarchyLevelArn("hierarchyLevelArn")
 *                         .hierarchyLevelId("hierarchyLevelId")
 *                         .build())
 *                 .levelThree(LevelThreeProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .hierarchyLevelArn("hierarchyLevelArn")
 *                         .hierarchyLevelId("hierarchyLevelId")
 *                         .build())
 *                 .levelTwo(LevelTwoProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .hierarchyLevelArn("hierarchyLevelArn")
 *                         .hierarchyLevelId("hierarchyLevelId")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-userhierarchystructure.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-userhierarchystructure.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:48.502Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnUserHierarchyStructure")
public class CfnUserHierarchyStructure extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnUserHierarchyStructure(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnUserHierarchyStructure(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.connect.CfnUserHierarchyStructure.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnUserHierarchyStructure(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connect.CfnUserHierarchyStructureProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The identifier for the user hierarchy structure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUserHierarchyStructureArn() {
        return software.amazon.jsii.Kernel.get(this, "attrUserHierarchyStructureArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The Amazon Resource Name (ARN) of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceArn() {
        return software.amazon.jsii.Kernel.get(this, "instanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceArn", java.util.Objects.requireNonNull(value, "instanceArn is required"));
    }

    /**
     * Contains information about a hierarchy structure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUserHierarchyStructure() {
        return software.amazon.jsii.Kernel.get(this, "userHierarchyStructure", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains information about a hierarchy structure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserHierarchyStructure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "userHierarchyStructure", value);
    }

    /**
     * Contains information about a hierarchy structure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserHierarchyStructure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.connect.CfnUserHierarchyStructure.UserHierarchyStructureProperty value) {
        software.amazon.jsii.Kernel.set(this, "userHierarchyStructure", value);
    }
    /**
     * The update for level five.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * LevelFiveProperty levelFiveProperty = LevelFiveProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .hierarchyLevelArn("hierarchyLevelArn")
     *         .hierarchyLevelId("hierarchyLevelId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelfive.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelfive.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnUserHierarchyStructure.LevelFiveProperty")
    @software.amazon.jsii.Jsii.Proxy(LevelFiveProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LevelFiveProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the hierarchy level.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelfive.html#cfn-connect-userhierarchystructure-levelfive-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelfive.html#cfn-connect-userhierarchystructure-levelfive-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The Amazon Resource Name (ARN) of the hierarchy level.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelfive.html#cfn-connect-userhierarchystructure-levelfive-hierarchylevelarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelfive.html#cfn-connect-userhierarchystructure-levelfive-hierarchylevelarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHierarchyLevelArn() {
            return null;
        }

        /**
         * The identifier of the hierarchy level.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelfive.html#cfn-connect-userhierarchystructure-levelfive-hierarchylevelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelfive.html#cfn-connect-userhierarchystructure-levelfive-hierarchylevelid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHierarchyLevelId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LevelFiveProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LevelFiveProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LevelFiveProperty> {
            java.lang.String name;
            java.lang.String hierarchyLevelArn;
            java.lang.String hierarchyLevelId;

            /**
             * Sets the value of {@link LevelFiveProperty#getName}
             * @param name The name of the hierarchy level. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link LevelFiveProperty#getHierarchyLevelArn}
             * @param hierarchyLevelArn The Amazon Resource Name (ARN) of the hierarchy level.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hierarchyLevelArn(java.lang.String hierarchyLevelArn) {
                this.hierarchyLevelArn = hierarchyLevelArn;
                return this;
            }

            /**
             * Sets the value of {@link LevelFiveProperty#getHierarchyLevelId}
             * @param hierarchyLevelId The identifier of the hierarchy level.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hierarchyLevelId(java.lang.String hierarchyLevelId) {
                this.hierarchyLevelId = hierarchyLevelId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LevelFiveProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LevelFiveProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LevelFiveProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LevelFiveProperty {
            private final java.lang.String name;
            private final java.lang.String hierarchyLevelArn;
            private final java.lang.String hierarchyLevelId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hierarchyLevelArn = software.amazon.jsii.Kernel.get(this, "hierarchyLevelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hierarchyLevelId = software.amazon.jsii.Kernel.get(this, "hierarchyLevelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.hierarchyLevelArn = builder.hierarchyLevelArn;
                this.hierarchyLevelId = builder.hierarchyLevelId;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getHierarchyLevelArn() {
                return this.hierarchyLevelArn;
            }

            @Override
            public final java.lang.String getHierarchyLevelId() {
                return this.hierarchyLevelId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getHierarchyLevelArn() != null) {
                    data.set("hierarchyLevelArn", om.valueToTree(this.getHierarchyLevelArn()));
                }
                if (this.getHierarchyLevelId() != null) {
                    data.set("hierarchyLevelId", om.valueToTree(this.getHierarchyLevelId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnUserHierarchyStructure.LevelFiveProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LevelFiveProperty.Jsii$Proxy that = (LevelFiveProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.hierarchyLevelArn != null ? !this.hierarchyLevelArn.equals(that.hierarchyLevelArn) : that.hierarchyLevelArn != null) return false;
                return this.hierarchyLevelId != null ? this.hierarchyLevelId.equals(that.hierarchyLevelId) : that.hierarchyLevelId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.hierarchyLevelArn != null ? this.hierarchyLevelArn.hashCode() : 0);
                result = 31 * result + (this.hierarchyLevelId != null ? this.hierarchyLevelId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The update for level four.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * LevelFourProperty levelFourProperty = LevelFourProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .hierarchyLevelArn("hierarchyLevelArn")
     *         .hierarchyLevelId("hierarchyLevelId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelfour.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelfour.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnUserHierarchyStructure.LevelFourProperty")
    @software.amazon.jsii.Jsii.Proxy(LevelFourProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LevelFourProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the hierarchy level.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelfour.html#cfn-connect-userhierarchystructure-levelfour-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelfour.html#cfn-connect-userhierarchystructure-levelfour-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The Amazon Resource Name (ARN) of the hierarchy level.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelfour.html#cfn-connect-userhierarchystructure-levelfour-hierarchylevelarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelfour.html#cfn-connect-userhierarchystructure-levelfour-hierarchylevelarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHierarchyLevelArn() {
            return null;
        }

        /**
         * The identifier of the hierarchy level.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelfour.html#cfn-connect-userhierarchystructure-levelfour-hierarchylevelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelfour.html#cfn-connect-userhierarchystructure-levelfour-hierarchylevelid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHierarchyLevelId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LevelFourProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LevelFourProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LevelFourProperty> {
            java.lang.String name;
            java.lang.String hierarchyLevelArn;
            java.lang.String hierarchyLevelId;

            /**
             * Sets the value of {@link LevelFourProperty#getName}
             * @param name The name of the hierarchy level. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link LevelFourProperty#getHierarchyLevelArn}
             * @param hierarchyLevelArn The Amazon Resource Name (ARN) of the hierarchy level.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hierarchyLevelArn(java.lang.String hierarchyLevelArn) {
                this.hierarchyLevelArn = hierarchyLevelArn;
                return this;
            }

            /**
             * Sets the value of {@link LevelFourProperty#getHierarchyLevelId}
             * @param hierarchyLevelId The identifier of the hierarchy level.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hierarchyLevelId(java.lang.String hierarchyLevelId) {
                this.hierarchyLevelId = hierarchyLevelId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LevelFourProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LevelFourProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LevelFourProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LevelFourProperty {
            private final java.lang.String name;
            private final java.lang.String hierarchyLevelArn;
            private final java.lang.String hierarchyLevelId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hierarchyLevelArn = software.amazon.jsii.Kernel.get(this, "hierarchyLevelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hierarchyLevelId = software.amazon.jsii.Kernel.get(this, "hierarchyLevelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.hierarchyLevelArn = builder.hierarchyLevelArn;
                this.hierarchyLevelId = builder.hierarchyLevelId;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getHierarchyLevelArn() {
                return this.hierarchyLevelArn;
            }

            @Override
            public final java.lang.String getHierarchyLevelId() {
                return this.hierarchyLevelId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getHierarchyLevelArn() != null) {
                    data.set("hierarchyLevelArn", om.valueToTree(this.getHierarchyLevelArn()));
                }
                if (this.getHierarchyLevelId() != null) {
                    data.set("hierarchyLevelId", om.valueToTree(this.getHierarchyLevelId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnUserHierarchyStructure.LevelFourProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LevelFourProperty.Jsii$Proxy that = (LevelFourProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.hierarchyLevelArn != null ? !this.hierarchyLevelArn.equals(that.hierarchyLevelArn) : that.hierarchyLevelArn != null) return false;
                return this.hierarchyLevelId != null ? this.hierarchyLevelId.equals(that.hierarchyLevelId) : that.hierarchyLevelId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.hierarchyLevelArn != null ? this.hierarchyLevelArn.hashCode() : 0);
                result = 31 * result + (this.hierarchyLevelId != null ? this.hierarchyLevelId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about level one.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * LevelOneProperty levelOneProperty = LevelOneProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .hierarchyLevelArn("hierarchyLevelArn")
     *         .hierarchyLevelId("hierarchyLevelId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelone.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelone.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnUserHierarchyStructure.LevelOneProperty")
    @software.amazon.jsii.Jsii.Proxy(LevelOneProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LevelOneProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the hierarchy level.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelone.html#cfn-connect-userhierarchystructure-levelone-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelone.html#cfn-connect-userhierarchystructure-levelone-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The Amazon Resource Name (ARN) of the hierarchy level.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelone.html#cfn-connect-userhierarchystructure-levelone-hierarchylevelarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelone.html#cfn-connect-userhierarchystructure-levelone-hierarchylevelarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHierarchyLevelArn() {
            return null;
        }

        /**
         * The identifier of the hierarchy level.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelone.html#cfn-connect-userhierarchystructure-levelone-hierarchylevelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelone.html#cfn-connect-userhierarchystructure-levelone-hierarchylevelid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHierarchyLevelId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LevelOneProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LevelOneProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LevelOneProperty> {
            java.lang.String name;
            java.lang.String hierarchyLevelArn;
            java.lang.String hierarchyLevelId;

            /**
             * Sets the value of {@link LevelOneProperty#getName}
             * @param name The name of the hierarchy level. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link LevelOneProperty#getHierarchyLevelArn}
             * @param hierarchyLevelArn The Amazon Resource Name (ARN) of the hierarchy level.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hierarchyLevelArn(java.lang.String hierarchyLevelArn) {
                this.hierarchyLevelArn = hierarchyLevelArn;
                return this;
            }

            /**
             * Sets the value of {@link LevelOneProperty#getHierarchyLevelId}
             * @param hierarchyLevelId The identifier of the hierarchy level.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hierarchyLevelId(java.lang.String hierarchyLevelId) {
                this.hierarchyLevelId = hierarchyLevelId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LevelOneProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LevelOneProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LevelOneProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LevelOneProperty {
            private final java.lang.String name;
            private final java.lang.String hierarchyLevelArn;
            private final java.lang.String hierarchyLevelId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hierarchyLevelArn = software.amazon.jsii.Kernel.get(this, "hierarchyLevelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hierarchyLevelId = software.amazon.jsii.Kernel.get(this, "hierarchyLevelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.hierarchyLevelArn = builder.hierarchyLevelArn;
                this.hierarchyLevelId = builder.hierarchyLevelId;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getHierarchyLevelArn() {
                return this.hierarchyLevelArn;
            }

            @Override
            public final java.lang.String getHierarchyLevelId() {
                return this.hierarchyLevelId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getHierarchyLevelArn() != null) {
                    data.set("hierarchyLevelArn", om.valueToTree(this.getHierarchyLevelArn()));
                }
                if (this.getHierarchyLevelId() != null) {
                    data.set("hierarchyLevelId", om.valueToTree(this.getHierarchyLevelId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnUserHierarchyStructure.LevelOneProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LevelOneProperty.Jsii$Proxy that = (LevelOneProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.hierarchyLevelArn != null ? !this.hierarchyLevelArn.equals(that.hierarchyLevelArn) : that.hierarchyLevelArn != null) return false;
                return this.hierarchyLevelId != null ? this.hierarchyLevelId.equals(that.hierarchyLevelId) : that.hierarchyLevelId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.hierarchyLevelArn != null ? this.hierarchyLevelArn.hashCode() : 0);
                result = 31 * result + (this.hierarchyLevelId != null ? this.hierarchyLevelId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The update for level three.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * LevelThreeProperty levelThreeProperty = LevelThreeProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .hierarchyLevelArn("hierarchyLevelArn")
     *         .hierarchyLevelId("hierarchyLevelId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelthree.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelthree.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnUserHierarchyStructure.LevelThreeProperty")
    @software.amazon.jsii.Jsii.Proxy(LevelThreeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LevelThreeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the hierarchy level.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelthree.html#cfn-connect-userhierarchystructure-levelthree-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelthree.html#cfn-connect-userhierarchystructure-levelthree-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The Amazon Resource Name (ARN) of the hierarchy level.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelthree.html#cfn-connect-userhierarchystructure-levelthree-hierarchylevelarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelthree.html#cfn-connect-userhierarchystructure-levelthree-hierarchylevelarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHierarchyLevelArn() {
            return null;
        }

        /**
         * The identifier of the hierarchy level.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelthree.html#cfn-connect-userhierarchystructure-levelthree-hierarchylevelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-levelthree.html#cfn-connect-userhierarchystructure-levelthree-hierarchylevelid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHierarchyLevelId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LevelThreeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LevelThreeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LevelThreeProperty> {
            java.lang.String name;
            java.lang.String hierarchyLevelArn;
            java.lang.String hierarchyLevelId;

            /**
             * Sets the value of {@link LevelThreeProperty#getName}
             * @param name The name of the hierarchy level. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link LevelThreeProperty#getHierarchyLevelArn}
             * @param hierarchyLevelArn The Amazon Resource Name (ARN) of the hierarchy level.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hierarchyLevelArn(java.lang.String hierarchyLevelArn) {
                this.hierarchyLevelArn = hierarchyLevelArn;
                return this;
            }

            /**
             * Sets the value of {@link LevelThreeProperty#getHierarchyLevelId}
             * @param hierarchyLevelId The identifier of the hierarchy level.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hierarchyLevelId(java.lang.String hierarchyLevelId) {
                this.hierarchyLevelId = hierarchyLevelId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LevelThreeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LevelThreeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LevelThreeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LevelThreeProperty {
            private final java.lang.String name;
            private final java.lang.String hierarchyLevelArn;
            private final java.lang.String hierarchyLevelId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hierarchyLevelArn = software.amazon.jsii.Kernel.get(this, "hierarchyLevelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hierarchyLevelId = software.amazon.jsii.Kernel.get(this, "hierarchyLevelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.hierarchyLevelArn = builder.hierarchyLevelArn;
                this.hierarchyLevelId = builder.hierarchyLevelId;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getHierarchyLevelArn() {
                return this.hierarchyLevelArn;
            }

            @Override
            public final java.lang.String getHierarchyLevelId() {
                return this.hierarchyLevelId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getHierarchyLevelArn() != null) {
                    data.set("hierarchyLevelArn", om.valueToTree(this.getHierarchyLevelArn()));
                }
                if (this.getHierarchyLevelId() != null) {
                    data.set("hierarchyLevelId", om.valueToTree(this.getHierarchyLevelId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnUserHierarchyStructure.LevelThreeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LevelThreeProperty.Jsii$Proxy that = (LevelThreeProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.hierarchyLevelArn != null ? !this.hierarchyLevelArn.equals(that.hierarchyLevelArn) : that.hierarchyLevelArn != null) return false;
                return this.hierarchyLevelId != null ? this.hierarchyLevelId.equals(that.hierarchyLevelId) : that.hierarchyLevelId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.hierarchyLevelArn != null ? this.hierarchyLevelArn.hashCode() : 0);
                result = 31 * result + (this.hierarchyLevelId != null ? this.hierarchyLevelId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The update for level two.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * LevelTwoProperty levelTwoProperty = LevelTwoProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .hierarchyLevelArn("hierarchyLevelArn")
     *         .hierarchyLevelId("hierarchyLevelId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-leveltwo.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-leveltwo.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnUserHierarchyStructure.LevelTwoProperty")
    @software.amazon.jsii.Jsii.Proxy(LevelTwoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LevelTwoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the hierarchy level.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-leveltwo.html#cfn-connect-userhierarchystructure-leveltwo-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-leveltwo.html#cfn-connect-userhierarchystructure-leveltwo-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The Amazon Resource Name (ARN) of the hierarchy level.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-leveltwo.html#cfn-connect-userhierarchystructure-leveltwo-hierarchylevelarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-leveltwo.html#cfn-connect-userhierarchystructure-leveltwo-hierarchylevelarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHierarchyLevelArn() {
            return null;
        }

        /**
         * The identifier of the hierarchy level.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-leveltwo.html#cfn-connect-userhierarchystructure-leveltwo-hierarchylevelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-leveltwo.html#cfn-connect-userhierarchystructure-leveltwo-hierarchylevelid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHierarchyLevelId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LevelTwoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LevelTwoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LevelTwoProperty> {
            java.lang.String name;
            java.lang.String hierarchyLevelArn;
            java.lang.String hierarchyLevelId;

            /**
             * Sets the value of {@link LevelTwoProperty#getName}
             * @param name The name of the hierarchy level. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link LevelTwoProperty#getHierarchyLevelArn}
             * @param hierarchyLevelArn The Amazon Resource Name (ARN) of the hierarchy level.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hierarchyLevelArn(java.lang.String hierarchyLevelArn) {
                this.hierarchyLevelArn = hierarchyLevelArn;
                return this;
            }

            /**
             * Sets the value of {@link LevelTwoProperty#getHierarchyLevelId}
             * @param hierarchyLevelId The identifier of the hierarchy level.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hierarchyLevelId(java.lang.String hierarchyLevelId) {
                this.hierarchyLevelId = hierarchyLevelId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LevelTwoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LevelTwoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LevelTwoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LevelTwoProperty {
            private final java.lang.String name;
            private final java.lang.String hierarchyLevelArn;
            private final java.lang.String hierarchyLevelId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hierarchyLevelArn = software.amazon.jsii.Kernel.get(this, "hierarchyLevelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hierarchyLevelId = software.amazon.jsii.Kernel.get(this, "hierarchyLevelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.hierarchyLevelArn = builder.hierarchyLevelArn;
                this.hierarchyLevelId = builder.hierarchyLevelId;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getHierarchyLevelArn() {
                return this.hierarchyLevelArn;
            }

            @Override
            public final java.lang.String getHierarchyLevelId() {
                return this.hierarchyLevelId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getHierarchyLevelArn() != null) {
                    data.set("hierarchyLevelArn", om.valueToTree(this.getHierarchyLevelArn()));
                }
                if (this.getHierarchyLevelId() != null) {
                    data.set("hierarchyLevelId", om.valueToTree(this.getHierarchyLevelId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnUserHierarchyStructure.LevelTwoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LevelTwoProperty.Jsii$Proxy that = (LevelTwoProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.hierarchyLevelArn != null ? !this.hierarchyLevelArn.equals(that.hierarchyLevelArn) : that.hierarchyLevelArn != null) return false;
                return this.hierarchyLevelId != null ? this.hierarchyLevelId.equals(that.hierarchyLevelId) : that.hierarchyLevelId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.hierarchyLevelArn != null ? this.hierarchyLevelArn.hashCode() : 0);
                result = 31 * result + (this.hierarchyLevelId != null ? this.hierarchyLevelId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about a hierarchy structure.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * UserHierarchyStructureProperty userHierarchyStructureProperty = UserHierarchyStructureProperty.builder()
     *         .levelFive(LevelFiveProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .hierarchyLevelArn("hierarchyLevelArn")
     *                 .hierarchyLevelId("hierarchyLevelId")
     *                 .build())
     *         .levelFour(LevelFourProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .hierarchyLevelArn("hierarchyLevelArn")
     *                 .hierarchyLevelId("hierarchyLevelId")
     *                 .build())
     *         .levelOne(LevelOneProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .hierarchyLevelArn("hierarchyLevelArn")
     *                 .hierarchyLevelId("hierarchyLevelId")
     *                 .build())
     *         .levelThree(LevelThreeProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .hierarchyLevelArn("hierarchyLevelArn")
     *                 .hierarchyLevelId("hierarchyLevelId")
     *                 .build())
     *         .levelTwo(LevelTwoProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .hierarchyLevelArn("hierarchyLevelArn")
     *                 .hierarchyLevelId("hierarchyLevelId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-userhierarchystructure.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-userhierarchystructure.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnUserHierarchyStructure.UserHierarchyStructureProperty")
    @software.amazon.jsii.Jsii.Proxy(UserHierarchyStructureProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UserHierarchyStructureProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about level five.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-userhierarchystructure.html#cfn-connect-userhierarchystructure-userhierarchystructure-levelfive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-userhierarchystructure.html#cfn-connect-userhierarchystructure-userhierarchystructure-levelfive</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLevelFive() {
            return null;
        }

        /**
         * The update for level four.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-userhierarchystructure.html#cfn-connect-userhierarchystructure-userhierarchystructure-levelfour">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-userhierarchystructure.html#cfn-connect-userhierarchystructure-userhierarchystructure-levelfour</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLevelFour() {
            return null;
        }

        /**
         * The update for level one.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-userhierarchystructure.html#cfn-connect-userhierarchystructure-userhierarchystructure-levelone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-userhierarchystructure.html#cfn-connect-userhierarchystructure-userhierarchystructure-levelone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLevelOne() {
            return null;
        }

        /**
         * The update for level three.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-userhierarchystructure.html#cfn-connect-userhierarchystructure-userhierarchystructure-levelthree">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-userhierarchystructure.html#cfn-connect-userhierarchystructure-userhierarchystructure-levelthree</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLevelThree() {
            return null;
        }

        /**
         * The update for level two.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-userhierarchystructure.html#cfn-connect-userhierarchystructure-userhierarchystructure-leveltwo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-userhierarchystructure-userhierarchystructure.html#cfn-connect-userhierarchystructure-userhierarchystructure-leveltwo</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLevelTwo() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UserHierarchyStructureProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UserHierarchyStructureProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UserHierarchyStructureProperty> {
            java.lang.Object levelFive;
            java.lang.Object levelFour;
            java.lang.Object levelOne;
            java.lang.Object levelThree;
            java.lang.Object levelTwo;

            /**
             * Sets the value of {@link UserHierarchyStructureProperty#getLevelFive}
             * @param levelFive Information about level five.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder levelFive(software.amazon.awscdk.IResolvable levelFive) {
                this.levelFive = levelFive;
                return this;
            }

            /**
             * Sets the value of {@link UserHierarchyStructureProperty#getLevelFive}
             * @param levelFive Information about level five.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder levelFive(software.amazon.awscdk.services.connect.CfnUserHierarchyStructure.LevelFiveProperty levelFive) {
                this.levelFive = levelFive;
                return this;
            }

            /**
             * Sets the value of {@link UserHierarchyStructureProperty#getLevelFour}
             * @param levelFour The update for level four.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder levelFour(software.amazon.awscdk.IResolvable levelFour) {
                this.levelFour = levelFour;
                return this;
            }

            /**
             * Sets the value of {@link UserHierarchyStructureProperty#getLevelFour}
             * @param levelFour The update for level four.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder levelFour(software.amazon.awscdk.services.connect.CfnUserHierarchyStructure.LevelFourProperty levelFour) {
                this.levelFour = levelFour;
                return this;
            }

            /**
             * Sets the value of {@link UserHierarchyStructureProperty#getLevelOne}
             * @param levelOne The update for level one.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder levelOne(software.amazon.awscdk.IResolvable levelOne) {
                this.levelOne = levelOne;
                return this;
            }

            /**
             * Sets the value of {@link UserHierarchyStructureProperty#getLevelOne}
             * @param levelOne The update for level one.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder levelOne(software.amazon.awscdk.services.connect.CfnUserHierarchyStructure.LevelOneProperty levelOne) {
                this.levelOne = levelOne;
                return this;
            }

            /**
             * Sets the value of {@link UserHierarchyStructureProperty#getLevelThree}
             * @param levelThree The update for level three.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder levelThree(software.amazon.awscdk.IResolvable levelThree) {
                this.levelThree = levelThree;
                return this;
            }

            /**
             * Sets the value of {@link UserHierarchyStructureProperty#getLevelThree}
             * @param levelThree The update for level three.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder levelThree(software.amazon.awscdk.services.connect.CfnUserHierarchyStructure.LevelThreeProperty levelThree) {
                this.levelThree = levelThree;
                return this;
            }

            /**
             * Sets the value of {@link UserHierarchyStructureProperty#getLevelTwo}
             * @param levelTwo The update for level two.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder levelTwo(software.amazon.awscdk.IResolvable levelTwo) {
                this.levelTwo = levelTwo;
                return this;
            }

            /**
             * Sets the value of {@link UserHierarchyStructureProperty#getLevelTwo}
             * @param levelTwo The update for level two.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder levelTwo(software.amazon.awscdk.services.connect.CfnUserHierarchyStructure.LevelTwoProperty levelTwo) {
                this.levelTwo = levelTwo;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UserHierarchyStructureProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UserHierarchyStructureProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UserHierarchyStructureProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserHierarchyStructureProperty {
            private final java.lang.Object levelFive;
            private final java.lang.Object levelFour;
            private final java.lang.Object levelOne;
            private final java.lang.Object levelThree;
            private final java.lang.Object levelTwo;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.levelFive = software.amazon.jsii.Kernel.get(this, "levelFive", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.levelFour = software.amazon.jsii.Kernel.get(this, "levelFour", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.levelOne = software.amazon.jsii.Kernel.get(this, "levelOne", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.levelThree = software.amazon.jsii.Kernel.get(this, "levelThree", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.levelTwo = software.amazon.jsii.Kernel.get(this, "levelTwo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.levelFive = builder.levelFive;
                this.levelFour = builder.levelFour;
                this.levelOne = builder.levelOne;
                this.levelThree = builder.levelThree;
                this.levelTwo = builder.levelTwo;
            }

            @Override
            public final java.lang.Object getLevelFive() {
                return this.levelFive;
            }

            @Override
            public final java.lang.Object getLevelFour() {
                return this.levelFour;
            }

            @Override
            public final java.lang.Object getLevelOne() {
                return this.levelOne;
            }

            @Override
            public final java.lang.Object getLevelThree() {
                return this.levelThree;
            }

            @Override
            public final java.lang.Object getLevelTwo() {
                return this.levelTwo;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLevelFive() != null) {
                    data.set("levelFive", om.valueToTree(this.getLevelFive()));
                }
                if (this.getLevelFour() != null) {
                    data.set("levelFour", om.valueToTree(this.getLevelFour()));
                }
                if (this.getLevelOne() != null) {
                    data.set("levelOne", om.valueToTree(this.getLevelOne()));
                }
                if (this.getLevelThree() != null) {
                    data.set("levelThree", om.valueToTree(this.getLevelThree()));
                }
                if (this.getLevelTwo() != null) {
                    data.set("levelTwo", om.valueToTree(this.getLevelTwo()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnUserHierarchyStructure.UserHierarchyStructureProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UserHierarchyStructureProperty.Jsii$Proxy that = (UserHierarchyStructureProperty.Jsii$Proxy) o;

                if (this.levelFive != null ? !this.levelFive.equals(that.levelFive) : that.levelFive != null) return false;
                if (this.levelFour != null ? !this.levelFour.equals(that.levelFour) : that.levelFour != null) return false;
                if (this.levelOne != null ? !this.levelOne.equals(that.levelOne) : that.levelOne != null) return false;
                if (this.levelThree != null ? !this.levelThree.equals(that.levelThree) : that.levelThree != null) return false;
                return this.levelTwo != null ? this.levelTwo.equals(that.levelTwo) : that.levelTwo == null;
            }

            @Override
            public final int hashCode() {
                int result = this.levelFive != null ? this.levelFive.hashCode() : 0;
                result = 31 * result + (this.levelFour != null ? this.levelFour.hashCode() : 0);
                result = 31 * result + (this.levelOne != null ? this.levelOne.hashCode() : 0);
                result = 31 * result + (this.levelThree != null ? this.levelThree.hashCode() : 0);
                result = 31 * result + (this.levelTwo != null ? this.levelTwo.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.connect.CfnUserHierarchyStructure}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.connect.CfnUserHierarchyStructure> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.connect.CfnUserHierarchyStructureProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.connect.CfnUserHierarchyStructureProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of the instance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-userhierarchystructure.html#cfn-connect-userhierarchystructure-instancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-userhierarchystructure.html#cfn-connect-userhierarchystructure-instancearn</a>
         * @param instanceArn The Amazon Resource Name (ARN) of the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceArn(final java.lang.String instanceArn) {
            this.props.instanceArn(instanceArn);
            return this;
        }

        /**
         * Contains information about a hierarchy structure.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-userhierarchystructure.html#cfn-connect-userhierarchystructure-userhierarchystructure">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-userhierarchystructure.html#cfn-connect-userhierarchystructure-userhierarchystructure</a>
         * @param userHierarchyStructure Contains information about a hierarchy structure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userHierarchyStructure(final software.amazon.awscdk.IResolvable userHierarchyStructure) {
            this.props.userHierarchyStructure(userHierarchyStructure);
            return this;
        }
        /**
         * Contains information about a hierarchy structure.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-userhierarchystructure.html#cfn-connect-userhierarchystructure-userhierarchystructure">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-userhierarchystructure.html#cfn-connect-userhierarchystructure-userhierarchystructure</a>
         * @param userHierarchyStructure Contains information about a hierarchy structure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userHierarchyStructure(final software.amazon.awscdk.services.connect.CfnUserHierarchyStructure.UserHierarchyStructureProperty userHierarchyStructure) {
            this.props.userHierarchyStructure(userHierarchyStructure);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.connect.CfnUserHierarchyStructure}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.connect.CfnUserHierarchyStructure build() {
            return new software.amazon.awscdk.services.connect.CfnUserHierarchyStructure(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
