package software.amazon.awscdk.services.dynamodb;

/**
 * Properties for importing data from the S3.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.s3.*;
 * IBucket bucket;
 * App app = new App();
 * Stack stack = new Stack(app, "Stack");
 * Table.Builder.create(stack, "Table")
 *         .partitionKey(Attribute.builder()
 *                 .name("id")
 *                 .type(AttributeType.STRING)
 *                 .build())
 *         .importSource(ImportSourceSpecification.builder()
 *                 .compressionType(InputCompressionType.GZIP)
 *                 .inputFormat(InputFormat.dynamoDBJson())
 *                 .bucket(bucket)
 *                 .keyPrefix("prefix")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:49.202Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.ImportSourceSpecification")
@software.amazon.jsii.Jsii.Proxy(ImportSourceSpecification.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ImportSourceSpecification extends software.amazon.jsii.JsiiSerializable {

    /**
     * The S3 bucket that is being imported from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getBucket();

    /**
     * The format of the imported data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.InputFormat getInputFormat();

    /**
     * The account number of the S3 bucket that is being imported from.
     * <p>
     * Default: - no value
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBucketOwner() {
        return null;
    }

    /**
     * The compression type of the imported data.
     * <p>
     * Default: InputCompressionType.NONE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.InputCompressionType getCompressionType() {
        return null;
    }

    /**
     * The key prefix shared by all S3 Objects that are being imported.
     * <p>
     * Default: - no value
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyPrefix() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ImportSourceSpecification}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ImportSourceSpecification}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ImportSourceSpecification> {
        software.amazon.awscdk.services.s3.IBucket bucket;
        software.amazon.awscdk.services.dynamodb.InputFormat inputFormat;
        java.lang.String bucketOwner;
        software.amazon.awscdk.services.dynamodb.InputCompressionType compressionType;
        java.lang.String keyPrefix;

        /**
         * Sets the value of {@link ImportSourceSpecification#getBucket}
         * @param bucket The S3 bucket that is being imported from. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link ImportSourceSpecification#getInputFormat}
         * @param inputFormat The format of the imported data. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputFormat(software.amazon.awscdk.services.dynamodb.InputFormat inputFormat) {
            this.inputFormat = inputFormat;
            return this;
        }

        /**
         * Sets the value of {@link ImportSourceSpecification#getBucketOwner}
         * @param bucketOwner The account number of the S3 bucket that is being imported from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketOwner(java.lang.String bucketOwner) {
            this.bucketOwner = bucketOwner;
            return this;
        }

        /**
         * Sets the value of {@link ImportSourceSpecification#getCompressionType}
         * @param compressionType The compression type of the imported data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compressionType(software.amazon.awscdk.services.dynamodb.InputCompressionType compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        /**
         * Sets the value of {@link ImportSourceSpecification#getKeyPrefix}
         * @param keyPrefix The key prefix shared by all S3 Objects that are being imported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPrefix(java.lang.String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ImportSourceSpecification}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ImportSourceSpecification build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ImportSourceSpecification}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImportSourceSpecification {
        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private final software.amazon.awscdk.services.dynamodb.InputFormat inputFormat;
        private final java.lang.String bucketOwner;
        private final software.amazon.awscdk.services.dynamodb.InputCompressionType compressionType;
        private final java.lang.String keyPrefix;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.inputFormat = software.amazon.jsii.Kernel.get(this, "inputFormat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.InputFormat.class));
            this.bucketOwner = software.amazon.jsii.Kernel.get(this, "bucketOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.compressionType = software.amazon.jsii.Kernel.get(this, "compressionType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.InputCompressionType.class));
            this.keyPrefix = software.amazon.jsii.Kernel.get(this, "keyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
            this.inputFormat = java.util.Objects.requireNonNull(builder.inputFormat, "inputFormat is required");
            this.bucketOwner = builder.bucketOwner;
            this.compressionType = builder.compressionType;
            this.keyPrefix = builder.keyPrefix;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.bucket;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.InputFormat getInputFormat() {
            return this.inputFormat;
        }

        @Override
        public final java.lang.String getBucketOwner() {
            return this.bucketOwner;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.InputCompressionType getCompressionType() {
            return this.compressionType;
        }

        @Override
        public final java.lang.String getKeyPrefix() {
            return this.keyPrefix;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucket", om.valueToTree(this.getBucket()));
            data.set("inputFormat", om.valueToTree(this.getInputFormat()));
            if (this.getBucketOwner() != null) {
                data.set("bucketOwner", om.valueToTree(this.getBucketOwner()));
            }
            if (this.getCompressionType() != null) {
                data.set("compressionType", om.valueToTree(this.getCompressionType()));
            }
            if (this.getKeyPrefix() != null) {
                data.set("keyPrefix", om.valueToTree(this.getKeyPrefix()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.ImportSourceSpecification"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ImportSourceSpecification.Jsii$Proxy that = (ImportSourceSpecification.Jsii$Proxy) o;

            if (!bucket.equals(that.bucket)) return false;
            if (!inputFormat.equals(that.inputFormat)) return false;
            if (this.bucketOwner != null ? !this.bucketOwner.equals(that.bucketOwner) : that.bucketOwner != null) return false;
            if (this.compressionType != null ? !this.compressionType.equals(that.compressionType) : that.compressionType != null) return false;
            return this.keyPrefix != null ? this.keyPrefix.equals(that.keyPrefix) : that.keyPrefix == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucket.hashCode();
            result = 31 * result + (this.inputFormat.hashCode());
            result = 31 * result + (this.bucketOwner != null ? this.bucketOwner.hashCode() : 0);
            result = 31 * result + (this.compressionType != null ? this.compressionType.hashCode() : 0);
            result = 31 * result + (this.keyPrefix != null ? this.keyPrefix.hashCode() : 0);
            return result;
        }
    }
}
