package software.amazon.awscdk.services.dynamodb;

/**
 * Represents the table schema attributes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dynamodb.*;
 * SchemaOptions schemaOptions = SchemaOptions.builder()
 *         .partitionKey(Attribute.builder()
 *                 .name("name")
 *                 .type(AttributeType.BINARY)
 *                 .build())
 *         // the properties below are optional
 *         .sortKey(Attribute.builder()
 *                 .name("name")
 *                 .type(AttributeType.BINARY)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:49.207Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.SchemaOptions")
@software.amazon.jsii.Jsii.Proxy(SchemaOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SchemaOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Partition key attribute definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.Attribute getPartitionKey();

    /**
     * Sort key attribute definition.
     * <p>
     * Default: no sort key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.Attribute getSortKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SchemaOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SchemaOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SchemaOptions> {
        software.amazon.awscdk.services.dynamodb.Attribute partitionKey;
        software.amazon.awscdk.services.dynamodb.Attribute sortKey;

        /**
         * Sets the value of {@link SchemaOptions#getPartitionKey}
         * @param partitionKey Partition key attribute definition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitionKey(software.amazon.awscdk.services.dynamodb.Attribute partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        /**
         * Sets the value of {@link SchemaOptions#getSortKey}
         * @param sortKey Sort key attribute definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sortKey(software.amazon.awscdk.services.dynamodb.Attribute sortKey) {
            this.sortKey = sortKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SchemaOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SchemaOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SchemaOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SchemaOptions {
        private final software.amazon.awscdk.services.dynamodb.Attribute partitionKey;
        private final software.amazon.awscdk.services.dynamodb.Attribute sortKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.partitionKey = software.amazon.jsii.Kernel.get(this, "partitionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Attribute.class));
            this.sortKey = software.amazon.jsii.Kernel.get(this, "sortKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Attribute.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.partitionKey = java.util.Objects.requireNonNull(builder.partitionKey, "partitionKey is required");
            this.sortKey = builder.sortKey;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.Attribute getPartitionKey() {
            return this.partitionKey;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.Attribute getSortKey() {
            return this.sortKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("partitionKey", om.valueToTree(this.getPartitionKey()));
            if (this.getSortKey() != null) {
                data.set("sortKey", om.valueToTree(this.getSortKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.SchemaOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SchemaOptions.Jsii$Proxy that = (SchemaOptions.Jsii$Proxy) o;

            if (!partitionKey.equals(that.partitionKey)) return false;
            return this.sortKey != null ? this.sortKey.equals(that.sortKey) : that.sortKey == null;
        }

        @Override
        public final int hashCode() {
            int result = this.partitionKey.hashCode();
            result = 31 * result + (this.sortKey != null ? this.sortKey.hashCode() : 0);
            return result;
        }
    }
}
