package software.amazon.awscdk.services.dynamodb;

/**
 * Options for configuring a system errors metric that considers multiple operations.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.cloudwatch.*;
 * import software.amazon.awscdk.services.dynamodb.*;
 * SystemErrorsForOperationsMetricOptions systemErrorsForOperationsMetricOptions = SystemErrorsForOperationsMetricOptions.builder()
 *         .account("account")
 *         .color("color")
 *         .dimensionsMap(Map.of(
 *                 "dimensionsMapKey", "dimensionsMap"))
 *         .label("label")
 *         .operations(List.of(Operation.GET_ITEM))
 *         .period(Duration.minutes(30))
 *         .region("region")
 *         .stackAccount("stackAccount")
 *         .stackRegion("stackRegion")
 *         .statistic("statistic")
 *         .unit(Unit.SECONDS)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:49.208Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.SystemErrorsForOperationsMetricOptions")
@software.amazon.jsii.Jsii.Proxy(SystemErrorsForOperationsMetricOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SystemErrorsForOperationsMetricOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cloudwatch.MetricOptions {

    /**
     * The operations to apply the metric to.
     * <p>
     * Default: - All operations available by DynamoDB tables will be considered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.dynamodb.Operation> getOperations() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SystemErrorsForOperationsMetricOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SystemErrorsForOperationsMetricOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SystemErrorsForOperationsMetricOptions> {
        java.util.List<software.amazon.awscdk.services.dynamodb.Operation> operations;
        java.lang.String account;
        java.lang.String color;
        java.util.Map<java.lang.String, java.lang.String> dimensionsMap;
        java.lang.String label;
        software.amazon.awscdk.Duration period;
        java.lang.String region;
        java.lang.String stackAccount;
        java.lang.String stackRegion;
        java.lang.String statistic;
        software.amazon.awscdk.services.cloudwatch.Unit unit;

        /**
         * Sets the value of {@link SystemErrorsForOperationsMetricOptions#getOperations}
         * @param operations The operations to apply the metric to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder operations(java.util.List<? extends software.amazon.awscdk.services.dynamodb.Operation> operations) {
            this.operations = (java.util.List<software.amazon.awscdk.services.dynamodb.Operation>)operations;
            return this;
        }

        /**
         * Sets the value of {@link SystemErrorsForOperationsMetricOptions#getAccount}
         * @param account Account which this metric comes from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder account(java.lang.String account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of {@link SystemErrorsForOperationsMetricOptions#getColor}
         * @param color The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The <code>Color</code> class has a set of standard colors that can be used here.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder color(java.lang.String color) {
            this.color = color;
            return this;
        }

        /**
         * Sets the value of {@link SystemErrorsForOperationsMetricOptions#getDimensionsMap}
         * @param dimensionsMap Dimensions of the metric.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dimensionsMap(java.util.Map<java.lang.String, java.lang.String> dimensionsMap) {
            this.dimensionsMap = dimensionsMap;
            return this;
        }

        /**
         * Sets the value of {@link SystemErrorsForOperationsMetricOptions#getLabel}
         * @param label Label for this metric when added to a Graph in a Dashboard.
         *              You can use <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">dynamic labels</a>
         *              to show summary information about the entire displayed time series
         *              in the legend. For example, if you use:
         *              <p>
         *              <blockquote><pre>
         *              [max: ${MAX}] MyMetric
         *              </pre></blockquote>
         *              <p>
         *              As the metric label, the maximum value in the visible range will
         *              be shown next to the time series name in the graph's legend.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder label(java.lang.String label) {
            this.label = label;
            return this;
        }

        /**
         * Sets the value of {@link SystemErrorsForOperationsMetricOptions#getPeriod}
         * @param period The period over which the specified statistic is applied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder period(software.amazon.awscdk.Duration period) {
            this.period = period;
            return this;
        }

        /**
         * Sets the value of {@link SystemErrorsForOperationsMetricOptions#getRegion}
         * @param region Region which this metric comes from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link SystemErrorsForOperationsMetricOptions#getStackAccount}
         * @param stackAccount Account of the stack this metric is attached to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackAccount(java.lang.String stackAccount) {
            this.stackAccount = stackAccount;
            return this;
        }

        /**
         * Sets the value of {@link SystemErrorsForOperationsMetricOptions#getStackRegion}
         * @param stackRegion Region of the stack this metric is attached to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackRegion(java.lang.String stackRegion) {
            this.stackRegion = stackRegion;
            return this;
        }

        /**
         * Sets the value of {@link SystemErrorsForOperationsMetricOptions#getStatistic}
         * @param statistic What function to use for aggregating.
         *                  Use the <code>aws_cloudwatch.Stats</code> helper class to construct valid input strings.
         *                  <p>
         *                  Can be one of the following:
         *                  <p>
         *                  <ul>
         *                  <li>"Minimum" | "min"</li>
         *                  <li>"Maximum" | "max"</li>
         *                  <li>"Average" | "avg"</li>
         *                  <li>"Sum" | "sum"</li>
         *                  <li>"SampleCount | "n"</li>
         *                  <li>"pNN.NN"</li>
         *                  <li>"tmNN.NN" | "tm(NN.NN%:NN.NN%)"</li>
         *                  <li>"iqm"</li>
         *                  <li>"wmNN.NN" | "wm(NN.NN%:NN.NN%)"</li>
         *                  <li>"tcNN.NN" | "tc(NN.NN%:NN.NN%)"</li>
         *                  <li>"tsNN.NN" | "ts(NN.NN%:NN.NN%)"</li>
         *                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statistic(java.lang.String statistic) {
            this.statistic = statistic;
            return this;
        }

        /**
         * Sets the value of {@link SystemErrorsForOperationsMetricOptions#getUnit}
         * @param unit Unit used to filter the metric stream.
         *             Only refer to datums emitted to the metric stream with the given unit and
         *             ignore all others. Only useful when datums are being emitted to the same
         *             metric stream under different units.
         *             <p>
         *             The default is to use all matric datums in the stream, regardless of unit,
         *             which is recommended in nearly all cases.
         *             <p>
         *             CloudWatch does not honor this property for graphs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder unit(software.amazon.awscdk.services.cloudwatch.Unit unit) {
            this.unit = unit;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SystemErrorsForOperationsMetricOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SystemErrorsForOperationsMetricOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SystemErrorsForOperationsMetricOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SystemErrorsForOperationsMetricOptions {
        private final java.util.List<software.amazon.awscdk.services.dynamodb.Operation> operations;
        private final java.lang.String account;
        private final java.lang.String color;
        private final java.util.Map<java.lang.String, java.lang.String> dimensionsMap;
        private final java.lang.String label;
        private final software.amazon.awscdk.Duration period;
        private final java.lang.String region;
        private final java.lang.String stackAccount;
        private final java.lang.String stackRegion;
        private final java.lang.String statistic;
        private final software.amazon.awscdk.services.cloudwatch.Unit unit;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.operations = software.amazon.jsii.Kernel.get(this, "operations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Operation.class)));
            this.account = software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.color = software.amazon.jsii.Kernel.get(this, "color", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dimensionsMap = software.amazon.jsii.Kernel.get(this, "dimensionsMap", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.label = software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stackAccount = software.amazon.jsii.Kernel.get(this, "stackAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stackRegion = software.amazon.jsii.Kernel.get(this, "stackRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Unit.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.operations = (java.util.List<software.amazon.awscdk.services.dynamodb.Operation>)builder.operations;
            this.account = builder.account;
            this.color = builder.color;
            this.dimensionsMap = builder.dimensionsMap;
            this.label = builder.label;
            this.period = builder.period;
            this.region = builder.region;
            this.stackAccount = builder.stackAccount;
            this.stackRegion = builder.stackRegion;
            this.statistic = builder.statistic;
            this.unit = builder.unit;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.dynamodb.Operation> getOperations() {
            return this.operations;
        }

        @Override
        public final java.lang.String getAccount() {
            return this.account;
        }

        @Override
        public final java.lang.String getColor() {
            return this.color;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getDimensionsMap() {
            return this.dimensionsMap;
        }

        @Override
        public final java.lang.String getLabel() {
            return this.label;
        }

        @Override
        public final software.amazon.awscdk.Duration getPeriod() {
            return this.period;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.String getStackAccount() {
            return this.stackAccount;
        }

        @Override
        public final java.lang.String getStackRegion() {
            return this.stackRegion;
        }

        @Override
        public final java.lang.String getStatistic() {
            return this.statistic;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.Unit getUnit() {
            return this.unit;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getOperations() != null) {
                data.set("operations", om.valueToTree(this.getOperations()));
            }
            if (this.getAccount() != null) {
                data.set("account", om.valueToTree(this.getAccount()));
            }
            if (this.getColor() != null) {
                data.set("color", om.valueToTree(this.getColor()));
            }
            if (this.getDimensionsMap() != null) {
                data.set("dimensionsMap", om.valueToTree(this.getDimensionsMap()));
            }
            if (this.getLabel() != null) {
                data.set("label", om.valueToTree(this.getLabel()));
            }
            if (this.getPeriod() != null) {
                data.set("period", om.valueToTree(this.getPeriod()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getStackAccount() != null) {
                data.set("stackAccount", om.valueToTree(this.getStackAccount()));
            }
            if (this.getStackRegion() != null) {
                data.set("stackRegion", om.valueToTree(this.getStackRegion()));
            }
            if (this.getStatistic() != null) {
                data.set("statistic", om.valueToTree(this.getStatistic()));
            }
            if (this.getUnit() != null) {
                data.set("unit", om.valueToTree(this.getUnit()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.SystemErrorsForOperationsMetricOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SystemErrorsForOperationsMetricOptions.Jsii$Proxy that = (SystemErrorsForOperationsMetricOptions.Jsii$Proxy) o;

            if (this.operations != null ? !this.operations.equals(that.operations) : that.operations != null) return false;
            if (this.account != null ? !this.account.equals(that.account) : that.account != null) return false;
            if (this.color != null ? !this.color.equals(that.color) : that.color != null) return false;
            if (this.dimensionsMap != null ? !this.dimensionsMap.equals(that.dimensionsMap) : that.dimensionsMap != null) return false;
            if (this.label != null ? !this.label.equals(that.label) : that.label != null) return false;
            if (this.period != null ? !this.period.equals(that.period) : that.period != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.stackAccount != null ? !this.stackAccount.equals(that.stackAccount) : that.stackAccount != null) return false;
            if (this.stackRegion != null ? !this.stackRegion.equals(that.stackRegion) : that.stackRegion != null) return false;
            if (this.statistic != null ? !this.statistic.equals(that.statistic) : that.statistic != null) return false;
            return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
        }

        @Override
        public final int hashCode() {
            int result = this.operations != null ? this.operations.hashCode() : 0;
            result = 31 * result + (this.account != null ? this.account.hashCode() : 0);
            result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
            result = 31 * result + (this.dimensionsMap != null ? this.dimensionsMap.hashCode() : 0);
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.stackAccount != null ? this.stackAccount.hashCode() : 0);
            result = 31 * result + (this.stackRegion != null ? this.stackRegion.hashCode() : 0);
            result = 31 * result + (this.statistic != null ? this.statistic.hashCode() : 0);
            result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
            return result;
        }
    }
}
