package software.amazon.awscdk.services.ecr;

/**
 * Properties for defining a <code>CfnRepositoryCreationTemplate</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecr.*;
 * CfnRepositoryCreationTemplateProps cfnRepositoryCreationTemplateProps = CfnRepositoryCreationTemplateProps.builder()
 *         .appliedFor(List.of("appliedFor"))
 *         .prefix("prefix")
 *         // the properties below are optional
 *         .customRoleArn("customRoleArn")
 *         .description("description")
 *         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                 .encryptionType("encryptionType")
 *                 // the properties below are optional
 *                 .kmsKey("kmsKey")
 *                 .build())
 *         .imageTagMutability("imageTagMutability")
 *         .lifecyclePolicy("lifecyclePolicy")
 *         .repositoryPolicy("repositoryPolicy")
 *         .resourceTags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repositorycreationtemplate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repositorycreationtemplate.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:50.032Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecr.CfnRepositoryCreationTemplateProps")
@software.amazon.jsii.Jsii.Proxy(CfnRepositoryCreationTemplateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRepositoryCreationTemplateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of enumerable Strings representing the repository creation scenarios that this template will apply towards.
     * <p>
     * The two supported scenarios are PULL_THROUGH_CACHE and REPLICATION
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repositorycreationtemplate.html#cfn-ecr-repositorycreationtemplate-appliedfor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repositorycreationtemplate.html#cfn-ecr-repositorycreationtemplate-appliedfor</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAppliedFor();

    /**
     * The repository namespace prefix associated with the repository creation template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repositorycreationtemplate.html#cfn-ecr-repositorycreationtemplate-prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repositorycreationtemplate.html#cfn-ecr-repositorycreationtemplate-prefix</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrefix();

    /**
     * The ARN of the role to be assumed by Amazon ECR.
     * <p>
     * Amazon ECR will assume your supplied role when the customRoleArn is specified. When this field isn't specified, Amazon ECR will use the service-linked role for the repository creation template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repositorycreationtemplate.html#cfn-ecr-repositorycreationtemplate-customrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repositorycreationtemplate.html#cfn-ecr-repositorycreationtemplate-customrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomRoleArn() {
        return null;
    }

    /**
     * The description associated with the repository creation template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repositorycreationtemplate.html#cfn-ecr-repositorycreationtemplate-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repositorycreationtemplate.html#cfn-ecr-repositorycreationtemplate-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The encryption configuration associated with the repository creation template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repositorycreationtemplate.html#cfn-ecr-repositorycreationtemplate-encryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repositorycreationtemplate.html#cfn-ecr-repositorycreationtemplate-encryptionconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
        return null;
    }

    /**
     * The tag mutability setting for the repository.
     * <p>
     * If this parameter is omitted, the default setting of MUTABLE will be used which will allow image tags to be overwritten. If IMMUTABLE is specified, all image tags within the repository will be immutable which will prevent them from being overwritten.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repositorycreationtemplate.html#cfn-ecr-repositorycreationtemplate-imagetagmutability">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repositorycreationtemplate.html#cfn-ecr-repositorycreationtemplate-imagetagmutability</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageTagMutability() {
        return null;
    }

    /**
     * The lifecycle policy to use for repositories created using the template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repositorycreationtemplate.html#cfn-ecr-repositorycreationtemplate-lifecyclepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repositorycreationtemplate.html#cfn-ecr-repositorycreationtemplate-lifecyclepolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLifecyclePolicy() {
        return null;
    }

    /**
     * The repository policy to apply to repositories created using the template.
     * <p>
     * A repository policy is a permissions policy associated with a repository to control access permissions.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repositorycreationtemplate.html#cfn-ecr-repositorycreationtemplate-repositorypolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repositorycreationtemplate.html#cfn-ecr-repositorycreationtemplate-repositorypolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRepositoryPolicy() {
        return null;
    }

    /**
     * The metadata to apply to the repository to help you categorize and organize.
     * <p>
     * Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repositorycreationtemplate.html#cfn-ecr-repositorycreationtemplate-resourcetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-repositorycreationtemplate.html#cfn-ecr-repositorycreationtemplate-resourcetags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getResourceTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRepositoryCreationTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRepositoryCreationTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRepositoryCreationTemplateProps> {
        java.util.List<java.lang.String> appliedFor;
        java.lang.String prefix;
        java.lang.String customRoleArn;
        java.lang.String description;
        java.lang.Object encryptionConfiguration;
        java.lang.String imageTagMutability;
        java.lang.String lifecyclePolicy;
        java.lang.String repositoryPolicy;
        java.lang.Object resourceTags;

        /**
         * Sets the value of {@link CfnRepositoryCreationTemplateProps#getAppliedFor}
         * @param appliedFor A list of enumerable Strings representing the repository creation scenarios that this template will apply towards. This parameter is required.
         *                   The two supported scenarios are PULL_THROUGH_CACHE and REPLICATION
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appliedFor(java.util.List<java.lang.String> appliedFor) {
            this.appliedFor = appliedFor;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryCreationTemplateProps#getPrefix}
         * @param prefix The repository namespace prefix associated with the repository creation template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prefix(java.lang.String prefix) {
            this.prefix = prefix;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryCreationTemplateProps#getCustomRoleArn}
         * @param customRoleArn The ARN of the role to be assumed by Amazon ECR.
         *                      Amazon ECR will assume your supplied role when the customRoleArn is specified. When this field isn't specified, Amazon ECR will use the service-linked role for the repository creation template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customRoleArn(java.lang.String customRoleArn) {
            this.customRoleArn = customRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryCreationTemplateProps#getDescription}
         * @param description The description associated with the repository creation template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryCreationTemplateProps#getEncryptionConfiguration}
         * @param encryptionConfiguration The encryption configuration associated with the repository creation template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfiguration(software.amazon.awscdk.IResolvable encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryCreationTemplateProps#getEncryptionConfiguration}
         * @param encryptionConfiguration The encryption configuration associated with the repository creation template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfiguration(software.amazon.awscdk.services.ecr.CfnRepositoryCreationTemplate.EncryptionConfigurationProperty encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryCreationTemplateProps#getImageTagMutability}
         * @param imageTagMutability The tag mutability setting for the repository.
         *                           If this parameter is omitted, the default setting of MUTABLE will be used which will allow image tags to be overwritten. If IMMUTABLE is specified, all image tags within the repository will be immutable which will prevent them from being overwritten.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageTagMutability(java.lang.String imageTagMutability) {
            this.imageTagMutability = imageTagMutability;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryCreationTemplateProps#getLifecyclePolicy}
         * @param lifecyclePolicy The lifecycle policy to use for repositories created using the template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecyclePolicy(java.lang.String lifecyclePolicy) {
            this.lifecyclePolicy = lifecyclePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryCreationTemplateProps#getRepositoryPolicy}
         * @param repositoryPolicy The repository policy to apply to repositories created using the template.
         *                         A repository policy is a permissions policy associated with a repository to control access permissions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryPolicy(java.lang.String repositoryPolicy) {
            this.repositoryPolicy = repositoryPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryCreationTemplateProps#getResourceTags}
         * @param resourceTags The metadata to apply to the repository to help you categorize and organize.
         *                     Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceTags(software.amazon.awscdk.IResolvable resourceTags) {
            this.resourceTags = resourceTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryCreationTemplateProps#getResourceTags}
         * @param resourceTags The metadata to apply to the repository to help you categorize and organize.
         *                     Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceTags(java.util.List<? extends java.lang.Object> resourceTags) {
            this.resourceTags = resourceTags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRepositoryCreationTemplateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRepositoryCreationTemplateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRepositoryCreationTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRepositoryCreationTemplateProps {
        private final java.util.List<java.lang.String> appliedFor;
        private final java.lang.String prefix;
        private final java.lang.String customRoleArn;
        private final java.lang.String description;
        private final java.lang.Object encryptionConfiguration;
        private final java.lang.String imageTagMutability;
        private final java.lang.String lifecyclePolicy;
        private final java.lang.String repositoryPolicy;
        private final java.lang.Object resourceTags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.appliedFor = software.amazon.jsii.Kernel.get(this, "appliedFor", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customRoleArn = software.amazon.jsii.Kernel.get(this, "customRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.imageTagMutability = software.amazon.jsii.Kernel.get(this, "imageTagMutability", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lifecyclePolicy = software.amazon.jsii.Kernel.get(this, "lifecyclePolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repositoryPolicy = software.amazon.jsii.Kernel.get(this, "repositoryPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceTags = software.amazon.jsii.Kernel.get(this, "resourceTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.appliedFor = java.util.Objects.requireNonNull(builder.appliedFor, "appliedFor is required");
            this.prefix = java.util.Objects.requireNonNull(builder.prefix, "prefix is required");
            this.customRoleArn = builder.customRoleArn;
            this.description = builder.description;
            this.encryptionConfiguration = builder.encryptionConfiguration;
            this.imageTagMutability = builder.imageTagMutability;
            this.lifecyclePolicy = builder.lifecyclePolicy;
            this.repositoryPolicy = builder.repositoryPolicy;
            this.resourceTags = builder.resourceTags;
        }

        @Override
        public final java.util.List<java.lang.String> getAppliedFor() {
            return this.appliedFor;
        }

        @Override
        public final java.lang.String getPrefix() {
            return this.prefix;
        }

        @Override
        public final java.lang.String getCustomRoleArn() {
            return this.customRoleArn;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getEncryptionConfiguration() {
            return this.encryptionConfiguration;
        }

        @Override
        public final java.lang.String getImageTagMutability() {
            return this.imageTagMutability;
        }

        @Override
        public final java.lang.String getLifecyclePolicy() {
            return this.lifecyclePolicy;
        }

        @Override
        public final java.lang.String getRepositoryPolicy() {
            return this.repositoryPolicy;
        }

        @Override
        public final java.lang.Object getResourceTags() {
            return this.resourceTags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("appliedFor", om.valueToTree(this.getAppliedFor()));
            data.set("prefix", om.valueToTree(this.getPrefix()));
            if (this.getCustomRoleArn() != null) {
                data.set("customRoleArn", om.valueToTree(this.getCustomRoleArn()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEncryptionConfiguration() != null) {
                data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
            }
            if (this.getImageTagMutability() != null) {
                data.set("imageTagMutability", om.valueToTree(this.getImageTagMutability()));
            }
            if (this.getLifecyclePolicy() != null) {
                data.set("lifecyclePolicy", om.valueToTree(this.getLifecyclePolicy()));
            }
            if (this.getRepositoryPolicy() != null) {
                data.set("repositoryPolicy", om.valueToTree(this.getRepositoryPolicy()));
            }
            if (this.getResourceTags() != null) {
                data.set("resourceTags", om.valueToTree(this.getResourceTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecr.CfnRepositoryCreationTemplateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRepositoryCreationTemplateProps.Jsii$Proxy that = (CfnRepositoryCreationTemplateProps.Jsii$Proxy) o;

            if (!appliedFor.equals(that.appliedFor)) return false;
            if (!prefix.equals(that.prefix)) return false;
            if (this.customRoleArn != null ? !this.customRoleArn.equals(that.customRoleArn) : that.customRoleArn != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.encryptionConfiguration != null ? !this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration != null) return false;
            if (this.imageTagMutability != null ? !this.imageTagMutability.equals(that.imageTagMutability) : that.imageTagMutability != null) return false;
            if (this.lifecyclePolicy != null ? !this.lifecyclePolicy.equals(that.lifecyclePolicy) : that.lifecyclePolicy != null) return false;
            if (this.repositoryPolicy != null ? !this.repositoryPolicy.equals(that.repositoryPolicy) : that.repositoryPolicy != null) return false;
            return this.resourceTags != null ? this.resourceTags.equals(that.resourceTags) : that.resourceTags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.appliedFor.hashCode();
            result = 31 * result + (this.prefix.hashCode());
            result = 31 * result + (this.customRoleArn != null ? this.customRoleArn.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0);
            result = 31 * result + (this.imageTagMutability != null ? this.imageTagMutability.hashCode() : 0);
            result = 31 * result + (this.lifecyclePolicy != null ? this.lifecyclePolicy.hashCode() : 0);
            result = 31 * result + (this.repositoryPolicy != null ? this.repositoryPolicy.hashCode() : 0);
            result = 31 * result + (this.resourceTags != null ? this.resourceTags.hashCode() : 0);
            return result;
        }
    }
}
