package software.amazon.awscdk.services.ecs;

/**
 * Indicates whether to use Availability Zone rebalancing for an ECS service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * TaskDefinition taskDefinition;
 * FargateService service = FargateService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .availabilityZoneRebalancing(AvailabilityZoneRebalancing.ENABLED)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:50.112Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.AvailabilityZoneRebalancing")
public enum AvailabilityZoneRebalancing {
    /**
     * Availability zone rebalancing is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ENABLED,
    /**
     * Availability zone rebalancing is disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DISABLED,
}
