package software.amazon.awscdk.services.ecs;

/**
 * Registers a new task definition from the supplied <code>family</code> and <code>containerDefinitions</code> .
 * <p>
 * Optionally, you can add data volumes to your containers with the <code>volumes</code> parameter. For more information about task definition parameters and defaults, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Amazon ECS Task Definitions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
 * <p>
 * You can specify a role for your task with the <code>taskRoleArn</code> parameter. When you specify a role for a task, its containers can then use the latest versions of the AWS CLI or SDKs to make API requests to the AWS services that are specified in the policy that's associated with the role. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Roles for Tasks</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
 * <p>
 * You can specify a Docker networking mode for the containers in your task definition with the <code>networkMode</code> parameter. If you specify the <code>awsvpc</code> network mode, the task is allocated an elastic network interface, and you must specify a <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_NetworkConfiguration.html">NetworkConfiguration</a> when you create a service or run a task with the task definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * CfnTaskDefinition cfnTaskDefinition = CfnTaskDefinition.Builder.create(this, "MyCfnTaskDefinition")
 *         .containerDefinitions(List.of(ContainerDefinitionProperty.builder()
 *                 .image("image")
 *                 .name("name")
 *                 // the properties below are optional
 *                 .command(List.of("command"))
 *                 .cpu(123)
 *                 .credentialSpecs(List.of("credentialSpecs"))
 *                 .dependsOn(List.of(ContainerDependencyProperty.builder()
 *                         .condition("condition")
 *                         .containerName("containerName")
 *                         .build()))
 *                 .disableNetworking(false)
 *                 .dnsSearchDomains(List.of("dnsSearchDomains"))
 *                 .dnsServers(List.of("dnsServers"))
 *                 .dockerLabels(Map.of(
 *                         "dockerLabelsKey", "dockerLabels"))
 *                 .dockerSecurityOptions(List.of("dockerSecurityOptions"))
 *                 .entryPoint(List.of("entryPoint"))
 *                 .environment(List.of(KeyValuePairProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .environmentFiles(List.of(EnvironmentFileProperty.builder()
 *                         .type("type")
 *                         .value("value")
 *                         .build()))
 *                 .essential(false)
 *                 .extraHosts(List.of(HostEntryProperty.builder()
 *                         .hostname("hostname")
 *                         .ipAddress("ipAddress")
 *                         .build()))
 *                 .firelensConfiguration(FirelensConfigurationProperty.builder()
 *                         .options(Map.of(
 *                                 "optionsKey", "options"))
 *                         .type("type")
 *                         .build())
 *                 .healthCheck(HealthCheckProperty.builder()
 *                         .command(List.of("command"))
 *                         .interval(123)
 *                         .retries(123)
 *                         .startPeriod(123)
 *                         .timeout(123)
 *                         .build())
 *                 .hostname("hostname")
 *                 .interactive(false)
 *                 .links(List.of("links"))
 *                 .linuxParameters(LinuxParametersProperty.builder()
 *                         .capabilities(KernelCapabilitiesProperty.builder()
 *                                 .add(List.of("add"))
 *                                 .drop(List.of("drop"))
 *                                 .build())
 *                         .devices(List.of(DeviceProperty.builder()
 *                                 .containerPath("containerPath")
 *                                 .hostPath("hostPath")
 *                                 .permissions(List.of("permissions"))
 *                                 .build()))
 *                         .initProcessEnabled(false)
 *                         .maxSwap(123)
 *                         .sharedMemorySize(123)
 *                         .swappiness(123)
 *                         .tmpfs(List.of(TmpfsProperty.builder()
 *                                 .size(123)
 *                                 // the properties below are optional
 *                                 .containerPath("containerPath")
 *                                 .mountOptions(List.of("mountOptions"))
 *                                 .build()))
 *                         .build())
 *                 .logConfiguration(LogConfigurationProperty.builder()
 *                         .logDriver("logDriver")
 *                         // the properties below are optional
 *                         .options(Map.of(
 *                                 "optionsKey", "options"))
 *                         .secretOptions(List.of(SecretProperty.builder()
 *                                 .name("name")
 *                                 .valueFrom("valueFrom")
 *                                 .build()))
 *                         .build())
 *                 .memory(123)
 *                 .memoryReservation(123)
 *                 .mountPoints(List.of(MountPointProperty.builder()
 *                         .containerPath("containerPath")
 *                         .readOnly(false)
 *                         .sourceVolume("sourceVolume")
 *                         .build()))
 *                 .portMappings(List.of(PortMappingProperty.builder()
 *                         .appProtocol("appProtocol")
 *                         .containerPort(123)
 *                         .containerPortRange("containerPortRange")
 *                         .hostPort(123)
 *                         .name("name")
 *                         .protocol("protocol")
 *                         .build()))
 *                 .privileged(false)
 *                 .pseudoTerminal(false)
 *                 .readonlyRootFilesystem(false)
 *                 .repositoryCredentials(RepositoryCredentialsProperty.builder()
 *                         .credentialsParameter("credentialsParameter")
 *                         .build())
 *                 .resourceRequirements(List.of(ResourceRequirementProperty.builder()
 *                         .type("type")
 *                         .value("value")
 *                         .build()))
 *                 .restartPolicy(RestartPolicyProperty.builder()
 *                         .enabled(false)
 *                         .ignoredExitCodes(List.of(123))
 *                         .restartAttemptPeriod(123)
 *                         .build())
 *                 .secrets(List.of(SecretProperty.builder()
 *                         .name("name")
 *                         .valueFrom("valueFrom")
 *                         .build()))
 *                 .startTimeout(123)
 *                 .stopTimeout(123)
 *                 .systemControls(List.of(SystemControlProperty.builder()
 *                         .namespace("namespace")
 *                         .value("value")
 *                         .build()))
 *                 .ulimits(List.of(UlimitProperty.builder()
 *                         .hardLimit(123)
 *                         .name("name")
 *                         .softLimit(123)
 *                         .build()))
 *                 .user("user")
 *                 .versionConsistency("versionConsistency")
 *                 .volumesFrom(List.of(VolumeFromProperty.builder()
 *                         .readOnly(false)
 *                         .sourceContainer("sourceContainer")
 *                         .build()))
 *                 .workingDirectory("workingDirectory")
 *                 .build()))
 *         .cpu("cpu")
 *         .enableFaultInjection(false)
 *         .ephemeralStorage(EphemeralStorageProperty.builder()
 *                 .sizeInGiB(123)
 *                 .build())
 *         .executionRoleArn("executionRoleArn")
 *         .family("family")
 *         .inferenceAccelerators(List.of(InferenceAcceleratorProperty.builder()
 *                 .deviceName("deviceName")
 *                 .deviceType("deviceType")
 *                 .build()))
 *         .ipcMode("ipcMode")
 *         .memory("memory")
 *         .networkMode("networkMode")
 *         .pidMode("pidMode")
 *         .placementConstraints(List.of(TaskDefinitionPlacementConstraintProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .expression("expression")
 *                 .build()))
 *         .proxyConfiguration(ProxyConfigurationProperty.builder()
 *                 .containerName("containerName")
 *                 // the properties below are optional
 *                 .proxyConfigurationProperties(List.of(KeyValuePairProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .type("type")
 *                 .build())
 *         .requiresCompatibilities(List.of("requiresCompatibilities"))
 *         .runtimePlatform(RuntimePlatformProperty.builder()
 *                 .cpuArchitecture("cpuArchitecture")
 *                 .operatingSystemFamily("operatingSystemFamily")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .taskRoleArn("taskRoleArn")
 *         .volumes(List.of(VolumeProperty.builder()
 *                 .configuredAtLaunch(false)
 *                 .dockerVolumeConfiguration(DockerVolumeConfigurationProperty.builder()
 *                         .autoprovision(false)
 *                         .driver("driver")
 *                         .driverOpts(Map.of(
 *                                 "driverOptsKey", "driverOpts"))
 *                         .labels(Map.of(
 *                                 "labelsKey", "labels"))
 *                         .scope("scope")
 *                         .build())
 *                 .efsVolumeConfiguration(EFSVolumeConfigurationProperty.builder()
 *                         .filesystemId("filesystemId")
 *                         // the properties below are optional
 *                         .authorizationConfig(AuthorizationConfigProperty.builder()
 *                                 .accessPointId("accessPointId")
 *                                 .iam("iam")
 *                                 .build())
 *                         .rootDirectory("rootDirectory")
 *                         .transitEncryption("transitEncryption")
 *                         .transitEncryptionPort(123)
 *                         .build())
 *                 .fSxWindowsFileServerVolumeConfiguration(FSxWindowsFileServerVolumeConfigurationProperty.builder()
 *                         .fileSystemId("fileSystemId")
 *                         .rootDirectory("rootDirectory")
 *                         // the properties below are optional
 *                         .authorizationConfig(FSxAuthorizationConfigProperty.builder()
 *                                 .credentialsParameter("credentialsParameter")
 *                                 .domain("domain")
 *                                 .build())
 *                         .build())
 *                 .host(HostVolumePropertiesProperty.builder()
 *                         .sourcePath("sourcePath")
 *                         .build())
 *                 .name("name")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:50.195Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition")
public class CfnTaskDefinition extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnTaskDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTaskDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.CfnTaskDefinition.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTaskDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnTaskDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTaskDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the task definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTaskDefinitionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrTaskDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A list of container definitions in JSON format that describe the different containers that make up your task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getContainerDefinitions() {
        return software.amazon.jsii.Kernel.get(this, "containerDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of container definitions in JSON format that describe the different containers that make up your task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContainerDefinitions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "containerDefinitions", value);
    }

    /**
     * A list of container definitions in JSON format that describe the different containers that make up your task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContainerDefinitions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ecs.CfnTaskDefinition.ContainerDefinitionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ecs.CfnTaskDefinition.ContainerDefinitionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "containerDefinitions", value);
    }

    /**
     * The number of <code>cpu</code> units used by the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCpu() {
        return software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The number of <code>cpu</code> units used by the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCpu(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cpu", value);
    }

    /**
     * Enables fault injection and allows for fault injection requests to be accepted from the task's containers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableFaultInjection() {
        return software.amazon.jsii.Kernel.get(this, "enableFaultInjection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Enables fault injection and allows for fault injection requests to be accepted from the task's containers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableFaultInjection(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableFaultInjection", value);
    }

    /**
     * Enables fault injection and allows for fault injection requests to be accepted from the task's containers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableFaultInjection(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableFaultInjection", value);
    }

    /**
     * The ephemeral storage settings to use for tasks run with the task definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEphemeralStorage() {
        return software.amazon.jsii.Kernel.get(this, "ephemeralStorage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The ephemeral storage settings to use for tasks run with the task definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEphemeralStorage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ephemeralStorage", value);
    }

    /**
     * The ephemeral storage settings to use for tasks run with the task definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEphemeralStorage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnTaskDefinition.EphemeralStorageProperty value) {
        software.amazon.jsii.Kernel.set(this, "ephemeralStorage", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent permission to make AWS API calls on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent permission to make AWS API calls on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExecutionRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "executionRoleArn", value);
    }

    /**
     * The name of a family that this task definition is registered to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFamily() {
        return software.amazon.jsii.Kernel.get(this, "family", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of a family that this task definition is registered to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFamily(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "family", value);
    }

    /**
     * The Elastic Inference accelerators to use for the containers in the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInferenceAccelerators() {
        return software.amazon.jsii.Kernel.get(this, "inferenceAccelerators", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Elastic Inference accelerators to use for the containers in the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInferenceAccelerators(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "inferenceAccelerators", value);
    }

    /**
     * The Elastic Inference accelerators to use for the containers in the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInferenceAccelerators(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ecs.CfnTaskDefinition.InferenceAcceleratorProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ecs.CfnTaskDefinition.InferenceAcceleratorProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "inferenceAccelerators", value);
    }

    /**
     * The IPC resource namespace to use for the containers in the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIpcMode() {
        return software.amazon.jsii.Kernel.get(this, "ipcMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IPC resource namespace to use for the containers in the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIpcMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ipcMode", value);
    }

    /**
     * The amount (in MiB) of memory used by the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMemory() {
        return software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The amount (in MiB) of memory used by the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMemory(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "memory", value);
    }

    /**
     * The Docker networking mode to use for the containers in the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNetworkMode() {
        return software.amazon.jsii.Kernel.get(this, "networkMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Docker networking mode to use for the containers in the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "networkMode", value);
    }

    /**
     * The process namespace to use for the containers in the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPidMode() {
        return software.amazon.jsii.Kernel.get(this, "pidMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The process namespace to use for the containers in the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPidMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "pidMode", value);
    }

    /**
     * An array of placement constraint objects to use for tasks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPlacementConstraints() {
        return software.amazon.jsii.Kernel.get(this, "placementConstraints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of placement constraint objects to use for tasks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlacementConstraints(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "placementConstraints", value);
    }

    /**
     * An array of placement constraint objects to use for tasks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlacementConstraints(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ecs.CfnTaskDefinition.TaskDefinitionPlacementConstraintProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ecs.CfnTaskDefinition.TaskDefinitionPlacementConstraintProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "placementConstraints", value);
    }

    /**
     * The configuration details for the App Mesh proxy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getProxyConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "proxyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration details for the App Mesh proxy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProxyConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "proxyConfiguration", value);
    }

    /**
     * The configuration details for the App Mesh proxy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProxyConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnTaskDefinition.ProxyConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "proxyConfiguration", value);
    }

    /**
     * The task launch types the task definition was validated against.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRequiresCompatibilities() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "requiresCompatibilities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The task launch types the task definition was validated against.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequiresCompatibilities(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "requiresCompatibilities", value);
    }

    /**
     * The operating system that your tasks definitions run on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRuntimePlatform() {
        return software.amazon.jsii.Kernel.get(this, "runtimePlatform", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The operating system that your tasks definitions run on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuntimePlatform(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "runtimePlatform", value);
    }

    /**
     * The operating system that your tasks definitions run on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuntimePlatform(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnTaskDefinition.RuntimePlatformProperty value) {
        software.amazon.jsii.Kernel.set(this, "runtimePlatform", value);
    }

    /**
     * The metadata that you apply to the task definition to help you categorize and organize them.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The metadata that you apply to the task definition to help you categorize and organize them.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The short name or full Amazon Resource Name (ARN) of the AWS Identity and Access Management role that grants containers in the task permission to call AWS APIs on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTaskRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "taskRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The short name or full Amazon Resource Name (ARN) of the AWS Identity and Access Management role that grants containers in the task permission to call AWS APIs on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTaskRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "taskRoleArn", value);
    }

    /**
     * The list of data volume definitions for the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVolumes() {
        return software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The list of data volume definitions for the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVolumes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "volumes", value);
    }

    /**
     * The list of data volume definitions for the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVolumes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ecs.CfnTaskDefinition.VolumeProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ecs.CfnTaskDefinition.VolumeProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "volumes", value);
    }
    /**
     * The authorization configuration details for the Amazon EFS file system.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * AuthorizationConfigProperty authorizationConfigProperty = AuthorizationConfigProperty.builder()
     *         .accessPointId("accessPointId")
     *         .iam("iam")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-authorizationconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-authorizationconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.AuthorizationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthorizationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthorizationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon EFS access point ID to use.
         * <p>
         * If an access point is specified, the root directory value specified in the <code>EFSVolumeConfiguration</code> must either be omitted or set to <code>/</code> which will enforce the path set on the EFS access point. If an access point is used, transit encryption must be on in the <code>EFSVolumeConfiguration</code> . For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">Working with Amazon EFS access points</a> in the <em>Amazon Elastic File System User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-authorizationconfig.html#cfn-ecs-taskdefinition-authorizationconfig-accesspointid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-authorizationconfig.html#cfn-ecs-taskdefinition-authorizationconfig-accesspointid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessPointId() {
            return null;
        }

        /**
         * Determines whether to use the Amazon ECS task role defined in a task definition when mounting the Amazon EFS file system.
         * <p>
         * If it is turned on, transit encryption must be turned on in the <code>EFSVolumeConfiguration</code> . If this parameter is omitted, the default value of <code>DISABLED</code> is used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html#efs-volume-accesspoints">Using Amazon EFS access points</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-authorizationconfig.html#cfn-ecs-taskdefinition-authorizationconfig-iam">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-authorizationconfig.html#cfn-ecs-taskdefinition-authorizationconfig-iam</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIam() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthorizationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthorizationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthorizationConfigProperty> {
            java.lang.String accessPointId;
            java.lang.String iam;

            /**
             * Sets the value of {@link AuthorizationConfigProperty#getAccessPointId}
             * @param accessPointId The Amazon EFS access point ID to use.
             *                      If an access point is specified, the root directory value specified in the <code>EFSVolumeConfiguration</code> must either be omitted or set to <code>/</code> which will enforce the path set on the EFS access point. If an access point is used, transit encryption must be on in the <code>EFSVolumeConfiguration</code> . For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">Working with Amazon EFS access points</a> in the <em>Amazon Elastic File System User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessPointId(java.lang.String accessPointId) {
                this.accessPointId = accessPointId;
                return this;
            }

            /**
             * Sets the value of {@link AuthorizationConfigProperty#getIam}
             * @param iam Determines whether to use the Amazon ECS task role defined in a task definition when mounting the Amazon EFS file system.
             *            If it is turned on, transit encryption must be turned on in the <code>EFSVolumeConfiguration</code> . If this parameter is omitted, the default value of <code>DISABLED</code> is used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html#efs-volume-accesspoints">Using Amazon EFS access points</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iam(java.lang.String iam) {
                this.iam = iam;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthorizationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthorizationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthorizationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthorizationConfigProperty {
            private final java.lang.String accessPointId;
            private final java.lang.String iam;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessPointId = software.amazon.jsii.Kernel.get(this, "accessPointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.iam = software.amazon.jsii.Kernel.get(this, "iam", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessPointId = builder.accessPointId;
                this.iam = builder.iam;
            }

            @Override
            public final java.lang.String getAccessPointId() {
                return this.accessPointId;
            }

            @Override
            public final java.lang.String getIam() {
                return this.iam;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessPointId() != null) {
                    data.set("accessPointId", om.valueToTree(this.getAccessPointId()));
                }
                if (this.getIam() != null) {
                    data.set("iam", om.valueToTree(this.getIam()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.AuthorizationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthorizationConfigProperty.Jsii$Proxy that = (AuthorizationConfigProperty.Jsii$Proxy) o;

                if (this.accessPointId != null ? !this.accessPointId.equals(that.accessPointId) : that.accessPointId != null) return false;
                return this.iam != null ? this.iam.equals(that.iam) : that.iam == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessPointId != null ? this.accessPointId.hashCode() : 0;
                result = 31 * result + (this.iam != null ? this.iam.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>ContainerDefinition</code> property specifies a container definition.
     * <p>
     * Container definitions are used in task definitions to describe the different containers that are launched as part of a task.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ContainerDefinitionProperty containerDefinitionProperty = ContainerDefinitionProperty.builder()
     *         .image("image")
     *         .name("name")
     *         // the properties below are optional
     *         .command(List.of("command"))
     *         .cpu(123)
     *         .credentialSpecs(List.of("credentialSpecs"))
     *         .dependsOn(List.of(ContainerDependencyProperty.builder()
     *                 .condition("condition")
     *                 .containerName("containerName")
     *                 .build()))
     *         .disableNetworking(false)
     *         .dnsSearchDomains(List.of("dnsSearchDomains"))
     *         .dnsServers(List.of("dnsServers"))
     *         .dockerLabels(Map.of(
     *                 "dockerLabelsKey", "dockerLabels"))
     *         .dockerSecurityOptions(List.of("dockerSecurityOptions"))
     *         .entryPoint(List.of("entryPoint"))
     *         .environment(List.of(KeyValuePairProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .environmentFiles(List.of(EnvironmentFileProperty.builder()
     *                 .type("type")
     *                 .value("value")
     *                 .build()))
     *         .essential(false)
     *         .extraHosts(List.of(HostEntryProperty.builder()
     *                 .hostname("hostname")
     *                 .ipAddress("ipAddress")
     *                 .build()))
     *         .firelensConfiguration(FirelensConfigurationProperty.builder()
     *                 .options(Map.of(
     *                         "optionsKey", "options"))
     *                 .type("type")
     *                 .build())
     *         .healthCheck(HealthCheckProperty.builder()
     *                 .command(List.of("command"))
     *                 .interval(123)
     *                 .retries(123)
     *                 .startPeriod(123)
     *                 .timeout(123)
     *                 .build())
     *         .hostname("hostname")
     *         .interactive(false)
     *         .links(List.of("links"))
     *         .linuxParameters(LinuxParametersProperty.builder()
     *                 .capabilities(KernelCapabilitiesProperty.builder()
     *                         .add(List.of("add"))
     *                         .drop(List.of("drop"))
     *                         .build())
     *                 .devices(List.of(DeviceProperty.builder()
     *                         .containerPath("containerPath")
     *                         .hostPath("hostPath")
     *                         .permissions(List.of("permissions"))
     *                         .build()))
     *                 .initProcessEnabled(false)
     *                 .maxSwap(123)
     *                 .sharedMemorySize(123)
     *                 .swappiness(123)
     *                 .tmpfs(List.of(TmpfsProperty.builder()
     *                         .size(123)
     *                         // the properties below are optional
     *                         .containerPath("containerPath")
     *                         .mountOptions(List.of("mountOptions"))
     *                         .build()))
     *                 .build())
     *         .logConfiguration(LogConfigurationProperty.builder()
     *                 .logDriver("logDriver")
     *                 // the properties below are optional
     *                 .options(Map.of(
     *                         "optionsKey", "options"))
     *                 .secretOptions(List.of(SecretProperty.builder()
     *                         .name("name")
     *                         .valueFrom("valueFrom")
     *                         .build()))
     *                 .build())
     *         .memory(123)
     *         .memoryReservation(123)
     *         .mountPoints(List.of(MountPointProperty.builder()
     *                 .containerPath("containerPath")
     *                 .readOnly(false)
     *                 .sourceVolume("sourceVolume")
     *                 .build()))
     *         .portMappings(List.of(PortMappingProperty.builder()
     *                 .appProtocol("appProtocol")
     *                 .containerPort(123)
     *                 .containerPortRange("containerPortRange")
     *                 .hostPort(123)
     *                 .name("name")
     *                 .protocol("protocol")
     *                 .build()))
     *         .privileged(false)
     *         .pseudoTerminal(false)
     *         .readonlyRootFilesystem(false)
     *         .repositoryCredentials(RepositoryCredentialsProperty.builder()
     *                 .credentialsParameter("credentialsParameter")
     *                 .build())
     *         .resourceRequirements(List.of(ResourceRequirementProperty.builder()
     *                 .type("type")
     *                 .value("value")
     *                 .build()))
     *         .restartPolicy(RestartPolicyProperty.builder()
     *                 .enabled(false)
     *                 .ignoredExitCodes(List.of(123))
     *                 .restartAttemptPeriod(123)
     *                 .build())
     *         .secrets(List.of(SecretProperty.builder()
     *                 .name("name")
     *                 .valueFrom("valueFrom")
     *                 .build()))
     *         .startTimeout(123)
     *         .stopTimeout(123)
     *         .systemControls(List.of(SystemControlProperty.builder()
     *                 .namespace("namespace")
     *                 .value("value")
     *                 .build()))
     *         .ulimits(List.of(UlimitProperty.builder()
     *                 .hardLimit(123)
     *                 .name("name")
     *                 .softLimit(123)
     *                 .build()))
     *         .user("user")
     *         .versionConsistency("versionConsistency")
     *         .volumesFrom(List.of(VolumeFromProperty.builder()
     *                 .readOnly(false)
     *                 .sourceContainer("sourceContainer")
     *                 .build()))
     *         .workingDirectory("workingDirectory")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.ContainerDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(ContainerDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContainerDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The image used to start a container.
         * <p>
         * This string is passed directly to the Docker daemon. By default, images in the Docker Hub registry are available. Other repositories are specified with either <code>*repository-url* / *image* : *tag*</code> or <code>*repository-url* / *image* &#64; *digest*</code> . Up to 255 letters (uppercase and lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter maps to <code>Image</code> in the docker container create command and the <code>IMAGE</code> parameter of docker run.
         * <p>
         * <ul>
         * <li>When a new task starts, the Amazon ECS container agent pulls the latest version of the specified image and tag for the container to use. However, subsequent updates to a repository image aren't propagated to already running tasks.</li>
         * <li>Images in Amazon ECR repositories can be specified by either using the full <code>registry/repository:tag</code> or <code>registry/repository&#64;digest</code> . For example, <code>012345678910.dkr.ecr.&lt;region-name&gt;.amazonaws.com/&lt;repository-name&gt;:latest</code> or <code>012345678910.dkr.ecr.&lt;region-name&gt;.amazonaws.com/&lt;repository-name&gt;&#64;sha256:94afd1f2e64d908bc90dbca0035a5b567EXAMPLE</code> .</li>
         * <li>Images in official repositories on Docker Hub use a single name (for example, <code>ubuntu</code> or <code>mongo</code> ).</li>
         * <li>Images in other repositories on Docker Hub are qualified with an organization name (for example, <code>amazon/amazon-ecs-agent</code> ).</li>
         * <li>Images in other online repositories are qualified further by a domain name (for example, <code>quay.io/assemblyline/ubuntu</code> ).</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-image">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-image</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImage();

        /**
         * The name of a container.
         * <p>
         * If you're linking multiple containers together in a task definition, the <code>name</code> of one container can be entered in the <code>links</code> of another container to connect the containers. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. This parameter maps to <code>name</code> in the docker container create command and the <code>--name</code> option to docker run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The command that's passed to the container.
         * <p>
         * This parameter maps to <code>Cmd</code> in the docker container create command and the <code>COMMAND</code> parameter to docker run. If there are multiple arguments, each argument is a separated string in the array.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-command">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-command</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
            return null;
        }

        /**
         * The number of <code>cpu</code> units reserved for the container.
         * <p>
         * This parameter maps to <code>CpuShares</code> in the docker container create commandand the <code>--cpu-shares</code> option to docker run.
         * <p>
         * This field is optional for tasks using the Fargate launch type, and the only requirement is that the total amount of CPU reserved for all containers within a task be lower than the task-level <code>cpu</code> value.
         * <p>
         * <blockquote>
         * <p>
         * You can determine the number of CPU units that are available per EC2 instance type by multiplying the vCPUs listed for that instance type on the <a href="https://docs.aws.amazon.com/ec2/instance-types/">Amazon EC2 Instances</a> detail page by 1,024.
         * <p>
         * </blockquote>
         * <p>
         * Linux containers share unallocated CPU units with other containers on the container instance with the same ratio as their allocated amount. For example, if you run a single-container task on a single-core instance type with 512 CPU units specified for that container, and that's the only task running on the container instance, that container could use the full 1,024 CPU unit share at any given time. However, if you launched another copy of the same task on that container instance, each task is guaranteed a minimum of 512 CPU units when needed. Moreover, each container could float to higher CPU usage if the other container was not using it. If both tasks were 100% active all of the time, they would be limited to 512 CPU units.
         * <p>
         * On Linux container instances, the Docker daemon on the container instance uses the CPU value to calculate the relative CPU share ratios for running containers. The minimum valid CPU share value that the Linux kernel allows is 2, and the maximum valid CPU share value that the Linux kernel allows is 262144. However, the CPU parameter isn't required, and you can use CPU values below 2 or above 262144 in your container definitions. For CPU values below 2 (including null) or above 262144, the behavior varies based on your Amazon ECS container agent version:
         * <p>
         * <ul>
         * <li><em>Agent versions less than or equal to 1.1.0:</em> Null and zero CPU values are passed to Docker as 0, which Docker then converts to 1,024 CPU shares. CPU values of 1 are passed to Docker as 1, which the Linux kernel converts to two CPU shares.</li>
         * <li><em>Agent versions greater than or equal to 1.2.0:</em> Null, zero, and CPU values of 1 are passed to Docker as 2.</li>
         * <li><em>Agent versions greater than or equal to 1.84.0:</em> CPU values greater than 256 vCPU are passed to Docker as 256, which is equivalent to 262144 CPU shares.</li>
         * </ul>
         * <p>
         * On Windows container instances, the CPU limit is enforced as an absolute limit, or a quota. Windows containers only have access to the specified amount of CPU that's described in the task definition. A null or zero CPU value is passed to Docker as <code>0</code> , which Windows interprets as 1% of one CPU.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-cpu">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-cpu</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCpu() {
            return null;
        }

        /**
         * A list of ARNs in SSM or Amazon S3 to a credential spec ( <code>CredSpec</code> ) file that configures the container for Active Directory authentication.
         * <p>
         * We recommend that you use this parameter instead of the <code>dockerSecurityOptions</code> . The maximum number of ARNs is 1.
         * <p>
         * There are two formats for each ARN.
         * <p>
         * <ul>
         * <li><strong>credentialspecdomainless:MyARN</strong> - You use <code>credentialspecdomainless:MyARN</code> to provide a <code>CredSpec</code> with an additional section for a secret in AWS Secrets Manager . You provide the login credentials to the domain in the secret.</li>
         * </ul>
         * <p>
         * Each task that runs on any container instance can join different domains.
         * <p>
         * You can use this format without joining the container instance to a domain.
         * <p>
         * <ul>
         * <li><strong>credentialspec:MyARN</strong> - You use <code>credentialspec:MyARN</code> to provide a <code>CredSpec</code> for a single domain.</li>
         * </ul>
         * <p>
         * You must join the container instance to the domain before you start any tasks that use this task definition.
         * <p>
         * In both formats, replace <code>MyARN</code> with the ARN in SSM or Amazon S3.
         * <p>
         * If you provide a <code>credentialspecdomainless:MyARN</code> , the <code>credspec</code> must provide a ARN in AWS Secrets Manager for a secret containing the username, password, and the domain to connect to. For better security, the instance isn't joined to the domain for domainless authentication. Other applications on the instance can't use the domainless credentials. You can use this parameter to run tasks on the same instance, even it the tasks need to join different domains. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows-gmsa.html">Using gMSAs for Windows Containers</a> and <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/linux-gmsa.html">Using gMSAs for Linux Containers</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-credentialspecs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-credentialspecs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCredentialSpecs() {
            return null;
        }

        /**
         * The dependencies defined for container startup and shutdown.
         * <p>
         * A container can contain multiple dependencies. When a dependency is defined for container startup, for container shutdown it is reversed.
         * <p>
         * For tasks using the EC2 launch type, the container instances require at least version 1.26.0 of the container agent to turn on container dependencies. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon ECS Container Agent</a> in the <em>Amazon Elastic Container Service Developer Guide</em> . If you're using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the <code>ecs-init</code> package. If your container instances are launched from version <code>20190301</code> or later, then they contain the required versions of the container agent and <code>ecs-init</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * For tasks using the Fargate launch type, the task or service requires the following platforms:
         * <p>
         * <ul>
         * <li>Linux platform version <code>1.3.0</code> or later.</li>
         * <li>Windows platform version <code>1.0.0</code> or later.</li>
         * </ul>
         * <p>
         * If the task definition is used in a blue/green deployment that uses <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-bluegreendeploymentconfiguration.html">AWS::CodeDeploy::DeploymentGroup BlueGreenDeploymentConfiguration</a> , the <code>dependsOn</code> parameter is not supported. For more information see <a href="https://docs.aws.amazon.com/https://github.com/aws-cloudformation/cloudformation-coverage-roadmap/issues/680">Issue #680</a> on the on the GitHub website.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-dependson">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-dependson</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDependsOn() {
            return null;
        }

        /**
         * When this parameter is true, networking is off within the container.
         * <p>
         * This parameter maps to <code>NetworkDisabled</code> in the docker container create command.
         * <p>
         * <blockquote>
         * <p>
         * This parameter is not supported for Windows containers.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-disablenetworking">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-disablenetworking</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableNetworking() {
            return null;
        }

        /**
         * A list of DNS search domains that are presented to the container.
         * <p>
         * This parameter maps to <code>DnsSearch</code> in the docker container create command and the <code>--dns-search</code> option to docker run.
         * <p>
         * <blockquote>
         * <p>
         * This parameter is not supported for Windows containers.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-dnssearchdomains">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-dnssearchdomains</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDnsSearchDomains() {
            return null;
        }

        /**
         * A list of DNS servers that are presented to the container.
         * <p>
         * This parameter maps to <code>Dns</code> in the docker container create command and the <code>--dns</code> option to docker run.
         * <p>
         * <blockquote>
         * <p>
         * This parameter is not supported for Windows containers.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-dnsservers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-dnsservers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDnsServers() {
            return null;
        }

        /**
         * A key/value map of labels to add to the container.
         * <p>
         * This parameter maps to <code>Labels</code> in the docker container create command and the <code>--label</code> option to docker run. This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-dockerlabels">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-dockerlabels</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDockerLabels() {
            return null;
        }

        /**
         * A list of strings to provide custom configuration for multiple security systems.
         * <p>
         * This field isn't valid for containers in tasks using the Fargate launch type.
         * <p>
         * For Linux tasks on EC2, this parameter can be used to reference custom labels for SELinux and AppArmor multi-level security systems.
         * <p>
         * For any tasks on EC2, this parameter can be used to reference a credential spec file that configures a container for Active Directory authentication. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows-gmsa.html">Using gMSAs for Windows Containers</a> and <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/linux-gmsa.html">Using gMSAs for Linux Containers</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * This parameter maps to <code>SecurityOpt</code> in the docker container create command and the <code>--security-opt</code> option to docker run.
         * <p>
         * <blockquote>
         * <p>
         * The Amazon ECS container agent running on a container instance must register with the <code>ECS_SELINUX_CAPABLE=true</code> or <code>ECS_APPARMOR_CAPABLE=true</code> environment variables before containers placed on that instance can use these security options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container Agent Configuration</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * Valid values: "no-new-privileges" | "apparmor:PROFILE" | "label:value" | "credentialspec:CredentialSpecFilePath"
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-dockersecurityoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-dockersecurityoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDockerSecurityOptions() {
            return null;
        }

        /**
         * <blockquote><p>Early versions of the Amazon ECS container agent don't properly handle <code>entryPoint</code> parameters.<p></blockquote>
         * <p>
         * If you have problems using <code>entryPoint</code> , update your container agent or enter your commands and arguments as <code>command</code> array items instead.
         * <p>
         * The entry point that's passed to the container. This parameter maps to <code>Entrypoint</code> in the docker container create command and the <code>--entrypoint</code> option to docker run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-entrypoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-entrypoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEntryPoint() {
            return null;
        }

        /**
         * The environment variables to pass to a container.
         * <p>
         * This parameter maps to <code>Env</code> in the docker container create command and the <code>--env</code> option to docker run.
         * <p>
         * <blockquote>
         * <p>
         * We don't recommend that you use plaintext environment variables for sensitive information, such as credential data.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-environment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-environment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
            return null;
        }

        /**
         * A list of files containing the environment variables to pass to a container.
         * <p>
         * This parameter maps to the <code>--env-file</code> option to docker run.
         * <p>
         * You can specify up to ten environment files. The file must have a <code>.env</code> file extension. Each line in an environment file contains an environment variable in <code>VARIABLE=VALUE</code> format. Lines beginning with <code>#</code> are treated as comments and are ignored.
         * <p>
         * If there are environment variables specified using the <code>environment</code> parameter in a container definition, they take precedence over the variables contained within an environment file. If multiple environment files are specified that contain the same variable, they're processed from the top down. We recommend that you use unique variable names. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html">Specifying Environment Variables</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-environmentfiles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-environmentfiles</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironmentFiles() {
            return null;
        }

        /**
         * If the <code>essential</code> parameter of a container is marked as <code>true</code> , and that container fails or stops for any reason, all other containers that are part of the task are stopped.
         * <p>
         * If the <code>essential</code> parameter of a container is marked as <code>false</code> , its failure doesn't affect the rest of the containers in a task. If this parameter is omitted, a container is assumed to be essential.
         * <p>
         * All tasks must have at least one essential container. If you have an application that's composed of multiple containers, group containers that are used for a common purpose into components, and separate the different components into multiple task definitions. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html">Application Architecture</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-essential">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-essential</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEssential() {
            return null;
        }

        /**
         * A list of hostnames and IP address mappings to append to the <code>/etc/hosts</code> file on the container.
         * <p>
         * This parameter maps to <code>ExtraHosts</code> in the docker container create command and the <code>--add-host</code> option to docker run.
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't supported for Windows containers or tasks that use the <code>awsvpc</code> network mode.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-extrahosts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-extrahosts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExtraHosts() {
            return null;
        }

        /**
         * The FireLens configuration for the container.
         * <p>
         * This is used to specify and configure a log router for container logs. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Custom Log Routing</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-firelensconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-firelensconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFirelensConfiguration() {
            return null;
        }

        /**
         * The container health check command and associated configuration parameters for the container.
         * <p>
         * This parameter maps to <code>HealthCheck</code> in the docker container create command and the <code>HEALTHCHECK</code> parameter of docker run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-healthcheck">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-healthcheck</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHealthCheck() {
            return null;
        }

        /**
         * The hostname to use for your container.
         * <p>
         * This parameter maps to <code>Hostname</code> in the docker container create command and the <code>--hostname</code> option to docker run.
         * <p>
         * <blockquote>
         * <p>
         * The <code>hostname</code> parameter is not supported if you're using the <code>awsvpc</code> network mode.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-hostname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-hostname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostname() {
            return null;
        }

        /**
         * When this parameter is <code>true</code> , you can deploy containerized applications that require <code>stdin</code> or a <code>tty</code> to be allocated.
         * <p>
         * This parameter maps to <code>OpenStdin</code> in the docker container create command and the <code>--interactive</code> option to docker run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-interactive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-interactive</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInteractive() {
            return null;
        }

        /**
         * The <code>links</code> parameter allows containers to communicate with each other without the need for port mappings.
         * <p>
         * This parameter is only supported if the network mode of a task definition is <code>bridge</code> . The <code>name:internalName</code> construct is analogous to <code>name:alias</code> in Docker links. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed.. This parameter maps to <code>Links</code> in the docker container create command and the <code>--link</code> option to docker run.
         * <p>
         * <blockquote>
         * <p>
         * This parameter is not supported for Windows containers. &gt; Containers that are collocated on a single container instance may be able to communicate with each other without requiring links or host port mappings. Network isolation is achieved on the container instance using security groups and VPC settings.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-links">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-links</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLinks() {
            return null;
        }

        /**
         * Linux-specific modifications that are applied to the container, such as Linux kernel capabilities. For more information see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html">KernelCapabilities</a> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter is not supported for Windows containers.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-linuxparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-linuxparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLinuxParameters() {
            return null;
        }

        /**
         * The log configuration specification for the container.
         * <p>
         * This parameter maps to <code>LogConfig</code> in the docker Create a container command and the <code>--log-driver</code> option to docker run. By default, containers use the same logging driver that the Docker daemon uses. However, the container may use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the Docker documentation.
         * <p>
         * <blockquote>
         * <p>
         * Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon (shown in the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_LogConfiguration.html">LogConfiguration</a> data type). Additional log drivers may be available in future releases of the Amazon ECS container agent.
         * <p>
         * </blockquote>
         * <p>
         * This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
         * <p>
         * <blockquote>
         * <p>
         * The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers placed on that instance can use these log configuration options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container Agent Configuration</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-logconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-logconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogConfiguration() {
            return null;
        }

        /**
         * The amount (in MiB) of memory to present to the container.
         * <p>
         * If your container attempts to exceed the memory specified here, the container is killed. The total amount of memory reserved for all containers within a task must be lower than the task <code>memory</code> value, if one is specified. This parameter maps to <code>Memory</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--memory</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a> .
         * <p>
         * If using the Fargate launch type, this parameter is optional.
         * <p>
         * If using the EC2 launch type, you must specify either a task-level memory value or a container-level memory value. If you specify both a container-level <code>memory</code> and <code>memoryReservation</code> value, <code>memory</code> must be greater than <code>memoryReservation</code> . If you specify <code>memoryReservation</code> , then that value is subtracted from the available memory resources for the container instance where the container is placed. Otherwise, the value of <code>memory</code> is used.
         * <p>
         * The Docker 20.10.0 or later daemon reserves a minimum of 6 MiB of memory for a container, so you should not specify fewer than 6 MiB of memory for your containers.
         * <p>
         * The Docker 19.03.13-ce or earlier daemon reserves a minimum of 4 MiB of memory for a container, so you should not specify fewer than 4 MiB of memory for your containers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-memory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-memory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMemory() {
            return null;
        }

        /**
         * The soft limit (in MiB) of memory to reserve for the container.
         * <p>
         * When system memory is under heavy contention, Docker attempts to keep the container memory to this soft limit. However, your container can consume more memory when it needs to, up to either the hard limit specified with the <code>memory</code> parameter (if applicable), or all of the available memory on the container instance, whichever comes first. This parameter maps to <code>MemoryReservation</code> in the docker container create command and the <code>--memory-reservation</code> option to docker run.
         * <p>
         * If a task-level memory value is not specified, you must specify a non-zero integer for one or both of <code>memory</code> or <code>memoryReservation</code> in a container definition. If you specify both, <code>memory</code> must be greater than <code>memoryReservation</code> . If you specify <code>memoryReservation</code> , then that value is subtracted from the available memory resources for the container instance where the container is placed. Otherwise, the value of <code>memory</code> is used.
         * <p>
         * For example, if your container normally uses 128 MiB of memory, but occasionally bursts to 256 MiB of memory for short periods of time, you can set a <code>memoryReservation</code> of 128 MiB, and a <code>memory</code> hard limit of 300 MiB. This configuration would allow the container to only reserve 128 MiB of memory from the remaining resources on the container instance, but also allow the container to consume more memory resources when needed.
         * <p>
         * The Docker 20.10.0 or later daemon reserves a minimum of 6 MiB of memory for a container. So, don't specify less than 6 MiB of memory for your containers.
         * <p>
         * The Docker 19.03.13-ce or earlier daemon reserves a minimum of 4 MiB of memory for a container. So, don't specify less than 4 MiB of memory for your containers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-memoryreservation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-memoryreservation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMemoryReservation() {
            return null;
        }

        /**
         * The mount points for data volumes in your container.
         * <p>
         * This parameter maps to <code>Volumes</code> in the docker container create command and the <code>--volume</code> option to docker run.
         * <p>
         * Windows containers can mount whole directories on the same drive as <code>$env:ProgramData</code> . Windows containers can't mount directories on a different drive, and mount point can't be across drives.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-mountpoints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-mountpoints</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMountPoints() {
            return null;
        }

        /**
         * The list of port mappings for the container.
         * <p>
         * Port mappings allow containers to access ports on the host container instance to send or receive traffic.
         * <p>
         * For task definitions that use the <code>awsvpc</code> network mode, you should only specify the <code>containerPort</code> . The <code>hostPort</code> can be left blank or it must be the same value as the <code>containerPort</code> .
         * <p>
         * Port mappings on Windows use the <code>NetNAT</code> gateway address rather than <code>localhost</code> . There is no loopback for port mappings on Windows, so you cannot access a container's mapped port from the host itself.
         * <p>
         * This parameter maps to <code>PortBindings</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--publish</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . If the network mode of a task definition is set to <code>none</code> , then you can't specify port mappings. If the network mode of a task definition is set to <code>host</code> , then host ports must either be undefined or they must match the container port in the port mapping.
         * <p>
         * <blockquote>
         * <p>
         * After a task reaches the <code>RUNNING</code> status, manual and automatic host and container port assignments are visible in the <em>Network Bindings</em> section of a container description for a selected task in the Amazon ECS console. The assignments are also visible in the <code>networkBindings</code> section <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTasks.html">DescribeTasks</a> responses.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-portmappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-portmappings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPortMappings() {
            return null;
        }

        /**
         * When this parameter is true, the container is given elevated privileges on the host container instance (similar to the <code>root</code> user).
         * <p>
         * This parameter maps to <code>Privileged</code> in the docker container create command and the <code>--privileged</code> option to docker run
         * <p>
         * <blockquote>
         * <p>
         * This parameter is not supported for Windows containers or tasks run on AWS Fargate .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-privileged">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-privileged</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrivileged() {
            return null;
        }

        /**
         * When this parameter is <code>true</code> , a TTY is allocated.
         * <p>
         * This parameter maps to <code>Tty</code> in the docker container create command and the <code>--tty</code> option to docker run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-pseudoterminal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-pseudoterminal</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPseudoTerminal() {
            return null;
        }

        /**
         * When this parameter is true, the container is given read-only access to its root file system.
         * <p>
         * This parameter maps to <code>ReadonlyRootfs</code> in the docker container create command and the <code>--read-only</code> option to docker run.
         * <p>
         * <blockquote>
         * <p>
         * This parameter is not supported for Windows containers.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-readonlyrootfilesystem">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-readonlyrootfilesystem</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadonlyRootFilesystem() {
            return null;
        }

        /**
         * The private repository authentication credentials to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-repositorycredentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-repositorycredentials</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRepositoryCredentials() {
            return null;
        }

        /**
         * The type and amount of a resource to assign to a container.
         * <p>
         * The only supported resource is a GPU.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-resourcerequirements">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-resourcerequirements</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceRequirements() {
            return null;
        }

        /**
         * The restart policy for a container.
         * <p>
         * When you set up a restart policy, Amazon ECS can restart the container without needing to replace the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-restart-policy.html">Restart individual containers in Amazon ECS tasks with container restart policies</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-restartpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-restartpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRestartPolicy() {
            return null;
        }

        /**
         * The secrets to pass to the container.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying Sensitive Data</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-secrets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-secrets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecrets() {
            return null;
        }

        /**
         * Time duration (in seconds) to wait before giving up on resolving dependencies for a container.
         * <p>
         * For example, you specify two containers in a task definition with containerA having a dependency on containerB reaching a <code>COMPLETE</code> , <code>SUCCESS</code> , or <code>HEALTHY</code> status. If a <code>startTimeout</code> value is specified for containerB and it doesn't reach the desired status within that time then containerA gives up and not start. This results in the task transitioning to a <code>STOPPED</code> state.
         * <p>
         * <blockquote>
         * <p>
         * When the <code>ECS_CONTAINER_START_TIMEOUT</code> container agent configuration variable is used, it's enforced independently from this start timeout value.
         * <p>
         * </blockquote>
         * <p>
         * For tasks using the Fargate launch type, the task or service requires the following platforms:
         * <p>
         * <ul>
         * <li>Linux platform version <code>1.3.0</code> or later.</li>
         * <li>Windows platform version <code>1.0.0</code> or later.</li>
         * </ul>
         * <p>
         * For tasks using the EC2 launch type, your container instances require at least version <code>1.26.0</code> of the container agent to use a container start timeout value. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon ECS Container Agent</a> in the <em>Amazon Elastic Container Service Developer Guide</em> . If you're using an Amazon ECS-optimized Linux AMI, your instance needs at least version <code>1.26.0-1</code> of the <code>ecs-init</code> package. If your container instances are launched from version <code>20190301</code> or later, then they contain the required versions of the container agent and <code>ecs-init</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * The valid values for Fargate are 2-120 seconds.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-starttimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-starttimeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStartTimeout() {
            return null;
        }

        /**
         * Time duration (in seconds) to wait before the container is forcefully killed if it doesn't exit normally on its own.
         * <p>
         * For tasks using the Fargate launch type, the task or service requires the following platforms:
         * <p>
         * <ul>
         * <li>Linux platform version <code>1.3.0</code> or later.</li>
         * <li>Windows platform version <code>1.0.0</code> or later.</li>
         * </ul>
         * <p>
         * For tasks that use the Fargate launch type, the max stop timeout value is 120 seconds and if the parameter is not specified, the default value of 30 seconds is used.
         * <p>
         * For tasks that use the EC2 launch type, if the <code>stopTimeout</code> parameter isn't specified, the value set for the Amazon ECS container agent configuration variable <code>ECS_CONTAINER_STOP_TIMEOUT</code> is used. If neither the <code>stopTimeout</code> parameter or the <code>ECS_CONTAINER_STOP_TIMEOUT</code> agent configuration variable are set, then the default values of 30 seconds for Linux containers and 30 seconds on Windows containers are used. Your container instances require at least version 1.26.0 of the container agent to use a container stop timeout value. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon ECS Container Agent</a> in the <em>Amazon Elastic Container Service Developer Guide</em> . If you're using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the <code>ecs-init</code> package. If your container instances are launched from version <code>20190301</code> or later, then they contain the required versions of the container agent and <code>ecs-init</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * The valid values for Fargate are 2-120 seconds.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-stoptimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-stoptimeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStopTimeout() {
            return null;
        }

        /**
         * A list of namespaced kernel parameters to set in the container.
         * <p>
         * This parameter maps to <code>Sysctls</code> in the docker container create command and the <code>--sysctl</code> option to docker run. For example, you can configure <code>net.ipv4.tcp_keepalive_time</code> setting to maintain longer lived connections.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-systemcontrols">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-systemcontrols</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSystemControls() {
            return null;
        }

        /**
         * A list of <code>ulimits</code> to set in the container.
         * <p>
         * This parameter maps to <code>Ulimits</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--ulimit</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . Valid naming values are displayed in the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_Ulimit.html">Ulimit</a> data type. This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
         * <p>
         * <blockquote>
         * <p>
         * This parameter is not supported for Windows containers.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-ulimits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-ulimits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUlimits() {
            return null;
        }

        /**
         * The user to use inside the container.
         * <p>
         * This parameter maps to <code>User</code> in the docker container create command and the <code>--user</code> option to docker run.
         * <p>
         * <blockquote>
         * <p>
         * When running tasks using the <code>host</code> network mode, don't run containers using the root user (UID 0). We recommend using a non-root user for better security.
         * <p>
         * </blockquote>
         * <p>
         * You can specify the <code>user</code> using the following formats. If specifying a UID or GID, you must specify it as a positive integer.
         * <p>
         * <ul>
         * <li><code>user</code></li>
         * <li><code>user:group</code></li>
         * <li><code>uid</code></li>
         * <li><code>uid:gid</code></li>
         * <li><code>user:gid</code></li>
         * <li><code>uid:group</code></li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * This parameter is not supported for Windows containers.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-user">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-user</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUser() {
            return null;
        }

        /**
         * Specifies whether Amazon ECS will resolve the container image tag provided in the container definition to an image digest.
         * <p>
         * By default, the value is <code>enabled</code> . If you set the value for a container as <code>disabled</code> , Amazon ECS will not resolve the provided container image tag to a digest and will use the original image URI specified in the container definition for deployment. For more information about container image resolution, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html#deployment-container-image-stability">Container image resolution</a> in the <em>Amazon ECS Developer Guide</em> .
         * <p>
         * Default: - "enabled"
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-versionconsistency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-versionconsistency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersionConsistency() {
            return null;
        }

        /**
         * Data volumes to mount from another container.
         * <p>
         * This parameter maps to <code>VolumesFrom</code> in the docker container create command and the <code>--volumes-from</code> option to docker run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-volumesfrom">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-volumesfrom</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVolumesFrom() {
            return null;
        }

        /**
         * The working directory to run commands inside the container in.
         * <p>
         * This parameter maps to <code>WorkingDir</code> in the docker container create command and the <code>--workdir</code> option to docker run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-workingdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-workingdirectory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWorkingDirectory() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ContainerDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContainerDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContainerDefinitionProperty> {
            java.lang.String image;
            java.lang.String name;
            java.util.List<java.lang.String> command;
            java.lang.Number cpu;
            java.util.List<java.lang.String> credentialSpecs;
            java.lang.Object dependsOn;
            java.lang.Object disableNetworking;
            java.util.List<java.lang.String> dnsSearchDomains;
            java.util.List<java.lang.String> dnsServers;
            java.lang.Object dockerLabels;
            java.util.List<java.lang.String> dockerSecurityOptions;
            java.util.List<java.lang.String> entryPoint;
            java.lang.Object environment;
            java.lang.Object environmentFiles;
            java.lang.Object essential;
            java.lang.Object extraHosts;
            java.lang.Object firelensConfiguration;
            java.lang.Object healthCheck;
            java.lang.String hostname;
            java.lang.Object interactive;
            java.util.List<java.lang.String> links;
            java.lang.Object linuxParameters;
            java.lang.Object logConfiguration;
            java.lang.Number memory;
            java.lang.Number memoryReservation;
            java.lang.Object mountPoints;
            java.lang.Object portMappings;
            java.lang.Object privileged;
            java.lang.Object pseudoTerminal;
            java.lang.Object readonlyRootFilesystem;
            java.lang.Object repositoryCredentials;
            java.lang.Object resourceRequirements;
            java.lang.Object restartPolicy;
            java.lang.Object secrets;
            java.lang.Number startTimeout;
            java.lang.Number stopTimeout;
            java.lang.Object systemControls;
            java.lang.Object ulimits;
            java.lang.String user;
            java.lang.String versionConsistency;
            java.lang.Object volumesFrom;
            java.lang.String workingDirectory;

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getImage}
             * @param image The image used to start a container. This parameter is required.
             *              This string is passed directly to the Docker daemon. By default, images in the Docker Hub registry are available. Other repositories are specified with either <code>*repository-url* / *image* : *tag*</code> or <code>*repository-url* / *image* &#64; *digest*</code> . Up to 255 letters (uppercase and lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter maps to <code>Image</code> in the docker container create command and the <code>IMAGE</code> parameter of docker run.
             *              <p>
             *              <ul>
             *              <li>When a new task starts, the Amazon ECS container agent pulls the latest version of the specified image and tag for the container to use. However, subsequent updates to a repository image aren't propagated to already running tasks.</li>
             *              <li>Images in Amazon ECR repositories can be specified by either using the full <code>registry/repository:tag</code> or <code>registry/repository&#64;digest</code> . For example, <code>012345678910.dkr.ecr.&lt;region-name&gt;.amazonaws.com/&lt;repository-name&gt;:latest</code> or <code>012345678910.dkr.ecr.&lt;region-name&gt;.amazonaws.com/&lt;repository-name&gt;&#64;sha256:94afd1f2e64d908bc90dbca0035a5b567EXAMPLE</code> .</li>
             *              <li>Images in official repositories on Docker Hub use a single name (for example, <code>ubuntu</code> or <code>mongo</code> ).</li>
             *              <li>Images in other repositories on Docker Hub are qualified with an organization name (for example, <code>amazon/amazon-ecs-agent</code> ).</li>
             *              <li>Images in other online repositories are qualified further by a domain name (for example, <code>quay.io/assemblyline/ubuntu</code> ).</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder image(java.lang.String image) {
                this.image = image;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getName}
             * @param name The name of a container. This parameter is required.
             *             If you're linking multiple containers together in a task definition, the <code>name</code> of one container can be entered in the <code>links</code> of another container to connect the containers. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. This parameter maps to <code>name</code> in the docker container create command and the <code>--name</code> option to docker run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getCommand}
             * @param command The command that's passed to the container.
             *                This parameter maps to <code>Cmd</code> in the docker container create command and the <code>COMMAND</code> parameter to docker run. If there are multiple arguments, each argument is a separated string in the array.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder command(java.util.List<java.lang.String> command) {
                this.command = command;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getCpu}
             * @param cpu The number of <code>cpu</code> units reserved for the container.
             *            This parameter maps to <code>CpuShares</code> in the docker container create commandand the <code>--cpu-shares</code> option to docker run.
             *            <p>
             *            This field is optional for tasks using the Fargate launch type, and the only requirement is that the total amount of CPU reserved for all containers within a task be lower than the task-level <code>cpu</code> value.
             *            <p>
             *            <blockquote>
             *            <p>
             *            You can determine the number of CPU units that are available per EC2 instance type by multiplying the vCPUs listed for that instance type on the <a href="https://docs.aws.amazon.com/ec2/instance-types/">Amazon EC2 Instances</a> detail page by 1,024.
             *            <p>
             *            </blockquote>
             *            <p>
             *            Linux containers share unallocated CPU units with other containers on the container instance with the same ratio as their allocated amount. For example, if you run a single-container task on a single-core instance type with 512 CPU units specified for that container, and that's the only task running on the container instance, that container could use the full 1,024 CPU unit share at any given time. However, if you launched another copy of the same task on that container instance, each task is guaranteed a minimum of 512 CPU units when needed. Moreover, each container could float to higher CPU usage if the other container was not using it. If both tasks were 100% active all of the time, they would be limited to 512 CPU units.
             *            <p>
             *            On Linux container instances, the Docker daemon on the container instance uses the CPU value to calculate the relative CPU share ratios for running containers. The minimum valid CPU share value that the Linux kernel allows is 2, and the maximum valid CPU share value that the Linux kernel allows is 262144. However, the CPU parameter isn't required, and you can use CPU values below 2 or above 262144 in your container definitions. For CPU values below 2 (including null) or above 262144, the behavior varies based on your Amazon ECS container agent version:
             *            <p>
             *            <ul>
             *            <li><em>Agent versions less than or equal to 1.1.0:</em> Null and zero CPU values are passed to Docker as 0, which Docker then converts to 1,024 CPU shares. CPU values of 1 are passed to Docker as 1, which the Linux kernel converts to two CPU shares.</li>
             *            <li><em>Agent versions greater than or equal to 1.2.0:</em> Null, zero, and CPU values of 1 are passed to Docker as 2.</li>
             *            <li><em>Agent versions greater than or equal to 1.84.0:</em> CPU values greater than 256 vCPU are passed to Docker as 256, which is equivalent to 262144 CPU shares.</li>
             *            </ul>
             *            <p>
             *            On Windows container instances, the CPU limit is enforced as an absolute limit, or a quota. Windows containers only have access to the specified amount of CPU that's described in the task definition. A null or zero CPU value is passed to Docker as <code>0</code> , which Windows interprets as 1% of one CPU.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpu(java.lang.Number cpu) {
                this.cpu = cpu;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getCredentialSpecs}
             * @param credentialSpecs A list of ARNs in SSM or Amazon S3 to a credential spec ( <code>CredSpec</code> ) file that configures the container for Active Directory authentication.
             *                        We recommend that you use this parameter instead of the <code>dockerSecurityOptions</code> . The maximum number of ARNs is 1.
             *                        <p>
             *                        There are two formats for each ARN.
             *                        <p>
             *                        <ul>
             *                        <li><strong>credentialspecdomainless:MyARN</strong> - You use <code>credentialspecdomainless:MyARN</code> to provide a <code>CredSpec</code> with an additional section for a secret in AWS Secrets Manager . You provide the login credentials to the domain in the secret.</li>
             *                        </ul>
             *                        <p>
             *                        Each task that runs on any container instance can join different domains.
             *                        <p>
             *                        You can use this format without joining the container instance to a domain.
             *                        <p>
             *                        <ul>
             *                        <li><strong>credentialspec:MyARN</strong> - You use <code>credentialspec:MyARN</code> to provide a <code>CredSpec</code> for a single domain.</li>
             *                        </ul>
             *                        <p>
             *                        You must join the container instance to the domain before you start any tasks that use this task definition.
             *                        <p>
             *                        In both formats, replace <code>MyARN</code> with the ARN in SSM or Amazon S3.
             *                        <p>
             *                        If you provide a <code>credentialspecdomainless:MyARN</code> , the <code>credspec</code> must provide a ARN in AWS Secrets Manager for a secret containing the username, password, and the domain to connect to. For better security, the instance isn't joined to the domain for domainless authentication. Other applications on the instance can't use the domainless credentials. You can use this parameter to run tasks on the same instance, even it the tasks need to join different domains. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows-gmsa.html">Using gMSAs for Windows Containers</a> and <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/linux-gmsa.html">Using gMSAs for Linux Containers</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialSpecs(java.util.List<java.lang.String> credentialSpecs) {
                this.credentialSpecs = credentialSpecs;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getDependsOn}
             * @param dependsOn The dependencies defined for container startup and shutdown.
             *                  A container can contain multiple dependencies. When a dependency is defined for container startup, for container shutdown it is reversed.
             *                  <p>
             *                  For tasks using the EC2 launch type, the container instances require at least version 1.26.0 of the container agent to turn on container dependencies. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon ECS Container Agent</a> in the <em>Amazon Elastic Container Service Developer Guide</em> . If you're using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the <code>ecs-init</code> package. If your container instances are launched from version <code>20190301</code> or later, then they contain the required versions of the container agent and <code>ecs-init</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                  <p>
             *                  For tasks using the Fargate launch type, the task or service requires the following platforms:
             *                  <p>
             *                  <ul>
             *                  <li>Linux platform version <code>1.3.0</code> or later.</li>
             *                  <li>Windows platform version <code>1.0.0</code> or later.</li>
             *                  </ul>
             *                  <p>
             *                  If the task definition is used in a blue/green deployment that uses <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-bluegreendeploymentconfiguration.html">AWS::CodeDeploy::DeploymentGroup BlueGreenDeploymentConfiguration</a> , the <code>dependsOn</code> parameter is not supported. For more information see <a href="https://docs.aws.amazon.com/https://github.com/aws-cloudformation/cloudformation-coverage-roadmap/issues/680">Issue #680</a> on the on the GitHub website.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dependsOn(software.amazon.awscdk.IResolvable dependsOn) {
                this.dependsOn = dependsOn;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getDependsOn}
             * @param dependsOn The dependencies defined for container startup and shutdown.
             *                  A container can contain multiple dependencies. When a dependency is defined for container startup, for container shutdown it is reversed.
             *                  <p>
             *                  For tasks using the EC2 launch type, the container instances require at least version 1.26.0 of the container agent to turn on container dependencies. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon ECS Container Agent</a> in the <em>Amazon Elastic Container Service Developer Guide</em> . If you're using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the <code>ecs-init</code> package. If your container instances are launched from version <code>20190301</code> or later, then they contain the required versions of the container agent and <code>ecs-init</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                  <p>
             *                  For tasks using the Fargate launch type, the task or service requires the following platforms:
             *                  <p>
             *                  <ul>
             *                  <li>Linux platform version <code>1.3.0</code> or later.</li>
             *                  <li>Windows platform version <code>1.0.0</code> or later.</li>
             *                  </ul>
             *                  <p>
             *                  If the task definition is used in a blue/green deployment that uses <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-bluegreendeploymentconfiguration.html">AWS::CodeDeploy::DeploymentGroup BlueGreenDeploymentConfiguration</a> , the <code>dependsOn</code> parameter is not supported. For more information see <a href="https://docs.aws.amazon.com/https://github.com/aws-cloudformation/cloudformation-coverage-roadmap/issues/680">Issue #680</a> on the on the GitHub website.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dependsOn(java.util.List<? extends java.lang.Object> dependsOn) {
                this.dependsOn = dependsOn;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getDisableNetworking}
             * @param disableNetworking When this parameter is true, networking is off within the container.
             *                          This parameter maps to <code>NetworkDisabled</code> in the docker container create command.
             *                          <p>
             *                          <blockquote>
             *                          <p>
             *                          This parameter is not supported for Windows containers.
             *                          <p>
             *                          </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableNetworking(java.lang.Boolean disableNetworking) {
                this.disableNetworking = disableNetworking;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getDisableNetworking}
             * @param disableNetworking When this parameter is true, networking is off within the container.
             *                          This parameter maps to <code>NetworkDisabled</code> in the docker container create command.
             *                          <p>
             *                          <blockquote>
             *                          <p>
             *                          This parameter is not supported for Windows containers.
             *                          <p>
             *                          </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableNetworking(software.amazon.awscdk.IResolvable disableNetworking) {
                this.disableNetworking = disableNetworking;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getDnsSearchDomains}
             * @param dnsSearchDomains A list of DNS search domains that are presented to the container.
             *                         This parameter maps to <code>DnsSearch</code> in the docker container create command and the <code>--dns-search</code> option to docker run.
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         This parameter is not supported for Windows containers.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsSearchDomains(java.util.List<java.lang.String> dnsSearchDomains) {
                this.dnsSearchDomains = dnsSearchDomains;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getDnsServers}
             * @param dnsServers A list of DNS servers that are presented to the container.
             *                   This parameter maps to <code>Dns</code> in the docker container create command and the <code>--dns</code> option to docker run.
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   This parameter is not supported for Windows containers.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsServers(java.util.List<java.lang.String> dnsServers) {
                this.dnsServers = dnsServers;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getDockerLabels}
             * @param dockerLabels A key/value map of labels to add to the container.
             *                     This parameter maps to <code>Labels</code> in the docker container create command and the <code>--label</code> option to docker run. This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dockerLabels(java.util.Map<java.lang.String, java.lang.String> dockerLabels) {
                this.dockerLabels = dockerLabels;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getDockerLabels}
             * @param dockerLabels A key/value map of labels to add to the container.
             *                     This parameter maps to <code>Labels</code> in the docker container create command and the <code>--label</code> option to docker run. This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dockerLabels(software.amazon.awscdk.IResolvable dockerLabels) {
                this.dockerLabels = dockerLabels;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getDockerSecurityOptions}
             * @param dockerSecurityOptions A list of strings to provide custom configuration for multiple security systems.
             *                              This field isn't valid for containers in tasks using the Fargate launch type.
             *                              <p>
             *                              For Linux tasks on EC2, this parameter can be used to reference custom labels for SELinux and AppArmor multi-level security systems.
             *                              <p>
             *                              For any tasks on EC2, this parameter can be used to reference a credential spec file that configures a container for Active Directory authentication. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows-gmsa.html">Using gMSAs for Windows Containers</a> and <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/linux-gmsa.html">Using gMSAs for Linux Containers</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                              <p>
             *                              This parameter maps to <code>SecurityOpt</code> in the docker container create command and the <code>--security-opt</code> option to docker run.
             *                              <p>
             *                              <blockquote>
             *                              <p>
             *                              The Amazon ECS container agent running on a container instance must register with the <code>ECS_SELINUX_CAPABLE=true</code> or <code>ECS_APPARMOR_CAPABLE=true</code> environment variables before containers placed on that instance can use these security options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container Agent Configuration</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                              <p>
             *                              </blockquote>
             *                              <p>
             *                              Valid values: "no-new-privileges" | "apparmor:PROFILE" | "label:value" | "credentialspec:CredentialSpecFilePath"
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dockerSecurityOptions(java.util.List<java.lang.String> dockerSecurityOptions) {
                this.dockerSecurityOptions = dockerSecurityOptions;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getEntryPoint}
             * @param entryPoint <blockquote><p>Early versions of the Amazon ECS container agent don't properly handle <code>entryPoint</code> parameters.<p></blockquote>
             *                   If you have problems using <code>entryPoint</code> , update your container agent or enter your commands and arguments as <code>command</code> array items instead.
             *                   <p>
             *                   The entry point that's passed to the container. This parameter maps to <code>Entrypoint</code> in the docker container create command and the <code>--entrypoint</code> option to docker run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entryPoint(java.util.List<java.lang.String> entryPoint) {
                this.entryPoint = entryPoint;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getEnvironment}
             * @param environment The environment variables to pass to a container.
             *                    This parameter maps to <code>Env</code> in the docker container create command and the <code>--env</code> option to docker run.
             *                    <p>
             *                    <blockquote>
             *                    <p>
             *                    We don't recommend that you use plaintext environment variables for sensitive information, such as credential data.
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(software.amazon.awscdk.IResolvable environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getEnvironment}
             * @param environment The environment variables to pass to a container.
             *                    This parameter maps to <code>Env</code> in the docker container create command and the <code>--env</code> option to docker run.
             *                    <p>
             *                    <blockquote>
             *                    <p>
             *                    We don't recommend that you use plaintext environment variables for sensitive information, such as credential data.
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(java.util.List<? extends java.lang.Object> environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getEnvironmentFiles}
             * @param environmentFiles A list of files containing the environment variables to pass to a container.
             *                         This parameter maps to the <code>--env-file</code> option to docker run.
             *                         <p>
             *                         You can specify up to ten environment files. The file must have a <code>.env</code> file extension. Each line in an environment file contains an environment variable in <code>VARIABLE=VALUE</code> format. Lines beginning with <code>#</code> are treated as comments and are ignored.
             *                         <p>
             *                         If there are environment variables specified using the <code>environment</code> parameter in a container definition, they take precedence over the variables contained within an environment file. If multiple environment files are specified that contain the same variable, they're processed from the top down. We recommend that you use unique variable names. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html">Specifying Environment Variables</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentFiles(software.amazon.awscdk.IResolvable environmentFiles) {
                this.environmentFiles = environmentFiles;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getEnvironmentFiles}
             * @param environmentFiles A list of files containing the environment variables to pass to a container.
             *                         This parameter maps to the <code>--env-file</code> option to docker run.
             *                         <p>
             *                         You can specify up to ten environment files. The file must have a <code>.env</code> file extension. Each line in an environment file contains an environment variable in <code>VARIABLE=VALUE</code> format. Lines beginning with <code>#</code> are treated as comments and are ignored.
             *                         <p>
             *                         If there are environment variables specified using the <code>environment</code> parameter in a container definition, they take precedence over the variables contained within an environment file. If multiple environment files are specified that contain the same variable, they're processed from the top down. We recommend that you use unique variable names. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html">Specifying Environment Variables</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentFiles(java.util.List<? extends java.lang.Object> environmentFiles) {
                this.environmentFiles = environmentFiles;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getEssential}
             * @param essential If the <code>essential</code> parameter of a container is marked as <code>true</code> , and that container fails or stops for any reason, all other containers that are part of the task are stopped.
             *                  If the <code>essential</code> parameter of a container is marked as <code>false</code> , its failure doesn't affect the rest of the containers in a task. If this parameter is omitted, a container is assumed to be essential.
             *                  <p>
             *                  All tasks must have at least one essential container. If you have an application that's composed of multiple containers, group containers that are used for a common purpose into components, and separate the different components into multiple task definitions. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html">Application Architecture</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder essential(java.lang.Boolean essential) {
                this.essential = essential;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getEssential}
             * @param essential If the <code>essential</code> parameter of a container is marked as <code>true</code> , and that container fails or stops for any reason, all other containers that are part of the task are stopped.
             *                  If the <code>essential</code> parameter of a container is marked as <code>false</code> , its failure doesn't affect the rest of the containers in a task. If this parameter is omitted, a container is assumed to be essential.
             *                  <p>
             *                  All tasks must have at least one essential container. If you have an application that's composed of multiple containers, group containers that are used for a common purpose into components, and separate the different components into multiple task definitions. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html">Application Architecture</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder essential(software.amazon.awscdk.IResolvable essential) {
                this.essential = essential;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getExtraHosts}
             * @param extraHosts A list of hostnames and IP address mappings to append to the <code>/etc/hosts</code> file on the container.
             *                   This parameter maps to <code>ExtraHosts</code> in the docker container create command and the <code>--add-host</code> option to docker run.
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   This parameter isn't supported for Windows containers or tasks that use the <code>awsvpc</code> network mode.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extraHosts(software.amazon.awscdk.IResolvable extraHosts) {
                this.extraHosts = extraHosts;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getExtraHosts}
             * @param extraHosts A list of hostnames and IP address mappings to append to the <code>/etc/hosts</code> file on the container.
             *                   This parameter maps to <code>ExtraHosts</code> in the docker container create command and the <code>--add-host</code> option to docker run.
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   This parameter isn't supported for Windows containers or tasks that use the <code>awsvpc</code> network mode.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extraHosts(java.util.List<? extends java.lang.Object> extraHosts) {
                this.extraHosts = extraHosts;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getFirelensConfiguration}
             * @param firelensConfiguration The FireLens configuration for the container.
             *                              This is used to specify and configure a log router for container logs. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Custom Log Routing</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firelensConfiguration(software.amazon.awscdk.IResolvable firelensConfiguration) {
                this.firelensConfiguration = firelensConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getFirelensConfiguration}
             * @param firelensConfiguration The FireLens configuration for the container.
             *                              This is used to specify and configure a log router for container logs. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Custom Log Routing</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firelensConfiguration(software.amazon.awscdk.services.ecs.CfnTaskDefinition.FirelensConfigurationProperty firelensConfiguration) {
                this.firelensConfiguration = firelensConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getHealthCheck}
             * @param healthCheck The container health check command and associated configuration parameters for the container.
             *                    This parameter maps to <code>HealthCheck</code> in the docker container create command and the <code>HEALTHCHECK</code> parameter of docker run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthCheck(software.amazon.awscdk.IResolvable healthCheck) {
                this.healthCheck = healthCheck;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getHealthCheck}
             * @param healthCheck The container health check command and associated configuration parameters for the container.
             *                    This parameter maps to <code>HealthCheck</code> in the docker container create command and the <code>HEALTHCHECK</code> parameter of docker run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthCheck(software.amazon.awscdk.services.ecs.CfnTaskDefinition.HealthCheckProperty healthCheck) {
                this.healthCheck = healthCheck;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getHostname}
             * @param hostname The hostname to use for your container.
             *                 This parameter maps to <code>Hostname</code> in the docker container create command and the <code>--hostname</code> option to docker run.
             *                 <p>
             *                 <blockquote>
             *                 <p>
             *                 The <code>hostname</code> parameter is not supported if you're using the <code>awsvpc</code> network mode.
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostname(java.lang.String hostname) {
                this.hostname = hostname;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getInteractive}
             * @param interactive When this parameter is <code>true</code> , you can deploy containerized applications that require <code>stdin</code> or a <code>tty</code> to be allocated.
             *                    This parameter maps to <code>OpenStdin</code> in the docker container create command and the <code>--interactive</code> option to docker run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interactive(java.lang.Boolean interactive) {
                this.interactive = interactive;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getInteractive}
             * @param interactive When this parameter is <code>true</code> , you can deploy containerized applications that require <code>stdin</code> or a <code>tty</code> to be allocated.
             *                    This parameter maps to <code>OpenStdin</code> in the docker container create command and the <code>--interactive</code> option to docker run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interactive(software.amazon.awscdk.IResolvable interactive) {
                this.interactive = interactive;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getLinks}
             * @param links The <code>links</code> parameter allows containers to communicate with each other without the need for port mappings.
             *              This parameter is only supported if the network mode of a task definition is <code>bridge</code> . The <code>name:internalName</code> construct is analogous to <code>name:alias</code> in Docker links. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed.. This parameter maps to <code>Links</code> in the docker container create command and the <code>--link</code> option to docker run.
             *              <p>
             *              <blockquote>
             *              <p>
             *              This parameter is not supported for Windows containers. &gt; Containers that are collocated on a single container instance may be able to communicate with each other without requiring links or host port mappings. Network isolation is achieved on the container instance using security groups and VPC settings.
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder links(java.util.List<java.lang.String> links) {
                this.links = links;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getLinuxParameters}
             * @param linuxParameters Linux-specific modifications that are applied to the container, such as Linux kernel capabilities. For more information see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html">KernelCapabilities</a> .
             *                        <blockquote>
             *                        <p>
             *                        This parameter is not supported for Windows containers.
             *                        <p>
             *                        </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder linuxParameters(software.amazon.awscdk.IResolvable linuxParameters) {
                this.linuxParameters = linuxParameters;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getLinuxParameters}
             * @param linuxParameters Linux-specific modifications that are applied to the container, such as Linux kernel capabilities. For more information see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html">KernelCapabilities</a> .
             *                        <blockquote>
             *                        <p>
             *                        This parameter is not supported for Windows containers.
             *                        <p>
             *                        </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder linuxParameters(software.amazon.awscdk.services.ecs.CfnTaskDefinition.LinuxParametersProperty linuxParameters) {
                this.linuxParameters = linuxParameters;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getLogConfiguration}
             * @param logConfiguration The log configuration specification for the container.
             *                         This parameter maps to <code>LogConfig</code> in the docker Create a container command and the <code>--log-driver</code> option to docker run. By default, containers use the same logging driver that the Docker daemon uses. However, the container may use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the Docker documentation.
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon (shown in the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_LogConfiguration.html">LogConfiguration</a> data type). Additional log drivers may be available in future releases of the Amazon ECS container agent.
             *                         <p>
             *                         </blockquote>
             *                         <p>
             *                         This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers placed on that instance can use these log configuration options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container Agent Configuration</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logConfiguration(software.amazon.awscdk.IResolvable logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getLogConfiguration}
             * @param logConfiguration The log configuration specification for the container.
             *                         This parameter maps to <code>LogConfig</code> in the docker Create a container command and the <code>--log-driver</code> option to docker run. By default, containers use the same logging driver that the Docker daemon uses. However, the container may use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the Docker documentation.
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon (shown in the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_LogConfiguration.html">LogConfiguration</a> data type). Additional log drivers may be available in future releases of the Amazon ECS container agent.
             *                         <p>
             *                         </blockquote>
             *                         <p>
             *                         This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers placed on that instance can use these log configuration options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container Agent Configuration</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logConfiguration(software.amazon.awscdk.services.ecs.CfnTaskDefinition.LogConfigurationProperty logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getMemory}
             * @param memory The amount (in MiB) of memory to present to the container.
             *               If your container attempts to exceed the memory specified here, the container is killed. The total amount of memory reserved for all containers within a task must be lower than the task <code>memory</code> value, if one is specified. This parameter maps to <code>Memory</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--memory</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a> .
             *               <p>
             *               If using the Fargate launch type, this parameter is optional.
             *               <p>
             *               If using the EC2 launch type, you must specify either a task-level memory value or a container-level memory value. If you specify both a container-level <code>memory</code> and <code>memoryReservation</code> value, <code>memory</code> must be greater than <code>memoryReservation</code> . If you specify <code>memoryReservation</code> , then that value is subtracted from the available memory resources for the container instance where the container is placed. Otherwise, the value of <code>memory</code> is used.
             *               <p>
             *               The Docker 20.10.0 or later daemon reserves a minimum of 6 MiB of memory for a container, so you should not specify fewer than 6 MiB of memory for your containers.
             *               <p>
             *               The Docker 19.03.13-ce or earlier daemon reserves a minimum of 4 MiB of memory for a container, so you should not specify fewer than 4 MiB of memory for your containers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memory(java.lang.Number memory) {
                this.memory = memory;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getMemoryReservation}
             * @param memoryReservation The soft limit (in MiB) of memory to reserve for the container.
             *                          When system memory is under heavy contention, Docker attempts to keep the container memory to this soft limit. However, your container can consume more memory when it needs to, up to either the hard limit specified with the <code>memory</code> parameter (if applicable), or all of the available memory on the container instance, whichever comes first. This parameter maps to <code>MemoryReservation</code> in the docker container create command and the <code>--memory-reservation</code> option to docker run.
             *                          <p>
             *                          If a task-level memory value is not specified, you must specify a non-zero integer for one or both of <code>memory</code> or <code>memoryReservation</code> in a container definition. If you specify both, <code>memory</code> must be greater than <code>memoryReservation</code> . If you specify <code>memoryReservation</code> , then that value is subtracted from the available memory resources for the container instance where the container is placed. Otherwise, the value of <code>memory</code> is used.
             *                          <p>
             *                          For example, if your container normally uses 128 MiB of memory, but occasionally bursts to 256 MiB of memory for short periods of time, you can set a <code>memoryReservation</code> of 128 MiB, and a <code>memory</code> hard limit of 300 MiB. This configuration would allow the container to only reserve 128 MiB of memory from the remaining resources on the container instance, but also allow the container to consume more memory resources when needed.
             *                          <p>
             *                          The Docker 20.10.0 or later daemon reserves a minimum of 6 MiB of memory for a container. So, don't specify less than 6 MiB of memory for your containers.
             *                          <p>
             *                          The Docker 19.03.13-ce or earlier daemon reserves a minimum of 4 MiB of memory for a container. So, don't specify less than 4 MiB of memory for your containers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryReservation(java.lang.Number memoryReservation) {
                this.memoryReservation = memoryReservation;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getMountPoints}
             * @param mountPoints The mount points for data volumes in your container.
             *                    This parameter maps to <code>Volumes</code> in the docker container create command and the <code>--volume</code> option to docker run.
             *                    <p>
             *                    Windows containers can mount whole directories on the same drive as <code>$env:ProgramData</code> . Windows containers can't mount directories on a different drive, and mount point can't be across drives.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountPoints(software.amazon.awscdk.IResolvable mountPoints) {
                this.mountPoints = mountPoints;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getMountPoints}
             * @param mountPoints The mount points for data volumes in your container.
             *                    This parameter maps to <code>Volumes</code> in the docker container create command and the <code>--volume</code> option to docker run.
             *                    <p>
             *                    Windows containers can mount whole directories on the same drive as <code>$env:ProgramData</code> . Windows containers can't mount directories on a different drive, and mount point can't be across drives.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountPoints(java.util.List<? extends java.lang.Object> mountPoints) {
                this.mountPoints = mountPoints;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getPortMappings}
             * @param portMappings The list of port mappings for the container.
             *                     Port mappings allow containers to access ports on the host container instance to send or receive traffic.
             *                     <p>
             *                     For task definitions that use the <code>awsvpc</code> network mode, you should only specify the <code>containerPort</code> . The <code>hostPort</code> can be left blank or it must be the same value as the <code>containerPort</code> .
             *                     <p>
             *                     Port mappings on Windows use the <code>NetNAT</code> gateway address rather than <code>localhost</code> . There is no loopback for port mappings on Windows, so you cannot access a container's mapped port from the host itself.
             *                     <p>
             *                     This parameter maps to <code>PortBindings</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--publish</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . If the network mode of a task definition is set to <code>none</code> , then you can't specify port mappings. If the network mode of a task definition is set to <code>host</code> , then host ports must either be undefined or they must match the container port in the port mapping.
             *                     <p>
             *                     <blockquote>
             *                     <p>
             *                     After a task reaches the <code>RUNNING</code> status, manual and automatic host and container port assignments are visible in the <em>Network Bindings</em> section of a container description for a selected task in the Amazon ECS console. The assignments are also visible in the <code>networkBindings</code> section <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTasks.html">DescribeTasks</a> responses.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portMappings(software.amazon.awscdk.IResolvable portMappings) {
                this.portMappings = portMappings;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getPortMappings}
             * @param portMappings The list of port mappings for the container.
             *                     Port mappings allow containers to access ports on the host container instance to send or receive traffic.
             *                     <p>
             *                     For task definitions that use the <code>awsvpc</code> network mode, you should only specify the <code>containerPort</code> . The <code>hostPort</code> can be left blank or it must be the same value as the <code>containerPort</code> .
             *                     <p>
             *                     Port mappings on Windows use the <code>NetNAT</code> gateway address rather than <code>localhost</code> . There is no loopback for port mappings on Windows, so you cannot access a container's mapped port from the host itself.
             *                     <p>
             *                     This parameter maps to <code>PortBindings</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--publish</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . If the network mode of a task definition is set to <code>none</code> , then you can't specify port mappings. If the network mode of a task definition is set to <code>host</code> , then host ports must either be undefined or they must match the container port in the port mapping.
             *                     <p>
             *                     <blockquote>
             *                     <p>
             *                     After a task reaches the <code>RUNNING</code> status, manual and automatic host and container port assignments are visible in the <em>Network Bindings</em> section of a container description for a selected task in the Amazon ECS console. The assignments are also visible in the <code>networkBindings</code> section <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTasks.html">DescribeTasks</a> responses.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portMappings(java.util.List<? extends java.lang.Object> portMappings) {
                this.portMappings = portMappings;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getPrivileged}
             * @param privileged When this parameter is true, the container is given elevated privileges on the host container instance (similar to the <code>root</code> user).
             *                   This parameter maps to <code>Privileged</code> in the docker container create command and the <code>--privileged</code> option to docker run
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   This parameter is not supported for Windows containers or tasks run on AWS Fargate .
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privileged(java.lang.Boolean privileged) {
                this.privileged = privileged;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getPrivileged}
             * @param privileged When this parameter is true, the container is given elevated privileges on the host container instance (similar to the <code>root</code> user).
             *                   This parameter maps to <code>Privileged</code> in the docker container create command and the <code>--privileged</code> option to docker run
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   This parameter is not supported for Windows containers or tasks run on AWS Fargate .
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privileged(software.amazon.awscdk.IResolvable privileged) {
                this.privileged = privileged;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getPseudoTerminal}
             * @param pseudoTerminal When this parameter is <code>true</code> , a TTY is allocated.
             *                       This parameter maps to <code>Tty</code> in the docker container create command and the <code>--tty</code> option to docker run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pseudoTerminal(java.lang.Boolean pseudoTerminal) {
                this.pseudoTerminal = pseudoTerminal;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getPseudoTerminal}
             * @param pseudoTerminal When this parameter is <code>true</code> , a TTY is allocated.
             *                       This parameter maps to <code>Tty</code> in the docker container create command and the <code>--tty</code> option to docker run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pseudoTerminal(software.amazon.awscdk.IResolvable pseudoTerminal) {
                this.pseudoTerminal = pseudoTerminal;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getReadonlyRootFilesystem}
             * @param readonlyRootFilesystem When this parameter is true, the container is given read-only access to its root file system.
             *                               This parameter maps to <code>ReadonlyRootfs</code> in the docker container create command and the <code>--read-only</code> option to docker run.
             *                               <p>
             *                               <blockquote>
             *                               <p>
             *                               This parameter is not supported for Windows containers.
             *                               <p>
             *                               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readonlyRootFilesystem(java.lang.Boolean readonlyRootFilesystem) {
                this.readonlyRootFilesystem = readonlyRootFilesystem;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getReadonlyRootFilesystem}
             * @param readonlyRootFilesystem When this parameter is true, the container is given read-only access to its root file system.
             *                               This parameter maps to <code>ReadonlyRootfs</code> in the docker container create command and the <code>--read-only</code> option to docker run.
             *                               <p>
             *                               <blockquote>
             *                               <p>
             *                               This parameter is not supported for Windows containers.
             *                               <p>
             *                               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readonlyRootFilesystem(software.amazon.awscdk.IResolvable readonlyRootFilesystem) {
                this.readonlyRootFilesystem = readonlyRootFilesystem;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getRepositoryCredentials}
             * @param repositoryCredentials The private repository authentication credentials to use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repositoryCredentials(software.amazon.awscdk.IResolvable repositoryCredentials) {
                this.repositoryCredentials = repositoryCredentials;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getRepositoryCredentials}
             * @param repositoryCredentials The private repository authentication credentials to use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repositoryCredentials(software.amazon.awscdk.services.ecs.CfnTaskDefinition.RepositoryCredentialsProperty repositoryCredentials) {
                this.repositoryCredentials = repositoryCredentials;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getResourceRequirements}
             * @param resourceRequirements The type and amount of a resource to assign to a container.
             *                             The only supported resource is a GPU.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceRequirements(software.amazon.awscdk.IResolvable resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getResourceRequirements}
             * @param resourceRequirements The type and amount of a resource to assign to a container.
             *                             The only supported resource is a GPU.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceRequirements(java.util.List<? extends java.lang.Object> resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getRestartPolicy}
             * @param restartPolicy The restart policy for a container.
             *                      When you set up a restart policy, Amazon ECS can restart the container without needing to replace the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-restart-policy.html">Restart individual containers in Amazon ECS tasks with container restart policies</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restartPolicy(software.amazon.awscdk.IResolvable restartPolicy) {
                this.restartPolicy = restartPolicy;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getRestartPolicy}
             * @param restartPolicy The restart policy for a container.
             *                      When you set up a restart policy, Amazon ECS can restart the container without needing to replace the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-restart-policy.html">Restart individual containers in Amazon ECS tasks with container restart policies</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restartPolicy(software.amazon.awscdk.services.ecs.CfnTaskDefinition.RestartPolicyProperty restartPolicy) {
                this.restartPolicy = restartPolicy;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getSecrets}
             * @param secrets The secrets to pass to the container.
             *                For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying Sensitive Data</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secrets(software.amazon.awscdk.IResolvable secrets) {
                this.secrets = secrets;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getSecrets}
             * @param secrets The secrets to pass to the container.
             *                For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying Sensitive Data</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secrets(java.util.List<? extends java.lang.Object> secrets) {
                this.secrets = secrets;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getStartTimeout}
             * @param startTimeout Time duration (in seconds) to wait before giving up on resolving dependencies for a container.
             *                     For example, you specify two containers in a task definition with containerA having a dependency on containerB reaching a <code>COMPLETE</code> , <code>SUCCESS</code> , or <code>HEALTHY</code> status. If a <code>startTimeout</code> value is specified for containerB and it doesn't reach the desired status within that time then containerA gives up and not start. This results in the task transitioning to a <code>STOPPED</code> state.
             *                     <p>
             *                     <blockquote>
             *                     <p>
             *                     When the <code>ECS_CONTAINER_START_TIMEOUT</code> container agent configuration variable is used, it's enforced independently from this start timeout value.
             *                     <p>
             *                     </blockquote>
             *                     <p>
             *                     For tasks using the Fargate launch type, the task or service requires the following platforms:
             *                     <p>
             *                     <ul>
             *                     <li>Linux platform version <code>1.3.0</code> or later.</li>
             *                     <li>Windows platform version <code>1.0.0</code> or later.</li>
             *                     </ul>
             *                     <p>
             *                     For tasks using the EC2 launch type, your container instances require at least version <code>1.26.0</code> of the container agent to use a container start timeout value. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon ECS Container Agent</a> in the <em>Amazon Elastic Container Service Developer Guide</em> . If you're using an Amazon ECS-optimized Linux AMI, your instance needs at least version <code>1.26.0-1</code> of the <code>ecs-init</code> package. If your container instances are launched from version <code>20190301</code> or later, then they contain the required versions of the container agent and <code>ecs-init</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                     <p>
             *                     The valid values for Fargate are 2-120 seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTimeout(java.lang.Number startTimeout) {
                this.startTimeout = startTimeout;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getStopTimeout}
             * @param stopTimeout Time duration (in seconds) to wait before the container is forcefully killed if it doesn't exit normally on its own.
             *                    For tasks using the Fargate launch type, the task or service requires the following platforms:
             *                    <p>
             *                    <ul>
             *                    <li>Linux platform version <code>1.3.0</code> or later.</li>
             *                    <li>Windows platform version <code>1.0.0</code> or later.</li>
             *                    </ul>
             *                    <p>
             *                    For tasks that use the Fargate launch type, the max stop timeout value is 120 seconds and if the parameter is not specified, the default value of 30 seconds is used.
             *                    <p>
             *                    For tasks that use the EC2 launch type, if the <code>stopTimeout</code> parameter isn't specified, the value set for the Amazon ECS container agent configuration variable <code>ECS_CONTAINER_STOP_TIMEOUT</code> is used. If neither the <code>stopTimeout</code> parameter or the <code>ECS_CONTAINER_STOP_TIMEOUT</code> agent configuration variable are set, then the default values of 30 seconds for Linux containers and 30 seconds on Windows containers are used. Your container instances require at least version 1.26.0 of the container agent to use a container stop timeout value. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon ECS Container Agent</a> in the <em>Amazon Elastic Container Service Developer Guide</em> . If you're using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the <code>ecs-init</code> package. If your container instances are launched from version <code>20190301</code> or later, then they contain the required versions of the container agent and <code>ecs-init</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                    <p>
             *                    The valid values for Fargate are 2-120 seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stopTimeout(java.lang.Number stopTimeout) {
                this.stopTimeout = stopTimeout;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getSystemControls}
             * @param systemControls A list of namespaced kernel parameters to set in the container.
             *                       This parameter maps to <code>Sysctls</code> in the docker container create command and the <code>--sysctl</code> option to docker run. For example, you can configure <code>net.ipv4.tcp_keepalive_time</code> setting to maintain longer lived connections.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder systemControls(software.amazon.awscdk.IResolvable systemControls) {
                this.systemControls = systemControls;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getSystemControls}
             * @param systemControls A list of namespaced kernel parameters to set in the container.
             *                       This parameter maps to <code>Sysctls</code> in the docker container create command and the <code>--sysctl</code> option to docker run. For example, you can configure <code>net.ipv4.tcp_keepalive_time</code> setting to maintain longer lived connections.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder systemControls(java.util.List<? extends java.lang.Object> systemControls) {
                this.systemControls = systemControls;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getUlimits}
             * @param ulimits A list of <code>ulimits</code> to set in the container.
             *                This parameter maps to <code>Ulimits</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--ulimit</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . Valid naming values are displayed in the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_Ulimit.html">Ulimit</a> data type. This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
             *                <p>
             *                <blockquote>
             *                <p>
             *                This parameter is not supported for Windows containers.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ulimits(software.amazon.awscdk.IResolvable ulimits) {
                this.ulimits = ulimits;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getUlimits}
             * @param ulimits A list of <code>ulimits</code> to set in the container.
             *                This parameter maps to <code>Ulimits</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--ulimit</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . Valid naming values are displayed in the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_Ulimit.html">Ulimit</a> data type. This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
             *                <p>
             *                <blockquote>
             *                <p>
             *                This parameter is not supported for Windows containers.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ulimits(java.util.List<? extends java.lang.Object> ulimits) {
                this.ulimits = ulimits;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getUser}
             * @param user The user to use inside the container.
             *             This parameter maps to <code>User</code> in the docker container create command and the <code>--user</code> option to docker run.
             *             <p>
             *             <blockquote>
             *             <p>
             *             When running tasks using the <code>host</code> network mode, don't run containers using the root user (UID 0). We recommend using a non-root user for better security.
             *             <p>
             *             </blockquote>
             *             <p>
             *             You can specify the <code>user</code> using the following formats. If specifying a UID or GID, you must specify it as a positive integer.
             *             <p>
             *             <ul>
             *             <li><code>user</code></li>
             *             <li><code>user:group</code></li>
             *             <li><code>uid</code></li>
             *             <li><code>uid:gid</code></li>
             *             <li><code>user:gid</code></li>
             *             <li><code>uid:group</code></li>
             *             </ul>
             *             <p>
             *             <blockquote>
             *             <p>
             *             This parameter is not supported for Windows containers.
             *             <p>
             *             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder user(java.lang.String user) {
                this.user = user;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getVersionConsistency}
             * @param versionConsistency Specifies whether Amazon ECS will resolve the container image tag provided in the container definition to an image digest.
             *                           By default, the value is <code>enabled</code> . If you set the value for a container as <code>disabled</code> , Amazon ECS will not resolve the provided container image tag to a digest and will use the original image URI specified in the container definition for deployment. For more information about container image resolution, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html#deployment-container-image-stability">Container image resolution</a> in the <em>Amazon ECS Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder versionConsistency(java.lang.String versionConsistency) {
                this.versionConsistency = versionConsistency;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getVolumesFrom}
             * @param volumesFrom Data volumes to mount from another container.
             *                    This parameter maps to <code>VolumesFrom</code> in the docker container create command and the <code>--volumes-from</code> option to docker run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumesFrom(software.amazon.awscdk.IResolvable volumesFrom) {
                this.volumesFrom = volumesFrom;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getVolumesFrom}
             * @param volumesFrom Data volumes to mount from another container.
             *                    This parameter maps to <code>VolumesFrom</code> in the docker container create command and the <code>--volumes-from</code> option to docker run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumesFrom(java.util.List<? extends java.lang.Object> volumesFrom) {
                this.volumesFrom = volumesFrom;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getWorkingDirectory}
             * @param workingDirectory The working directory to run commands inside the container in.
             *                         This parameter maps to <code>WorkingDir</code> in the docker container create command and the <code>--workdir</code> option to docker run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workingDirectory(java.lang.String workingDirectory) {
                this.workingDirectory = workingDirectory;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContainerDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContainerDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerDefinitionProperty {
            private final java.lang.String image;
            private final java.lang.String name;
            private final java.util.List<java.lang.String> command;
            private final java.lang.Number cpu;
            private final java.util.List<java.lang.String> credentialSpecs;
            private final java.lang.Object dependsOn;
            private final java.lang.Object disableNetworking;
            private final java.util.List<java.lang.String> dnsSearchDomains;
            private final java.util.List<java.lang.String> dnsServers;
            private final java.lang.Object dockerLabels;
            private final java.util.List<java.lang.String> dockerSecurityOptions;
            private final java.util.List<java.lang.String> entryPoint;
            private final java.lang.Object environment;
            private final java.lang.Object environmentFiles;
            private final java.lang.Object essential;
            private final java.lang.Object extraHosts;
            private final java.lang.Object firelensConfiguration;
            private final java.lang.Object healthCheck;
            private final java.lang.String hostname;
            private final java.lang.Object interactive;
            private final java.util.List<java.lang.String> links;
            private final java.lang.Object linuxParameters;
            private final java.lang.Object logConfiguration;
            private final java.lang.Number memory;
            private final java.lang.Number memoryReservation;
            private final java.lang.Object mountPoints;
            private final java.lang.Object portMappings;
            private final java.lang.Object privileged;
            private final java.lang.Object pseudoTerminal;
            private final java.lang.Object readonlyRootFilesystem;
            private final java.lang.Object repositoryCredentials;
            private final java.lang.Object resourceRequirements;
            private final java.lang.Object restartPolicy;
            private final java.lang.Object secrets;
            private final java.lang.Number startTimeout;
            private final java.lang.Number stopTimeout;
            private final java.lang.Object systemControls;
            private final java.lang.Object ulimits;
            private final java.lang.String user;
            private final java.lang.String versionConsistency;
            private final java.lang.Object volumesFrom;
            private final java.lang.String workingDirectory;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cpu = software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.credentialSpecs = software.amazon.jsii.Kernel.get(this, "credentialSpecs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.dependsOn = software.amazon.jsii.Kernel.get(this, "dependsOn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.disableNetworking = software.amazon.jsii.Kernel.get(this, "disableNetworking", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dnsSearchDomains = software.amazon.jsii.Kernel.get(this, "dnsSearchDomains", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.dnsServers = software.amazon.jsii.Kernel.get(this, "dnsServers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.dockerLabels = software.amazon.jsii.Kernel.get(this, "dockerLabels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dockerSecurityOptions = software.amazon.jsii.Kernel.get(this, "dockerSecurityOptions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.entryPoint = software.amazon.jsii.Kernel.get(this, "entryPoint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.environmentFiles = software.amazon.jsii.Kernel.get(this, "environmentFiles", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.essential = software.amazon.jsii.Kernel.get(this, "essential", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.extraHosts = software.amazon.jsii.Kernel.get(this, "extraHosts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.firelensConfiguration = software.amazon.jsii.Kernel.get(this, "firelensConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.healthCheck = software.amazon.jsii.Kernel.get(this, "healthCheck", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hostname = software.amazon.jsii.Kernel.get(this, "hostname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.interactive = software.amazon.jsii.Kernel.get(this, "interactive", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.links = software.amazon.jsii.Kernel.get(this, "links", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.linuxParameters = software.amazon.jsii.Kernel.get(this, "linuxParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logConfiguration = software.amazon.jsii.Kernel.get(this, "logConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.memory = software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.memoryReservation = software.amazon.jsii.Kernel.get(this, "memoryReservation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mountPoints = software.amazon.jsii.Kernel.get(this, "mountPoints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.portMappings = software.amazon.jsii.Kernel.get(this, "portMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.privileged = software.amazon.jsii.Kernel.get(this, "privileged", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.pseudoTerminal = software.amazon.jsii.Kernel.get(this, "pseudoTerminal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.readonlyRootFilesystem = software.amazon.jsii.Kernel.get(this, "readonlyRootFilesystem", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.repositoryCredentials = software.amazon.jsii.Kernel.get(this, "repositoryCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceRequirements = software.amazon.jsii.Kernel.get(this, "resourceRequirements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.restartPolicy = software.amazon.jsii.Kernel.get(this, "restartPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secrets = software.amazon.jsii.Kernel.get(this, "secrets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.startTimeout = software.amazon.jsii.Kernel.get(this, "startTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stopTimeout = software.amazon.jsii.Kernel.get(this, "stopTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.systemControls = software.amazon.jsii.Kernel.get(this, "systemControls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ulimits = software.amazon.jsii.Kernel.get(this, "ulimits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.versionConsistency = software.amazon.jsii.Kernel.get(this, "versionConsistency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.volumesFrom = software.amazon.jsii.Kernel.get(this, "volumesFrom", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.workingDirectory = software.amazon.jsii.Kernel.get(this, "workingDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.image = java.util.Objects.requireNonNull(builder.image, "image is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.command = builder.command;
                this.cpu = builder.cpu;
                this.credentialSpecs = builder.credentialSpecs;
                this.dependsOn = builder.dependsOn;
                this.disableNetworking = builder.disableNetworking;
                this.dnsSearchDomains = builder.dnsSearchDomains;
                this.dnsServers = builder.dnsServers;
                this.dockerLabels = builder.dockerLabels;
                this.dockerSecurityOptions = builder.dockerSecurityOptions;
                this.entryPoint = builder.entryPoint;
                this.environment = builder.environment;
                this.environmentFiles = builder.environmentFiles;
                this.essential = builder.essential;
                this.extraHosts = builder.extraHosts;
                this.firelensConfiguration = builder.firelensConfiguration;
                this.healthCheck = builder.healthCheck;
                this.hostname = builder.hostname;
                this.interactive = builder.interactive;
                this.links = builder.links;
                this.linuxParameters = builder.linuxParameters;
                this.logConfiguration = builder.logConfiguration;
                this.memory = builder.memory;
                this.memoryReservation = builder.memoryReservation;
                this.mountPoints = builder.mountPoints;
                this.portMappings = builder.portMappings;
                this.privileged = builder.privileged;
                this.pseudoTerminal = builder.pseudoTerminal;
                this.readonlyRootFilesystem = builder.readonlyRootFilesystem;
                this.repositoryCredentials = builder.repositoryCredentials;
                this.resourceRequirements = builder.resourceRequirements;
                this.restartPolicy = builder.restartPolicy;
                this.secrets = builder.secrets;
                this.startTimeout = builder.startTimeout;
                this.stopTimeout = builder.stopTimeout;
                this.systemControls = builder.systemControls;
                this.ulimits = builder.ulimits;
                this.user = builder.user;
                this.versionConsistency = builder.versionConsistency;
                this.volumesFrom = builder.volumesFrom;
                this.workingDirectory = builder.workingDirectory;
            }

            @Override
            public final java.lang.String getImage() {
                return this.image;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.util.List<java.lang.String> getCommand() {
                return this.command;
            }

            @Override
            public final java.lang.Number getCpu() {
                return this.cpu;
            }

            @Override
            public final java.util.List<java.lang.String> getCredentialSpecs() {
                return this.credentialSpecs;
            }

            @Override
            public final java.lang.Object getDependsOn() {
                return this.dependsOn;
            }

            @Override
            public final java.lang.Object getDisableNetworking() {
                return this.disableNetworking;
            }

            @Override
            public final java.util.List<java.lang.String> getDnsSearchDomains() {
                return this.dnsSearchDomains;
            }

            @Override
            public final java.util.List<java.lang.String> getDnsServers() {
                return this.dnsServers;
            }

            @Override
            public final java.lang.Object getDockerLabels() {
                return this.dockerLabels;
            }

            @Override
            public final java.util.List<java.lang.String> getDockerSecurityOptions() {
                return this.dockerSecurityOptions;
            }

            @Override
            public final java.util.List<java.lang.String> getEntryPoint() {
                return this.entryPoint;
            }

            @Override
            public final java.lang.Object getEnvironment() {
                return this.environment;
            }

            @Override
            public final java.lang.Object getEnvironmentFiles() {
                return this.environmentFiles;
            }

            @Override
            public final java.lang.Object getEssential() {
                return this.essential;
            }

            @Override
            public final java.lang.Object getExtraHosts() {
                return this.extraHosts;
            }

            @Override
            public final java.lang.Object getFirelensConfiguration() {
                return this.firelensConfiguration;
            }

            @Override
            public final java.lang.Object getHealthCheck() {
                return this.healthCheck;
            }

            @Override
            public final java.lang.String getHostname() {
                return this.hostname;
            }

            @Override
            public final java.lang.Object getInteractive() {
                return this.interactive;
            }

            @Override
            public final java.util.List<java.lang.String> getLinks() {
                return this.links;
            }

            @Override
            public final java.lang.Object getLinuxParameters() {
                return this.linuxParameters;
            }

            @Override
            public final java.lang.Object getLogConfiguration() {
                return this.logConfiguration;
            }

            @Override
            public final java.lang.Number getMemory() {
                return this.memory;
            }

            @Override
            public final java.lang.Number getMemoryReservation() {
                return this.memoryReservation;
            }

            @Override
            public final java.lang.Object getMountPoints() {
                return this.mountPoints;
            }

            @Override
            public final java.lang.Object getPortMappings() {
                return this.portMappings;
            }

            @Override
            public final java.lang.Object getPrivileged() {
                return this.privileged;
            }

            @Override
            public final java.lang.Object getPseudoTerminal() {
                return this.pseudoTerminal;
            }

            @Override
            public final java.lang.Object getReadonlyRootFilesystem() {
                return this.readonlyRootFilesystem;
            }

            @Override
            public final java.lang.Object getRepositoryCredentials() {
                return this.repositoryCredentials;
            }

            @Override
            public final java.lang.Object getResourceRequirements() {
                return this.resourceRequirements;
            }

            @Override
            public final java.lang.Object getRestartPolicy() {
                return this.restartPolicy;
            }

            @Override
            public final java.lang.Object getSecrets() {
                return this.secrets;
            }

            @Override
            public final java.lang.Number getStartTimeout() {
                return this.startTimeout;
            }

            @Override
            public final java.lang.Number getStopTimeout() {
                return this.stopTimeout;
            }

            @Override
            public final java.lang.Object getSystemControls() {
                return this.systemControls;
            }

            @Override
            public final java.lang.Object getUlimits() {
                return this.ulimits;
            }

            @Override
            public final java.lang.String getUser() {
                return this.user;
            }

            @Override
            public final java.lang.String getVersionConsistency() {
                return this.versionConsistency;
            }

            @Override
            public final java.lang.Object getVolumesFrom() {
                return this.volumesFrom;
            }

            @Override
            public final java.lang.String getWorkingDirectory() {
                return this.workingDirectory;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("image", om.valueToTree(this.getImage()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getCommand() != null) {
                    data.set("command", om.valueToTree(this.getCommand()));
                }
                if (this.getCpu() != null) {
                    data.set("cpu", om.valueToTree(this.getCpu()));
                }
                if (this.getCredentialSpecs() != null) {
                    data.set("credentialSpecs", om.valueToTree(this.getCredentialSpecs()));
                }
                if (this.getDependsOn() != null) {
                    data.set("dependsOn", om.valueToTree(this.getDependsOn()));
                }
                if (this.getDisableNetworking() != null) {
                    data.set("disableNetworking", om.valueToTree(this.getDisableNetworking()));
                }
                if (this.getDnsSearchDomains() != null) {
                    data.set("dnsSearchDomains", om.valueToTree(this.getDnsSearchDomains()));
                }
                if (this.getDnsServers() != null) {
                    data.set("dnsServers", om.valueToTree(this.getDnsServers()));
                }
                if (this.getDockerLabels() != null) {
                    data.set("dockerLabels", om.valueToTree(this.getDockerLabels()));
                }
                if (this.getDockerSecurityOptions() != null) {
                    data.set("dockerSecurityOptions", om.valueToTree(this.getDockerSecurityOptions()));
                }
                if (this.getEntryPoint() != null) {
                    data.set("entryPoint", om.valueToTree(this.getEntryPoint()));
                }
                if (this.getEnvironment() != null) {
                    data.set("environment", om.valueToTree(this.getEnvironment()));
                }
                if (this.getEnvironmentFiles() != null) {
                    data.set("environmentFiles", om.valueToTree(this.getEnvironmentFiles()));
                }
                if (this.getEssential() != null) {
                    data.set("essential", om.valueToTree(this.getEssential()));
                }
                if (this.getExtraHosts() != null) {
                    data.set("extraHosts", om.valueToTree(this.getExtraHosts()));
                }
                if (this.getFirelensConfiguration() != null) {
                    data.set("firelensConfiguration", om.valueToTree(this.getFirelensConfiguration()));
                }
                if (this.getHealthCheck() != null) {
                    data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
                }
                if (this.getHostname() != null) {
                    data.set("hostname", om.valueToTree(this.getHostname()));
                }
                if (this.getInteractive() != null) {
                    data.set("interactive", om.valueToTree(this.getInteractive()));
                }
                if (this.getLinks() != null) {
                    data.set("links", om.valueToTree(this.getLinks()));
                }
                if (this.getLinuxParameters() != null) {
                    data.set("linuxParameters", om.valueToTree(this.getLinuxParameters()));
                }
                if (this.getLogConfiguration() != null) {
                    data.set("logConfiguration", om.valueToTree(this.getLogConfiguration()));
                }
                if (this.getMemory() != null) {
                    data.set("memory", om.valueToTree(this.getMemory()));
                }
                if (this.getMemoryReservation() != null) {
                    data.set("memoryReservation", om.valueToTree(this.getMemoryReservation()));
                }
                if (this.getMountPoints() != null) {
                    data.set("mountPoints", om.valueToTree(this.getMountPoints()));
                }
                if (this.getPortMappings() != null) {
                    data.set("portMappings", om.valueToTree(this.getPortMappings()));
                }
                if (this.getPrivileged() != null) {
                    data.set("privileged", om.valueToTree(this.getPrivileged()));
                }
                if (this.getPseudoTerminal() != null) {
                    data.set("pseudoTerminal", om.valueToTree(this.getPseudoTerminal()));
                }
                if (this.getReadonlyRootFilesystem() != null) {
                    data.set("readonlyRootFilesystem", om.valueToTree(this.getReadonlyRootFilesystem()));
                }
                if (this.getRepositoryCredentials() != null) {
                    data.set("repositoryCredentials", om.valueToTree(this.getRepositoryCredentials()));
                }
                if (this.getResourceRequirements() != null) {
                    data.set("resourceRequirements", om.valueToTree(this.getResourceRequirements()));
                }
                if (this.getRestartPolicy() != null) {
                    data.set("restartPolicy", om.valueToTree(this.getRestartPolicy()));
                }
                if (this.getSecrets() != null) {
                    data.set("secrets", om.valueToTree(this.getSecrets()));
                }
                if (this.getStartTimeout() != null) {
                    data.set("startTimeout", om.valueToTree(this.getStartTimeout()));
                }
                if (this.getStopTimeout() != null) {
                    data.set("stopTimeout", om.valueToTree(this.getStopTimeout()));
                }
                if (this.getSystemControls() != null) {
                    data.set("systemControls", om.valueToTree(this.getSystemControls()));
                }
                if (this.getUlimits() != null) {
                    data.set("ulimits", om.valueToTree(this.getUlimits()));
                }
                if (this.getUser() != null) {
                    data.set("user", om.valueToTree(this.getUser()));
                }
                if (this.getVersionConsistency() != null) {
                    data.set("versionConsistency", om.valueToTree(this.getVersionConsistency()));
                }
                if (this.getVolumesFrom() != null) {
                    data.set("volumesFrom", om.valueToTree(this.getVolumesFrom()));
                }
                if (this.getWorkingDirectory() != null) {
                    data.set("workingDirectory", om.valueToTree(this.getWorkingDirectory()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.ContainerDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContainerDefinitionProperty.Jsii$Proxy that = (ContainerDefinitionProperty.Jsii$Proxy) o;

                if (!image.equals(that.image)) return false;
                if (!name.equals(that.name)) return false;
                if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
                if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) return false;
                if (this.credentialSpecs != null ? !this.credentialSpecs.equals(that.credentialSpecs) : that.credentialSpecs != null) return false;
                if (this.dependsOn != null ? !this.dependsOn.equals(that.dependsOn) : that.dependsOn != null) return false;
                if (this.disableNetworking != null ? !this.disableNetworking.equals(that.disableNetworking) : that.disableNetworking != null) return false;
                if (this.dnsSearchDomains != null ? !this.dnsSearchDomains.equals(that.dnsSearchDomains) : that.dnsSearchDomains != null) return false;
                if (this.dnsServers != null ? !this.dnsServers.equals(that.dnsServers) : that.dnsServers != null) return false;
                if (this.dockerLabels != null ? !this.dockerLabels.equals(that.dockerLabels) : that.dockerLabels != null) return false;
                if (this.dockerSecurityOptions != null ? !this.dockerSecurityOptions.equals(that.dockerSecurityOptions) : that.dockerSecurityOptions != null) return false;
                if (this.entryPoint != null ? !this.entryPoint.equals(that.entryPoint) : that.entryPoint != null) return false;
                if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
                if (this.environmentFiles != null ? !this.environmentFiles.equals(that.environmentFiles) : that.environmentFiles != null) return false;
                if (this.essential != null ? !this.essential.equals(that.essential) : that.essential != null) return false;
                if (this.extraHosts != null ? !this.extraHosts.equals(that.extraHosts) : that.extraHosts != null) return false;
                if (this.firelensConfiguration != null ? !this.firelensConfiguration.equals(that.firelensConfiguration) : that.firelensConfiguration != null) return false;
                if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
                if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) return false;
                if (this.interactive != null ? !this.interactive.equals(that.interactive) : that.interactive != null) return false;
                if (this.links != null ? !this.links.equals(that.links) : that.links != null) return false;
                if (this.linuxParameters != null ? !this.linuxParameters.equals(that.linuxParameters) : that.linuxParameters != null) return false;
                if (this.logConfiguration != null ? !this.logConfiguration.equals(that.logConfiguration) : that.logConfiguration != null) return false;
                if (this.memory != null ? !this.memory.equals(that.memory) : that.memory != null) return false;
                if (this.memoryReservation != null ? !this.memoryReservation.equals(that.memoryReservation) : that.memoryReservation != null) return false;
                if (this.mountPoints != null ? !this.mountPoints.equals(that.mountPoints) : that.mountPoints != null) return false;
                if (this.portMappings != null ? !this.portMappings.equals(that.portMappings) : that.portMappings != null) return false;
                if (this.privileged != null ? !this.privileged.equals(that.privileged) : that.privileged != null) return false;
                if (this.pseudoTerminal != null ? !this.pseudoTerminal.equals(that.pseudoTerminal) : that.pseudoTerminal != null) return false;
                if (this.readonlyRootFilesystem != null ? !this.readonlyRootFilesystem.equals(that.readonlyRootFilesystem) : that.readonlyRootFilesystem != null) return false;
                if (this.repositoryCredentials != null ? !this.repositoryCredentials.equals(that.repositoryCredentials) : that.repositoryCredentials != null) return false;
                if (this.resourceRequirements != null ? !this.resourceRequirements.equals(that.resourceRequirements) : that.resourceRequirements != null) return false;
                if (this.restartPolicy != null ? !this.restartPolicy.equals(that.restartPolicy) : that.restartPolicy != null) return false;
                if (this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null) return false;
                if (this.startTimeout != null ? !this.startTimeout.equals(that.startTimeout) : that.startTimeout != null) return false;
                if (this.stopTimeout != null ? !this.stopTimeout.equals(that.stopTimeout) : that.stopTimeout != null) return false;
                if (this.systemControls != null ? !this.systemControls.equals(that.systemControls) : that.systemControls != null) return false;
                if (this.ulimits != null ? !this.ulimits.equals(that.ulimits) : that.ulimits != null) return false;
                if (this.user != null ? !this.user.equals(that.user) : that.user != null) return false;
                if (this.versionConsistency != null ? !this.versionConsistency.equals(that.versionConsistency) : that.versionConsistency != null) return false;
                if (this.volumesFrom != null ? !this.volumesFrom.equals(that.volumesFrom) : that.volumesFrom != null) return false;
                return this.workingDirectory != null ? this.workingDirectory.equals(that.workingDirectory) : that.workingDirectory == null;
            }

            @Override
            public final int hashCode() {
                int result = this.image.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
                result = 31 * result + (this.cpu != null ? this.cpu.hashCode() : 0);
                result = 31 * result + (this.credentialSpecs != null ? this.credentialSpecs.hashCode() : 0);
                result = 31 * result + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
                result = 31 * result + (this.disableNetworking != null ? this.disableNetworking.hashCode() : 0);
                result = 31 * result + (this.dnsSearchDomains != null ? this.dnsSearchDomains.hashCode() : 0);
                result = 31 * result + (this.dnsServers != null ? this.dnsServers.hashCode() : 0);
                result = 31 * result + (this.dockerLabels != null ? this.dockerLabels.hashCode() : 0);
                result = 31 * result + (this.dockerSecurityOptions != null ? this.dockerSecurityOptions.hashCode() : 0);
                result = 31 * result + (this.entryPoint != null ? this.entryPoint.hashCode() : 0);
                result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
                result = 31 * result + (this.environmentFiles != null ? this.environmentFiles.hashCode() : 0);
                result = 31 * result + (this.essential != null ? this.essential.hashCode() : 0);
                result = 31 * result + (this.extraHosts != null ? this.extraHosts.hashCode() : 0);
                result = 31 * result + (this.firelensConfiguration != null ? this.firelensConfiguration.hashCode() : 0);
                result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
                result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
                result = 31 * result + (this.interactive != null ? this.interactive.hashCode() : 0);
                result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
                result = 31 * result + (this.linuxParameters != null ? this.linuxParameters.hashCode() : 0);
                result = 31 * result + (this.logConfiguration != null ? this.logConfiguration.hashCode() : 0);
                result = 31 * result + (this.memory != null ? this.memory.hashCode() : 0);
                result = 31 * result + (this.memoryReservation != null ? this.memoryReservation.hashCode() : 0);
                result = 31 * result + (this.mountPoints != null ? this.mountPoints.hashCode() : 0);
                result = 31 * result + (this.portMappings != null ? this.portMappings.hashCode() : 0);
                result = 31 * result + (this.privileged != null ? this.privileged.hashCode() : 0);
                result = 31 * result + (this.pseudoTerminal != null ? this.pseudoTerminal.hashCode() : 0);
                result = 31 * result + (this.readonlyRootFilesystem != null ? this.readonlyRootFilesystem.hashCode() : 0);
                result = 31 * result + (this.repositoryCredentials != null ? this.repositoryCredentials.hashCode() : 0);
                result = 31 * result + (this.resourceRequirements != null ? this.resourceRequirements.hashCode() : 0);
                result = 31 * result + (this.restartPolicy != null ? this.restartPolicy.hashCode() : 0);
                result = 31 * result + (this.secrets != null ? this.secrets.hashCode() : 0);
                result = 31 * result + (this.startTimeout != null ? this.startTimeout.hashCode() : 0);
                result = 31 * result + (this.stopTimeout != null ? this.stopTimeout.hashCode() : 0);
                result = 31 * result + (this.systemControls != null ? this.systemControls.hashCode() : 0);
                result = 31 * result + (this.ulimits != null ? this.ulimits.hashCode() : 0);
                result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
                result = 31 * result + (this.versionConsistency != null ? this.versionConsistency.hashCode() : 0);
                result = 31 * result + (this.volumesFrom != null ? this.volumesFrom.hashCode() : 0);
                result = 31 * result + (this.workingDirectory != null ? this.workingDirectory.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>ContainerDependency</code> property specifies the dependencies defined for container startup and shutdown.
     * <p>
     * A container can contain multiple dependencies. When a dependency is defined for container startup, for container shutdown it is reversed.
     * <p>
     * Your Amazon ECS container instances require at least version 1.26.0 of the container agent to enable container dependencies. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon ECS Container Agent</a> in the <em>Amazon Elastic Container Service Developer Guide</em> . If you are using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the <code>ecs-init</code> package. If your container instances are launched from version <code>20190301</code> or later, then they contain the required versions of the container agent and <code>ecs-init</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * For tasks using the Fargate launch type, this parameter requires that the task or service uses platform version 1.3.0 or later.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ContainerDependencyProperty containerDependencyProperty = ContainerDependencyProperty.builder()
     *         .condition("condition")
     *         .containerName("containerName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdependency.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdependency.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.ContainerDependencyProperty")
    @software.amazon.jsii.Jsii.Proxy(ContainerDependencyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContainerDependencyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The dependency condition of the container. The following are the available conditions and their behavior:.
         * <p>
         * <ul>
         * <li><code>START</code> - This condition emulates the behavior of links and volumes today. It validates that a dependent container is started before permitting other containers to start.</li>
         * <li><code>COMPLETE</code> - This condition validates that a dependent container runs to completion (exits) before permitting other containers to start. This can be useful for nonessential containers that run a script and then exit. This condition can't be set on an essential container.</li>
         * <li><code>SUCCESS</code> - This condition is the same as <code>COMPLETE</code> , but it also requires that the container exits with a <code>zero</code> status. This condition can't be set on an essential container.</li>
         * <li><code>HEALTHY</code> - This condition validates that the dependent container passes its Docker health check before permitting other containers to start. This requires that the dependent container has health checks configured. This condition is confirmed only at task startup.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdependency.html#cfn-ecs-taskdefinition-containerdependency-condition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdependency.html#cfn-ecs-taskdefinition-containerdependency-condition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCondition() {
            return null;
        }

        /**
         * The name of a container.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdependency.html#cfn-ecs-taskdefinition-containerdependency-containername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdependency.html#cfn-ecs-taskdefinition-containerdependency-containername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainerName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ContainerDependencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContainerDependencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContainerDependencyProperty> {
            java.lang.String condition;
            java.lang.String containerName;

            /**
             * Sets the value of {@link ContainerDependencyProperty#getCondition}
             * @param condition The dependency condition of the container. The following are the available conditions and their behavior:.
             *                  <ul>
             *                  <li><code>START</code> - This condition emulates the behavior of links and volumes today. It validates that a dependent container is started before permitting other containers to start.</li>
             *                  <li><code>COMPLETE</code> - This condition validates that a dependent container runs to completion (exits) before permitting other containers to start. This can be useful for nonessential containers that run a script and then exit. This condition can't be set on an essential container.</li>
             *                  <li><code>SUCCESS</code> - This condition is the same as <code>COMPLETE</code> , but it also requires that the container exits with a <code>zero</code> status. This condition can't be set on an essential container.</li>
             *                  <li><code>HEALTHY</code> - This condition validates that the dependent container passes its Docker health check before permitting other containers to start. This requires that the dependent container has health checks configured. This condition is confirmed only at task startup.</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(java.lang.String condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDependencyProperty#getContainerName}
             * @param containerName The name of a container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerName(java.lang.String containerName) {
                this.containerName = containerName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerDependencyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContainerDependencyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContainerDependencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerDependencyProperty {
            private final java.lang.String condition;
            private final java.lang.String containerName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.containerName = software.amazon.jsii.Kernel.get(this, "containerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.condition = builder.condition;
                this.containerName = builder.containerName;
            }

            @Override
            public final java.lang.String getCondition() {
                return this.condition;
            }

            @Override
            public final java.lang.String getContainerName() {
                return this.containerName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCondition() != null) {
                    data.set("condition", om.valueToTree(this.getCondition()));
                }
                if (this.getContainerName() != null) {
                    data.set("containerName", om.valueToTree(this.getContainerName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.ContainerDependencyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContainerDependencyProperty.Jsii$Proxy that = (ContainerDependencyProperty.Jsii$Proxy) o;

                if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) return false;
                return this.containerName != null ? this.containerName.equals(that.containerName) : that.containerName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.condition != null ? this.condition.hashCode() : 0;
                result = 31 * result + (this.containerName != null ? this.containerName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>Device</code> property specifies an object representing a container instance host device.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * DeviceProperty deviceProperty = DeviceProperty.builder()
     *         .containerPath("containerPath")
     *         .hostPath("hostPath")
     *         .permissions(List.of("permissions"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-device.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-device.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.DeviceProperty")
    @software.amazon.jsii.Jsii.Proxy(DeviceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeviceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The path inside the container at which to expose the host device.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-device.html#cfn-ecs-taskdefinition-device-containerpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-device.html#cfn-ecs-taskdefinition-device-containerpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainerPath() {
            return null;
        }

        /**
         * The path for the device on the host container instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-device.html#cfn-ecs-taskdefinition-device-hostpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-device.html#cfn-ecs-taskdefinition-device-hostpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostPath() {
            return null;
        }

        /**
         * The explicit permissions to provide to the container for the device.
         * <p>
         * By default, the container has permissions for <code>read</code> , <code>write</code> , and <code>mknod</code> for the device.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-device.html#cfn-ecs-taskdefinition-device-permissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-device.html#cfn-ecs-taskdefinition-device-permissions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPermissions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeviceProperty> {
            java.lang.String containerPath;
            java.lang.String hostPath;
            java.util.List<java.lang.String> permissions;

            /**
             * Sets the value of {@link DeviceProperty#getContainerPath}
             * @param containerPath The path inside the container at which to expose the host device.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPath(java.lang.String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            /**
             * Sets the value of {@link DeviceProperty#getHostPath}
             * @param hostPath The path for the device on the host container instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostPath(java.lang.String hostPath) {
                this.hostPath = hostPath;
                return this;
            }

            /**
             * Sets the value of {@link DeviceProperty#getPermissions}
             * @param permissions The explicit permissions to provide to the container for the device.
             *                    By default, the container has permissions for <code>read</code> , <code>write</code> , and <code>mknod</code> for the device.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder permissions(java.util.List<java.lang.String> permissions) {
                this.permissions = permissions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeviceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeviceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeviceProperty {
            private final java.lang.String containerPath;
            private final java.lang.String hostPath;
            private final java.util.List<java.lang.String> permissions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerPath = software.amazon.jsii.Kernel.get(this, "containerPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostPath = software.amazon.jsii.Kernel.get(this, "hostPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.permissions = software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerPath = builder.containerPath;
                this.hostPath = builder.hostPath;
                this.permissions = builder.permissions;
            }

            @Override
            public final java.lang.String getContainerPath() {
                return this.containerPath;
            }

            @Override
            public final java.lang.String getHostPath() {
                return this.hostPath;
            }

            @Override
            public final java.util.List<java.lang.String> getPermissions() {
                return this.permissions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerPath() != null) {
                    data.set("containerPath", om.valueToTree(this.getContainerPath()));
                }
                if (this.getHostPath() != null) {
                    data.set("hostPath", om.valueToTree(this.getHostPath()));
                }
                if (this.getPermissions() != null) {
                    data.set("permissions", om.valueToTree(this.getPermissions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.DeviceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeviceProperty.Jsii$Proxy that = (DeviceProperty.Jsii$Proxy) o;

                if (this.containerPath != null ? !this.containerPath.equals(that.containerPath) : that.containerPath != null) return false;
                if (this.hostPath != null ? !this.hostPath.equals(that.hostPath) : that.hostPath != null) return false;
                return this.permissions != null ? this.permissions.equals(that.permissions) : that.permissions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerPath != null ? this.containerPath.hashCode() : 0;
                result = 31 * result + (this.hostPath != null ? this.hostPath.hashCode() : 0);
                result = 31 * result + (this.permissions != null ? this.permissions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>DockerVolumeConfiguration</code> property specifies a Docker volume configuration and is used when you use Docker volumes.
     * <p>
     * Docker volumes are only supported when you are using the EC2 launch type. Windows containers only support the use of the <code>local</code> driver. To use bind mounts, specify a <code>host</code> instead.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * DockerVolumeConfigurationProperty dockerVolumeConfigurationProperty = DockerVolumeConfigurationProperty.builder()
     *         .autoprovision(false)
     *         .driver("driver")
     *         .driverOpts(Map.of(
     *                 "driverOptsKey", "driverOpts"))
     *         .labels(Map.of(
     *                 "labelsKey", "labels"))
     *         .scope("scope")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-dockervolumeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-dockervolumeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.DockerVolumeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DockerVolumeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DockerVolumeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If this value is <code>true</code> , the Docker volume is created if it doesn't already exist.
         * <p>
         * <blockquote>
         * <p>
         * This field is only used if the <code>scope</code> is <code>shared</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-dockervolumeconfiguration.html#cfn-ecs-taskdefinition-dockervolumeconfiguration-autoprovision">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-dockervolumeconfiguration.html#cfn-ecs-taskdefinition-dockervolumeconfiguration-autoprovision</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoprovision() {
            return null;
        }

        /**
         * The Docker volume driver to use.
         * <p>
         * The driver value must match the driver name provided by Docker because it is used for task placement. If the driver was installed using the Docker plugin CLI, use <code>docker plugin ls</code> to retrieve the driver name from your container instance. If the driver was installed using another method, use Docker plugin discovery to retrieve the driver name. This parameter maps to <code>Driver</code> in the docker container create command and the <code>xxdriver</code> option to docker volume create.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-dockervolumeconfiguration.html#cfn-ecs-taskdefinition-dockervolumeconfiguration-driver">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-dockervolumeconfiguration.html#cfn-ecs-taskdefinition-dockervolumeconfiguration-driver</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDriver() {
            return null;
        }

        /**
         * A map of Docker driver-specific options passed through.
         * <p>
         * This parameter maps to <code>DriverOpts</code> in the docker create-volume command and the <code>xxopt</code> option to docker volume create.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-dockervolumeconfiguration.html#cfn-ecs-taskdefinition-dockervolumeconfiguration-driveropts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-dockervolumeconfiguration.html#cfn-ecs-taskdefinition-dockervolumeconfiguration-driveropts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDriverOpts() {
            return null;
        }

        /**
         * Custom metadata to add to your Docker volume.
         * <p>
         * This parameter maps to <code>Labels</code> in the docker container create command and the <code>xxlabel</code> option to docker volume create.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-dockervolumeconfiguration.html#cfn-ecs-taskdefinition-dockervolumeconfiguration-labels">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-dockervolumeconfiguration.html#cfn-ecs-taskdefinition-dockervolumeconfiguration-labels</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLabels() {
            return null;
        }

        /**
         * The scope for the Docker volume that determines its lifecycle.
         * <p>
         * Docker volumes that are scoped to a <code>task</code> are automatically provisioned when the task starts and destroyed when the task stops. Docker volumes that are scoped as <code>shared</code> persist after the task stops.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-dockervolumeconfiguration.html#cfn-ecs-taskdefinition-dockervolumeconfiguration-scope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-dockervolumeconfiguration.html#cfn-ecs-taskdefinition-dockervolumeconfiguration-scope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScope() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DockerVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DockerVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DockerVolumeConfigurationProperty> {
            java.lang.Object autoprovision;
            java.lang.String driver;
            java.lang.Object driverOpts;
            java.lang.Object labels;
            java.lang.String scope;

            /**
             * Sets the value of {@link DockerVolumeConfigurationProperty#getAutoprovision}
             * @param autoprovision If this value is <code>true</code> , the Docker volume is created if it doesn't already exist.
             *                      <blockquote>
             *                      <p>
             *                      This field is only used if the <code>scope</code> is <code>shared</code> .
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoprovision(java.lang.Boolean autoprovision) {
                this.autoprovision = autoprovision;
                return this;
            }

            /**
             * Sets the value of {@link DockerVolumeConfigurationProperty#getAutoprovision}
             * @param autoprovision If this value is <code>true</code> , the Docker volume is created if it doesn't already exist.
             *                      <blockquote>
             *                      <p>
             *                      This field is only used if the <code>scope</code> is <code>shared</code> .
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoprovision(software.amazon.awscdk.IResolvable autoprovision) {
                this.autoprovision = autoprovision;
                return this;
            }

            /**
             * Sets the value of {@link DockerVolumeConfigurationProperty#getDriver}
             * @param driver The Docker volume driver to use.
             *               The driver value must match the driver name provided by Docker because it is used for task placement. If the driver was installed using the Docker plugin CLI, use <code>docker plugin ls</code> to retrieve the driver name from your container instance. If the driver was installed using another method, use Docker plugin discovery to retrieve the driver name. This parameter maps to <code>Driver</code> in the docker container create command and the <code>xxdriver</code> option to docker volume create.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder driver(java.lang.String driver) {
                this.driver = driver;
                return this;
            }

            /**
             * Sets the value of {@link DockerVolumeConfigurationProperty#getDriverOpts}
             * @param driverOpts A map of Docker driver-specific options passed through.
             *                   This parameter maps to <code>DriverOpts</code> in the docker create-volume command and the <code>xxopt</code> option to docker volume create.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder driverOpts(java.util.Map<java.lang.String, java.lang.String> driverOpts) {
                this.driverOpts = driverOpts;
                return this;
            }

            /**
             * Sets the value of {@link DockerVolumeConfigurationProperty#getDriverOpts}
             * @param driverOpts A map of Docker driver-specific options passed through.
             *                   This parameter maps to <code>DriverOpts</code> in the docker create-volume command and the <code>xxopt</code> option to docker volume create.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder driverOpts(software.amazon.awscdk.IResolvable driverOpts) {
                this.driverOpts = driverOpts;
                return this;
            }

            /**
             * Sets the value of {@link DockerVolumeConfigurationProperty#getLabels}
             * @param labels Custom metadata to add to your Docker volume.
             *               This parameter maps to <code>Labels</code> in the docker container create command and the <code>xxlabel</code> option to docker volume create.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder labels(java.util.Map<java.lang.String, java.lang.String> labels) {
                this.labels = labels;
                return this;
            }

            /**
             * Sets the value of {@link DockerVolumeConfigurationProperty#getLabels}
             * @param labels Custom metadata to add to your Docker volume.
             *               This parameter maps to <code>Labels</code> in the docker container create command and the <code>xxlabel</code> option to docker volume create.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder labels(software.amazon.awscdk.IResolvable labels) {
                this.labels = labels;
                return this;
            }

            /**
             * Sets the value of {@link DockerVolumeConfigurationProperty#getScope}
             * @param scope The scope for the Docker volume that determines its lifecycle.
             *              Docker volumes that are scoped to a <code>task</code> are automatically provisioned when the task starts and destroyed when the task stops. Docker volumes that are scoped as <code>shared</code> persist after the task stops.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scope(java.lang.String scope) {
                this.scope = scope;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DockerVolumeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DockerVolumeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DockerVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DockerVolumeConfigurationProperty {
            private final java.lang.Object autoprovision;
            private final java.lang.String driver;
            private final java.lang.Object driverOpts;
            private final java.lang.Object labels;
            private final java.lang.String scope;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoprovision = software.amazon.jsii.Kernel.get(this, "autoprovision", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.driver = software.amazon.jsii.Kernel.get(this, "driver", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.driverOpts = software.amazon.jsii.Kernel.get(this, "driverOpts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.labels = software.amazon.jsii.Kernel.get(this, "labels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoprovision = builder.autoprovision;
                this.driver = builder.driver;
                this.driverOpts = builder.driverOpts;
                this.labels = builder.labels;
                this.scope = builder.scope;
            }

            @Override
            public final java.lang.Object getAutoprovision() {
                return this.autoprovision;
            }

            @Override
            public final java.lang.String getDriver() {
                return this.driver;
            }

            @Override
            public final java.lang.Object getDriverOpts() {
                return this.driverOpts;
            }

            @Override
            public final java.lang.Object getLabels() {
                return this.labels;
            }

            @Override
            public final java.lang.String getScope() {
                return this.scope;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutoprovision() != null) {
                    data.set("autoprovision", om.valueToTree(this.getAutoprovision()));
                }
                if (this.getDriver() != null) {
                    data.set("driver", om.valueToTree(this.getDriver()));
                }
                if (this.getDriverOpts() != null) {
                    data.set("driverOpts", om.valueToTree(this.getDriverOpts()));
                }
                if (this.getLabels() != null) {
                    data.set("labels", om.valueToTree(this.getLabels()));
                }
                if (this.getScope() != null) {
                    data.set("scope", om.valueToTree(this.getScope()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.DockerVolumeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DockerVolumeConfigurationProperty.Jsii$Proxy that = (DockerVolumeConfigurationProperty.Jsii$Proxy) o;

                if (this.autoprovision != null ? !this.autoprovision.equals(that.autoprovision) : that.autoprovision != null) return false;
                if (this.driver != null ? !this.driver.equals(that.driver) : that.driver != null) return false;
                if (this.driverOpts != null ? !this.driverOpts.equals(that.driverOpts) : that.driverOpts != null) return false;
                if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) return false;
                return this.scope != null ? this.scope.equals(that.scope) : that.scope == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoprovision != null ? this.autoprovision.hashCode() : 0;
                result = 31 * result + (this.driver != null ? this.driver.hashCode() : 0);
                result = 31 * result + (this.driverOpts != null ? this.driverOpts.hashCode() : 0);
                result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
                result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This parameter is specified when you're using an Amazon Elastic File System file system for task storage.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html">Amazon EFS volumes</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * EFSVolumeConfigurationProperty eFSVolumeConfigurationProperty = EFSVolumeConfigurationProperty.builder()
     *         .filesystemId("filesystemId")
     *         // the properties below are optional
     *         .authorizationConfig(AuthorizationConfigProperty.builder()
     *                 .accessPointId("accessPointId")
     *                 .iam("iam")
     *                 .build())
     *         .rootDirectory("rootDirectory")
     *         .transitEncryption("transitEncryption")
     *         .transitEncryptionPort(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-efsvolumeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-efsvolumeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.EFSVolumeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EFSVolumeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EFSVolumeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon EFS file system ID to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-efsvolumeconfiguration.html#cfn-ecs-taskdefinition-efsvolumeconfiguration-filesystemid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-efsvolumeconfiguration.html#cfn-ecs-taskdefinition-efsvolumeconfiguration-filesystemid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFilesystemId();

        /**
         * The authorization configuration details for the Amazon EFS file system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-efsvolumeconfiguration.html#cfn-ecs-taskdefinition-efsvolumeconfiguration-authorizationconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-efsvolumeconfiguration.html#cfn-ecs-taskdefinition-efsvolumeconfiguration-authorizationconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthorizationConfig() {
            return null;
        }

        /**
         * The directory within the Amazon EFS file system to mount as the root directory inside the host.
         * <p>
         * If this parameter is omitted, the root of the Amazon EFS volume will be used. Specifying <code>/</code> will have the same effect as omitting this parameter.
         * <p>
         * <blockquote>
         * <p>
         * If an EFS access point is specified in the <code>authorizationConfig</code> , the root directory parameter must either be omitted or set to <code>/</code> which will enforce the path set on the EFS access point.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-efsvolumeconfiguration.html#cfn-ecs-taskdefinition-efsvolumeconfiguration-rootdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-efsvolumeconfiguration.html#cfn-ecs-taskdefinition-efsvolumeconfiguration-rootdirectory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRootDirectory() {
            return null;
        }

        /**
         * Determines whether to use encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server.
         * <p>
         * Transit encryption must be turned on if Amazon EFS IAM authorization is used. If this parameter is omitted, the default value of <code>DISABLED</code> is used. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html">Encrypting data in transit</a> in the <em>Amazon Elastic File System User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-efsvolumeconfiguration.html#cfn-ecs-taskdefinition-efsvolumeconfiguration-transitencryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-efsvolumeconfiguration.html#cfn-ecs-taskdefinition-efsvolumeconfiguration-transitencryption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTransitEncryption() {
            return null;
        }

        /**
         * The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server.
         * <p>
         * If you do not specify a transit encryption port, it will use the port selection strategy that the Amazon EFS mount helper uses. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html">EFS mount helper</a> in the <em>Amazon Elastic File System User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-efsvolumeconfiguration.html#cfn-ecs-taskdefinition-efsvolumeconfiguration-transitencryptionport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-efsvolumeconfiguration.html#cfn-ecs-taskdefinition-efsvolumeconfiguration-transitencryptionport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTransitEncryptionPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EFSVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EFSVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EFSVolumeConfigurationProperty> {
            java.lang.String filesystemId;
            java.lang.Object authorizationConfig;
            java.lang.String rootDirectory;
            java.lang.String transitEncryption;
            java.lang.Number transitEncryptionPort;

            /**
             * Sets the value of {@link EFSVolumeConfigurationProperty#getFilesystemId}
             * @param filesystemId The Amazon EFS file system ID to use. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filesystemId(java.lang.String filesystemId) {
                this.filesystemId = filesystemId;
                return this;
            }

            /**
             * Sets the value of {@link EFSVolumeConfigurationProperty#getAuthorizationConfig}
             * @param authorizationConfig The authorization configuration details for the Amazon EFS file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationConfig(software.amazon.awscdk.IResolvable authorizationConfig) {
                this.authorizationConfig = authorizationConfig;
                return this;
            }

            /**
             * Sets the value of {@link EFSVolumeConfigurationProperty#getAuthorizationConfig}
             * @param authorizationConfig The authorization configuration details for the Amazon EFS file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationConfig(software.amazon.awscdk.services.ecs.CfnTaskDefinition.AuthorizationConfigProperty authorizationConfig) {
                this.authorizationConfig = authorizationConfig;
                return this;
            }

            /**
             * Sets the value of {@link EFSVolumeConfigurationProperty#getRootDirectory}
             * @param rootDirectory The directory within the Amazon EFS file system to mount as the root directory inside the host.
             *                      If this parameter is omitted, the root of the Amazon EFS volume will be used. Specifying <code>/</code> will have the same effect as omitting this parameter.
             *                      <p>
             *                      <blockquote>
             *                      <p>
             *                      If an EFS access point is specified in the <code>authorizationConfig</code> , the root directory parameter must either be omitted or set to <code>/</code> which will enforce the path set on the EFS access point.
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rootDirectory(java.lang.String rootDirectory) {
                this.rootDirectory = rootDirectory;
                return this;
            }

            /**
             * Sets the value of {@link EFSVolumeConfigurationProperty#getTransitEncryption}
             * @param transitEncryption Determines whether to use encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server.
             *                          Transit encryption must be turned on if Amazon EFS IAM authorization is used. If this parameter is omitted, the default value of <code>DISABLED</code> is used. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html">Encrypting data in transit</a> in the <em>Amazon Elastic File System User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitEncryption(java.lang.String transitEncryption) {
                this.transitEncryption = transitEncryption;
                return this;
            }

            /**
             * Sets the value of {@link EFSVolumeConfigurationProperty#getTransitEncryptionPort}
             * @param transitEncryptionPort The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server.
             *                              If you do not specify a transit encryption port, it will use the port selection strategy that the Amazon EFS mount helper uses. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html">EFS mount helper</a> in the <em>Amazon Elastic File System User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitEncryptionPort(java.lang.Number transitEncryptionPort) {
                this.transitEncryptionPort = transitEncryptionPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EFSVolumeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EFSVolumeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EFSVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EFSVolumeConfigurationProperty {
            private final java.lang.String filesystemId;
            private final java.lang.Object authorizationConfig;
            private final java.lang.String rootDirectory;
            private final java.lang.String transitEncryption;
            private final java.lang.Number transitEncryptionPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.filesystemId = software.amazon.jsii.Kernel.get(this, "filesystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authorizationConfig = software.amazon.jsii.Kernel.get(this, "authorizationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rootDirectory = software.amazon.jsii.Kernel.get(this, "rootDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.transitEncryption = software.amazon.jsii.Kernel.get(this, "transitEncryption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.transitEncryptionPort = software.amazon.jsii.Kernel.get(this, "transitEncryptionPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.filesystemId = java.util.Objects.requireNonNull(builder.filesystemId, "filesystemId is required");
                this.authorizationConfig = builder.authorizationConfig;
                this.rootDirectory = builder.rootDirectory;
                this.transitEncryption = builder.transitEncryption;
                this.transitEncryptionPort = builder.transitEncryptionPort;
            }

            @Override
            public final java.lang.String getFilesystemId() {
                return this.filesystemId;
            }

            @Override
            public final java.lang.Object getAuthorizationConfig() {
                return this.authorizationConfig;
            }

            @Override
            public final java.lang.String getRootDirectory() {
                return this.rootDirectory;
            }

            @Override
            public final java.lang.String getTransitEncryption() {
                return this.transitEncryption;
            }

            @Override
            public final java.lang.Number getTransitEncryptionPort() {
                return this.transitEncryptionPort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("filesystemId", om.valueToTree(this.getFilesystemId()));
                if (this.getAuthorizationConfig() != null) {
                    data.set("authorizationConfig", om.valueToTree(this.getAuthorizationConfig()));
                }
                if (this.getRootDirectory() != null) {
                    data.set("rootDirectory", om.valueToTree(this.getRootDirectory()));
                }
                if (this.getTransitEncryption() != null) {
                    data.set("transitEncryption", om.valueToTree(this.getTransitEncryption()));
                }
                if (this.getTransitEncryptionPort() != null) {
                    data.set("transitEncryptionPort", om.valueToTree(this.getTransitEncryptionPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.EFSVolumeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EFSVolumeConfigurationProperty.Jsii$Proxy that = (EFSVolumeConfigurationProperty.Jsii$Proxy) o;

                if (!filesystemId.equals(that.filesystemId)) return false;
                if (this.authorizationConfig != null ? !this.authorizationConfig.equals(that.authorizationConfig) : that.authorizationConfig != null) return false;
                if (this.rootDirectory != null ? !this.rootDirectory.equals(that.rootDirectory) : that.rootDirectory != null) return false;
                if (this.transitEncryption != null ? !this.transitEncryption.equals(that.transitEncryption) : that.transitEncryption != null) return false;
                return this.transitEncryptionPort != null ? this.transitEncryptionPort.equals(that.transitEncryptionPort) : that.transitEncryptionPort == null;
            }

            @Override
            public final int hashCode() {
                int result = this.filesystemId.hashCode();
                result = 31 * result + (this.authorizationConfig != null ? this.authorizationConfig.hashCode() : 0);
                result = 31 * result + (this.rootDirectory != null ? this.rootDirectory.hashCode() : 0);
                result = 31 * result + (this.transitEncryption != null ? this.transitEncryption.hashCode() : 0);
                result = 31 * result + (this.transitEncryptionPort != null ? this.transitEncryptionPort.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A list of files containing the environment variables to pass to a container.
     * <p>
     * You can specify up to ten environment files. The file must have a <code>.env</code> file extension. Each line in an environment file should contain an environment variable in <code>VARIABLE=VALUE</code> format. Lines beginning with <code>#</code> are treated as comments and are ignored.
     * <p>
     * If there are environment variables specified using the <code>environment</code> parameter in a container definition, they take precedence over the variables contained within an environment file. If multiple environment files are specified that contain the same variable, they're processed from the top down. We recommend that you use unique variable names. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/use-environment-file.html">Use a file to pass environment variables to a container</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Environment variable files are objects in Amazon S3 and all Amazon S3 security considerations apply.
     * <p>
     * You must use the following platforms for the Fargate launch type:
     * <p>
     * <ul>
     * <li>Linux platform version <code>1.4.0</code> or later.</li>
     * <li>Windows platform version <code>1.0.0</code> or later.</li>
     * </ul>
     * <p>
     * Consider the following when using the Fargate launch type:
     * <p>
     * <ul>
     * <li>The file is handled like a native Docker env-file.</li>
     * <li>There is no support for shell escape handling.</li>
     * <li>The container entry point interperts the <code>VARIABLE</code> values.</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * EnvironmentFileProperty environmentFileProperty = EnvironmentFileProperty.builder()
     *         .type("type")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-environmentfile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-environmentfile.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.EnvironmentFileProperty")
    @software.amazon.jsii.Jsii.Proxy(EnvironmentFileProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnvironmentFileProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The file type to use.
         * <p>
         * Environment files are objects in Amazon S3. The only supported value is <code>s3</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-environmentfile.html#cfn-ecs-taskdefinition-environmentfile-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-environmentfile.html#cfn-ecs-taskdefinition-environmentfile-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the Amazon S3 object containing the environment variable file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-environmentfile.html#cfn-ecs-taskdefinition-environmentfile-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-environmentfile.html#cfn-ecs-taskdefinition-environmentfile-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EnvironmentFileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnvironmentFileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnvironmentFileProperty> {
            java.lang.String type;
            java.lang.String value;

            /**
             * Sets the value of {@link EnvironmentFileProperty#getType}
             * @param type The file type to use.
             *             Environment files are objects in Amazon S3. The only supported value is <code>s3</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentFileProperty#getValue}
             * @param value The Amazon Resource Name (ARN) of the Amazon S3 object containing the environment variable file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnvironmentFileProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnvironmentFileProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EnvironmentFileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnvironmentFileProperty {
            private final java.lang.String type;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = builder.type;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.EnvironmentFileProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnvironmentFileProperty.Jsii$Proxy that = (EnvironmentFileProperty.Jsii$Proxy) o;

                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type != null ? this.type.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The amount of ephemeral storage to allocate for the task.
     * <p>
     * This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html">Using data volumes in tasks</a> in the <em>Amazon ECS Developer Guide;</em> .
     * <p>
     * <blockquote>
     * <p>
     * For tasks using the Fargate launch type, the task requires the following platforms:
     * <p>
     * <ul>
     * <li>Linux platform version <code>1.4.0</code> or later.</li>
     * <li>Windows platform version <code>1.0.0</code> or later.</li>
     * </ul>
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * EphemeralStorageProperty ephemeralStorageProperty = EphemeralStorageProperty.builder()
     *         .sizeInGiB(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-ephemeralstorage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-ephemeralstorage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.EphemeralStorageProperty")
    @software.amazon.jsii.Jsii.Proxy(EphemeralStorageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EphemeralStorageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The total amount, in GiB, of ephemeral storage to set for the task.
         * <p>
         * The minimum supported value is <code>21</code> GiB and the maximum supported value is <code>200</code> GiB.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-ephemeralstorage.html#cfn-ecs-taskdefinition-ephemeralstorage-sizeingib">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-ephemeralstorage.html#cfn-ecs-taskdefinition-ephemeralstorage-sizeingib</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSizeInGiB() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EphemeralStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EphemeralStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EphemeralStorageProperty> {
            java.lang.Number sizeInGiB;

            /**
             * Sets the value of {@link EphemeralStorageProperty#getSizeInGiB}
             * @param sizeInGiB The total amount, in GiB, of ephemeral storage to set for the task.
             *                  The minimum supported value is <code>21</code> GiB and the maximum supported value is <code>200</code> GiB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeInGiB(java.lang.Number sizeInGiB) {
                this.sizeInGiB = sizeInGiB;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EphemeralStorageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EphemeralStorageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EphemeralStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EphemeralStorageProperty {
            private final java.lang.Number sizeInGiB;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sizeInGiB = software.amazon.jsii.Kernel.get(this, "sizeInGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sizeInGiB = builder.sizeInGiB;
            }

            @Override
            public final java.lang.Number getSizeInGiB() {
                return this.sizeInGiB;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSizeInGiB() != null) {
                    data.set("sizeInGiB", om.valueToTree(this.getSizeInGiB()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.EphemeralStorageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EphemeralStorageProperty.Jsii$Proxy that = (EphemeralStorageProperty.Jsii$Proxy) o;

                return this.sizeInGiB != null ? this.sizeInGiB.equals(that.sizeInGiB) : that.sizeInGiB == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sizeInGiB != null ? this.sizeInGiB.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The authorization configuration details for Amazon FSx for Windows File Server file system.
     * <p>
     * See <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_FSxWindowsFileServerVolumeConfiguration.html">FSxWindowsFileServerVolumeConfiguration</a> in the <em>Amazon ECS API Reference</em> .
     * <p>
     * For more information and the input format, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/wfsx-volumes.html">Amazon FSx for Windows File Server Volumes</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * FSxAuthorizationConfigProperty fSxAuthorizationConfigProperty = FSxAuthorizationConfigProperty.builder()
     *         .credentialsParameter("credentialsParameter")
     *         .domain("domain")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-fsxauthorizationconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-fsxauthorizationconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.FSxAuthorizationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(FSxAuthorizationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FSxAuthorizationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The authorization credential option to use.
         * <p>
         * The authorization credential options can be provided using either the Amazon Resource Name (ARN) of an AWS Secrets Manager secret or SSM Parameter Store parameter. The ARN refers to the stored credentials.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-fsxauthorizationconfig.html#cfn-ecs-taskdefinition-fsxauthorizationconfig-credentialsparameter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-fsxauthorizationconfig.html#cfn-ecs-taskdefinition-fsxauthorizationconfig-credentialsparameter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCredentialsParameter();

        /**
         * A fully qualified domain name hosted by an <a href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html">AWS Directory Service</a> Managed Microsoft AD (Active Directory) or self-hosted AD on Amazon EC2.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-fsxauthorizationconfig.html#cfn-ecs-taskdefinition-fsxauthorizationconfig-domain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-fsxauthorizationconfig.html#cfn-ecs-taskdefinition-fsxauthorizationconfig-domain</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDomain();

        /**
         * @return a {@link Builder} of {@link FSxAuthorizationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FSxAuthorizationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FSxAuthorizationConfigProperty> {
            java.lang.String credentialsParameter;
            java.lang.String domain;

            /**
             * Sets the value of {@link FSxAuthorizationConfigProperty#getCredentialsParameter}
             * @param credentialsParameter The authorization credential option to use. This parameter is required.
             *                             The authorization credential options can be provided using either the Amazon Resource Name (ARN) of an AWS Secrets Manager secret or SSM Parameter Store parameter. The ARN refers to the stored credentials.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialsParameter(java.lang.String credentialsParameter) {
                this.credentialsParameter = credentialsParameter;
                return this;
            }

            /**
             * Sets the value of {@link FSxAuthorizationConfigProperty#getDomain}
             * @param domain A fully qualified domain name hosted by an <a href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html">AWS Directory Service</a> Managed Microsoft AD (Active Directory) or self-hosted AD on Amazon EC2. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domain(java.lang.String domain) {
                this.domain = domain;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FSxAuthorizationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FSxAuthorizationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FSxAuthorizationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FSxAuthorizationConfigProperty {
            private final java.lang.String credentialsParameter;
            private final java.lang.String domain;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.credentialsParameter = software.amazon.jsii.Kernel.get(this, "credentialsParameter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.credentialsParameter = java.util.Objects.requireNonNull(builder.credentialsParameter, "credentialsParameter is required");
                this.domain = java.util.Objects.requireNonNull(builder.domain, "domain is required");
            }

            @Override
            public final java.lang.String getCredentialsParameter() {
                return this.credentialsParameter;
            }

            @Override
            public final java.lang.String getDomain() {
                return this.domain;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("credentialsParameter", om.valueToTree(this.getCredentialsParameter()));
                data.set("domain", om.valueToTree(this.getDomain()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.FSxAuthorizationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FSxAuthorizationConfigProperty.Jsii$Proxy that = (FSxAuthorizationConfigProperty.Jsii$Proxy) o;

                if (!credentialsParameter.equals(that.credentialsParameter)) return false;
                return this.domain.equals(that.domain);
            }

            @Override
            public final int hashCode() {
                int result = this.credentialsParameter.hashCode();
                result = 31 * result + (this.domain.hashCode());
                return result;
            }
        }
    }
    /**
     * This parameter is specified when you're using <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/what-is.html">Amazon FSx for Windows File Server</a> file system for task storage.
     * <p>
     * For more information and the input format, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/wfsx-volumes.html">Amazon FSx for Windows File Server volumes</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * FSxWindowsFileServerVolumeConfigurationProperty fSxWindowsFileServerVolumeConfigurationProperty = FSxWindowsFileServerVolumeConfigurationProperty.builder()
     *         .fileSystemId("fileSystemId")
     *         .rootDirectory("rootDirectory")
     *         // the properties below are optional
     *         .authorizationConfig(FSxAuthorizationConfigProperty.builder()
     *                 .credentialsParameter("credentialsParameter")
     *                 .domain("domain")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-fsxwindowsfileservervolumeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-fsxwindowsfileservervolumeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.FSxWindowsFileServerVolumeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FSxWindowsFileServerVolumeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FSxWindowsFileServerVolumeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon FSx for Windows File Server file system ID to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-fsxwindowsfileservervolumeconfiguration.html#cfn-ecs-taskdefinition-fsxwindowsfileservervolumeconfiguration-filesystemid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-fsxwindowsfileservervolumeconfiguration.html#cfn-ecs-taskdefinition-fsxwindowsfileservervolumeconfiguration-filesystemid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId();

        /**
         * The directory within the Amazon FSx for Windows File Server file system to mount as the root directory inside the host.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-fsxwindowsfileservervolumeconfiguration.html#cfn-ecs-taskdefinition-fsxwindowsfileservervolumeconfiguration-rootdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-fsxwindowsfileservervolumeconfiguration.html#cfn-ecs-taskdefinition-fsxwindowsfileservervolumeconfiguration-rootdirectory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRootDirectory();

        /**
         * The authorization configuration details for the Amazon FSx for Windows File Server file system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-fsxwindowsfileservervolumeconfiguration.html#cfn-ecs-taskdefinition-fsxwindowsfileservervolumeconfiguration-authorizationconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-fsxwindowsfileservervolumeconfiguration.html#cfn-ecs-taskdefinition-fsxwindowsfileservervolumeconfiguration-authorizationconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthorizationConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FSxWindowsFileServerVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FSxWindowsFileServerVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FSxWindowsFileServerVolumeConfigurationProperty> {
            java.lang.String fileSystemId;
            java.lang.String rootDirectory;
            java.lang.Object authorizationConfig;

            /**
             * Sets the value of {@link FSxWindowsFileServerVolumeConfigurationProperty#getFileSystemId}
             * @param fileSystemId The Amazon FSx for Windows File Server file system ID to use. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileSystemId(java.lang.String fileSystemId) {
                this.fileSystemId = fileSystemId;
                return this;
            }

            /**
             * Sets the value of {@link FSxWindowsFileServerVolumeConfigurationProperty#getRootDirectory}
             * @param rootDirectory The directory within the Amazon FSx for Windows File Server file system to mount as the root directory inside the host. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rootDirectory(java.lang.String rootDirectory) {
                this.rootDirectory = rootDirectory;
                return this;
            }

            /**
             * Sets the value of {@link FSxWindowsFileServerVolumeConfigurationProperty#getAuthorizationConfig}
             * @param authorizationConfig The authorization configuration details for the Amazon FSx for Windows File Server file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationConfig(software.amazon.awscdk.IResolvable authorizationConfig) {
                this.authorizationConfig = authorizationConfig;
                return this;
            }

            /**
             * Sets the value of {@link FSxWindowsFileServerVolumeConfigurationProperty#getAuthorizationConfig}
             * @param authorizationConfig The authorization configuration details for the Amazon FSx for Windows File Server file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationConfig(software.amazon.awscdk.services.ecs.CfnTaskDefinition.FSxAuthorizationConfigProperty authorizationConfig) {
                this.authorizationConfig = authorizationConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FSxWindowsFileServerVolumeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FSxWindowsFileServerVolumeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FSxWindowsFileServerVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FSxWindowsFileServerVolumeConfigurationProperty {
            private final java.lang.String fileSystemId;
            private final java.lang.String rootDirectory;
            private final java.lang.Object authorizationConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fileSystemId = software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rootDirectory = software.amazon.jsii.Kernel.get(this, "rootDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authorizationConfig = software.amazon.jsii.Kernel.get(this, "authorizationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fileSystemId = java.util.Objects.requireNonNull(builder.fileSystemId, "fileSystemId is required");
                this.rootDirectory = java.util.Objects.requireNonNull(builder.rootDirectory, "rootDirectory is required");
                this.authorizationConfig = builder.authorizationConfig;
            }

            @Override
            public final java.lang.String getFileSystemId() {
                return this.fileSystemId;
            }

            @Override
            public final java.lang.String getRootDirectory() {
                return this.rootDirectory;
            }

            @Override
            public final java.lang.Object getAuthorizationConfig() {
                return this.authorizationConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fileSystemId", om.valueToTree(this.getFileSystemId()));
                data.set("rootDirectory", om.valueToTree(this.getRootDirectory()));
                if (this.getAuthorizationConfig() != null) {
                    data.set("authorizationConfig", om.valueToTree(this.getAuthorizationConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.FSxWindowsFileServerVolumeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FSxWindowsFileServerVolumeConfigurationProperty.Jsii$Proxy that = (FSxWindowsFileServerVolumeConfigurationProperty.Jsii$Proxy) o;

                if (!fileSystemId.equals(that.fileSystemId)) return false;
                if (!rootDirectory.equals(that.rootDirectory)) return false;
                return this.authorizationConfig != null ? this.authorizationConfig.equals(that.authorizationConfig) : that.authorizationConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fileSystemId.hashCode();
                result = 31 * result + (this.rootDirectory.hashCode());
                result = 31 * result + (this.authorizationConfig != null ? this.authorizationConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The FireLens configuration for the container.
     * <p>
     * This is used to specify and configure a log router for container logs. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Custom log routing</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * FirelensConfigurationProperty firelensConfigurationProperty = FirelensConfigurationProperty.builder()
     *         .options(Map.of(
     *                 "optionsKey", "options"))
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-firelensconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-firelensconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.FirelensConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FirelensConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FirelensConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The options to use when configuring the log router.
         * <p>
         * This field is optional and can be used to add additional metadata, such as the task, task definition, cluster, and container instance details to the log event.
         * <p>
         * If specified, valid option keys are:
         * <p>
         * <ul>
         * <li><code>enable-ecs-log-metadata</code> , which can be <code>true</code> or <code>false</code></li>
         * <li><code>config-file-type</code> , which can be <code>s3</code> or <code>file</code></li>
         * <li><code>config-file-value</code> , which is either an S3 ARN or a file path</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-firelensconfiguration.html#cfn-ecs-taskdefinition-firelensconfiguration-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-firelensconfiguration.html#cfn-ecs-taskdefinition-firelensconfiguration-options</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOptions() {
            return null;
        }

        /**
         * The log router to use.
         * <p>
         * The valid values are <code>fluentd</code> or <code>fluentbit</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-firelensconfiguration.html#cfn-ecs-taskdefinition-firelensconfiguration-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-firelensconfiguration.html#cfn-ecs-taskdefinition-firelensconfiguration-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FirelensConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FirelensConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FirelensConfigurationProperty> {
            java.lang.Object options;
            java.lang.String type;

            /**
             * Sets the value of {@link FirelensConfigurationProperty#getOptions}
             * @param options The options to use when configuring the log router.
             *                This field is optional and can be used to add additional metadata, such as the task, task definition, cluster, and container instance details to the log event.
             *                <p>
             *                If specified, valid option keys are:
             *                <p>
             *                <ul>
             *                <li><code>enable-ecs-log-metadata</code> , which can be <code>true</code> or <code>false</code></li>
             *                <li><code>config-file-type</code> , which can be <code>s3</code> or <code>file</code></li>
             *                <li><code>config-file-value</code> , which is either an S3 ARN or a file path</li>
             *                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(java.util.Map<java.lang.String, java.lang.String> options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link FirelensConfigurationProperty#getOptions}
             * @param options The options to use when configuring the log router.
             *                This field is optional and can be used to add additional metadata, such as the task, task definition, cluster, and container instance details to the log event.
             *                <p>
             *                If specified, valid option keys are:
             *                <p>
             *                <ul>
             *                <li><code>enable-ecs-log-metadata</code> , which can be <code>true</code> or <code>false</code></li>
             *                <li><code>config-file-type</code> , which can be <code>s3</code> or <code>file</code></li>
             *                <li><code>config-file-value</code> , which is either an S3 ARN or a file path</li>
             *                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(software.amazon.awscdk.IResolvable options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link FirelensConfigurationProperty#getType}
             * @param type The log router to use.
             *             The valid values are <code>fluentd</code> or <code>fluentbit</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FirelensConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FirelensConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FirelensConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FirelensConfigurationProperty {
            private final java.lang.Object options;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.options = builder.options;
                this.type = builder.type;
            }

            @Override
            public final java.lang.Object getOptions() {
                return this.options;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOptions() != null) {
                    data.set("options", om.valueToTree(this.getOptions()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.FirelensConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FirelensConfigurationProperty.Jsii$Proxy that = (FirelensConfigurationProperty.Jsii$Proxy) o;

                if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.options != null ? this.options.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>HealthCheck</code> property specifies an object representing a container health check.
     * <p>
     * Health check parameters that are specified in a container definition override any Docker health checks that exist in the container image (such as those specified in a parent image or from the image's Dockerfile). This configuration maps to the <code>HEALTHCHECK</code> parameter of docker run.
     * <p>
     * <blockquote>
     * <p>
     * The Amazon ECS container agent only monitors and reports on the health checks specified in the task definition. Amazon ECS does not monitor Docker health checks that are embedded in a container image and not specified in the container definition. Health check parameters that are specified in a container definition override any Docker health checks that exist in the container image.
     * <p>
     * </blockquote>
     * <p>
     * If a task is run manually, and not as part of a service, the task will continue its lifecycle regardless of its health status. For tasks that are part of a service, if the task reports as unhealthy then the task will be stopped and the service scheduler will replace it.
     * <p>
     * The following are notes about container health check support:
     * <p>
     * <ul>
     * <li>Container health checks require version 1.17.0 or greater of the Amazon ECS container agent. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon ECS Container Agent</a> .</li>
     * <li>Container health checks are supported for Fargate tasks if you are using platform version 1.1.0 or greater. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform Versions</a> .</li>
     * <li>Container health checks are not supported for tasks that are part of a service that is configured to use a Classic Load Balancer.</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * HealthCheckProperty healthCheckProperty = HealthCheckProperty.builder()
     *         .command(List.of("command"))
     *         .interval(123)
     *         .retries(123)
     *         .startPeriod(123)
     *         .timeout(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-healthcheck.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-healthcheck.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.HealthCheckProperty")
    @software.amazon.jsii.Jsii.Proxy(HealthCheckProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HealthCheckProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A string array representing the command that the container runs to determine if it is healthy.
         * <p>
         * The string array must start with <code>CMD</code> to run the command arguments directly, or <code>CMD-SHELL</code> to run the command with the container's default shell.
         * <p>
         * When you use the AWS Management Console JSON panel, the AWS Command Line Interface , or the APIs, enclose the list of commands in double quotes and brackets.
         * <p>
         * <code>[ "CMD-SHELL", "curl -f http://localhost/ || exit 1" ]</code>
         * <p>
         * You don't include the double quotes and brackets when you use the AWS Management Console.
         * <p>
         * <code>CMD-SHELL, curl -f http://localhost/ || exit 1</code>
         * <p>
         * An exit code of 0 indicates success, and non-zero exit code indicates failure. For more information, see <code>HealthCheck</code> in the docker container create command.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-healthcheck.html#cfn-ecs-taskdefinition-healthcheck-command">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-healthcheck.html#cfn-ecs-taskdefinition-healthcheck-command</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
            return null;
        }

        /**
         * The time period in seconds between each health check execution.
         * <p>
         * You may specify between 5 and 300 seconds. The default value is 30 seconds. This value applies only when you specify a <code>command</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-healthcheck.html#cfn-ecs-taskdefinition-healthcheck-interval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-healthcheck.html#cfn-ecs-taskdefinition-healthcheck-interval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInterval() {
            return null;
        }

        /**
         * The number of times to retry a failed health check before the container is considered unhealthy.
         * <p>
         * You may specify between 1 and 10 retries. The default value is 3. This value applies only when you specify a <code>command</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-healthcheck.html#cfn-ecs-taskdefinition-healthcheck-retries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-healthcheck.html#cfn-ecs-taskdefinition-healthcheck-retries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRetries() {
            return null;
        }

        /**
         * The optional grace period to provide containers time to bootstrap before failed health checks count towards the maximum number of retries.
         * <p>
         * You can specify between 0 and 300 seconds. By default, the <code>startPeriod</code> is off. This value applies only when you specify a <code>command</code> .
         * <p>
         * <blockquote>
         * <p>
         * If a health check succeeds within the <code>startPeriod</code> , then the container is considered healthy and any subsequent failures count toward the maximum number of retries.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-healthcheck.html#cfn-ecs-taskdefinition-healthcheck-startperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-healthcheck.html#cfn-ecs-taskdefinition-healthcheck-startperiod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStartPeriod() {
            return null;
        }

        /**
         * The time period in seconds to wait for a health check to succeed before it is considered a failure.
         * <p>
         * You may specify between 2 and 60 seconds. The default value is 5. This value applies only when you specify a <code>command</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-healthcheck.html#cfn-ecs-taskdefinition-healthcheck-timeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-healthcheck.html#cfn-ecs-taskdefinition-healthcheck-timeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeout() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HealthCheckProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HealthCheckProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HealthCheckProperty> {
            java.util.List<java.lang.String> command;
            java.lang.Number interval;
            java.lang.Number retries;
            java.lang.Number startPeriod;
            java.lang.Number timeout;

            /**
             * Sets the value of {@link HealthCheckProperty#getCommand}
             * @param command A string array representing the command that the container runs to determine if it is healthy.
             *                The string array must start with <code>CMD</code> to run the command arguments directly, or <code>CMD-SHELL</code> to run the command with the container's default shell.
             *                <p>
             *                When you use the AWS Management Console JSON panel, the AWS Command Line Interface , or the APIs, enclose the list of commands in double quotes and brackets.
             *                <p>
             *                <code>[ "CMD-SHELL", "curl -f http://localhost/ || exit 1" ]</code>
             *                <p>
             *                You don't include the double quotes and brackets when you use the AWS Management Console.
             *                <p>
             *                <code>CMD-SHELL, curl -f http://localhost/ || exit 1</code>
             *                <p>
             *                An exit code of 0 indicates success, and non-zero exit code indicates failure. For more information, see <code>HealthCheck</code> in the docker container create command.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder command(java.util.List<java.lang.String> command) {
                this.command = command;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckProperty#getInterval}
             * @param interval The time period in seconds between each health check execution.
             *                 You may specify between 5 and 300 seconds. The default value is 30 seconds. This value applies only when you specify a <code>command</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.Number interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckProperty#getRetries}
             * @param retries The number of times to retry a failed health check before the container is considered unhealthy.
             *                You may specify between 1 and 10 retries. The default value is 3. This value applies only when you specify a <code>command</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retries(java.lang.Number retries) {
                this.retries = retries;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckProperty#getStartPeriod}
             * @param startPeriod The optional grace period to provide containers time to bootstrap before failed health checks count towards the maximum number of retries.
             *                    You can specify between 0 and 300 seconds. By default, the <code>startPeriod</code> is off. This value applies only when you specify a <code>command</code> .
             *                    <p>
             *                    <blockquote>
             *                    <p>
             *                    If a health check succeeds within the <code>startPeriod</code> , then the container is considered healthy and any subsequent failures count toward the maximum number of retries.
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startPeriod(java.lang.Number startPeriod) {
                this.startPeriod = startPeriod;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckProperty#getTimeout}
             * @param timeout The time period in seconds to wait for a health check to succeed before it is considered a failure.
             *                You may specify between 2 and 60 seconds. The default value is 5. This value applies only when you specify a <code>command</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeout(java.lang.Number timeout) {
                this.timeout = timeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HealthCheckProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HealthCheckProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HealthCheckProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HealthCheckProperty {
            private final java.util.List<java.lang.String> command;
            private final java.lang.Number interval;
            private final java.lang.Number retries;
            private final java.lang.Number startPeriod;
            private final java.lang.Number timeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.retries = software.amazon.jsii.Kernel.get(this, "retries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.startPeriod = software.amazon.jsii.Kernel.get(this, "startPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.command = builder.command;
                this.interval = builder.interval;
                this.retries = builder.retries;
                this.startPeriod = builder.startPeriod;
                this.timeout = builder.timeout;
            }

            @Override
            public final java.util.List<java.lang.String> getCommand() {
                return this.command;
            }

            @Override
            public final java.lang.Number getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.Number getRetries() {
                return this.retries;
            }

            @Override
            public final java.lang.Number getStartPeriod() {
                return this.startPeriod;
            }

            @Override
            public final java.lang.Number getTimeout() {
                return this.timeout;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCommand() != null) {
                    data.set("command", om.valueToTree(this.getCommand()));
                }
                if (this.getInterval() != null) {
                    data.set("interval", om.valueToTree(this.getInterval()));
                }
                if (this.getRetries() != null) {
                    data.set("retries", om.valueToTree(this.getRetries()));
                }
                if (this.getStartPeriod() != null) {
                    data.set("startPeriod", om.valueToTree(this.getStartPeriod()));
                }
                if (this.getTimeout() != null) {
                    data.set("timeout", om.valueToTree(this.getTimeout()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.HealthCheckProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HealthCheckProperty.Jsii$Proxy that = (HealthCheckProperty.Jsii$Proxy) o;

                if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
                if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) return false;
                if (this.retries != null ? !this.retries.equals(that.retries) : that.retries != null) return false;
                if (this.startPeriod != null ? !this.startPeriod.equals(that.startPeriod) : that.startPeriod != null) return false;
                return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
            }

            @Override
            public final int hashCode() {
                int result = this.command != null ? this.command.hashCode() : 0;
                result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
                result = 31 * result + (this.retries != null ? this.retries.hashCode() : 0);
                result = 31 * result + (this.startPeriod != null ? this.startPeriod.hashCode() : 0);
                result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>HostEntry</code> property specifies a hostname and an IP address that are added to the <code>/etc/hosts</code> file of a container through the <code>extraHosts</code> parameter of its <code>ContainerDefinition</code> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * HostEntryProperty hostEntryProperty = HostEntryProperty.builder()
     *         .hostname("hostname")
     *         .ipAddress("ipAddress")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-hostentry.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-hostentry.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.HostEntryProperty")
    @software.amazon.jsii.Jsii.Proxy(HostEntryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HostEntryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The hostname to use in the <code>/etc/hosts</code> entry.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-hostentry.html#cfn-ecs-taskdefinition-hostentry-hostname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-hostentry.html#cfn-ecs-taskdefinition-hostentry-hostname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostname() {
            return null;
        }

        /**
         * The IP address to use in the <code>/etc/hosts</code> entry.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-hostentry.html#cfn-ecs-taskdefinition-hostentry-ipaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-hostentry.html#cfn-ecs-taskdefinition-hostentry-ipaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIpAddress() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HostEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HostEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HostEntryProperty> {
            java.lang.String hostname;
            java.lang.String ipAddress;

            /**
             * Sets the value of {@link HostEntryProperty#getHostname}
             * @param hostname The hostname to use in the <code>/etc/hosts</code> entry.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostname(java.lang.String hostname) {
                this.hostname = hostname;
                return this;
            }

            /**
             * Sets the value of {@link HostEntryProperty#getIpAddress}
             * @param ipAddress The IP address to use in the <code>/etc/hosts</code> entry.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipAddress(java.lang.String ipAddress) {
                this.ipAddress = ipAddress;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HostEntryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HostEntryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HostEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HostEntryProperty {
            private final java.lang.String hostname;
            private final java.lang.String ipAddress;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hostname = software.amazon.jsii.Kernel.get(this, "hostname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ipAddress = software.amazon.jsii.Kernel.get(this, "ipAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hostname = builder.hostname;
                this.ipAddress = builder.ipAddress;
            }

            @Override
            public final java.lang.String getHostname() {
                return this.hostname;
            }

            @Override
            public final java.lang.String getIpAddress() {
                return this.ipAddress;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHostname() != null) {
                    data.set("hostname", om.valueToTree(this.getHostname()));
                }
                if (this.getIpAddress() != null) {
                    data.set("ipAddress", om.valueToTree(this.getIpAddress()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.HostEntryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HostEntryProperty.Jsii$Proxy that = (HostEntryProperty.Jsii$Proxy) o;

                if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) return false;
                return this.ipAddress != null ? this.ipAddress.equals(that.ipAddress) : that.ipAddress == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hostname != null ? this.hostname.hashCode() : 0;
                result = 31 * result + (this.ipAddress != null ? this.ipAddress.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>HostVolumeProperties</code> property specifies details on a container instance bind mount host volume.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * HostVolumePropertiesProperty hostVolumePropertiesProperty = HostVolumePropertiesProperty.builder()
     *         .sourcePath("sourcePath")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-hostvolumeproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-hostvolumeproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.HostVolumePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(HostVolumePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HostVolumePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * When the <code>host</code> parameter is used, specify a <code>sourcePath</code> to declare the path on the host container instance that's presented to the container.
         * <p>
         * If this parameter is empty, then the Docker daemon has assigned a host path for you. If the <code>host</code> parameter contains a <code>sourcePath</code> file location, then the data volume persists at the specified location on the host container instance until you delete it manually. If the <code>sourcePath</code> value doesn't exist on the host container instance, the Docker daemon creates it. If the location does exist, the contents of the source path folder are exported.
         * <p>
         * If you're using the Fargate launch type, the <code>sourcePath</code> parameter is not supported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-hostvolumeproperties.html#cfn-ecs-taskdefinition-hostvolumeproperties-sourcepath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-hostvolumeproperties.html#cfn-ecs-taskdefinition-hostvolumeproperties-sourcepath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourcePath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HostVolumePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HostVolumePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HostVolumePropertiesProperty> {
            java.lang.String sourcePath;

            /**
             * Sets the value of {@link HostVolumePropertiesProperty#getSourcePath}
             * @param sourcePath When the <code>host</code> parameter is used, specify a <code>sourcePath</code> to declare the path on the host container instance that's presented to the container.
             *                   If this parameter is empty, then the Docker daemon has assigned a host path for you. If the <code>host</code> parameter contains a <code>sourcePath</code> file location, then the data volume persists at the specified location on the host container instance until you delete it manually. If the <code>sourcePath</code> value doesn't exist on the host container instance, the Docker daemon creates it. If the location does exist, the contents of the source path folder are exported.
             *                   <p>
             *                   If you're using the Fargate launch type, the <code>sourcePath</code> parameter is not supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePath(java.lang.String sourcePath) {
                this.sourcePath = sourcePath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HostVolumePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HostVolumePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HostVolumePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HostVolumePropertiesProperty {
            private final java.lang.String sourcePath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourcePath = software.amazon.jsii.Kernel.get(this, "sourcePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourcePath = builder.sourcePath;
            }

            @Override
            public final java.lang.String getSourcePath() {
                return this.sourcePath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSourcePath() != null) {
                    data.set("sourcePath", om.valueToTree(this.getSourcePath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.HostVolumePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HostVolumePropertiesProperty.Jsii$Proxy that = (HostVolumePropertiesProperty.Jsii$Proxy) o;

                return this.sourcePath != null ? this.sourcePath.equals(that.sourcePath) : that.sourcePath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourcePath != null ? this.sourcePath.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Details on an Elastic Inference accelerator.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-inference.html">Working with Amazon Elastic Inference on Amazon ECS</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * InferenceAcceleratorProperty inferenceAcceleratorProperty = InferenceAcceleratorProperty.builder()
     *         .deviceName("deviceName")
     *         .deviceType("deviceType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-inferenceaccelerator.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-inferenceaccelerator.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.InferenceAcceleratorProperty")
    @software.amazon.jsii.Jsii.Proxy(InferenceAcceleratorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InferenceAcceleratorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Elastic Inference accelerator device name.
         * <p>
         * The <code>deviceName</code> must also be referenced in a container definition as a <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ResourceRequirement.html">ResourceRequirement</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-inferenceaccelerator.html#cfn-ecs-taskdefinition-inferenceaccelerator-devicename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-inferenceaccelerator.html#cfn-ecs-taskdefinition-inferenceaccelerator-devicename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeviceName() {
            return null;
        }

        /**
         * The Elastic Inference accelerator type to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-inferenceaccelerator.html#cfn-ecs-taskdefinition-inferenceaccelerator-devicetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-inferenceaccelerator.html#cfn-ecs-taskdefinition-inferenceaccelerator-devicetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeviceType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InferenceAcceleratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InferenceAcceleratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InferenceAcceleratorProperty> {
            java.lang.String deviceName;
            java.lang.String deviceType;

            /**
             * Sets the value of {@link InferenceAcceleratorProperty#getDeviceName}
             * @param deviceName The Elastic Inference accelerator device name.
             *                   The <code>deviceName</code> must also be referenced in a container definition as a <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ResourceRequirement.html">ResourceRequirement</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceName(java.lang.String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            /**
             * Sets the value of {@link InferenceAcceleratorProperty#getDeviceType}
             * @param deviceType The Elastic Inference accelerator type to use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceType(java.lang.String deviceType) {
                this.deviceType = deviceType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InferenceAcceleratorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InferenceAcceleratorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InferenceAcceleratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InferenceAcceleratorProperty {
            private final java.lang.String deviceName;
            private final java.lang.String deviceType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deviceName = software.amazon.jsii.Kernel.get(this, "deviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deviceType = software.amazon.jsii.Kernel.get(this, "deviceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deviceName = builder.deviceName;
                this.deviceType = builder.deviceType;
            }

            @Override
            public final java.lang.String getDeviceName() {
                return this.deviceName;
            }

            @Override
            public final java.lang.String getDeviceType() {
                return this.deviceType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeviceName() != null) {
                    data.set("deviceName", om.valueToTree(this.getDeviceName()));
                }
                if (this.getDeviceType() != null) {
                    data.set("deviceType", om.valueToTree(this.getDeviceType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.InferenceAcceleratorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InferenceAcceleratorProperty.Jsii$Proxy that = (InferenceAcceleratorProperty.Jsii$Proxy) o;

                if (this.deviceName != null ? !this.deviceName.equals(that.deviceName) : that.deviceName != null) return false;
                return this.deviceType != null ? this.deviceType.equals(that.deviceType) : that.deviceType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deviceName != null ? this.deviceName.hashCode() : 0;
                result = 31 * result + (this.deviceType != null ? this.deviceType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Linux capabilities to add or remove from the default Docker configuration for a container defined in the task definition.
     * <p>
     * For more detailed information about these Linux capabilities, see the <a href="https://docs.aws.amazon.com/http://man7.org/linux/man-pages/man7/capabilities.7.html">capabilities(7)</a> Linux manual page.
     * <p>
     * The following describes how Docker processes the Linux capabilities specified in the <code>add</code> and <code>drop</code> request parameters. For information about the latest behavior, see <a href="https://docs.aws.amazon.com/https://forums.docker.com/t/docker-compose-order-of-cap-drop-and-cap-add/97136/1">Docker Compose: order of cap_drop and cap_add</a> in the Docker Community Forum.
     * <p>
     * <ul>
     * <li>When the container is a privleged container, the container capabilities are all of the default Docker capabilities. The capabilities specified in the <code>add</code> request parameter, and the <code>drop</code> request parameter are ignored.</li>
     * <li>When the <code>add</code> request parameter is set to ALL, the container capabilities are all of the default Docker capabilities, excluding those specified in the <code>drop</code> request parameter.</li>
     * <li>When the <code>drop</code> request parameter is set to ALL, the container capabilities are the capabilities specified in the <code>add</code> request parameter.</li>
     * <li>When the <code>add</code> request parameter and the <code>drop</code> request parameter are both empty, the capabilities the container capabilities are all of the default Docker capabilities.</li>
     * <li>The default is to first drop the capabilities specified in the <code>drop</code> request parameter, and then add the capabilities specified in the <code>add</code> request parameter.</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * KernelCapabilitiesProperty kernelCapabilitiesProperty = KernelCapabilitiesProperty.builder()
     *         .add(List.of("add"))
     *         .drop(List.of("drop"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-kernelcapabilities.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-kernelcapabilities.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.KernelCapabilitiesProperty")
    @software.amazon.jsii.Jsii.Proxy(KernelCapabilitiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KernelCapabilitiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Linux capabilities for the container that have been added to the default configuration provided by Docker.
         * <p>
         * This parameter maps to <code>CapAdd</code> in the docker container create command and the <code>--cap-add</code> option to docker run.
         * <p>
         * <blockquote>
         * <p>
         * Tasks launched on AWS Fargate only support adding the <code>SYS_PTRACE</code> kernel capability.
         * <p>
         * </blockquote>
         * <p>
         * Valid values: <code>"ALL" | "AUDIT_CONTROL" | "AUDIT_WRITE" | "BLOCK_SUSPEND" | "CHOWN" | "DAC_OVERRIDE" | "DAC_READ_SEARCH" | "FOWNER" | "FSETID" | "IPC_LOCK" | "IPC_OWNER" | "KILL" | "LEASE" | "LINUX_IMMUTABLE" | "MAC_ADMIN" | "MAC_OVERRIDE" | "MKNOD" | "NET_ADMIN" | "NET_BIND_SERVICE" | "NET_BROADCAST" | "NET_RAW" | "SETFCAP" | "SETGID" | "SETPCAP" | "SETUID" | "SYS_ADMIN" | "SYS_BOOT" | "SYS_CHROOT" | "SYS_MODULE" | "SYS_NICE" | "SYS_PACCT" | "SYS_PTRACE" | "SYS_RAWIO" | "SYS_RESOURCE" | "SYS_TIME" | "SYS_TTY_CONFIG" | "SYSLOG" | "WAKE_ALARM"</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-kernelcapabilities.html#cfn-ecs-taskdefinition-kernelcapabilities-add">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-kernelcapabilities.html#cfn-ecs-taskdefinition-kernelcapabilities-add</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdd() {
            return null;
        }

        /**
         * The Linux capabilities for the container that have been removed from the default configuration provided by Docker.
         * <p>
         * This parameter maps to <code>CapDrop</code> in the docker container create command and the <code>--cap-drop</code> option to docker run.
         * <p>
         * Valid values: <code>"ALL" | "AUDIT_CONTROL" | "AUDIT_WRITE" | "BLOCK_SUSPEND" | "CHOWN" | "DAC_OVERRIDE" | "DAC_READ_SEARCH" | "FOWNER" | "FSETID" | "IPC_LOCK" | "IPC_OWNER" | "KILL" | "LEASE" | "LINUX_IMMUTABLE" | "MAC_ADMIN" | "MAC_OVERRIDE" | "MKNOD" | "NET_ADMIN" | "NET_BIND_SERVICE" | "NET_BROADCAST" | "NET_RAW" | "SETFCAP" | "SETGID" | "SETPCAP" | "SETUID" | "SYS_ADMIN" | "SYS_BOOT" | "SYS_CHROOT" | "SYS_MODULE" | "SYS_NICE" | "SYS_PACCT" | "SYS_PTRACE" | "SYS_RAWIO" | "SYS_RESOURCE" | "SYS_TIME" | "SYS_TTY_CONFIG" | "SYSLOG" | "WAKE_ALARM"</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-kernelcapabilities.html#cfn-ecs-taskdefinition-kernelcapabilities-drop">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-kernelcapabilities.html#cfn-ecs-taskdefinition-kernelcapabilities-drop</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDrop() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KernelCapabilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KernelCapabilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KernelCapabilitiesProperty> {
            java.util.List<java.lang.String> add;
            java.util.List<java.lang.String> drop;

            /**
             * Sets the value of {@link KernelCapabilitiesProperty#getAdd}
             * @param add The Linux capabilities for the container that have been added to the default configuration provided by Docker.
             *            This parameter maps to <code>CapAdd</code> in the docker container create command and the <code>--cap-add</code> option to docker run.
             *            <p>
             *            <blockquote>
             *            <p>
             *            Tasks launched on AWS Fargate only support adding the <code>SYS_PTRACE</code> kernel capability.
             *            <p>
             *            </blockquote>
             *            <p>
             *            Valid values: <code>"ALL" | "AUDIT_CONTROL" | "AUDIT_WRITE" | "BLOCK_SUSPEND" | "CHOWN" | "DAC_OVERRIDE" | "DAC_READ_SEARCH" | "FOWNER" | "FSETID" | "IPC_LOCK" | "IPC_OWNER" | "KILL" | "LEASE" | "LINUX_IMMUTABLE" | "MAC_ADMIN" | "MAC_OVERRIDE" | "MKNOD" | "NET_ADMIN" | "NET_BIND_SERVICE" | "NET_BROADCAST" | "NET_RAW" | "SETFCAP" | "SETGID" | "SETPCAP" | "SETUID" | "SYS_ADMIN" | "SYS_BOOT" | "SYS_CHROOT" | "SYS_MODULE" | "SYS_NICE" | "SYS_PACCT" | "SYS_PTRACE" | "SYS_RAWIO" | "SYS_RESOURCE" | "SYS_TIME" | "SYS_TTY_CONFIG" | "SYSLOG" | "WAKE_ALARM"</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder add(java.util.List<java.lang.String> add) {
                this.add = add;
                return this;
            }

            /**
             * Sets the value of {@link KernelCapabilitiesProperty#getDrop}
             * @param drop The Linux capabilities for the container that have been removed from the default configuration provided by Docker.
             *             This parameter maps to <code>CapDrop</code> in the docker container create command and the <code>--cap-drop</code> option to docker run.
             *             <p>
             *             Valid values: <code>"ALL" | "AUDIT_CONTROL" | "AUDIT_WRITE" | "BLOCK_SUSPEND" | "CHOWN" | "DAC_OVERRIDE" | "DAC_READ_SEARCH" | "FOWNER" | "FSETID" | "IPC_LOCK" | "IPC_OWNER" | "KILL" | "LEASE" | "LINUX_IMMUTABLE" | "MAC_ADMIN" | "MAC_OVERRIDE" | "MKNOD" | "NET_ADMIN" | "NET_BIND_SERVICE" | "NET_BROADCAST" | "NET_RAW" | "SETFCAP" | "SETGID" | "SETPCAP" | "SETUID" | "SYS_ADMIN" | "SYS_BOOT" | "SYS_CHROOT" | "SYS_MODULE" | "SYS_NICE" | "SYS_PACCT" | "SYS_PTRACE" | "SYS_RAWIO" | "SYS_RESOURCE" | "SYS_TIME" | "SYS_TTY_CONFIG" | "SYSLOG" | "WAKE_ALARM"</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder drop(java.util.List<java.lang.String> drop) {
                this.drop = drop;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KernelCapabilitiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KernelCapabilitiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KernelCapabilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KernelCapabilitiesProperty {
            private final java.util.List<java.lang.String> add;
            private final java.util.List<java.lang.String> drop;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.add = software.amazon.jsii.Kernel.get(this, "add", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.drop = software.amazon.jsii.Kernel.get(this, "drop", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.add = builder.add;
                this.drop = builder.drop;
            }

            @Override
            public final java.util.List<java.lang.String> getAdd() {
                return this.add;
            }

            @Override
            public final java.util.List<java.lang.String> getDrop() {
                return this.drop;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdd() != null) {
                    data.set("add", om.valueToTree(this.getAdd()));
                }
                if (this.getDrop() != null) {
                    data.set("drop", om.valueToTree(this.getDrop()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.KernelCapabilitiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KernelCapabilitiesProperty.Jsii$Proxy that = (KernelCapabilitiesProperty.Jsii$Proxy) o;

                if (this.add != null ? !this.add.equals(that.add) : that.add != null) return false;
                return this.drop != null ? this.drop.equals(that.drop) : that.drop == null;
            }

            @Override
            public final int hashCode() {
                int result = this.add != null ? this.add.hashCode() : 0;
                result = 31 * result + (this.drop != null ? this.drop.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A key-value pair object.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * KeyValuePairProperty keyValuePairProperty = KeyValuePairProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-keyvaluepair.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-keyvaluepair.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.KeyValuePairProperty")
    @software.amazon.jsii.Jsii.Proxy(KeyValuePairProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KeyValuePairProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the key-value pair.
         * <p>
         * For environment variables, this is the name of the environment variable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-keyvaluepair.html#cfn-ecs-taskdefinition-keyvaluepair-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-keyvaluepair.html#cfn-ecs-taskdefinition-keyvaluepair-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The value of the key-value pair.
         * <p>
         * For environment variables, this is the value of the environment variable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-keyvaluepair.html#cfn-ecs-taskdefinition-keyvaluepair-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-keyvaluepair.html#cfn-ecs-taskdefinition-keyvaluepair-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KeyValuePairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KeyValuePairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KeyValuePairProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link KeyValuePairProperty#getName}
             * @param name The name of the key-value pair.
             *             For environment variables, this is the name of the environment variable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link KeyValuePairProperty#getValue}
             * @param value The value of the key-value pair.
             *              For environment variables, this is the value of the environment variable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeyValuePairProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KeyValuePairProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KeyValuePairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeyValuePairProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.KeyValuePairProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KeyValuePairProperty.Jsii$Proxy that = (KeyValuePairProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Linux-specific options that are applied to the container, such as Linux <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html">KernelCapabilities</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * LinuxParametersProperty linuxParametersProperty = LinuxParametersProperty.builder()
     *         .capabilities(KernelCapabilitiesProperty.builder()
     *                 .add(List.of("add"))
     *                 .drop(List.of("drop"))
     *                 .build())
     *         .devices(List.of(DeviceProperty.builder()
     *                 .containerPath("containerPath")
     *                 .hostPath("hostPath")
     *                 .permissions(List.of("permissions"))
     *                 .build()))
     *         .initProcessEnabled(false)
     *         .maxSwap(123)
     *         .sharedMemorySize(123)
     *         .swappiness(123)
     *         .tmpfs(List.of(TmpfsProperty.builder()
     *                 .size(123)
     *                 // the properties below are optional
     *                 .containerPath("containerPath")
     *                 .mountOptions(List.of("mountOptions"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.LinuxParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(LinuxParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LinuxParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Linux capabilities for the container that are added to or dropped from the default configuration provided by Docker.
         * <p>
         * <blockquote>
         * <p>
         * For tasks that use the Fargate launch type, <code>capabilities</code> is supported for all platform versions but the <code>add</code> parameter is only supported if using platform version 1.4.0 or later.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html#cfn-ecs-taskdefinition-linuxparameters-capabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html#cfn-ecs-taskdefinition-linuxparameters-capabilities</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCapabilities() {
            return null;
        }

        /**
         * Any host devices to expose to the container.
         * <p>
         * This parameter maps to <code>Devices</code> in the docker container create command and the <code>--device</code> option to docker run.
         * <p>
         * <blockquote>
         * <p>
         * If you're using tasks that use the Fargate launch type, the <code>devices</code> parameter isn't supported.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html#cfn-ecs-taskdefinition-linuxparameters-devices">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html#cfn-ecs-taskdefinition-linuxparameters-devices</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDevices() {
            return null;
        }

        /**
         * Run an <code>init</code> process inside the container that forwards signals and reaps processes.
         * <p>
         * This parameter maps to the <code>--init</code> option to docker run. This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html#cfn-ecs-taskdefinition-linuxparameters-initprocessenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html#cfn-ecs-taskdefinition-linuxparameters-initprocessenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInitProcessEnabled() {
            return null;
        }

        /**
         * The total amount of swap memory (in MiB) a container can use.
         * <p>
         * This parameter will be translated to the <code>--memory-swap</code> option to docker run where the value would be the sum of the container memory plus the <code>maxSwap</code> value.
         * <p>
         * If a <code>maxSwap</code> value of <code>0</code> is specified, the container will not use swap. Accepted values are <code>0</code> or any positive integer. If the <code>maxSwap</code> parameter is omitted, the container will use the swap configuration for the container instance it is running on. A <code>maxSwap</code> value must be set for the <code>swappiness</code> parameter to be used.
         * <p>
         * <blockquote>
         * <p>
         * If you're using tasks that use the Fargate launch type, the <code>maxSwap</code> parameter isn't supported.
         * <p>
         * If you're using tasks on Amazon Linux 2023 the <code>swappiness</code> parameter isn't supported.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html#cfn-ecs-taskdefinition-linuxparameters-maxswap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html#cfn-ecs-taskdefinition-linuxparameters-maxswap</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxSwap() {
            return null;
        }

        /**
         * The value for the size (in MiB) of the <code>/dev/shm</code> volume.
         * <p>
         * This parameter maps to the <code>--shm-size</code> option to docker run.
         * <p>
         * <blockquote>
         * <p>
         * If you are using tasks that use the Fargate launch type, the <code>sharedMemorySize</code> parameter is not supported.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html#cfn-ecs-taskdefinition-linuxparameters-sharedmemorysize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html#cfn-ecs-taskdefinition-linuxparameters-sharedmemorysize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSharedMemorySize() {
            return null;
        }

        /**
         * This allows you to tune a container's memory swappiness behavior.
         * <p>
         * A <code>swappiness</code> value of <code>0</code> will cause swapping to not happen unless absolutely necessary. A <code>swappiness</code> value of <code>100</code> will cause pages to be swapped very aggressively. Accepted values are whole numbers between <code>0</code> and <code>100</code> . If the <code>swappiness</code> parameter is not specified, a default value of <code>60</code> is used. If a value is not specified for <code>maxSwap</code> then this parameter is ignored. This parameter maps to the <code>--memory-swappiness</code> option to docker run.
         * <p>
         * <blockquote>
         * <p>
         * If you're using tasks that use the Fargate launch type, the <code>swappiness</code> parameter isn't supported.
         * <p>
         * If you're using tasks on Amazon Linux 2023 the <code>swappiness</code> parameter isn't supported.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html#cfn-ecs-taskdefinition-linuxparameters-swappiness">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html#cfn-ecs-taskdefinition-linuxparameters-swappiness</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSwappiness() {
            return null;
        }

        /**
         * The container path, mount options, and size (in MiB) of the tmpfs mount.
         * <p>
         * This parameter maps to the <code>--tmpfs</code> option to docker run.
         * <p>
         * <blockquote>
         * <p>
         * If you're using tasks that use the Fargate launch type, the <code>tmpfs</code> parameter isn't supported.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html#cfn-ecs-taskdefinition-linuxparameters-tmpfs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-linuxparameters.html#cfn-ecs-taskdefinition-linuxparameters-tmpfs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTmpfs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LinuxParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LinuxParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LinuxParametersProperty> {
            java.lang.Object capabilities;
            java.lang.Object devices;
            java.lang.Object initProcessEnabled;
            java.lang.Number maxSwap;
            java.lang.Number sharedMemorySize;
            java.lang.Number swappiness;
            java.lang.Object tmpfs;

            /**
             * Sets the value of {@link LinuxParametersProperty#getCapabilities}
             * @param capabilities The Linux capabilities for the container that are added to or dropped from the default configuration provided by Docker.
             *                     <blockquote>
             *                     <p>
             *                     For tasks that use the Fargate launch type, <code>capabilities</code> is supported for all platform versions but the <code>add</code> parameter is only supported if using platform version 1.4.0 or later.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capabilities(software.amazon.awscdk.IResolvable capabilities) {
                this.capabilities = capabilities;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getCapabilities}
             * @param capabilities The Linux capabilities for the container that are added to or dropped from the default configuration provided by Docker.
             *                     <blockquote>
             *                     <p>
             *                     For tasks that use the Fargate launch type, <code>capabilities</code> is supported for all platform versions but the <code>add</code> parameter is only supported if using platform version 1.4.0 or later.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capabilities(software.amazon.awscdk.services.ecs.CfnTaskDefinition.KernelCapabilitiesProperty capabilities) {
                this.capabilities = capabilities;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getDevices}
             * @param devices Any host devices to expose to the container.
             *                This parameter maps to <code>Devices</code> in the docker container create command and the <code>--device</code> option to docker run.
             *                <p>
             *                <blockquote>
             *                <p>
             *                If you're using tasks that use the Fargate launch type, the <code>devices</code> parameter isn't supported.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder devices(software.amazon.awscdk.IResolvable devices) {
                this.devices = devices;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getDevices}
             * @param devices Any host devices to expose to the container.
             *                This parameter maps to <code>Devices</code> in the docker container create command and the <code>--device</code> option to docker run.
             *                <p>
             *                <blockquote>
             *                <p>
             *                If you're using tasks that use the Fargate launch type, the <code>devices</code> parameter isn't supported.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder devices(java.util.List<? extends java.lang.Object> devices) {
                this.devices = devices;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getInitProcessEnabled}
             * @param initProcessEnabled Run an <code>init</code> process inside the container that forwards signals and reaps processes.
             *                           This parameter maps to the <code>--init</code> option to docker run. This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initProcessEnabled(java.lang.Boolean initProcessEnabled) {
                this.initProcessEnabled = initProcessEnabled;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getInitProcessEnabled}
             * @param initProcessEnabled Run an <code>init</code> process inside the container that forwards signals and reaps processes.
             *                           This parameter maps to the <code>--init</code> option to docker run. This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initProcessEnabled(software.amazon.awscdk.IResolvable initProcessEnabled) {
                this.initProcessEnabled = initProcessEnabled;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getMaxSwap}
             * @param maxSwap The total amount of swap memory (in MiB) a container can use.
             *                This parameter will be translated to the <code>--memory-swap</code> option to docker run where the value would be the sum of the container memory plus the <code>maxSwap</code> value.
             *                <p>
             *                If a <code>maxSwap</code> value of <code>0</code> is specified, the container will not use swap. Accepted values are <code>0</code> or any positive integer. If the <code>maxSwap</code> parameter is omitted, the container will use the swap configuration for the container instance it is running on. A <code>maxSwap</code> value must be set for the <code>swappiness</code> parameter to be used.
             *                <p>
             *                <blockquote>
             *                <p>
             *                If you're using tasks that use the Fargate launch type, the <code>maxSwap</code> parameter isn't supported.
             *                <p>
             *                If you're using tasks on Amazon Linux 2023 the <code>swappiness</code> parameter isn't supported.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxSwap(java.lang.Number maxSwap) {
                this.maxSwap = maxSwap;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getSharedMemorySize}
             * @param sharedMemorySize The value for the size (in MiB) of the <code>/dev/shm</code> volume.
             *                         This parameter maps to the <code>--shm-size</code> option to docker run.
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         If you are using tasks that use the Fargate launch type, the <code>sharedMemorySize</code> parameter is not supported.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sharedMemorySize(java.lang.Number sharedMemorySize) {
                this.sharedMemorySize = sharedMemorySize;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getSwappiness}
             * @param swappiness This allows you to tune a container's memory swappiness behavior.
             *                   A <code>swappiness</code> value of <code>0</code> will cause swapping to not happen unless absolutely necessary. A <code>swappiness</code> value of <code>100</code> will cause pages to be swapped very aggressively. Accepted values are whole numbers between <code>0</code> and <code>100</code> . If the <code>swappiness</code> parameter is not specified, a default value of <code>60</code> is used. If a value is not specified for <code>maxSwap</code> then this parameter is ignored. This parameter maps to the <code>--memory-swappiness</code> option to docker run.
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   If you're using tasks that use the Fargate launch type, the <code>swappiness</code> parameter isn't supported.
             *                   <p>
             *                   If you're using tasks on Amazon Linux 2023 the <code>swappiness</code> parameter isn't supported.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder swappiness(java.lang.Number swappiness) {
                this.swappiness = swappiness;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getTmpfs}
             * @param tmpfs The container path, mount options, and size (in MiB) of the tmpfs mount.
             *              This parameter maps to the <code>--tmpfs</code> option to docker run.
             *              <p>
             *              <blockquote>
             *              <p>
             *              If you're using tasks that use the Fargate launch type, the <code>tmpfs</code> parameter isn't supported.
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tmpfs(software.amazon.awscdk.IResolvable tmpfs) {
                this.tmpfs = tmpfs;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getTmpfs}
             * @param tmpfs The container path, mount options, and size (in MiB) of the tmpfs mount.
             *              This parameter maps to the <code>--tmpfs</code> option to docker run.
             *              <p>
             *              <blockquote>
             *              <p>
             *              If you're using tasks that use the Fargate launch type, the <code>tmpfs</code> parameter isn't supported.
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tmpfs(java.util.List<? extends java.lang.Object> tmpfs) {
                this.tmpfs = tmpfs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LinuxParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LinuxParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LinuxParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LinuxParametersProperty {
            private final java.lang.Object capabilities;
            private final java.lang.Object devices;
            private final java.lang.Object initProcessEnabled;
            private final java.lang.Number maxSwap;
            private final java.lang.Number sharedMemorySize;
            private final java.lang.Number swappiness;
            private final java.lang.Object tmpfs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.capabilities = software.amazon.jsii.Kernel.get(this, "capabilities", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.devices = software.amazon.jsii.Kernel.get(this, "devices", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.initProcessEnabled = software.amazon.jsii.Kernel.get(this, "initProcessEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxSwap = software.amazon.jsii.Kernel.get(this, "maxSwap", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sharedMemorySize = software.amazon.jsii.Kernel.get(this, "sharedMemorySize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.swappiness = software.amazon.jsii.Kernel.get(this, "swappiness", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.tmpfs = software.amazon.jsii.Kernel.get(this, "tmpfs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.capabilities = builder.capabilities;
                this.devices = builder.devices;
                this.initProcessEnabled = builder.initProcessEnabled;
                this.maxSwap = builder.maxSwap;
                this.sharedMemorySize = builder.sharedMemorySize;
                this.swappiness = builder.swappiness;
                this.tmpfs = builder.tmpfs;
            }

            @Override
            public final java.lang.Object getCapabilities() {
                return this.capabilities;
            }

            @Override
            public final java.lang.Object getDevices() {
                return this.devices;
            }

            @Override
            public final java.lang.Object getInitProcessEnabled() {
                return this.initProcessEnabled;
            }

            @Override
            public final java.lang.Number getMaxSwap() {
                return this.maxSwap;
            }

            @Override
            public final java.lang.Number getSharedMemorySize() {
                return this.sharedMemorySize;
            }

            @Override
            public final java.lang.Number getSwappiness() {
                return this.swappiness;
            }

            @Override
            public final java.lang.Object getTmpfs() {
                return this.tmpfs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCapabilities() != null) {
                    data.set("capabilities", om.valueToTree(this.getCapabilities()));
                }
                if (this.getDevices() != null) {
                    data.set("devices", om.valueToTree(this.getDevices()));
                }
                if (this.getInitProcessEnabled() != null) {
                    data.set("initProcessEnabled", om.valueToTree(this.getInitProcessEnabled()));
                }
                if (this.getMaxSwap() != null) {
                    data.set("maxSwap", om.valueToTree(this.getMaxSwap()));
                }
                if (this.getSharedMemorySize() != null) {
                    data.set("sharedMemorySize", om.valueToTree(this.getSharedMemorySize()));
                }
                if (this.getSwappiness() != null) {
                    data.set("swappiness", om.valueToTree(this.getSwappiness()));
                }
                if (this.getTmpfs() != null) {
                    data.set("tmpfs", om.valueToTree(this.getTmpfs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.LinuxParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LinuxParametersProperty.Jsii$Proxy that = (LinuxParametersProperty.Jsii$Proxy) o;

                if (this.capabilities != null ? !this.capabilities.equals(that.capabilities) : that.capabilities != null) return false;
                if (this.devices != null ? !this.devices.equals(that.devices) : that.devices != null) return false;
                if (this.initProcessEnabled != null ? !this.initProcessEnabled.equals(that.initProcessEnabled) : that.initProcessEnabled != null) return false;
                if (this.maxSwap != null ? !this.maxSwap.equals(that.maxSwap) : that.maxSwap != null) return false;
                if (this.sharedMemorySize != null ? !this.sharedMemorySize.equals(that.sharedMemorySize) : that.sharedMemorySize != null) return false;
                if (this.swappiness != null ? !this.swappiness.equals(that.swappiness) : that.swappiness != null) return false;
                return this.tmpfs != null ? this.tmpfs.equals(that.tmpfs) : that.tmpfs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.capabilities != null ? this.capabilities.hashCode() : 0;
                result = 31 * result + (this.devices != null ? this.devices.hashCode() : 0);
                result = 31 * result + (this.initProcessEnabled != null ? this.initProcessEnabled.hashCode() : 0);
                result = 31 * result + (this.maxSwap != null ? this.maxSwap.hashCode() : 0);
                result = 31 * result + (this.sharedMemorySize != null ? this.sharedMemorySize.hashCode() : 0);
                result = 31 * result + (this.swappiness != null ? this.swappiness.hashCode() : 0);
                result = 31 * result + (this.tmpfs != null ? this.tmpfs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>LogConfiguration</code> property specifies log configuration options to send to a custom log driver for the container.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * LogConfigurationProperty logConfigurationProperty = LogConfigurationProperty.builder()
     *         .logDriver("logDriver")
     *         // the properties below are optional
     *         .options(Map.of(
     *                 "optionsKey", "options"))
     *         .secretOptions(List.of(SecretProperty.builder()
     *                 .name("name")
     *                 .valueFrom("valueFrom")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-logconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-logconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.LogConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LogConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The log driver to use for the container.
         * <p>
         * For tasks on AWS Fargate , the supported log drivers are <code>awslogs</code> , <code>splunk</code> , and <code>awsfirelens</code> .
         * <p>
         * For tasks hosted on Amazon EC2 instances, the supported log drivers are <code>awslogs</code> , <code>fluentd</code> , <code>gelf</code> , <code>json-file</code> , <code>journald</code> , <code>syslog</code> , <code>splunk</code> , and <code>awsfirelens</code> .
         * <p>
         * For more information about using the <code>awslogs</code> log driver, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html">Send Amazon ECS logs to CloudWatch</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * For more information about using the <code>awsfirelens</code> log driver, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Send Amazon ECS logs to an AWS service or AWS Partner</a> .
         * <p>
         * <blockquote>
         * <p>
         * If you have a custom driver that isn't listed, you can fork the Amazon ECS container agent project that's <a href="https://docs.aws.amazon.com/https://github.com/aws/amazon-ecs-agent">available on GitHub</a> and customize it to work with that driver. We encourage you to submit pull requests for changes that you would like to have included. However, we don't currently provide support for running modified copies of this software.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-logconfiguration.html#cfn-ecs-taskdefinition-logconfiguration-logdriver">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-logconfiguration.html#cfn-ecs-taskdefinition-logconfiguration-logdriver</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogDriver();

        /**
         * The configuration options to send to the log driver.
         * <p>
         * The options you can specify depend on the log driver. Some of the options you can specify when you use the <code>awslogs</code> log driver to route logs to Amazon CloudWatch include the following:
         * <p>
         * <ul>
         * <li><strong>awslogs-create-group</strong> - Required: No</li>
         * </ul>
         * <p>
         * Specify whether you want the log group to be created automatically. If this option isn't specified, it defaults to <code>false</code> .
         * <p>
         * <blockquote>
         * <p>
         * Your IAM policy must include the <code>logs:CreateLogGroup</code> permission before you attempt to use <code>awslogs-create-group</code> .
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><strong>awslogs-region</strong> - Required: Yes</li>
         * </ul>
         * <p>
         * Specify the AWS Region that the <code>awslogs</code> log driver is to send your Docker logs to. You can choose to send all of your logs from clusters in different Regions to a single region in CloudWatch Logs. This is so that they're all visible in one location. Otherwise, you can separate them by Region for more granularity. Make sure that the specified log group exists in the Region that you specify with this option.
         * <p>
         * <ul>
         * <li><strong>awslogs-group</strong> - Required: Yes</li>
         * </ul>
         * <p>
         * Make sure to specify a log group that the <code>awslogs</code> log driver sends its log streams to.
         * <p>
         * <ul>
         * <li><strong>awslogs-stream-prefix</strong> - Required: Yes, when using Fargate.Optional when using EC2.</li>
         * </ul>
         * <p>
         * Use the <code>awslogs-stream-prefix</code> option to associate a log stream with the specified prefix, the container name, and the ID of the Amazon ECS task that the container belongs to. If you specify a prefix with this option, then the log stream takes the format <code>prefix-name/container-name/ecs-task-id</code> .
         * <p>
         * If you don't specify a prefix with this option, then the log stream is named after the container ID that's assigned by the Docker daemon on the container instance. Because it's difficult to trace logs back to the container that sent them with just the Docker container ID (which is only available on the container instance), we recommend that you specify a prefix with this option.
         * <p>
         * For Amazon ECS services, you can use the service name as the prefix. Doing so, you can trace log streams to the service that the container belongs to, the name of the container that sent them, and the ID of the task that the container belongs to.
         * <p>
         * You must specify a stream-prefix for your logs to have your logs appear in the Log pane when using the Amazon ECS console.
         * <p>
         * <ul>
         * <li><strong>awslogs-datetime-format</strong> - Required: No</li>
         * </ul>
         * <p>
         * This option defines a multiline start pattern in Python <code>strftime</code> format. A log message consists of a line that matches the pattern and any following lines that don’t match the pattern. The matched line is the delimiter between log messages.
         * <p>
         * One example of a use case for using this format is for parsing output such as a stack dump, which might otherwise be logged in multiple entries. The correct pattern allows it to be captured in a single entry.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/awslogs/#awslogs-datetime-format">awslogs-datetime-format</a> .
         * <p>
         * You cannot configure both the <code>awslogs-datetime-format</code> and <code>awslogs-multiline-pattern</code> options.
         * <p>
         * <blockquote>
         * <p>
         * Multiline logging performs regular expression parsing and matching of all log messages. This might have a negative impact on logging performance.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><strong>awslogs-multiline-pattern</strong> - Required: No</li>
         * </ul>
         * <p>
         * This option defines a multiline start pattern that uses a regular expression. A log message consists of a line that matches the pattern and any following lines that don’t match the pattern. The matched line is the delimiter between log messages.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/awslogs/#awslogs-multiline-pattern">awslogs-multiline-pattern</a> .
         * <p>
         * This option is ignored if <code>awslogs-datetime-format</code> is also configured.
         * <p>
         * You cannot configure both the <code>awslogs-datetime-format</code> and <code>awslogs-multiline-pattern</code> options.
         * <p>
         * <blockquote>
         * <p>
         * Multiline logging performs regular expression parsing and matching of all log messages. This might have a negative impact on logging performance.
         * <p>
         * </blockquote>
         * <p>
         * The following options apply to all supported log drivers.
         * <p>
         * <ul>
         * <li><strong>mode</strong> - Required: No</li>
         * </ul>
         * <p>
         * Valid values: <code>non-blocking</code> | <code>blocking</code>
         * <p>
         * This option defines the delivery mode of log messages from the container to the log driver specified using <code>logDriver</code> . The delivery mode you choose affects application availability when the flow of logs from container is interrupted.
         * <p>
         * If you use the <code>blocking</code> mode and the flow of logs is interrupted, calls from container code to write to the <code>stdout</code> and <code>stderr</code> streams will block. The logging thread of the application will block as a result. This may cause the application to become unresponsive and lead to container healthcheck failure.
         * <p>
         * If you use the <code>non-blocking</code> mode, the container's logs are instead stored in an in-memory intermediate buffer configured with the <code>max-buffer-size</code> option. This prevents the application from becoming unresponsive when logs cannot be sent. We recommend using this mode if you want to ensure service availability and are okay with some log loss. For more information, see <a href="https://docs.aws.amazon.com/containers/preventing-log-loss-with-non-blocking-mode-in-the-awslogs-container-log-driver/">Preventing log loss with non-blocking mode in the <code>awslogs</code> container log driver</a> .
         * <p>
         * You can set a default <code>mode</code> for all containers in a specific AWS Region by using the <code>defaultLogDriverMode</code> account setting. If you don't specify the <code>mode</code> option or configure the account setting, Amazon ECS will default to the <code>blocking</code> mode. For more information about the account setting, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#default-log-driver-mode">Default log driver mode</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * On June 25, 2025, Amazon ECS is changing the default log driver mode from <code>blocking</code> to <code>non-blocking</code> to prioritize task availability over logging. To continue using the <code>blocking</code> mode after this change, do one of the following:
         * <p>
         * <ul>
         * <li>Set the <code>mode</code> option in your container definition's <code>logConfiguration</code> as <code>blocking</code> .</li>
         * <li>Set the <code>defaultLogDriverMode</code> account setting to <code>blocking</code> .</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><strong>max-buffer-size</strong> - Required: No</li>
         * </ul>
         * <p>
         * Default value: <code>1m</code>
         * <p>
         * When <code>non-blocking</code> mode is used, the <code>max-buffer-size</code> log option controls the size of the buffer that's used for intermediate message storage. Make sure to specify an adequate buffer size based on your application. When the buffer fills up, further logs cannot be stored. Logs that cannot be stored are lost.
         * <p>
         * To route logs using the <code>splunk</code> log router, you need to specify a <code>splunk-token</code> and a <code>splunk-url</code> .
         * <p>
         * When you use the <code>awsfirelens</code> log router to route logs to an AWS Service or AWS Partner Network destination for log storage and analytics, you can set the <code>log-driver-buffer-limit</code> option to limit the number of events that are buffered in memory, before being sent to the log router container. It can help to resolve potential log loss issue because high throughput might result in memory running out for the buffer inside of Docker.
         * <p>
         * Other options you can specify when using <code>awsfirelens</code> to route logs depend on the destination. When you export logs to Amazon Data Firehose, you can specify the AWS Region with <code>region</code> and a name for the log stream with <code>delivery_stream</code> .
         * <p>
         * When you export logs to Amazon Kinesis Data Streams, you can specify an AWS Region with <code>region</code> and a data stream name with <code>stream</code> .
         * <p>
         * When you export logs to Amazon OpenSearch Service, you can specify options like <code>Name</code> , <code>Host</code> (OpenSearch Service endpoint without protocol), <code>Port</code> , <code>Index</code> , <code>Type</code> , <code>Aws_auth</code> , <code>Aws_region</code> , <code>Suppress_Type_Name</code> , and <code>tls</code> . For more information, see <a href="https://docs.aws.amazon.com/containers/under-the-hood-firelens-for-amazon-ecs-tasks/">Under the hood: FireLens for Amazon ECS Tasks</a> .
         * <p>
         * When you export logs to Amazon S3, you can specify the bucket using the <code>bucket</code> option. You can also specify <code>region</code> , <code>total_file_size</code> , <code>upload_timeout</code> , and <code>use_put_object</code> as options.
         * <p>
         * This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-logconfiguration.html#cfn-ecs-taskdefinition-logconfiguration-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-logconfiguration.html#cfn-ecs-taskdefinition-logconfiguration-options</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOptions() {
            return null;
        }

        /**
         * The secrets to pass to the log configuration.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-logconfiguration.html#cfn-ecs-taskdefinition-logconfiguration-secretoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-logconfiguration.html#cfn-ecs-taskdefinition-logconfiguration-secretoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecretOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogConfigurationProperty> {
            java.lang.String logDriver;
            java.lang.Object options;
            java.lang.Object secretOptions;

            /**
             * Sets the value of {@link LogConfigurationProperty#getLogDriver}
             * @param logDriver The log driver to use for the container. This parameter is required.
             *                  For tasks on AWS Fargate , the supported log drivers are <code>awslogs</code> , <code>splunk</code> , and <code>awsfirelens</code> .
             *                  <p>
             *                  For tasks hosted on Amazon EC2 instances, the supported log drivers are <code>awslogs</code> , <code>fluentd</code> , <code>gelf</code> , <code>json-file</code> , <code>journald</code> , <code>syslog</code> , <code>splunk</code> , and <code>awsfirelens</code> .
             *                  <p>
             *                  For more information about using the <code>awslogs</code> log driver, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html">Send Amazon ECS logs to CloudWatch</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                  <p>
             *                  For more information about using the <code>awsfirelens</code> log driver, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Send Amazon ECS logs to an AWS service or AWS Partner</a> .
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  If you have a custom driver that isn't listed, you can fork the Amazon ECS container agent project that's <a href="https://docs.aws.amazon.com/https://github.com/aws/amazon-ecs-agent">available on GitHub</a> and customize it to work with that driver. We encourage you to submit pull requests for changes that you would like to have included. However, we don't currently provide support for running modified copies of this software.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logDriver(java.lang.String logDriver) {
                this.logDriver = logDriver;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigurationProperty#getOptions}
             * @param options The configuration options to send to the log driver.
             *                The options you can specify depend on the log driver. Some of the options you can specify when you use the <code>awslogs</code> log driver to route logs to Amazon CloudWatch include the following:
             *                <p>
             *                <ul>
             *                <li><strong>awslogs-create-group</strong> - Required: No</li>
             *                </ul>
             *                <p>
             *                Specify whether you want the log group to be created automatically. If this option isn't specified, it defaults to <code>false</code> .
             *                <p>
             *                <blockquote>
             *                <p>
             *                Your IAM policy must include the <code>logs:CreateLogGroup</code> permission before you attempt to use <code>awslogs-create-group</code> .
             *                <p>
             *                </blockquote>
             *                <p>
             *                <ul>
             *                <li><strong>awslogs-region</strong> - Required: Yes</li>
             *                </ul>
             *                <p>
             *                Specify the AWS Region that the <code>awslogs</code> log driver is to send your Docker logs to. You can choose to send all of your logs from clusters in different Regions to a single region in CloudWatch Logs. This is so that they're all visible in one location. Otherwise, you can separate them by Region for more granularity. Make sure that the specified log group exists in the Region that you specify with this option.
             *                <p>
             *                <ul>
             *                <li><strong>awslogs-group</strong> - Required: Yes</li>
             *                </ul>
             *                <p>
             *                Make sure to specify a log group that the <code>awslogs</code> log driver sends its log streams to.
             *                <p>
             *                <ul>
             *                <li><strong>awslogs-stream-prefix</strong> - Required: Yes, when using Fargate.Optional when using EC2.</li>
             *                </ul>
             *                <p>
             *                Use the <code>awslogs-stream-prefix</code> option to associate a log stream with the specified prefix, the container name, and the ID of the Amazon ECS task that the container belongs to. If you specify a prefix with this option, then the log stream takes the format <code>prefix-name/container-name/ecs-task-id</code> .
             *                <p>
             *                If you don't specify a prefix with this option, then the log stream is named after the container ID that's assigned by the Docker daemon on the container instance. Because it's difficult to trace logs back to the container that sent them with just the Docker container ID (which is only available on the container instance), we recommend that you specify a prefix with this option.
             *                <p>
             *                For Amazon ECS services, you can use the service name as the prefix. Doing so, you can trace log streams to the service that the container belongs to, the name of the container that sent them, and the ID of the task that the container belongs to.
             *                <p>
             *                You must specify a stream-prefix for your logs to have your logs appear in the Log pane when using the Amazon ECS console.
             *                <p>
             *                <ul>
             *                <li><strong>awslogs-datetime-format</strong> - Required: No</li>
             *                </ul>
             *                <p>
             *                This option defines a multiline start pattern in Python <code>strftime</code> format. A log message consists of a line that matches the pattern and any following lines that don’t match the pattern. The matched line is the delimiter between log messages.
             *                <p>
             *                One example of a use case for using this format is for parsing output such as a stack dump, which might otherwise be logged in multiple entries. The correct pattern allows it to be captured in a single entry.
             *                <p>
             *                For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/awslogs/#awslogs-datetime-format">awslogs-datetime-format</a> .
             *                <p>
             *                You cannot configure both the <code>awslogs-datetime-format</code> and <code>awslogs-multiline-pattern</code> options.
             *                <p>
             *                <blockquote>
             *                <p>
             *                Multiline logging performs regular expression parsing and matching of all log messages. This might have a negative impact on logging performance.
             *                <p>
             *                </blockquote>
             *                <p>
             *                <ul>
             *                <li><strong>awslogs-multiline-pattern</strong> - Required: No</li>
             *                </ul>
             *                <p>
             *                This option defines a multiline start pattern that uses a regular expression. A log message consists of a line that matches the pattern and any following lines that don’t match the pattern. The matched line is the delimiter between log messages.
             *                <p>
             *                For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/awslogs/#awslogs-multiline-pattern">awslogs-multiline-pattern</a> .
             *                <p>
             *                This option is ignored if <code>awslogs-datetime-format</code> is also configured.
             *                <p>
             *                You cannot configure both the <code>awslogs-datetime-format</code> and <code>awslogs-multiline-pattern</code> options.
             *                <p>
             *                <blockquote>
             *                <p>
             *                Multiline logging performs regular expression parsing and matching of all log messages. This might have a negative impact on logging performance.
             *                <p>
             *                </blockquote>
             *                <p>
             *                The following options apply to all supported log drivers.
             *                <p>
             *                <ul>
             *                <li><strong>mode</strong> - Required: No</li>
             *                </ul>
             *                <p>
             *                Valid values: <code>non-blocking</code> | <code>blocking</code>
             *                <p>
             *                This option defines the delivery mode of log messages from the container to the log driver specified using <code>logDriver</code> . The delivery mode you choose affects application availability when the flow of logs from container is interrupted.
             *                <p>
             *                If you use the <code>blocking</code> mode and the flow of logs is interrupted, calls from container code to write to the <code>stdout</code> and <code>stderr</code> streams will block. The logging thread of the application will block as a result. This may cause the application to become unresponsive and lead to container healthcheck failure.
             *                <p>
             *                If you use the <code>non-blocking</code> mode, the container's logs are instead stored in an in-memory intermediate buffer configured with the <code>max-buffer-size</code> option. This prevents the application from becoming unresponsive when logs cannot be sent. We recommend using this mode if you want to ensure service availability and are okay with some log loss. For more information, see <a href="https://docs.aws.amazon.com/containers/preventing-log-loss-with-non-blocking-mode-in-the-awslogs-container-log-driver/">Preventing log loss with non-blocking mode in the <code>awslogs</code> container log driver</a> .
             *                <p>
             *                You can set a default <code>mode</code> for all containers in a specific AWS Region by using the <code>defaultLogDriverMode</code> account setting. If you don't specify the <code>mode</code> option or configure the account setting, Amazon ECS will default to the <code>blocking</code> mode. For more information about the account setting, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#default-log-driver-mode">Default log driver mode</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                <p>
             *                <blockquote>
             *                <p>
             *                On June 25, 2025, Amazon ECS is changing the default log driver mode from <code>blocking</code> to <code>non-blocking</code> to prioritize task availability over logging. To continue using the <code>blocking</code> mode after this change, do one of the following:
             *                <p>
             *                <ul>
             *                <li>Set the <code>mode</code> option in your container definition's <code>logConfiguration</code> as <code>blocking</code> .</li>
             *                <li>Set the <code>defaultLogDriverMode</code> account setting to <code>blocking</code> .</li>
             *                </ul>
             *                <p>
             *                </blockquote>
             *                <p>
             *                <ul>
             *                <li><strong>max-buffer-size</strong> - Required: No</li>
             *                </ul>
             *                <p>
             *                Default value: <code>1m</code>
             *                <p>
             *                When <code>non-blocking</code> mode is used, the <code>max-buffer-size</code> log option controls the size of the buffer that's used for intermediate message storage. Make sure to specify an adequate buffer size based on your application. When the buffer fills up, further logs cannot be stored. Logs that cannot be stored are lost.
             *                <p>
             *                To route logs using the <code>splunk</code> log router, you need to specify a <code>splunk-token</code> and a <code>splunk-url</code> .
             *                <p>
             *                When you use the <code>awsfirelens</code> log router to route logs to an AWS Service or AWS Partner Network destination for log storage and analytics, you can set the <code>log-driver-buffer-limit</code> option to limit the number of events that are buffered in memory, before being sent to the log router container. It can help to resolve potential log loss issue because high throughput might result in memory running out for the buffer inside of Docker.
             *                <p>
             *                Other options you can specify when using <code>awsfirelens</code> to route logs depend on the destination. When you export logs to Amazon Data Firehose, you can specify the AWS Region with <code>region</code> and a name for the log stream with <code>delivery_stream</code> .
             *                <p>
             *                When you export logs to Amazon Kinesis Data Streams, you can specify an AWS Region with <code>region</code> and a data stream name with <code>stream</code> .
             *                <p>
             *                When you export logs to Amazon OpenSearch Service, you can specify options like <code>Name</code> , <code>Host</code> (OpenSearch Service endpoint without protocol), <code>Port</code> , <code>Index</code> , <code>Type</code> , <code>Aws_auth</code> , <code>Aws_region</code> , <code>Suppress_Type_Name</code> , and <code>tls</code> . For more information, see <a href="https://docs.aws.amazon.com/containers/under-the-hood-firelens-for-amazon-ecs-tasks/">Under the hood: FireLens for Amazon ECS Tasks</a> .
             *                <p>
             *                When you export logs to Amazon S3, you can specify the bucket using the <code>bucket</code> option. You can also specify <code>region</code> , <code>total_file_size</code> , <code>upload_timeout</code> , and <code>use_put_object</code> as options.
             *                <p>
             *                This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(java.util.Map<java.lang.String, java.lang.String> options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigurationProperty#getOptions}
             * @param options The configuration options to send to the log driver.
             *                The options you can specify depend on the log driver. Some of the options you can specify when you use the <code>awslogs</code> log driver to route logs to Amazon CloudWatch include the following:
             *                <p>
             *                <ul>
             *                <li><strong>awslogs-create-group</strong> - Required: No</li>
             *                </ul>
             *                <p>
             *                Specify whether you want the log group to be created automatically. If this option isn't specified, it defaults to <code>false</code> .
             *                <p>
             *                <blockquote>
             *                <p>
             *                Your IAM policy must include the <code>logs:CreateLogGroup</code> permission before you attempt to use <code>awslogs-create-group</code> .
             *                <p>
             *                </blockquote>
             *                <p>
             *                <ul>
             *                <li><strong>awslogs-region</strong> - Required: Yes</li>
             *                </ul>
             *                <p>
             *                Specify the AWS Region that the <code>awslogs</code> log driver is to send your Docker logs to. You can choose to send all of your logs from clusters in different Regions to a single region in CloudWatch Logs. This is so that they're all visible in one location. Otherwise, you can separate them by Region for more granularity. Make sure that the specified log group exists in the Region that you specify with this option.
             *                <p>
             *                <ul>
             *                <li><strong>awslogs-group</strong> - Required: Yes</li>
             *                </ul>
             *                <p>
             *                Make sure to specify a log group that the <code>awslogs</code> log driver sends its log streams to.
             *                <p>
             *                <ul>
             *                <li><strong>awslogs-stream-prefix</strong> - Required: Yes, when using Fargate.Optional when using EC2.</li>
             *                </ul>
             *                <p>
             *                Use the <code>awslogs-stream-prefix</code> option to associate a log stream with the specified prefix, the container name, and the ID of the Amazon ECS task that the container belongs to. If you specify a prefix with this option, then the log stream takes the format <code>prefix-name/container-name/ecs-task-id</code> .
             *                <p>
             *                If you don't specify a prefix with this option, then the log stream is named after the container ID that's assigned by the Docker daemon on the container instance. Because it's difficult to trace logs back to the container that sent them with just the Docker container ID (which is only available on the container instance), we recommend that you specify a prefix with this option.
             *                <p>
             *                For Amazon ECS services, you can use the service name as the prefix. Doing so, you can trace log streams to the service that the container belongs to, the name of the container that sent them, and the ID of the task that the container belongs to.
             *                <p>
             *                You must specify a stream-prefix for your logs to have your logs appear in the Log pane when using the Amazon ECS console.
             *                <p>
             *                <ul>
             *                <li><strong>awslogs-datetime-format</strong> - Required: No</li>
             *                </ul>
             *                <p>
             *                This option defines a multiline start pattern in Python <code>strftime</code> format. A log message consists of a line that matches the pattern and any following lines that don’t match the pattern. The matched line is the delimiter between log messages.
             *                <p>
             *                One example of a use case for using this format is for parsing output such as a stack dump, which might otherwise be logged in multiple entries. The correct pattern allows it to be captured in a single entry.
             *                <p>
             *                For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/awslogs/#awslogs-datetime-format">awslogs-datetime-format</a> .
             *                <p>
             *                You cannot configure both the <code>awslogs-datetime-format</code> and <code>awslogs-multiline-pattern</code> options.
             *                <p>
             *                <blockquote>
             *                <p>
             *                Multiline logging performs regular expression parsing and matching of all log messages. This might have a negative impact on logging performance.
             *                <p>
             *                </blockquote>
             *                <p>
             *                <ul>
             *                <li><strong>awslogs-multiline-pattern</strong> - Required: No</li>
             *                </ul>
             *                <p>
             *                This option defines a multiline start pattern that uses a regular expression. A log message consists of a line that matches the pattern and any following lines that don’t match the pattern. The matched line is the delimiter between log messages.
             *                <p>
             *                For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/awslogs/#awslogs-multiline-pattern">awslogs-multiline-pattern</a> .
             *                <p>
             *                This option is ignored if <code>awslogs-datetime-format</code> is also configured.
             *                <p>
             *                You cannot configure both the <code>awslogs-datetime-format</code> and <code>awslogs-multiline-pattern</code> options.
             *                <p>
             *                <blockquote>
             *                <p>
             *                Multiline logging performs regular expression parsing and matching of all log messages. This might have a negative impact on logging performance.
             *                <p>
             *                </blockquote>
             *                <p>
             *                The following options apply to all supported log drivers.
             *                <p>
             *                <ul>
             *                <li><strong>mode</strong> - Required: No</li>
             *                </ul>
             *                <p>
             *                Valid values: <code>non-blocking</code> | <code>blocking</code>
             *                <p>
             *                This option defines the delivery mode of log messages from the container to the log driver specified using <code>logDriver</code> . The delivery mode you choose affects application availability when the flow of logs from container is interrupted.
             *                <p>
             *                If you use the <code>blocking</code> mode and the flow of logs is interrupted, calls from container code to write to the <code>stdout</code> and <code>stderr</code> streams will block. The logging thread of the application will block as a result. This may cause the application to become unresponsive and lead to container healthcheck failure.
             *                <p>
             *                If you use the <code>non-blocking</code> mode, the container's logs are instead stored in an in-memory intermediate buffer configured with the <code>max-buffer-size</code> option. This prevents the application from becoming unresponsive when logs cannot be sent. We recommend using this mode if you want to ensure service availability and are okay with some log loss. For more information, see <a href="https://docs.aws.amazon.com/containers/preventing-log-loss-with-non-blocking-mode-in-the-awslogs-container-log-driver/">Preventing log loss with non-blocking mode in the <code>awslogs</code> container log driver</a> .
             *                <p>
             *                You can set a default <code>mode</code> for all containers in a specific AWS Region by using the <code>defaultLogDriverMode</code> account setting. If you don't specify the <code>mode</code> option or configure the account setting, Amazon ECS will default to the <code>blocking</code> mode. For more information about the account setting, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#default-log-driver-mode">Default log driver mode</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                <p>
             *                <blockquote>
             *                <p>
             *                On June 25, 2025, Amazon ECS is changing the default log driver mode from <code>blocking</code> to <code>non-blocking</code> to prioritize task availability over logging. To continue using the <code>blocking</code> mode after this change, do one of the following:
             *                <p>
             *                <ul>
             *                <li>Set the <code>mode</code> option in your container definition's <code>logConfiguration</code> as <code>blocking</code> .</li>
             *                <li>Set the <code>defaultLogDriverMode</code> account setting to <code>blocking</code> .</li>
             *                </ul>
             *                <p>
             *                </blockquote>
             *                <p>
             *                <ul>
             *                <li><strong>max-buffer-size</strong> - Required: No</li>
             *                </ul>
             *                <p>
             *                Default value: <code>1m</code>
             *                <p>
             *                When <code>non-blocking</code> mode is used, the <code>max-buffer-size</code> log option controls the size of the buffer that's used for intermediate message storage. Make sure to specify an adequate buffer size based on your application. When the buffer fills up, further logs cannot be stored. Logs that cannot be stored are lost.
             *                <p>
             *                To route logs using the <code>splunk</code> log router, you need to specify a <code>splunk-token</code> and a <code>splunk-url</code> .
             *                <p>
             *                When you use the <code>awsfirelens</code> log router to route logs to an AWS Service or AWS Partner Network destination for log storage and analytics, you can set the <code>log-driver-buffer-limit</code> option to limit the number of events that are buffered in memory, before being sent to the log router container. It can help to resolve potential log loss issue because high throughput might result in memory running out for the buffer inside of Docker.
             *                <p>
             *                Other options you can specify when using <code>awsfirelens</code> to route logs depend on the destination. When you export logs to Amazon Data Firehose, you can specify the AWS Region with <code>region</code> and a name for the log stream with <code>delivery_stream</code> .
             *                <p>
             *                When you export logs to Amazon Kinesis Data Streams, you can specify an AWS Region with <code>region</code> and a data stream name with <code>stream</code> .
             *                <p>
             *                When you export logs to Amazon OpenSearch Service, you can specify options like <code>Name</code> , <code>Host</code> (OpenSearch Service endpoint without protocol), <code>Port</code> , <code>Index</code> , <code>Type</code> , <code>Aws_auth</code> , <code>Aws_region</code> , <code>Suppress_Type_Name</code> , and <code>tls</code> . For more information, see <a href="https://docs.aws.amazon.com/containers/under-the-hood-firelens-for-amazon-ecs-tasks/">Under the hood: FireLens for Amazon ECS Tasks</a> .
             *                <p>
             *                When you export logs to Amazon S3, you can specify the bucket using the <code>bucket</code> option. You can also specify <code>region</code> , <code>total_file_size</code> , <code>upload_timeout</code> , and <code>use_put_object</code> as options.
             *                <p>
             *                This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(software.amazon.awscdk.IResolvable options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigurationProperty#getSecretOptions}
             * @param secretOptions The secrets to pass to the log configuration.
             *                      For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretOptions(software.amazon.awscdk.IResolvable secretOptions) {
                this.secretOptions = secretOptions;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigurationProperty#getSecretOptions}
             * @param secretOptions The secrets to pass to the log configuration.
             *                      For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretOptions(java.util.List<? extends java.lang.Object> secretOptions) {
                this.secretOptions = secretOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogConfigurationProperty {
            private final java.lang.String logDriver;
            private final java.lang.Object options;
            private final java.lang.Object secretOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logDriver = software.amazon.jsii.Kernel.get(this, "logDriver", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secretOptions = software.amazon.jsii.Kernel.get(this, "secretOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logDriver = java.util.Objects.requireNonNull(builder.logDriver, "logDriver is required");
                this.options = builder.options;
                this.secretOptions = builder.secretOptions;
            }

            @Override
            public final java.lang.String getLogDriver() {
                return this.logDriver;
            }

            @Override
            public final java.lang.Object getOptions() {
                return this.options;
            }

            @Override
            public final java.lang.Object getSecretOptions() {
                return this.secretOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logDriver", om.valueToTree(this.getLogDriver()));
                if (this.getOptions() != null) {
                    data.set("options", om.valueToTree(this.getOptions()));
                }
                if (this.getSecretOptions() != null) {
                    data.set("secretOptions", om.valueToTree(this.getSecretOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.LogConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogConfigurationProperty.Jsii$Proxy that = (LogConfigurationProperty.Jsii$Proxy) o;

                if (!logDriver.equals(that.logDriver)) return false;
                if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
                return this.secretOptions != null ? this.secretOptions.equals(that.secretOptions) : that.secretOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.logDriver.hashCode();
                result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
                result = 31 * result + (this.secretOptions != null ? this.secretOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The details for a volume mount point that's used in a container definition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * MountPointProperty mountPointProperty = MountPointProperty.builder()
     *         .containerPath("containerPath")
     *         .readOnly(false)
     *         .sourceVolume("sourceVolume")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-mountpoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-mountpoint.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.MountPointProperty")
    @software.amazon.jsii.Jsii.Proxy(MountPointProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MountPointProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The path on the container to mount the host volume at.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-mountpoint.html#cfn-ecs-taskdefinition-mountpoint-containerpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-mountpoint.html#cfn-ecs-taskdefinition-mountpoint-containerpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainerPath() {
            return null;
        }

        /**
         * If this value is <code>true</code> , the container has read-only access to the volume.
         * <p>
         * If this value is <code>false</code> , then the container can write to the volume. The default value is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-mountpoint.html#cfn-ecs-taskdefinition-mountpoint-readonly">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-mountpoint.html#cfn-ecs-taskdefinition-mountpoint-readonly</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadOnly() {
            return null;
        }

        /**
         * The name of the volume to mount.
         * <p>
         * Must be a volume name referenced in the <code>name</code> parameter of task definition <code>volume</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-mountpoint.html#cfn-ecs-taskdefinition-mountpoint-sourcevolume">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-mountpoint.html#cfn-ecs-taskdefinition-mountpoint-sourcevolume</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceVolume() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MountPointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MountPointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MountPointProperty> {
            java.lang.String containerPath;
            java.lang.Object readOnly;
            java.lang.String sourceVolume;

            /**
             * Sets the value of {@link MountPointProperty#getContainerPath}
             * @param containerPath The path on the container to mount the host volume at.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPath(java.lang.String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            /**
             * Sets the value of {@link MountPointProperty#getReadOnly}
             * @param readOnly If this value is <code>true</code> , the container has read-only access to the volume.
             *                 If this value is <code>false</code> , then the container can write to the volume. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(java.lang.Boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link MountPointProperty#getReadOnly}
             * @param readOnly If this value is <code>true</code> , the container has read-only access to the volume.
             *                 If this value is <code>false</code> , then the container can write to the volume. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(software.amazon.awscdk.IResolvable readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link MountPointProperty#getSourceVolume}
             * @param sourceVolume The name of the volume to mount.
             *                     Must be a volume name referenced in the <code>name</code> parameter of task definition <code>volume</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceVolume(java.lang.String sourceVolume) {
                this.sourceVolume = sourceVolume;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MountPointProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MountPointProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MountPointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MountPointProperty {
            private final java.lang.String containerPath;
            private final java.lang.Object readOnly;
            private final java.lang.String sourceVolume;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerPath = software.amazon.jsii.Kernel.get(this, "containerPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.readOnly = software.amazon.jsii.Kernel.get(this, "readOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceVolume = software.amazon.jsii.Kernel.get(this, "sourceVolume", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerPath = builder.containerPath;
                this.readOnly = builder.readOnly;
                this.sourceVolume = builder.sourceVolume;
            }

            @Override
            public final java.lang.String getContainerPath() {
                return this.containerPath;
            }

            @Override
            public final java.lang.Object getReadOnly() {
                return this.readOnly;
            }

            @Override
            public final java.lang.String getSourceVolume() {
                return this.sourceVolume;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerPath() != null) {
                    data.set("containerPath", om.valueToTree(this.getContainerPath()));
                }
                if (this.getReadOnly() != null) {
                    data.set("readOnly", om.valueToTree(this.getReadOnly()));
                }
                if (this.getSourceVolume() != null) {
                    data.set("sourceVolume", om.valueToTree(this.getSourceVolume()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.MountPointProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MountPointProperty.Jsii$Proxy that = (MountPointProperty.Jsii$Proxy) o;

                if (this.containerPath != null ? !this.containerPath.equals(that.containerPath) : that.containerPath != null) return false;
                if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) return false;
                return this.sourceVolume != null ? this.sourceVolume.equals(that.sourceVolume) : that.sourceVolume == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerPath != null ? this.containerPath.hashCode() : 0;
                result = 31 * result + (this.readOnly != null ? this.readOnly.hashCode() : 0);
                result = 31 * result + (this.sourceVolume != null ? this.sourceVolume.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>PortMapping</code> property specifies a port mapping.
     * <p>
     * Port mappings allow containers to access ports on the host container instance to send or receive traffic. Port mappings are specified as part of the container definition.
     * <p>
     * If you are using containers in a task with the <code>awsvpc</code> or <code>host</code> network mode, exposed ports should be specified using <code>containerPort</code> . The <code>hostPort</code> can be left blank or it must be the same value as the <code>containerPort</code> .
     * <p>
     * After a task reaches the <code>RUNNING</code> status, manual and automatic host and container port assignments are visible in the <code>networkBindings</code> section of <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTasks.html">DescribeTasks</a> API responses.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * PortMappingProperty portMappingProperty = PortMappingProperty.builder()
     *         .appProtocol("appProtocol")
     *         .containerPort(123)
     *         .containerPortRange("containerPortRange")
     *         .hostPort(123)
     *         .name("name")
     *         .protocol("protocol")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-portmapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-portmapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.PortMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(PortMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PortMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The application protocol that's used for the port mapping.
         * <p>
         * This parameter only applies to Service Connect. We recommend that you set this parameter to be consistent with the protocol that your application uses. If you set this parameter, Amazon ECS adds protocol-specific connection handling to the Service Connect proxy. If you set this parameter, Amazon ECS adds protocol-specific telemetry in the Amazon ECS console and CloudWatch.
         * <p>
         * If you don't set a value for this parameter, then TCP is used. However, Amazon ECS doesn't add protocol-specific telemetry for TCP.
         * <p>
         * <code>appProtocol</code> is immutable in a Service Connect service. Updating this field requires a service deletion and redeployment.
         * <p>
         * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-portmapping.html#cfn-ecs-taskdefinition-portmapping-appprotocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-portmapping.html#cfn-ecs-taskdefinition-portmapping-appprotocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAppProtocol() {
            return null;
        }

        /**
         * The port number on the container that's bound to the user-specified or automatically assigned host port.
         * <p>
         * If you use containers in a task with the <code>awsvpc</code> or <code>host</code> network mode, specify the exposed ports using <code>containerPort</code> .
         * <p>
         * If you use containers in a task with the <code>bridge</code> network mode and you specify a container port and not a host port, your container automatically receives a host port in the ephemeral port range. For more information, see <code>hostPort</code> . Port mappings that are automatically assigned in this way do not count toward the 100 reserved ports limit of a container instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-portmapping.html#cfn-ecs-taskdefinition-portmapping-containerport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-portmapping.html#cfn-ecs-taskdefinition-portmapping-containerport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getContainerPort() {
            return null;
        }

        /**
         * The port number range on the container that's bound to the dynamically mapped host port range.
         * <p>
         * The following rules apply when you specify a <code>containerPortRange</code> :
         * <p>
         * <ul>
         * <li>You must use either the <code>bridge</code> network mode or the <code>awsvpc</code> network mode.</li>
         * <li>This parameter is available for both the EC2 and AWS Fargate launch types.</li>
         * <li>This parameter is available for both the Linux and Windows operating systems.</li>
         * <li>The container instance must have at least version 1.67.0 of the container agent and at least version 1.67.0-1 of the <code>ecs-init</code> package</li>
         * <li>You can specify a maximum of 100 port ranges per container.</li>
         * <li>You do not specify a <code>hostPortRange</code> . The value of the <code>hostPortRange</code> is set as follows:</li>
         * <li>For containers in a task with the <code>awsvpc</code> network mode, the <code>hostPortRange</code> is set to the same value as the <code>containerPortRange</code> . This is a static mapping strategy.</li>
         * <li>For containers in a task with the <code>bridge</code> network mode, the Amazon ECS agent finds open host ports from the default ephemeral range and passes it to docker to bind them to the container ports.</li>
         * <li>The <code>containerPortRange</code> valid values are between 1 and 65535.</li>
         * <li>A port can only be included in one port mapping per container.</li>
         * <li>You cannot specify overlapping port ranges.</li>
         * <li>The first port in the range must be less than last port in the range.</li>
         * <li>Docker recommends that you turn off the docker-proxy in the Docker daemon config file when you have a large number of ports.</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://github.com/moby/moby/issues/11185">Issue #11185</a> on the Github website.
         * <p>
         * For information about how to turn off the docker-proxy in the Docker daemon config file, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/bootstrap_container_instance.html#bootstrap_docker_daemon">Docker daemon</a> in the <em>Amazon ECS Developer Guide</em> .
         * <p>
         * You can call <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTasks.html"><code>DescribeTasks</code></a> to view the <code>hostPortRange</code> which are the host ports that are bound to the container ports.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-portmapping.html#cfn-ecs-taskdefinition-portmapping-containerportrange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-portmapping.html#cfn-ecs-taskdefinition-portmapping-containerportrange</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainerPortRange() {
            return null;
        }

        /**
         * The port number on the container instance to reserve for your container.
         * <p>
         * If you specify a <code>containerPortRange</code> , leave this field empty and the value of the <code>hostPort</code> is set as follows:
         * <p>
         * <ul>
         * <li>For containers in a task with the <code>awsvpc</code> network mode, the <code>hostPort</code> is set to the same value as the <code>containerPort</code> . This is a static mapping strategy.</li>
         * <li>For containers in a task with the <code>bridge</code> network mode, the Amazon ECS agent finds open ports on the host and automatically binds them to the container ports. This is a dynamic mapping strategy.</li>
         * </ul>
         * <p>
         * If you use containers in a task with the <code>awsvpc</code> or <code>host</code> network mode, the <code>hostPort</code> can either be left blank or set to the same value as the <code>containerPort</code> .
         * <p>
         * If you use containers in a task with the <code>bridge</code> network mode, you can specify a non-reserved host port for your container port mapping, or you can omit the <code>hostPort</code> (or set it to <code>0</code> ) while specifying a <code>containerPort</code> and your container automatically receives a port in the ephemeral port range for your container instance operating system and Docker version.
         * <p>
         * The default ephemeral port range for Docker version 1.6.0 and later is listed on the instance under <code>/proc/sys/net/ipv4/ip_local_port_range</code> . If this kernel parameter is unavailable, the default ephemeral port range from 49153 through 65535 (Linux) or 49152 through 65535 (Windows) is used. Do not attempt to specify a host port in the ephemeral port range as these are reserved for automatic assignment. In general, ports below 32768 are outside of the ephemeral port range.
         * <p>
         * The default reserved ports are 22 for SSH, the Docker ports 2375 and 2376, and the Amazon ECS container agent ports 51678-51680. Any host port that was previously specified in a running task is also reserved while the task is running. That is, after a task stops, the host port is released. The current reserved ports are displayed in the <code>remainingResources</code> of <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeContainerInstances.html">DescribeContainerInstances</a> output. A container instance can have up to 100 reserved ports at a time. This number includes the default reserved ports. Automatically assigned ports aren't included in the 100 reserved ports quota.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-portmapping.html#cfn-ecs-taskdefinition-portmapping-hostport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-portmapping.html#cfn-ecs-taskdefinition-portmapping-hostport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHostPort() {
            return null;
        }

        /**
         * The name that's used for the port mapping.
         * <p>
         * This parameter is the name that you use in the <code>serviceConnectConfiguration</code> and the <code>vpcLatticeConfigurations</code> of a service. The name can include up to 64 characters. The characters can include lowercase letters, numbers, underscores (_), and hyphens (-). The name can't start with a hyphen.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-portmapping.html#cfn-ecs-taskdefinition-portmapping-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-portmapping.html#cfn-ecs-taskdefinition-portmapping-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The protocol used for the port mapping.
         * <p>
         * Valid values are <code>tcp</code> and <code>udp</code> . The default is <code>tcp</code> . <code>protocol</code> is immutable in a Service Connect service. Updating this field requires a service deletion and redeployment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-portmapping.html#cfn-ecs-taskdefinition-portmapping-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-portmapping.html#cfn-ecs-taskdefinition-portmapping-protocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PortMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PortMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PortMappingProperty> {
            java.lang.String appProtocol;
            java.lang.Number containerPort;
            java.lang.String containerPortRange;
            java.lang.Number hostPort;
            java.lang.String name;
            java.lang.String protocol;

            /**
             * Sets the value of {@link PortMappingProperty#getAppProtocol}
             * @param appProtocol The application protocol that's used for the port mapping.
             *                    This parameter only applies to Service Connect. We recommend that you set this parameter to be consistent with the protocol that your application uses. If you set this parameter, Amazon ECS adds protocol-specific connection handling to the Service Connect proxy. If you set this parameter, Amazon ECS adds protocol-specific telemetry in the Amazon ECS console and CloudWatch.
             *                    <p>
             *                    If you don't set a value for this parameter, then TCP is used. However, Amazon ECS doesn't add protocol-specific telemetry for TCP.
             *                    <p>
             *                    <code>appProtocol</code> is immutable in a Service Connect service. Updating this field requires a service deletion and redeployment.
             *                    <p>
             *                    Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appProtocol(java.lang.String appProtocol) {
                this.appProtocol = appProtocol;
                return this;
            }

            /**
             * Sets the value of {@link PortMappingProperty#getContainerPort}
             * @param containerPort The port number on the container that's bound to the user-specified or automatically assigned host port.
             *                      If you use containers in a task with the <code>awsvpc</code> or <code>host</code> network mode, specify the exposed ports using <code>containerPort</code> .
             *                      <p>
             *                      If you use containers in a task with the <code>bridge</code> network mode and you specify a container port and not a host port, your container automatically receives a host port in the ephemeral port range. For more information, see <code>hostPort</code> . Port mappings that are automatically assigned in this way do not count toward the 100 reserved ports limit of a container instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPort(java.lang.Number containerPort) {
                this.containerPort = containerPort;
                return this;
            }

            /**
             * Sets the value of {@link PortMappingProperty#getContainerPortRange}
             * @param containerPortRange The port number range on the container that's bound to the dynamically mapped host port range.
             *                           The following rules apply when you specify a <code>containerPortRange</code> :
             *                           <p>
             *                           <ul>
             *                           <li>You must use either the <code>bridge</code> network mode or the <code>awsvpc</code> network mode.</li>
             *                           <li>This parameter is available for both the EC2 and AWS Fargate launch types.</li>
             *                           <li>This parameter is available for both the Linux and Windows operating systems.</li>
             *                           <li>The container instance must have at least version 1.67.0 of the container agent and at least version 1.67.0-1 of the <code>ecs-init</code> package</li>
             *                           <li>You can specify a maximum of 100 port ranges per container.</li>
             *                           <li>You do not specify a <code>hostPortRange</code> . The value of the <code>hostPortRange</code> is set as follows:</li>
             *                           <li>For containers in a task with the <code>awsvpc</code> network mode, the <code>hostPortRange</code> is set to the same value as the <code>containerPortRange</code> . This is a static mapping strategy.</li>
             *                           <li>For containers in a task with the <code>bridge</code> network mode, the Amazon ECS agent finds open host ports from the default ephemeral range and passes it to docker to bind them to the container ports.</li>
             *                           <li>The <code>containerPortRange</code> valid values are between 1 and 65535.</li>
             *                           <li>A port can only be included in one port mapping per container.</li>
             *                           <li>You cannot specify overlapping port ranges.</li>
             *                           <li>The first port in the range must be less than last port in the range.</li>
             *                           <li>Docker recommends that you turn off the docker-proxy in the Docker daemon config file when you have a large number of ports.</li>
             *                           </ul>
             *                           <p>
             *                           For more information, see <a href="https://docs.aws.amazon.com/https://github.com/moby/moby/issues/11185">Issue #11185</a> on the Github website.
             *                           <p>
             *                           For information about how to turn off the docker-proxy in the Docker daemon config file, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/bootstrap_container_instance.html#bootstrap_docker_daemon">Docker daemon</a> in the <em>Amazon ECS Developer Guide</em> .
             *                           <p>
             *                           You can call <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTasks.html"><code>DescribeTasks</code></a> to view the <code>hostPortRange</code> which are the host ports that are bound to the container ports.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPortRange(java.lang.String containerPortRange) {
                this.containerPortRange = containerPortRange;
                return this;
            }

            /**
             * Sets the value of {@link PortMappingProperty#getHostPort}
             * @param hostPort The port number on the container instance to reserve for your container.
             *                 If you specify a <code>containerPortRange</code> , leave this field empty and the value of the <code>hostPort</code> is set as follows:
             *                 <p>
             *                 <ul>
             *                 <li>For containers in a task with the <code>awsvpc</code> network mode, the <code>hostPort</code> is set to the same value as the <code>containerPort</code> . This is a static mapping strategy.</li>
             *                 <li>For containers in a task with the <code>bridge</code> network mode, the Amazon ECS agent finds open ports on the host and automatically binds them to the container ports. This is a dynamic mapping strategy.</li>
             *                 </ul>
             *                 <p>
             *                 If you use containers in a task with the <code>awsvpc</code> or <code>host</code> network mode, the <code>hostPort</code> can either be left blank or set to the same value as the <code>containerPort</code> .
             *                 <p>
             *                 If you use containers in a task with the <code>bridge</code> network mode, you can specify a non-reserved host port for your container port mapping, or you can omit the <code>hostPort</code> (or set it to <code>0</code> ) while specifying a <code>containerPort</code> and your container automatically receives a port in the ephemeral port range for your container instance operating system and Docker version.
             *                 <p>
             *                 The default ephemeral port range for Docker version 1.6.0 and later is listed on the instance under <code>/proc/sys/net/ipv4/ip_local_port_range</code> . If this kernel parameter is unavailable, the default ephemeral port range from 49153 through 65535 (Linux) or 49152 through 65535 (Windows) is used. Do not attempt to specify a host port in the ephemeral port range as these are reserved for automatic assignment. In general, ports below 32768 are outside of the ephemeral port range.
             *                 <p>
             *                 The default reserved ports are 22 for SSH, the Docker ports 2375 and 2376, and the Amazon ECS container agent ports 51678-51680. Any host port that was previously specified in a running task is also reserved while the task is running. That is, after a task stops, the host port is released. The current reserved ports are displayed in the <code>remainingResources</code> of <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeContainerInstances.html">DescribeContainerInstances</a> output. A container instance can have up to 100 reserved ports at a time. This number includes the default reserved ports. Automatically assigned ports aren't included in the 100 reserved ports quota.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostPort(java.lang.Number hostPort) {
                this.hostPort = hostPort;
                return this;
            }

            /**
             * Sets the value of {@link PortMappingProperty#getName}
             * @param name The name that's used for the port mapping.
             *             This parameter is the name that you use in the <code>serviceConnectConfiguration</code> and the <code>vpcLatticeConfigurations</code> of a service. The name can include up to 64 characters. The characters can include lowercase letters, numbers, underscores (_), and hyphens (-). The name can't start with a hyphen.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link PortMappingProperty#getProtocol}
             * @param protocol The protocol used for the port mapping.
             *                 Valid values are <code>tcp</code> and <code>udp</code> . The default is <code>tcp</code> . <code>protocol</code> is immutable in a Service Connect service. Updating this field requires a service deletion and redeployment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PortMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PortMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PortMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PortMappingProperty {
            private final java.lang.String appProtocol;
            private final java.lang.Number containerPort;
            private final java.lang.String containerPortRange;
            private final java.lang.Number hostPort;
            private final java.lang.String name;
            private final java.lang.String protocol;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appProtocol = software.amazon.jsii.Kernel.get(this, "appProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.containerPort = software.amazon.jsii.Kernel.get(this, "containerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.containerPortRange = software.amazon.jsii.Kernel.get(this, "containerPortRange", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostPort = software.amazon.jsii.Kernel.get(this, "hostPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appProtocol = builder.appProtocol;
                this.containerPort = builder.containerPort;
                this.containerPortRange = builder.containerPortRange;
                this.hostPort = builder.hostPort;
                this.name = builder.name;
                this.protocol = builder.protocol;
            }

            @Override
            public final java.lang.String getAppProtocol() {
                return this.appProtocol;
            }

            @Override
            public final java.lang.Number getContainerPort() {
                return this.containerPort;
            }

            @Override
            public final java.lang.String getContainerPortRange() {
                return this.containerPortRange;
            }

            @Override
            public final java.lang.Number getHostPort() {
                return this.hostPort;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAppProtocol() != null) {
                    data.set("appProtocol", om.valueToTree(this.getAppProtocol()));
                }
                if (this.getContainerPort() != null) {
                    data.set("containerPort", om.valueToTree(this.getContainerPort()));
                }
                if (this.getContainerPortRange() != null) {
                    data.set("containerPortRange", om.valueToTree(this.getContainerPortRange()));
                }
                if (this.getHostPort() != null) {
                    data.set("hostPort", om.valueToTree(this.getHostPort()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getProtocol() != null) {
                    data.set("protocol", om.valueToTree(this.getProtocol()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.PortMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PortMappingProperty.Jsii$Proxy that = (PortMappingProperty.Jsii$Proxy) o;

                if (this.appProtocol != null ? !this.appProtocol.equals(that.appProtocol) : that.appProtocol != null) return false;
                if (this.containerPort != null ? !this.containerPort.equals(that.containerPort) : that.containerPort != null) return false;
                if (this.containerPortRange != null ? !this.containerPortRange.equals(that.containerPortRange) : that.containerPortRange != null) return false;
                if (this.hostPort != null ? !this.hostPort.equals(that.hostPort) : that.hostPort != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.protocol != null ? this.protocol.equals(that.protocol) : that.protocol == null;
            }

            @Override
            public final int hashCode() {
                int result = this.appProtocol != null ? this.appProtocol.hashCode() : 0;
                result = 31 * result + (this.containerPort != null ? this.containerPort.hashCode() : 0);
                result = 31 * result + (this.containerPortRange != null ? this.containerPortRange.hashCode() : 0);
                result = 31 * result + (this.hostPort != null ? this.hostPort.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration details for the App Mesh proxy.
     * <p>
     * For tasks that use the EC2 launch type, the container instances require at least version 1.26.0 of the container agent and at least version 1.26.0-1 of the <code>ecs-init</code> package to use a proxy configuration. If your container instances are launched from the Amazon ECS optimized AMI version <code>20190301</code> or later, then they contain the required versions of the container agent and <code>ecs-init</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ProxyConfigurationProperty proxyConfigurationProperty = ProxyConfigurationProperty.builder()
     *         .containerName("containerName")
     *         // the properties below are optional
     *         .proxyConfigurationProperties(List.of(KeyValuePairProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-proxyconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-proxyconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.ProxyConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ProxyConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProxyConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the container that will serve as the App Mesh proxy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-proxyconfiguration.html#cfn-ecs-taskdefinition-proxyconfiguration-containername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-proxyconfiguration.html#cfn-ecs-taskdefinition-proxyconfiguration-containername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContainerName();

        /**
         * The set of network configuration parameters to provide the Container Network Interface (CNI) plugin, specified as key-value pairs.
         * <p>
         * <ul>
         * <li><code>IgnoredUID</code> - (Required) The user ID (UID) of the proxy container as defined by the <code>user</code> parameter in a container definition. This is used to ensure the proxy ignores its own traffic. If <code>IgnoredGID</code> is specified, this field can be empty.</li>
         * <li><code>IgnoredGID</code> - (Required) The group ID (GID) of the proxy container as defined by the <code>user</code> parameter in a container definition. This is used to ensure the proxy ignores its own traffic. If <code>IgnoredUID</code> is specified, this field can be empty.</li>
         * <li><code>AppPorts</code> - (Required) The list of ports that the application uses. Network traffic to these ports is forwarded to the <code>ProxyIngressPort</code> and <code>ProxyEgressPort</code> .</li>
         * <li><code>ProxyIngressPort</code> - (Required) Specifies the port that incoming traffic to the <code>AppPorts</code> is directed to.</li>
         * <li><code>ProxyEgressPort</code> - (Required) Specifies the port that outgoing traffic from the <code>AppPorts</code> is directed to.</li>
         * <li><code>EgressIgnoredPorts</code> - (Required) The egress traffic going to the specified ports is ignored and not redirected to the <code>ProxyEgressPort</code> . It can be an empty list.</li>
         * <li><code>EgressIgnoredIPs</code> - (Required) The egress traffic going to the specified IP addresses is ignored and not redirected to the <code>ProxyEgressPort</code> . It can be an empty list.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-proxyconfiguration.html#cfn-ecs-taskdefinition-proxyconfiguration-proxyconfigurationproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-proxyconfiguration.html#cfn-ecs-taskdefinition-proxyconfiguration-proxyconfigurationproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProxyConfigurationProperties() {
            return null;
        }

        /**
         * The proxy type.
         * <p>
         * The only supported value is <code>APPMESH</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-proxyconfiguration.html#cfn-ecs-taskdefinition-proxyconfiguration-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-proxyconfiguration.html#cfn-ecs-taskdefinition-proxyconfiguration-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProxyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProxyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProxyConfigurationProperty> {
            java.lang.String containerName;
            java.lang.Object proxyConfigurationProperties;
            java.lang.String type;

            /**
             * Sets the value of {@link ProxyConfigurationProperty#getContainerName}
             * @param containerName The name of the container that will serve as the App Mesh proxy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerName(java.lang.String containerName) {
                this.containerName = containerName;
                return this;
            }

            /**
             * Sets the value of {@link ProxyConfigurationProperty#getProxyConfigurationProperties}
             * @param proxyConfigurationProperties The set of network configuration parameters to provide the Container Network Interface (CNI) plugin, specified as key-value pairs.
             *                                     <ul>
             *                                     <li><code>IgnoredUID</code> - (Required) The user ID (UID) of the proxy container as defined by the <code>user</code> parameter in a container definition. This is used to ensure the proxy ignores its own traffic. If <code>IgnoredGID</code> is specified, this field can be empty.</li>
             *                                     <li><code>IgnoredGID</code> - (Required) The group ID (GID) of the proxy container as defined by the <code>user</code> parameter in a container definition. This is used to ensure the proxy ignores its own traffic. If <code>IgnoredUID</code> is specified, this field can be empty.</li>
             *                                     <li><code>AppPorts</code> - (Required) The list of ports that the application uses. Network traffic to these ports is forwarded to the <code>ProxyIngressPort</code> and <code>ProxyEgressPort</code> .</li>
             *                                     <li><code>ProxyIngressPort</code> - (Required) Specifies the port that incoming traffic to the <code>AppPorts</code> is directed to.</li>
             *                                     <li><code>ProxyEgressPort</code> - (Required) Specifies the port that outgoing traffic from the <code>AppPorts</code> is directed to.</li>
             *                                     <li><code>EgressIgnoredPorts</code> - (Required) The egress traffic going to the specified ports is ignored and not redirected to the <code>ProxyEgressPort</code> . It can be an empty list.</li>
             *                                     <li><code>EgressIgnoredIPs</code> - (Required) The egress traffic going to the specified IP addresses is ignored and not redirected to the <code>ProxyEgressPort</code> . It can be an empty list.</li>
             *                                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder proxyConfigurationProperties(software.amazon.awscdk.IResolvable proxyConfigurationProperties) {
                this.proxyConfigurationProperties = proxyConfigurationProperties;
                return this;
            }

            /**
             * Sets the value of {@link ProxyConfigurationProperty#getProxyConfigurationProperties}
             * @param proxyConfigurationProperties The set of network configuration parameters to provide the Container Network Interface (CNI) plugin, specified as key-value pairs.
             *                                     <ul>
             *                                     <li><code>IgnoredUID</code> - (Required) The user ID (UID) of the proxy container as defined by the <code>user</code> parameter in a container definition. This is used to ensure the proxy ignores its own traffic. If <code>IgnoredGID</code> is specified, this field can be empty.</li>
             *                                     <li><code>IgnoredGID</code> - (Required) The group ID (GID) of the proxy container as defined by the <code>user</code> parameter in a container definition. This is used to ensure the proxy ignores its own traffic. If <code>IgnoredUID</code> is specified, this field can be empty.</li>
             *                                     <li><code>AppPorts</code> - (Required) The list of ports that the application uses. Network traffic to these ports is forwarded to the <code>ProxyIngressPort</code> and <code>ProxyEgressPort</code> .</li>
             *                                     <li><code>ProxyIngressPort</code> - (Required) Specifies the port that incoming traffic to the <code>AppPorts</code> is directed to.</li>
             *                                     <li><code>ProxyEgressPort</code> - (Required) Specifies the port that outgoing traffic from the <code>AppPorts</code> is directed to.</li>
             *                                     <li><code>EgressIgnoredPorts</code> - (Required) The egress traffic going to the specified ports is ignored and not redirected to the <code>ProxyEgressPort</code> . It can be an empty list.</li>
             *                                     <li><code>EgressIgnoredIPs</code> - (Required) The egress traffic going to the specified IP addresses is ignored and not redirected to the <code>ProxyEgressPort</code> . It can be an empty list.</li>
             *                                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder proxyConfigurationProperties(java.util.List<? extends java.lang.Object> proxyConfigurationProperties) {
                this.proxyConfigurationProperties = proxyConfigurationProperties;
                return this;
            }

            /**
             * Sets the value of {@link ProxyConfigurationProperty#getType}
             * @param type The proxy type.
             *             The only supported value is <code>APPMESH</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProxyConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProxyConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProxyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProxyConfigurationProperty {
            private final java.lang.String containerName;
            private final java.lang.Object proxyConfigurationProperties;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerName = software.amazon.jsii.Kernel.get(this, "containerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.proxyConfigurationProperties = software.amazon.jsii.Kernel.get(this, "proxyConfigurationProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerName = java.util.Objects.requireNonNull(builder.containerName, "containerName is required");
                this.proxyConfigurationProperties = builder.proxyConfigurationProperties;
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getContainerName() {
                return this.containerName;
            }

            @Override
            public final java.lang.Object getProxyConfigurationProperties() {
                return this.proxyConfigurationProperties;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("containerName", om.valueToTree(this.getContainerName()));
                if (this.getProxyConfigurationProperties() != null) {
                    data.set("proxyConfigurationProperties", om.valueToTree(this.getProxyConfigurationProperties()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.ProxyConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProxyConfigurationProperty.Jsii$Proxy that = (ProxyConfigurationProperty.Jsii$Proxy) o;

                if (!containerName.equals(that.containerName)) return false;
                if (this.proxyConfigurationProperties != null ? !this.proxyConfigurationProperties.equals(that.proxyConfigurationProperties) : that.proxyConfigurationProperties != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerName.hashCode();
                result = 31 * result + (this.proxyConfigurationProperties != null ? this.proxyConfigurationProperties.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The repository credentials for private registry authentication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * RepositoryCredentialsProperty repositoryCredentialsProperty = RepositoryCredentialsProperty.builder()
     *         .credentialsParameter("credentialsParameter")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-repositorycredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-repositorycredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.RepositoryCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(RepositoryCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RepositoryCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the secret containing the private repository credentials.
         * <p>
         * <blockquote>
         * <p>
         * When you use the Amazon ECS API, AWS CLI , or AWS SDK, if the secret exists in the same Region as the task that you're launching then you can use either the full ARN or the name of the secret. When you use the AWS Management Console, you must specify the full ARN of the secret.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-repositorycredentials.html#cfn-ecs-taskdefinition-repositorycredentials-credentialsparameter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-repositorycredentials.html#cfn-ecs-taskdefinition-repositorycredentials-credentialsparameter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCredentialsParameter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RepositoryCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RepositoryCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RepositoryCredentialsProperty> {
            java.lang.String credentialsParameter;

            /**
             * Sets the value of {@link RepositoryCredentialsProperty#getCredentialsParameter}
             * @param credentialsParameter The Amazon Resource Name (ARN) of the secret containing the private repository credentials.
             *                             <blockquote>
             *                             <p>
             *                             When you use the Amazon ECS API, AWS CLI , or AWS SDK, if the secret exists in the same Region as the task that you're launching then you can use either the full ARN or the name of the secret. When you use the AWS Management Console, you must specify the full ARN of the secret.
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialsParameter(java.lang.String credentialsParameter) {
                this.credentialsParameter = credentialsParameter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RepositoryCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RepositoryCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RepositoryCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RepositoryCredentialsProperty {
            private final java.lang.String credentialsParameter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.credentialsParameter = software.amazon.jsii.Kernel.get(this, "credentialsParameter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.credentialsParameter = builder.credentialsParameter;
            }

            @Override
            public final java.lang.String getCredentialsParameter() {
                return this.credentialsParameter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCredentialsParameter() != null) {
                    data.set("credentialsParameter", om.valueToTree(this.getCredentialsParameter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.RepositoryCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RepositoryCredentialsProperty.Jsii$Proxy that = (RepositoryCredentialsProperty.Jsii$Proxy) o;

                return this.credentialsParameter != null ? this.credentialsParameter.equals(that.credentialsParameter) : that.credentialsParameter == null;
            }

            @Override
            public final int hashCode() {
                int result = this.credentialsParameter != null ? this.credentialsParameter.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The type and amount of a resource to assign to a container.
     * <p>
     * The supported resource types are GPUs and Elastic Inference accelerators. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-gpu.html">Working with GPUs on Amazon ECS</a> or <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-inference.html">Working with Amazon Elastic Inference on Amazon ECS</a> in the <em>Amazon Elastic Container Service Developer Guide</em>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ResourceRequirementProperty resourceRequirementProperty = ResourceRequirementProperty.builder()
     *         .type("type")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-resourcerequirement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-resourcerequirement.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.ResourceRequirementProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceRequirementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceRequirementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of resource to assign to a container.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-resourcerequirement.html#cfn-ecs-taskdefinition-resourcerequirement-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-resourcerequirement.html#cfn-ecs-taskdefinition-resourcerequirement-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The value for the specified resource type.
         * <p>
         * When the type is <code>GPU</code> , the value is the number of physical <code>GPUs</code> the Amazon ECS container agent reserves for the container. The number of GPUs that's reserved for all containers in a task can't exceed the number of available GPUs on the container instance that the task is launched on.
         * <p>
         * When the type is <code>InferenceAccelerator</code> , the <code>value</code> matches the <code>deviceName</code> for an <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_InferenceAccelerator.html">InferenceAccelerator</a> specified in a task definition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-resourcerequirement.html#cfn-ecs-taskdefinition-resourcerequirement-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-resourcerequirement.html#cfn-ecs-taskdefinition-resourcerequirement-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link ResourceRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceRequirementProperty> {
            java.lang.String type;
            java.lang.String value;

            /**
             * Sets the value of {@link ResourceRequirementProperty#getType}
             * @param type The type of resource to assign to a container. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ResourceRequirementProperty#getValue}
             * @param value The value for the specified resource type. This parameter is required.
             *              When the type is <code>GPU</code> , the value is the number of physical <code>GPUs</code> the Amazon ECS container agent reserves for the container. The number of GPUs that's reserved for all containers in a task can't exceed the number of available GPUs on the container instance that the task is launched on.
             *              <p>
             *              When the type is <code>InferenceAccelerator</code> , the <code>value</code> matches the <code>deviceName</code> for an <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_InferenceAccelerator.html">InferenceAccelerator</a> specified in a task definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceRequirementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceRequirementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceRequirementProperty {
            private final java.lang.String type;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.ResourceRequirementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceRequirementProperty.Jsii$Proxy that = (ResourceRequirementProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * You can enable a restart policy for each container defined in your task definition, to overcome transient failures faster and maintain task availability.
     * <p>
     * When you enable a restart policy for a container, Amazon ECS can restart the container if it exits, without needing to replace the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-restart-policy.html">Restart individual containers in Amazon ECS tasks with container restart policies</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * RestartPolicyProperty restartPolicyProperty = RestartPolicyProperty.builder()
     *         .enabled(false)
     *         .ignoredExitCodes(List.of(123))
     *         .restartAttemptPeriod(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-restartpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-restartpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.RestartPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(RestartPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RestartPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether a restart policy is enabled for the container.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-restartpolicy.html#cfn-ecs-taskdefinition-restartpolicy-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-restartpolicy.html#cfn-ecs-taskdefinition-restartpolicy-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * A list of exit codes that Amazon ECS will ignore and not attempt a restart on.
         * <p>
         * You can specify a maximum of 50 container exit codes. By default, Amazon ECS does not ignore any exit codes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-restartpolicy.html#cfn-ecs-taskdefinition-restartpolicy-ignoredexitcodes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-restartpolicy.html#cfn-ecs-taskdefinition-restartpolicy-ignoredexitcodes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIgnoredExitCodes() {
            return null;
        }

        /**
         * A period of time (in seconds) that the container must run for before a restart can be attempted.
         * <p>
         * A container can be restarted only once every <code>restartAttemptPeriod</code> seconds. If a container isn't able to run for this time period and exits early, it will not be restarted. You can set a minimum <code>restartAttemptPeriod</code> of 60 seconds and a maximum <code>restartAttemptPeriod</code> of 1800 seconds. By default, a container must run for 300 seconds before it can be restarted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-restartpolicy.html#cfn-ecs-taskdefinition-restartpolicy-restartattemptperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-restartpolicy.html#cfn-ecs-taskdefinition-restartpolicy-restartattemptperiod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRestartAttemptPeriod() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RestartPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RestartPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RestartPolicyProperty> {
            java.lang.Object enabled;
            java.lang.Object ignoredExitCodes;
            java.lang.Number restartAttemptPeriod;

            /**
             * Sets the value of {@link RestartPolicyProperty#getEnabled}
             * @param enabled Specifies whether a restart policy is enabled for the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link RestartPolicyProperty#getEnabled}
             * @param enabled Specifies whether a restart policy is enabled for the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link RestartPolicyProperty#getIgnoredExitCodes}
             * @param ignoredExitCodes A list of exit codes that Amazon ECS will ignore and not attempt a restart on.
             *                         You can specify a maximum of 50 container exit codes. By default, Amazon ECS does not ignore any exit codes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignoredExitCodes(java.util.List<? extends java.lang.Number> ignoredExitCodes) {
                this.ignoredExitCodes = ignoredExitCodes;
                return this;
            }

            /**
             * Sets the value of {@link RestartPolicyProperty#getIgnoredExitCodes}
             * @param ignoredExitCodes A list of exit codes that Amazon ECS will ignore and not attempt a restart on.
             *                         You can specify a maximum of 50 container exit codes. By default, Amazon ECS does not ignore any exit codes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ignoredExitCodes(software.amazon.awscdk.IResolvable ignoredExitCodes) {
                this.ignoredExitCodes = ignoredExitCodes;
                return this;
            }

            /**
             * Sets the value of {@link RestartPolicyProperty#getRestartAttemptPeriod}
             * @param restartAttemptPeriod A period of time (in seconds) that the container must run for before a restart can be attempted.
             *                             A container can be restarted only once every <code>restartAttemptPeriod</code> seconds. If a container isn't able to run for this time period and exits early, it will not be restarted. You can set a minimum <code>restartAttemptPeriod</code> of 60 seconds and a maximum <code>restartAttemptPeriod</code> of 1800 seconds. By default, a container must run for 300 seconds before it can be restarted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restartAttemptPeriod(java.lang.Number restartAttemptPeriod) {
                this.restartAttemptPeriod = restartAttemptPeriod;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RestartPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RestartPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RestartPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RestartPolicyProperty {
            private final java.lang.Object enabled;
            private final java.lang.Object ignoredExitCodes;
            private final java.lang.Number restartAttemptPeriod;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ignoredExitCodes = software.amazon.jsii.Kernel.get(this, "ignoredExitCodes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.restartAttemptPeriod = software.amazon.jsii.Kernel.get(this, "restartAttemptPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.ignoredExitCodes = builder.ignoredExitCodes;
                this.restartAttemptPeriod = builder.restartAttemptPeriod;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getIgnoredExitCodes() {
                return this.ignoredExitCodes;
            }

            @Override
            public final java.lang.Number getRestartAttemptPeriod() {
                return this.restartAttemptPeriod;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getIgnoredExitCodes() != null) {
                    data.set("ignoredExitCodes", om.valueToTree(this.getIgnoredExitCodes()));
                }
                if (this.getRestartAttemptPeriod() != null) {
                    data.set("restartAttemptPeriod", om.valueToTree(this.getRestartAttemptPeriod()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.RestartPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RestartPolicyProperty.Jsii$Proxy that = (RestartPolicyProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.ignoredExitCodes != null ? !this.ignoredExitCodes.equals(that.ignoredExitCodes) : that.ignoredExitCodes != null) return false;
                return this.restartAttemptPeriod != null ? this.restartAttemptPeriod.equals(that.restartAttemptPeriod) : that.restartAttemptPeriod == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.ignoredExitCodes != null ? this.ignoredExitCodes.hashCode() : 0);
                result = 31 * result + (this.restartAttemptPeriod != null ? this.restartAttemptPeriod.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the platform for the Amazon ECS service or task.
     * <p>
     * For more information about <code>RuntimePlatform</code> , see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#runtime-platform">RuntimePlatform</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * RuntimePlatformProperty runtimePlatformProperty = RuntimePlatformProperty.builder()
     *         .cpuArchitecture("cpuArchitecture")
     *         .operatingSystemFamily("operatingSystemFamily")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-runtimeplatform.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-runtimeplatform.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.RuntimePlatformProperty")
    @software.amazon.jsii.Jsii.Proxy(RuntimePlatformProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuntimePlatformProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CPU architecture.
         * <p>
         * You can run your Linux tasks on an ARM-based platform by setting the value to <code>ARM64</code> . This option is available for tasks that run on Linux Amazon EC2 instance or Linux containers on Fargate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-runtimeplatform.html#cfn-ecs-taskdefinition-runtimeplatform-cpuarchitecture">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-runtimeplatform.html#cfn-ecs-taskdefinition-runtimeplatform-cpuarchitecture</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCpuArchitecture() {
            return null;
        }

        /**
         * The operating system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-runtimeplatform.html#cfn-ecs-taskdefinition-runtimeplatform-operatingsystemfamily">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-runtimeplatform.html#cfn-ecs-taskdefinition-runtimeplatform-operatingsystemfamily</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOperatingSystemFamily() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuntimePlatformProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuntimePlatformProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuntimePlatformProperty> {
            java.lang.String cpuArchitecture;
            java.lang.String operatingSystemFamily;

            /**
             * Sets the value of {@link RuntimePlatformProperty#getCpuArchitecture}
             * @param cpuArchitecture The CPU architecture.
             *                        You can run your Linux tasks on an ARM-based platform by setting the value to <code>ARM64</code> . This option is available for tasks that run on Linux Amazon EC2 instance or Linux containers on Fargate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpuArchitecture(java.lang.String cpuArchitecture) {
                this.cpuArchitecture = cpuArchitecture;
                return this;
            }

            /**
             * Sets the value of {@link RuntimePlatformProperty#getOperatingSystemFamily}
             * @param operatingSystemFamily The operating system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operatingSystemFamily(java.lang.String operatingSystemFamily) {
                this.operatingSystemFamily = operatingSystemFamily;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuntimePlatformProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuntimePlatformProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuntimePlatformProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuntimePlatformProperty {
            private final java.lang.String cpuArchitecture;
            private final java.lang.String operatingSystemFamily;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cpuArchitecture = software.amazon.jsii.Kernel.get(this, "cpuArchitecture", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.operatingSystemFamily = software.amazon.jsii.Kernel.get(this, "operatingSystemFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cpuArchitecture = builder.cpuArchitecture;
                this.operatingSystemFamily = builder.operatingSystemFamily;
            }

            @Override
            public final java.lang.String getCpuArchitecture() {
                return this.cpuArchitecture;
            }

            @Override
            public final java.lang.String getOperatingSystemFamily() {
                return this.operatingSystemFamily;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCpuArchitecture() != null) {
                    data.set("cpuArchitecture", om.valueToTree(this.getCpuArchitecture()));
                }
                if (this.getOperatingSystemFamily() != null) {
                    data.set("operatingSystemFamily", om.valueToTree(this.getOperatingSystemFamily()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.RuntimePlatformProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuntimePlatformProperty.Jsii$Proxy that = (RuntimePlatformProperty.Jsii$Proxy) o;

                if (this.cpuArchitecture != null ? !this.cpuArchitecture.equals(that.cpuArchitecture) : that.cpuArchitecture != null) return false;
                return this.operatingSystemFamily != null ? this.operatingSystemFamily.equals(that.operatingSystemFamily) : that.operatingSystemFamily == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cpuArchitecture != null ? this.cpuArchitecture.hashCode() : 0;
                result = 31 * result + (this.operatingSystemFamily != null ? this.operatingSystemFamily.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object representing the secret to expose to your container.
     * <p>
     * Secrets can be exposed to a container in the following ways:
     * <p>
     * <ul>
     * <li>To inject sensitive data into your containers as environment variables, use the <code>secrets</code> container definition parameter.</li>
     * <li>To reference sensitive information in the log configuration of a container, use the <code>secretOptions</code> container definition parameter.</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * SecretProperty secretProperty = SecretProperty.builder()
     *         .name("name")
     *         .valueFrom("valueFrom")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-secret.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-secret.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.SecretProperty")
    @software.amazon.jsii.Jsii.Proxy(SecretProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SecretProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the secret.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-secret.html#cfn-ecs-taskdefinition-secret-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-secret.html#cfn-ecs-taskdefinition-secret-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The secret to expose to the container.
         * <p>
         * The supported values are either the full ARN of the AWS Secrets Manager secret or the full ARN of the parameter in the SSM Parameter Store.
         * <p>
         * For information about the require AWS Identity and Access Management permissions, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-secrets.html#secrets-iam">Required IAM permissions for Amazon ECS secrets</a> (for Secrets Manager) or <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-parameters.html">Required IAM permissions for Amazon ECS secrets</a> (for Systems Manager Parameter store) in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * If the SSM Parameter Store parameter exists in the same Region as the task you're launching, then you can use either the full ARN or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-secret.html#cfn-ecs-taskdefinition-secret-valuefrom">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-secret.html#cfn-ecs-taskdefinition-secret-valuefrom</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValueFrom();

        /**
         * @return a {@link Builder} of {@link SecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SecretProperty> {
            java.lang.String name;
            java.lang.String valueFrom;

            /**
             * Sets the value of {@link SecretProperty#getName}
             * @param name The name of the secret. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SecretProperty#getValueFrom}
             * @param valueFrom The secret to expose to the container. This parameter is required.
             *                  The supported values are either the full ARN of the AWS Secrets Manager secret or the full ARN of the parameter in the SSM Parameter Store.
             *                  <p>
             *                  For information about the require AWS Identity and Access Management permissions, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-secrets.html#secrets-iam">Required IAM permissions for Amazon ECS secrets</a> (for Secrets Manager) or <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-parameters.html">Required IAM permissions for Amazon ECS secrets</a> (for Systems Manager Parameter store) in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  If the SSM Parameter Store parameter exists in the same Region as the task you're launching, then you can use either the full ARN or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueFrom(java.lang.String valueFrom) {
                this.valueFrom = valueFrom;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SecretProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SecretProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecretProperty {
            private final java.lang.String name;
            private final java.lang.String valueFrom;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueFrom = software.amazon.jsii.Kernel.get(this, "valueFrom", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.valueFrom = java.util.Objects.requireNonNull(builder.valueFrom, "valueFrom is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValueFrom() {
                return this.valueFrom;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("valueFrom", om.valueToTree(this.getValueFrom()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.SecretProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SecretProperty.Jsii$Proxy that = (SecretProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.valueFrom.equals(that.valueFrom);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.valueFrom.hashCode());
                return result;
            }
        }
    }
    /**
     * A list of namespaced kernel parameters to set in the container.
     * <p>
     * This parameter maps to <code>Sysctls</code> in the docker container create command and the <code>--sysctl</code> option to docker run. For example, you can configure <code>net.ipv4.tcp_keepalive_time</code> setting to maintain longer lived connections.
     * <p>
     * We don't recommend that you specify network-related <code>systemControls</code> parameters for multiple containers in a single task that also uses either the <code>awsvpc</code> or <code>host</code> network mode. Doing this has the following disadvantages:
     * <p>
     * <ul>
     * <li>For tasks that use the <code>awsvpc</code> network mode including Fargate, if you set <code>systemControls</code> for any container, it applies to all containers in the task. If you set different <code>systemControls</code> for multiple containers in a single task, the container that's started last determines which <code>systemControls</code> take effect.</li>
     * <li>For tasks that use the <code>host</code> network mode, the network namespace <code>systemControls</code> aren't supported.</li>
     * </ul>
     * <p>
     * If you're setting an IPC resource namespace to use for the containers in the task, the following conditions apply to your system controls. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#task_definition_ipcmode">IPC mode</a> .
     * <p>
     * <ul>
     * <li>For tasks that use the <code>host</code> IPC mode, IPC namespace <code>systemControls</code> aren't supported.</li>
     * <li>For tasks that use the <code>task</code> IPC mode, IPC namespace <code>systemControls</code> values apply to all containers within a task.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * This parameter is not supported for Windows containers. &gt; This parameter is only supported for tasks that are hosted on AWS Fargate if the tasks are using platform version <code>1.4.0</code> or later (Linux). This isn't supported for Windows containers on Fargate.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * SystemControlProperty systemControlProperty = SystemControlProperty.builder()
     *         .namespace("namespace")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-systemcontrol.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-systemcontrol.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.SystemControlProperty")
    @software.amazon.jsii.Jsii.Proxy(SystemControlProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SystemControlProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The namespaced kernel parameter to set a <code>value</code> for.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-systemcontrol.html#cfn-ecs-taskdefinition-systemcontrol-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-systemcontrol.html#cfn-ecs-taskdefinition-systemcontrol-namespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
            return null;
        }

        /**
         * The namespaced kernel parameter to set a <code>value</code> for.
         * <p>
         * Valid IPC namespace values: <code>"kernel.msgmax" | "kernel.msgmnb" | "kernel.msgmni" | "kernel.sem" | "kernel.shmall" | "kernel.shmmax" | "kernel.shmmni" | "kernel.shm_rmid_forced"</code> , and <code>Sysctls</code> that start with <code>"fs.mqueue.*"</code>
         * <p>
         * Valid network namespace values: <code>Sysctls</code> that start with <code>"net.*"</code> . Only namespaced <code>Sysctls</code> that exist within the container starting with "net.* are accepted.
         * <p>
         * All of these values are supported by Fargate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-systemcontrol.html#cfn-ecs-taskdefinition-systemcontrol-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-systemcontrol.html#cfn-ecs-taskdefinition-systemcontrol-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SystemControlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SystemControlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SystemControlProperty> {
            java.lang.String namespace;
            java.lang.String value;

            /**
             * Sets the value of {@link SystemControlProperty#getNamespace}
             * @param namespace The namespaced kernel parameter to set a <code>value</code> for.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of {@link SystemControlProperty#getValue}
             * @param value The namespaced kernel parameter to set a <code>value</code> for.
             *              Valid IPC namespace values: <code>"kernel.msgmax" | "kernel.msgmnb" | "kernel.msgmni" | "kernel.sem" | "kernel.shmall" | "kernel.shmmax" | "kernel.shmmni" | "kernel.shm_rmid_forced"</code> , and <code>Sysctls</code> that start with <code>"fs.mqueue.*"</code>
             *              <p>
             *              Valid network namespace values: <code>Sysctls</code> that start with <code>"net.*"</code> . Only namespaced <code>Sysctls</code> that exist within the container starting with "net.* are accepted.
             *              <p>
             *              All of these values are supported by Fargate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SystemControlProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SystemControlProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SystemControlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SystemControlProperty {
            private final java.lang.String namespace;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.namespace = builder.namespace;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNamespace() != null) {
                    data.set("namespace", om.valueToTree(this.getNamespace()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.SystemControlProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SystemControlProperty.Jsii$Proxy that = (SystemControlProperty.Jsii$Proxy) o;

                if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.namespace != null ? this.namespace.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The constraint on task placement in the task definition.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html">Task placement constraints</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * Task placement constraints aren't supported for tasks run on AWS Fargate .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * TaskDefinitionPlacementConstraintProperty taskDefinitionPlacementConstraintProperty = TaskDefinitionPlacementConstraintProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .expression("expression")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-taskdefinitionplacementconstraint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-taskdefinitionplacementconstraint.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.TaskDefinitionPlacementConstraintProperty")
    @software.amazon.jsii.Jsii.Proxy(TaskDefinitionPlacementConstraintProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TaskDefinitionPlacementConstraintProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of constraint.
         * <p>
         * The <code>MemberOf</code> constraint restricts selection to be from a group of valid candidates.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-taskdefinitionplacementconstraint.html#cfn-ecs-taskdefinition-taskdefinitionplacementconstraint-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-taskdefinitionplacementconstraint.html#cfn-ecs-taskdefinition-taskdefinitionplacementconstraint-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * A cluster query language expression to apply to the constraint.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster query language</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-taskdefinitionplacementconstraint.html#cfn-ecs-taskdefinition-taskdefinitionplacementconstraint-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-taskdefinitionplacementconstraint.html#cfn-ecs-taskdefinition-taskdefinitionplacementconstraint-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExpression() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TaskDefinitionPlacementConstraintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TaskDefinitionPlacementConstraintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TaskDefinitionPlacementConstraintProperty> {
            java.lang.String type;
            java.lang.String expression;

            /**
             * Sets the value of {@link TaskDefinitionPlacementConstraintProperty#getType}
             * @param type The type of constraint. This parameter is required.
             *             The <code>MemberOf</code> constraint restricts selection to be from a group of valid candidates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link TaskDefinitionPlacementConstraintProperty#getExpression}
             * @param expression A cluster query language expression to apply to the constraint.
             *                   For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster query language</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TaskDefinitionPlacementConstraintProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TaskDefinitionPlacementConstraintProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TaskDefinitionPlacementConstraintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TaskDefinitionPlacementConstraintProperty {
            private final java.lang.String type;
            private final java.lang.String expression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.expression = builder.expression;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getExpression() != null) {
                    data.set("expression", om.valueToTree(this.getExpression()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.TaskDefinitionPlacementConstraintProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TaskDefinitionPlacementConstraintProperty.Jsii$Proxy that = (TaskDefinitionPlacementConstraintProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.expression != null ? this.expression.equals(that.expression) : that.expression == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The container path, mount options, and size of the tmpfs mount.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * TmpfsProperty tmpfsProperty = TmpfsProperty.builder()
     *         .size(123)
     *         // the properties below are optional
     *         .containerPath("containerPath")
     *         .mountOptions(List.of("mountOptions"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-tmpfs.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-tmpfs.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.TmpfsProperty")
    @software.amazon.jsii.Jsii.Proxy(TmpfsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TmpfsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum size (in MiB) of the tmpfs volume.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-tmpfs.html#cfn-ecs-taskdefinition-tmpfs-size">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-tmpfs.html#cfn-ecs-taskdefinition-tmpfs-size</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getSize();

        /**
         * The absolute file path where the tmpfs volume is to be mounted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-tmpfs.html#cfn-ecs-taskdefinition-tmpfs-containerpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-tmpfs.html#cfn-ecs-taskdefinition-tmpfs-containerpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainerPath() {
            return null;
        }

        /**
         * The list of tmpfs volume mount options.
         * <p>
         * Valid values: <code>"defaults" | "ro" | "rw" | "suid" | "nosuid" | "dev" | "nodev" | "exec" | "noexec" | "sync" | "async" | "dirsync" | "remount" | "mand" | "nomand" | "atime" | "noatime" | "diratime" | "nodiratime" | "bind" | "rbind" | "unbindable" | "runbindable" | "private" | "rprivate" | "shared" | "rshared" | "slave" | "rslave" | "relatime" | "norelatime" | "strictatime" | "nostrictatime" | "mode" | "uid" | "gid" | "nr_inodes" | "nr_blocks" | "mpol"</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-tmpfs.html#cfn-ecs-taskdefinition-tmpfs-mountoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-tmpfs.html#cfn-ecs-taskdefinition-tmpfs-mountoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMountOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TmpfsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TmpfsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TmpfsProperty> {
            java.lang.Number size;
            java.lang.String containerPath;
            java.util.List<java.lang.String> mountOptions;

            /**
             * Sets the value of {@link TmpfsProperty#getSize}
             * @param size The maximum size (in MiB) of the tmpfs volume. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder size(java.lang.Number size) {
                this.size = size;
                return this;
            }

            /**
             * Sets the value of {@link TmpfsProperty#getContainerPath}
             * @param containerPath The absolute file path where the tmpfs volume is to be mounted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPath(java.lang.String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            /**
             * Sets the value of {@link TmpfsProperty#getMountOptions}
             * @param mountOptions The list of tmpfs volume mount options.
             *                     Valid values: <code>"defaults" | "ro" | "rw" | "suid" | "nosuid" | "dev" | "nodev" | "exec" | "noexec" | "sync" | "async" | "dirsync" | "remount" | "mand" | "nomand" | "atime" | "noatime" | "diratime" | "nodiratime" | "bind" | "rbind" | "unbindable" | "runbindable" | "private" | "rprivate" | "shared" | "rshared" | "slave" | "rslave" | "relatime" | "norelatime" | "strictatime" | "nostrictatime" | "mode" | "uid" | "gid" | "nr_inodes" | "nr_blocks" | "mpol"</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountOptions(java.util.List<java.lang.String> mountOptions) {
                this.mountOptions = mountOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TmpfsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TmpfsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TmpfsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TmpfsProperty {
            private final java.lang.Number size;
            private final java.lang.String containerPath;
            private final java.util.List<java.lang.String> mountOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.size = software.amazon.jsii.Kernel.get(this, "size", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.containerPath = software.amazon.jsii.Kernel.get(this, "containerPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mountOptions = software.amazon.jsii.Kernel.get(this, "mountOptions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.size = java.util.Objects.requireNonNull(builder.size, "size is required");
                this.containerPath = builder.containerPath;
                this.mountOptions = builder.mountOptions;
            }

            @Override
            public final java.lang.Number getSize() {
                return this.size;
            }

            @Override
            public final java.lang.String getContainerPath() {
                return this.containerPath;
            }

            @Override
            public final java.util.List<java.lang.String> getMountOptions() {
                return this.mountOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("size", om.valueToTree(this.getSize()));
                if (this.getContainerPath() != null) {
                    data.set("containerPath", om.valueToTree(this.getContainerPath()));
                }
                if (this.getMountOptions() != null) {
                    data.set("mountOptions", om.valueToTree(this.getMountOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.TmpfsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TmpfsProperty.Jsii$Proxy that = (TmpfsProperty.Jsii$Proxy) o;

                if (!size.equals(that.size)) return false;
                if (this.containerPath != null ? !this.containerPath.equals(that.containerPath) : that.containerPath != null) return false;
                return this.mountOptions != null ? this.mountOptions.equals(that.mountOptions) : that.mountOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.size.hashCode();
                result = 31 * result + (this.containerPath != null ? this.containerPath.hashCode() : 0);
                result = 31 * result + (this.mountOptions != null ? this.mountOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>ulimit</code> settings to pass to the container.
     * <p>
     * Amazon ECS tasks hosted on AWS Fargate use the default resource limit values set by the operating system with the exception of the <code>nofile</code> resource limit parameter which AWS Fargate overrides. The <code>nofile</code> resource limit sets a restriction on the number of open files that a container can use. The default <code>nofile</code> soft limit is <code>65535</code> and the default hard limit is <code>65535</code> .
     * <p>
     * You can specify the <code>ulimit</code> settings for a container in a task definition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * UlimitProperty ulimitProperty = UlimitProperty.builder()
     *         .hardLimit(123)
     *         .name("name")
     *         .softLimit(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-ulimit.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-ulimit.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.UlimitProperty")
    @software.amazon.jsii.Jsii.Proxy(UlimitProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UlimitProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The hard limit for the <code>ulimit</code> type.
         * <p>
         * The value can be specified in bytes, seconds, or as a count, depending on the <code>type</code> of the <code>ulimit</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-ulimit.html#cfn-ecs-taskdefinition-ulimit-hardlimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-ulimit.html#cfn-ecs-taskdefinition-ulimit-hardlimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getHardLimit();

        /**
         * The <code>type</code> of the <code>ulimit</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-ulimit.html#cfn-ecs-taskdefinition-ulimit-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-ulimit.html#cfn-ecs-taskdefinition-ulimit-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The soft limit for the <code>ulimit</code> type.
         * <p>
         * The value can be specified in bytes, seconds, or as a count, depending on the <code>type</code> of the <code>ulimit</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-ulimit.html#cfn-ecs-taskdefinition-ulimit-softlimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-ulimit.html#cfn-ecs-taskdefinition-ulimit-softlimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getSoftLimit();

        /**
         * @return a {@link Builder} of {@link UlimitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UlimitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UlimitProperty> {
            java.lang.Number hardLimit;
            java.lang.String name;
            java.lang.Number softLimit;

            /**
             * Sets the value of {@link UlimitProperty#getHardLimit}
             * @param hardLimit The hard limit for the <code>ulimit</code> type. This parameter is required.
             *                  The value can be specified in bytes, seconds, or as a count, depending on the <code>type</code> of the <code>ulimit</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hardLimit(java.lang.Number hardLimit) {
                this.hardLimit = hardLimit;
                return this;
            }

            /**
             * Sets the value of {@link UlimitProperty#getName}
             * @param name The <code>type</code> of the <code>ulimit</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link UlimitProperty#getSoftLimit}
             * @param softLimit The soft limit for the <code>ulimit</code> type. This parameter is required.
             *                  The value can be specified in bytes, seconds, or as a count, depending on the <code>type</code> of the <code>ulimit</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder softLimit(java.lang.Number softLimit) {
                this.softLimit = softLimit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UlimitProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UlimitProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UlimitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UlimitProperty {
            private final java.lang.Number hardLimit;
            private final java.lang.String name;
            private final java.lang.Number softLimit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hardLimit = software.amazon.jsii.Kernel.get(this, "hardLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.softLimit = software.amazon.jsii.Kernel.get(this, "softLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hardLimit = java.util.Objects.requireNonNull(builder.hardLimit, "hardLimit is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.softLimit = java.util.Objects.requireNonNull(builder.softLimit, "softLimit is required");
            }

            @Override
            public final java.lang.Number getHardLimit() {
                return this.hardLimit;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Number getSoftLimit() {
                return this.softLimit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("hardLimit", om.valueToTree(this.getHardLimit()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("softLimit", om.valueToTree(this.getSoftLimit()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.UlimitProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UlimitProperty.Jsii$Proxy that = (UlimitProperty.Jsii$Proxy) o;

                if (!hardLimit.equals(that.hardLimit)) return false;
                if (!name.equals(that.name)) return false;
                return this.softLimit.equals(that.softLimit);
            }

            @Override
            public final int hashCode() {
                int result = this.hardLimit.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.softLimit.hashCode());
                return result;
            }
        }
    }
    /**
     * Details on a data volume from another container in the same task definition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * VolumeFromProperty volumeFromProperty = VolumeFromProperty.builder()
     *         .readOnly(false)
     *         .sourceContainer("sourceContainer")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volumefrom.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volumefrom.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.VolumeFromProperty")
    @software.amazon.jsii.Jsii.Proxy(VolumeFromProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VolumeFromProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If this value is <code>true</code> , the container has read-only access to the volume.
         * <p>
         * If this value is <code>false</code> , then the container can write to the volume. The default value is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volumefrom.html#cfn-ecs-taskdefinition-volumefrom-readonly">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volumefrom.html#cfn-ecs-taskdefinition-volumefrom-readonly</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadOnly() {
            return null;
        }

        /**
         * The name of another container within the same task definition to mount volumes from.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volumefrom.html#cfn-ecs-taskdefinition-volumefrom-sourcecontainer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volumefrom.html#cfn-ecs-taskdefinition-volumefrom-sourcecontainer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceContainer() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VolumeFromProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VolumeFromProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VolumeFromProperty> {
            java.lang.Object readOnly;
            java.lang.String sourceContainer;

            /**
             * Sets the value of {@link VolumeFromProperty#getReadOnly}
             * @param readOnly If this value is <code>true</code> , the container has read-only access to the volume.
             *                 If this value is <code>false</code> , then the container can write to the volume. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(java.lang.Boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link VolumeFromProperty#getReadOnly}
             * @param readOnly If this value is <code>true</code> , the container has read-only access to the volume.
             *                 If this value is <code>false</code> , then the container can write to the volume. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(software.amazon.awscdk.IResolvable readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link VolumeFromProperty#getSourceContainer}
             * @param sourceContainer The name of another container within the same task definition to mount volumes from.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceContainer(java.lang.String sourceContainer) {
                this.sourceContainer = sourceContainer;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VolumeFromProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VolumeFromProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VolumeFromProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VolumeFromProperty {
            private final java.lang.Object readOnly;
            private final java.lang.String sourceContainer;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.readOnly = software.amazon.jsii.Kernel.get(this, "readOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceContainer = software.amazon.jsii.Kernel.get(this, "sourceContainer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.readOnly = builder.readOnly;
                this.sourceContainer = builder.sourceContainer;
            }

            @Override
            public final java.lang.Object getReadOnly() {
                return this.readOnly;
            }

            @Override
            public final java.lang.String getSourceContainer() {
                return this.sourceContainer;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReadOnly() != null) {
                    data.set("readOnly", om.valueToTree(this.getReadOnly()));
                }
                if (this.getSourceContainer() != null) {
                    data.set("sourceContainer", om.valueToTree(this.getSourceContainer()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.VolumeFromProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VolumeFromProperty.Jsii$Proxy that = (VolumeFromProperty.Jsii$Proxy) o;

                if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) return false;
                return this.sourceContainer != null ? this.sourceContainer.equals(that.sourceContainer) : that.sourceContainer == null;
            }

            @Override
            public final int hashCode() {
                int result = this.readOnly != null ? this.readOnly.hashCode() : 0;
                result = 31 * result + (this.sourceContainer != null ? this.sourceContainer.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The data volume configuration for tasks launched using this task definition.
     * <p>
     * Specifying a volume configuration in a task definition is optional. The volume configuration may contain multiple volumes but only one volume configured at launch is supported. Each volume defined in the volume configuration may only specify a <code>name</code> and one of either <code>configuredAtLaunch</code> , <code>dockerVolumeConfiguration</code> , <code>efsVolumeConfiguration</code> , <code>fsxWindowsFileServerVolumeConfiguration</code> , or <code>host</code> . If an empty volume configuration is specified, by default Amazon ECS uses a host volume. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html">Using data volumes in tasks</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * VolumeProperty volumeProperty = VolumeProperty.builder()
     *         .configuredAtLaunch(false)
     *         .dockerVolumeConfiguration(DockerVolumeConfigurationProperty.builder()
     *                 .autoprovision(false)
     *                 .driver("driver")
     *                 .driverOpts(Map.of(
     *                         "driverOptsKey", "driverOpts"))
     *                 .labels(Map.of(
     *                         "labelsKey", "labels"))
     *                 .scope("scope")
     *                 .build())
     *         .efsVolumeConfiguration(EFSVolumeConfigurationProperty.builder()
     *                 .filesystemId("filesystemId")
     *                 // the properties below are optional
     *                 .authorizationConfig(AuthorizationConfigProperty.builder()
     *                         .accessPointId("accessPointId")
     *                         .iam("iam")
     *                         .build())
     *                 .rootDirectory("rootDirectory")
     *                 .transitEncryption("transitEncryption")
     *                 .transitEncryptionPort(123)
     *                 .build())
     *         .fSxWindowsFileServerVolumeConfiguration(FSxWindowsFileServerVolumeConfigurationProperty.builder()
     *                 .fileSystemId("fileSystemId")
     *                 .rootDirectory("rootDirectory")
     *                 // the properties below are optional
     *                 .authorizationConfig(FSxAuthorizationConfigProperty.builder()
     *                         .credentialsParameter("credentialsParameter")
     *                         .domain("domain")
     *                         .build())
     *                 .build())
     *         .host(HostVolumePropertiesProperty.builder()
     *                 .sourcePath("sourcePath")
     *                 .build())
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volume.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volume.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinition.VolumeProperty")
    @software.amazon.jsii.Jsii.Proxy(VolumeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VolumeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether the volume should be configured at launch time.
         * <p>
         * This is used to create Amazon EBS volumes for standalone tasks or tasks created as part of a service. Each task definition revision may only have one volume configured at launch in the volume configuration.
         * <p>
         * To configure a volume at launch time, use this task definition revision and specify a <code>volumeConfigurations</code> object when calling the <code>CreateService</code> , <code>UpdateService</code> , <code>RunTask</code> or <code>StartTask</code> APIs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volume.html#cfn-ecs-taskdefinition-volume-configuredatlaunch">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volume.html#cfn-ecs-taskdefinition-volume-configuredatlaunch</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfiguredAtLaunch() {
            return null;
        }

        /**
         * This parameter is specified when you use Docker volumes.
         * <p>
         * Windows containers only support the use of the <code>local</code> driver. To use bind mounts, specify the <code>host</code> parameter instead.
         * <p>
         * <blockquote>
         * <p>
         * Docker volumes aren't supported by tasks run on AWS Fargate .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volume.html#cfn-ecs-taskdefinition-volume-dockervolumeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volume.html#cfn-ecs-taskdefinition-volume-dockervolumeconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDockerVolumeConfiguration() {
            return null;
        }

        /**
         * This parameter is specified when you use an Amazon Elastic File System file system for task storage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volume.html#cfn-ecs-taskdefinition-volume-efsvolumeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volume.html#cfn-ecs-taskdefinition-volume-efsvolumeconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEfsVolumeConfiguration() {
            return null;
        }

        /**
         * This parameter is specified when you use Amazon FSx for Windows File Server file system for task storage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volume.html#cfn-ecs-taskdefinition-volume-fsxwindowsfileservervolumeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volume.html#cfn-ecs-taskdefinition-volume-fsxwindowsfileservervolumeconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFSxWindowsFileServerVolumeConfiguration() {
            return null;
        }

        /**
         * This parameter is specified when you use bind mount host volumes.
         * <p>
         * The contents of the <code>host</code> parameter determine whether your bind mount host volume persists on the host container instance and where it's stored. If the <code>host</code> parameter is empty, then the Docker daemon assigns a host path for your data volume. However, the data isn't guaranteed to persist after the containers that are associated with it stop running.
         * <p>
         * Windows containers can mount whole directories on the same drive as <code>$env:ProgramData</code> . Windows containers can't mount directories on a different drive, and mount point can't be across drives. For example, you can mount <code>C:\my\path:C:\my\path</code> and <code>D:\:D:\</code> , but not <code>D:\my\path:C:\my\path</code> or <code>D:\:C:\my\path</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volume.html#cfn-ecs-taskdefinition-volume-host">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volume.html#cfn-ecs-taskdefinition-volume-host</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHost() {
            return null;
        }

        /**
         * The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed.
         * <p>
         * When using a volume configured at launch, the <code>name</code> is required and must also be specified as the volume name in the <code>ServiceVolumeConfiguration</code> or <code>TaskVolumeConfiguration</code> parameter when creating your service or standalone task.
         * <p>
         * For all other types of volumes, this name is referenced in the <code>sourceVolume</code> parameter of the <code>mountPoints</code> object in the container definition.
         * <p>
         * When a volume is using the <code>efsVolumeConfiguration</code> , the name is required.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volume.html#cfn-ecs-taskdefinition-volume-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-volume.html#cfn-ecs-taskdefinition-volume-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VolumeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VolumeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VolumeProperty> {
            java.lang.Object configuredAtLaunch;
            java.lang.Object dockerVolumeConfiguration;
            java.lang.Object efsVolumeConfiguration;
            java.lang.Object fSxWindowsFileServerVolumeConfiguration;
            java.lang.Object host;
            java.lang.String name;

            /**
             * Sets the value of {@link VolumeProperty#getConfiguredAtLaunch}
             * @param configuredAtLaunch Indicates whether the volume should be configured at launch time.
             *                           This is used to create Amazon EBS volumes for standalone tasks or tasks created as part of a service. Each task definition revision may only have one volume configured at launch in the volume configuration.
             *                           <p>
             *                           To configure a volume at launch time, use this task definition revision and specify a <code>volumeConfigurations</code> object when calling the <code>CreateService</code> , <code>UpdateService</code> , <code>RunTask</code> or <code>StartTask</code> APIs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configuredAtLaunch(java.lang.Boolean configuredAtLaunch) {
                this.configuredAtLaunch = configuredAtLaunch;
                return this;
            }

            /**
             * Sets the value of {@link VolumeProperty#getConfiguredAtLaunch}
             * @param configuredAtLaunch Indicates whether the volume should be configured at launch time.
             *                           This is used to create Amazon EBS volumes for standalone tasks or tasks created as part of a service. Each task definition revision may only have one volume configured at launch in the volume configuration.
             *                           <p>
             *                           To configure a volume at launch time, use this task definition revision and specify a <code>volumeConfigurations</code> object when calling the <code>CreateService</code> , <code>UpdateService</code> , <code>RunTask</code> or <code>StartTask</code> APIs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configuredAtLaunch(software.amazon.awscdk.IResolvable configuredAtLaunch) {
                this.configuredAtLaunch = configuredAtLaunch;
                return this;
            }

            /**
             * Sets the value of {@link VolumeProperty#getDockerVolumeConfiguration}
             * @param dockerVolumeConfiguration This parameter is specified when you use Docker volumes.
             *                                  Windows containers only support the use of the <code>local</code> driver. To use bind mounts, specify the <code>host</code> parameter instead.
             *                                  <p>
             *                                  <blockquote>
             *                                  <p>
             *                                  Docker volumes aren't supported by tasks run on AWS Fargate .
             *                                  <p>
             *                                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dockerVolumeConfiguration(software.amazon.awscdk.IResolvable dockerVolumeConfiguration) {
                this.dockerVolumeConfiguration = dockerVolumeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VolumeProperty#getDockerVolumeConfiguration}
             * @param dockerVolumeConfiguration This parameter is specified when you use Docker volumes.
             *                                  Windows containers only support the use of the <code>local</code> driver. To use bind mounts, specify the <code>host</code> parameter instead.
             *                                  <p>
             *                                  <blockquote>
             *                                  <p>
             *                                  Docker volumes aren't supported by tasks run on AWS Fargate .
             *                                  <p>
             *                                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dockerVolumeConfiguration(software.amazon.awscdk.services.ecs.CfnTaskDefinition.DockerVolumeConfigurationProperty dockerVolumeConfiguration) {
                this.dockerVolumeConfiguration = dockerVolumeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VolumeProperty#getEfsVolumeConfiguration}
             * @param efsVolumeConfiguration This parameter is specified when you use an Amazon Elastic File System file system for task storage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder efsVolumeConfiguration(software.amazon.awscdk.IResolvable efsVolumeConfiguration) {
                this.efsVolumeConfiguration = efsVolumeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VolumeProperty#getEfsVolumeConfiguration}
             * @param efsVolumeConfiguration This parameter is specified when you use an Amazon Elastic File System file system for task storage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder efsVolumeConfiguration(software.amazon.awscdk.services.ecs.CfnTaskDefinition.EFSVolumeConfigurationProperty efsVolumeConfiguration) {
                this.efsVolumeConfiguration = efsVolumeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VolumeProperty#getFSxWindowsFileServerVolumeConfiguration}
             * @param fSxWindowsFileServerVolumeConfiguration This parameter is specified when you use Amazon FSx for Windows File Server file system for task storage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fSxWindowsFileServerVolumeConfiguration(software.amazon.awscdk.IResolvable fSxWindowsFileServerVolumeConfiguration) {
                this.fSxWindowsFileServerVolumeConfiguration = fSxWindowsFileServerVolumeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VolumeProperty#getFSxWindowsFileServerVolumeConfiguration}
             * @param fSxWindowsFileServerVolumeConfiguration This parameter is specified when you use Amazon FSx for Windows File Server file system for task storage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fSxWindowsFileServerVolumeConfiguration(software.amazon.awscdk.services.ecs.CfnTaskDefinition.FSxWindowsFileServerVolumeConfigurationProperty fSxWindowsFileServerVolumeConfiguration) {
                this.fSxWindowsFileServerVolumeConfiguration = fSxWindowsFileServerVolumeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VolumeProperty#getHost}
             * @param host This parameter is specified when you use bind mount host volumes.
             *             The contents of the <code>host</code> parameter determine whether your bind mount host volume persists on the host container instance and where it's stored. If the <code>host</code> parameter is empty, then the Docker daemon assigns a host path for your data volume. However, the data isn't guaranteed to persist after the containers that are associated with it stop running.
             *             <p>
             *             Windows containers can mount whole directories on the same drive as <code>$env:ProgramData</code> . Windows containers can't mount directories on a different drive, and mount point can't be across drives. For example, you can mount <code>C:\my\path:C:\my\path</code> and <code>D:\:D:\</code> , but not <code>D:\my\path:C:\my\path</code> or <code>D:\:C:\my\path</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(software.amazon.awscdk.IResolvable host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link VolumeProperty#getHost}
             * @param host This parameter is specified when you use bind mount host volumes.
             *             The contents of the <code>host</code> parameter determine whether your bind mount host volume persists on the host container instance and where it's stored. If the <code>host</code> parameter is empty, then the Docker daemon assigns a host path for your data volume. However, the data isn't guaranteed to persist after the containers that are associated with it stop running.
             *             <p>
             *             Windows containers can mount whole directories on the same drive as <code>$env:ProgramData</code> . Windows containers can't mount directories on a different drive, and mount point can't be across drives. For example, you can mount <code>C:\my\path:C:\my\path</code> and <code>D:\:D:\</code> , but not <code>D:\my\path:C:\my\path</code> or <code>D:\:C:\my\path</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(software.amazon.awscdk.services.ecs.CfnTaskDefinition.HostVolumePropertiesProperty host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link VolumeProperty#getName}
             * @param name The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed.
             *             When using a volume configured at launch, the <code>name</code> is required and must also be specified as the volume name in the <code>ServiceVolumeConfiguration</code> or <code>TaskVolumeConfiguration</code> parameter when creating your service or standalone task.
             *             <p>
             *             For all other types of volumes, this name is referenced in the <code>sourceVolume</code> parameter of the <code>mountPoints</code> object in the container definition.
             *             <p>
             *             When a volume is using the <code>efsVolumeConfiguration</code> , the name is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VolumeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VolumeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VolumeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VolumeProperty {
            private final java.lang.Object configuredAtLaunch;
            private final java.lang.Object dockerVolumeConfiguration;
            private final java.lang.Object efsVolumeConfiguration;
            private final java.lang.Object fSxWindowsFileServerVolumeConfiguration;
            private final java.lang.Object host;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.configuredAtLaunch = software.amazon.jsii.Kernel.get(this, "configuredAtLaunch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dockerVolumeConfiguration = software.amazon.jsii.Kernel.get(this, "dockerVolumeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.efsVolumeConfiguration = software.amazon.jsii.Kernel.get(this, "efsVolumeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fSxWindowsFileServerVolumeConfiguration = software.amazon.jsii.Kernel.get(this, "fSxWindowsFileServerVolumeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configuredAtLaunch = builder.configuredAtLaunch;
                this.dockerVolumeConfiguration = builder.dockerVolumeConfiguration;
                this.efsVolumeConfiguration = builder.efsVolumeConfiguration;
                this.fSxWindowsFileServerVolumeConfiguration = builder.fSxWindowsFileServerVolumeConfiguration;
                this.host = builder.host;
                this.name = builder.name;
            }

            @Override
            public final java.lang.Object getConfiguredAtLaunch() {
                return this.configuredAtLaunch;
            }

            @Override
            public final java.lang.Object getDockerVolumeConfiguration() {
                return this.dockerVolumeConfiguration;
            }

            @Override
            public final java.lang.Object getEfsVolumeConfiguration() {
                return this.efsVolumeConfiguration;
            }

            @Override
            public final java.lang.Object getFSxWindowsFileServerVolumeConfiguration() {
                return this.fSxWindowsFileServerVolumeConfiguration;
            }

            @Override
            public final java.lang.Object getHost() {
                return this.host;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConfiguredAtLaunch() != null) {
                    data.set("configuredAtLaunch", om.valueToTree(this.getConfiguredAtLaunch()));
                }
                if (this.getDockerVolumeConfiguration() != null) {
                    data.set("dockerVolumeConfiguration", om.valueToTree(this.getDockerVolumeConfiguration()));
                }
                if (this.getEfsVolumeConfiguration() != null) {
                    data.set("efsVolumeConfiguration", om.valueToTree(this.getEfsVolumeConfiguration()));
                }
                if (this.getFSxWindowsFileServerVolumeConfiguration() != null) {
                    data.set("fSxWindowsFileServerVolumeConfiguration", om.valueToTree(this.getFSxWindowsFileServerVolumeConfiguration()));
                }
                if (this.getHost() != null) {
                    data.set("host", om.valueToTree(this.getHost()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinition.VolumeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VolumeProperty.Jsii$Proxy that = (VolumeProperty.Jsii$Proxy) o;

                if (this.configuredAtLaunch != null ? !this.configuredAtLaunch.equals(that.configuredAtLaunch) : that.configuredAtLaunch != null) return false;
                if (this.dockerVolumeConfiguration != null ? !this.dockerVolumeConfiguration.equals(that.dockerVolumeConfiguration) : that.dockerVolumeConfiguration != null) return false;
                if (this.efsVolumeConfiguration != null ? !this.efsVolumeConfiguration.equals(that.efsVolumeConfiguration) : that.efsVolumeConfiguration != null) return false;
                if (this.fSxWindowsFileServerVolumeConfiguration != null ? !this.fSxWindowsFileServerVolumeConfiguration.equals(that.fSxWindowsFileServerVolumeConfiguration) : that.fSxWindowsFileServerVolumeConfiguration != null) return false;
                if (this.host != null ? !this.host.equals(that.host) : that.host != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.configuredAtLaunch != null ? this.configuredAtLaunch.hashCode() : 0;
                result = 31 * result + (this.dockerVolumeConfiguration != null ? this.dockerVolumeConfiguration.hashCode() : 0);
                result = 31 * result + (this.efsVolumeConfiguration != null ? this.efsVolumeConfiguration.hashCode() : 0);
                result = 31 * result + (this.fSxWindowsFileServerVolumeConfiguration != null ? this.fSxWindowsFileServerVolumeConfiguration.hashCode() : 0);
                result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.CfnTaskDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.CfnTaskDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ecs.CfnTaskDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A list of container definitions in JSON format that describe the different containers that make up your task.
         * <p>
         * For more information about container definition parameters and defaults, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Amazon ECS Task Definitions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-containerdefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-containerdefinitions</a>
         * @param containerDefinitions A list of container definitions in JSON format that describe the different containers that make up your task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerDefinitions(final software.amazon.awscdk.IResolvable containerDefinitions) {
            this.props().containerDefinitions(containerDefinitions);
            return this;
        }
        /**
         * A list of container definitions in JSON format that describe the different containers that make up your task.
         * <p>
         * For more information about container definition parameters and defaults, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Amazon ECS Task Definitions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-containerdefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-containerdefinitions</a>
         * @param containerDefinitions A list of container definitions in JSON format that describe the different containers that make up your task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerDefinitions(final java.util.List<? extends java.lang.Object> containerDefinitions) {
            this.props().containerDefinitions(containerDefinitions);
            return this;
        }

        /**
         * The number of <code>cpu</code> units used by the task.
         * <p>
         * If you use the EC2 launch type, this field is optional. Any value can be used. If you use the Fargate launch type, this field is required. You must use one of the following values. The value that you choose determines your range of valid values for the <code>memory</code> parameter.
         * <p>
         * If you're using the EC2 launch type or the external launch type, this field is optional. Supported values are between <code>128</code> CPU units ( <code>0.125</code> vCPUs) and <code>196608</code> CPU units ( <code>192</code> vCPUs).
         * <p>
         * This field is required for Fargate. For information about the valid values, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#task_size">Task size</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-cpu">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-cpu</a>
         * @param cpu The number of <code>cpu</code> units used by the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(final java.lang.String cpu) {
            this.props().cpu(cpu);
            return this;
        }

        /**
         * Enables fault injection and allows for fault injection requests to be accepted from the task's containers.
         * <p>
         * The default value is <code>false</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-enablefaultinjection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-enablefaultinjection</a>
         * @param enableFaultInjection Enables fault injection and allows for fault injection requests to be accepted from the task's containers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableFaultInjection(final java.lang.Boolean enableFaultInjection) {
            this.props().enableFaultInjection(enableFaultInjection);
            return this;
        }
        /**
         * Enables fault injection and allows for fault injection requests to be accepted from the task's containers.
         * <p>
         * The default value is <code>false</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-enablefaultinjection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-enablefaultinjection</a>
         * @param enableFaultInjection Enables fault injection and allows for fault injection requests to be accepted from the task's containers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableFaultInjection(final software.amazon.awscdk.IResolvable enableFaultInjection) {
            this.props().enableFaultInjection(enableFaultInjection);
            return this;
        }

        /**
         * The ephemeral storage settings to use for tasks run with the task definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-ephemeralstorage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-ephemeralstorage</a>
         * @param ephemeralStorage The ephemeral storage settings to use for tasks run with the task definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorage(final software.amazon.awscdk.IResolvable ephemeralStorage) {
            this.props().ephemeralStorage(ephemeralStorage);
            return this;
        }
        /**
         * The ephemeral storage settings to use for tasks run with the task definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-ephemeralstorage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-ephemeralstorage</a>
         * @param ephemeralStorage The ephemeral storage settings to use for tasks run with the task definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorage(final software.amazon.awscdk.services.ecs.CfnTaskDefinition.EphemeralStorageProperty ephemeralStorage) {
            this.props().ephemeralStorage(ephemeralStorage);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent permission to make AWS API calls on your behalf.
         * <p>
         * For informationabout the required IAM roles for Amazon ECS, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/security-ecs-iam-role-overview.html">IAM roles for Amazon ECS</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-executionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-executionrolearn</a>
         * @param executionRoleArn The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent permission to make AWS API calls on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(final java.lang.String executionRoleArn) {
            this.props().executionRoleArn(executionRoleArn);
            return this;
        }

        /**
         * The name of a family that this task definition is registered to.
         * <p>
         * Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
         * <p>
         * A family groups multiple versions of a task definition. Amazon ECS gives the first task definition that you registered to a family a revision number of 1. Amazon ECS gives sequential revision numbers to each task definition that you add.
         * <p>
         * <blockquote>
         * <p>
         * To use revision numbers when you update a task definition, specify this property. If you don't specify a value, AWS CloudFormation generates a new task definition each time that you update it.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-family">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-family</a>
         * @param family The name of a family that this task definition is registered to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder family(final java.lang.String family) {
            this.props().family(family);
            return this;
        }

        /**
         * The Elastic Inference accelerators to use for the containers in the task.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-inferenceaccelerators">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-inferenceaccelerators</a>
         * @param inferenceAccelerators The Elastic Inference accelerators to use for the containers in the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceAccelerators(final software.amazon.awscdk.IResolvable inferenceAccelerators) {
            this.props().inferenceAccelerators(inferenceAccelerators);
            return this;
        }
        /**
         * The Elastic Inference accelerators to use for the containers in the task.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-inferenceaccelerators">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-inferenceaccelerators</a>
         * @param inferenceAccelerators The Elastic Inference accelerators to use for the containers in the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceAccelerators(final java.util.List<? extends java.lang.Object> inferenceAccelerators) {
            this.props().inferenceAccelerators(inferenceAccelerators);
            return this;
        }

        /**
         * The IPC resource namespace to use for the containers in the task.
         * <p>
         * The valid values are <code>host</code> , <code>task</code> , or <code>none</code> . If <code>host</code> is specified, then all containers within the tasks that specified the <code>host</code> IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance. If <code>task</code> is specified, all containers within the specified task share the same IPC resources. If <code>none</code> is specified, then IPC resources within the containers of a task are private and not shared with other containers in a task or on the container instance. If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance.
         * <p>
         * If the <code>host</code> IPC mode is used, be aware that there is a heightened risk of undesired IPC namespace expose.
         * <p>
         * If you are setting namespaced kernel parameters using <code>systemControls</code> for the containers in the task, the following will apply to your IPC resource namespace. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">System Controls</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * <ul>
         * <li>For tasks that use the <code>host</code> IPC mode, IPC namespace related <code>systemControls</code> are not supported.</li>
         * <li>For tasks that use the <code>task</code> IPC mode, IPC namespace related <code>systemControls</code> will apply to all containers within a task.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * This parameter is not supported for Windows containers or tasks run on AWS Fargate .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-ipcmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-ipcmode</a>
         * @param ipcMode The IPC resource namespace to use for the containers in the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipcMode(final java.lang.String ipcMode) {
            this.props().ipcMode(ipcMode);
            return this;
        }

        /**
         * The amount (in MiB) of memory used by the task.
         * <p>
         * If your tasks runs on Amazon EC2 instances, you must specify either a task-level memory value or a container-level memory value. This field is optional and any value can be used. If a task-level memory value is specified, the container-level memory value is optional. For more information regarding container-level memory and memory reservation, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html">ContainerDefinition</a> .
         * <p>
         * If your tasks runs on AWS Fargate , this field is required. You must use one of the following values. The value you choose determines your range of valid values for the <code>cpu</code> parameter.
         * <p>
         * <ul>
         * <li>512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)</li>
         * <li>1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)</li>
         * <li>2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available <code>cpu</code> values: 1024 (1 vCPU)</li>
         * <li>Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2 vCPU)</li>
         * <li>Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4 vCPU)</li>
         * <li>Between 16 GB and 60 GB in 4 GB increments - Available <code>cpu</code> values: 8192 (8 vCPU)</li>
         * </ul>
         * <p>
         * This option requires Linux platform <code>1.4.0</code> or later.
         * <p>
         * <ul>
         * <li>Between 32GB and 120 GB in 8 GB increments - Available <code>cpu</code> values: 16384 (16 vCPU)</li>
         * </ul>
         * <p>
         * This option requires Linux platform <code>1.4.0</code> or later.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-memory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-memory</a>
         * @param memory The amount (in MiB) of memory used by the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memory(final java.lang.String memory) {
            this.props().memory(memory);
            return this;
        }

        /**
         * The Docker networking mode to use for the containers in the task.
         * <p>
         * The valid values are <code>none</code> , <code>bridge</code> , <code>awsvpc</code> , and <code>host</code> . If no network mode is specified, the default is <code>bridge</code> .
         * <p>
         * For Amazon ECS tasks on Fargate, the <code>awsvpc</code> network mode is required. For Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can be used. For Amazon ECS tasks on Amazon EC2 Windows instances, <code>&lt;default&gt;</code> or <code>awsvpc</code> can be used. If the network mode is set to <code>none</code> , you cannot specify port mappings in your container definitions, and the tasks containers do not have external connectivity. The <code>host</code> and <code>awsvpc</code> network modes offer the highest networking performance for containers because they use the EC2 network stack instead of the virtualized network stack provided by the <code>bridge</code> mode.
         * <p>
         * With the <code>host</code> and <code>awsvpc</code> network modes, exposed container ports are mapped directly to the corresponding host port (for the <code>host</code> network mode) or the attached elastic network interface port (for the <code>awsvpc</code> network mode), so you cannot take advantage of dynamic host port mappings.
         * <p>
         * <blockquote>
         * <p>
         * When using the <code>host</code> network mode, you should not run containers using the root user (UID 0). It is considered best practice to use a non-root user.
         * <p>
         * </blockquote>
         * <p>
         * If the network mode is <code>awsvpc</code> , the task is allocated an elastic network interface, and you must specify a <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_NetworkConfiguration.html">NetworkConfiguration</a> value when you create a service or run a task with the task definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * If the network mode is <code>host</code> , you cannot run multiple instantiations of the same task on a single container instance when port mappings are used.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-networkmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-networkmode</a>
         * @param networkMode The Docker networking mode to use for the containers in the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkMode(final java.lang.String networkMode) {
            this.props().networkMode(networkMode);
            return this;
        }

        /**
         * The process namespace to use for the containers in the task.
         * <p>
         * The valid values are <code>host</code> or <code>task</code> . On Fargate for Linux containers, the only valid value is <code>task</code> . For example, monitoring sidecars might need <code>pidMode</code> to access information about other containers running in the same task.
         * <p>
         * If <code>host</code> is specified, all containers within the tasks that specified the <code>host</code> PID mode on the same container instance share the same process namespace with the host Amazon EC2 instance.
         * <p>
         * If <code>task</code> is specified, all containers within the specified task share the same process namespace.
         * <p>
         * If no value is specified, the default is a private namespace for each container.
         * <p>
         * If the <code>host</code> PID mode is used, there's a heightened risk of undesired process namespace exposure.
         * <p>
         * <blockquote>
         * <p>
         * This parameter is not supported for Windows containers. &gt; This parameter is only supported for tasks that are hosted on AWS Fargate if the tasks are using platform version <code>1.4.0</code> or later (Linux). This isn't supported for Windows containers on Fargate.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-pidmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-pidmode</a>
         * @param pidMode The process namespace to use for the containers in the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pidMode(final java.lang.String pidMode) {
            this.props().pidMode(pidMode);
            return this;
        }

        /**
         * An array of placement constraint objects to use for tasks.
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't supported for tasks run on AWS Fargate .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-placementconstraints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-placementconstraints</a>
         * @param placementConstraints An array of placement constraint objects to use for tasks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementConstraints(final software.amazon.awscdk.IResolvable placementConstraints) {
            this.props().placementConstraints(placementConstraints);
            return this;
        }
        /**
         * An array of placement constraint objects to use for tasks.
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't supported for tasks run on AWS Fargate .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-placementconstraints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-placementconstraints</a>
         * @param placementConstraints An array of placement constraint objects to use for tasks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementConstraints(final java.util.List<? extends java.lang.Object> placementConstraints) {
            this.props().placementConstraints(placementConstraints);
            return this;
        }

        /**
         * The configuration details for the App Mesh proxy.
         * <p>
         * Your Amazon ECS container instances require at least version 1.26.0 of the container agent and at least version 1.26.0-1 of the <code>ecs-init</code> package to use a proxy configuration. If your container instances are launched from the Amazon ECS optimized AMI version <code>20190301</code> or later, they contain the required versions of the container agent and <code>ecs-init</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-proxyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-proxyconfiguration</a>
         * @param proxyConfiguration The configuration details for the App Mesh proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyConfiguration(final software.amazon.awscdk.IResolvable proxyConfiguration) {
            this.props().proxyConfiguration(proxyConfiguration);
            return this;
        }
        /**
         * The configuration details for the App Mesh proxy.
         * <p>
         * Your Amazon ECS container instances require at least version 1.26.0 of the container agent and at least version 1.26.0-1 of the <code>ecs-init</code> package to use a proxy configuration. If your container instances are launched from the Amazon ECS optimized AMI version <code>20190301</code> or later, they contain the required versions of the container agent and <code>ecs-init</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-proxyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-proxyconfiguration</a>
         * @param proxyConfiguration The configuration details for the App Mesh proxy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyConfiguration(final software.amazon.awscdk.services.ecs.CfnTaskDefinition.ProxyConfigurationProperty proxyConfiguration) {
            this.props().proxyConfiguration(proxyConfiguration);
            return this;
        }

        /**
         * The task launch types the task definition was validated against.
         * <p>
         * The valid values are <code>EC2</code> , <code>FARGATE</code> , and <code>EXTERNAL</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-requirescompatibilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-requirescompatibilities</a>
         * @param requiresCompatibilities The task launch types the task definition was validated against. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requiresCompatibilities(final java.util.List<java.lang.String> requiresCompatibilities) {
            this.props().requiresCompatibilities(requiresCompatibilities);
            return this;
        }

        /**
         * The operating system that your tasks definitions run on.
         * <p>
         * A platform family is specified only for tasks using the Fargate launch type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-runtimeplatform">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-runtimeplatform</a>
         * @param runtimePlatform The operating system that your tasks definitions run on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimePlatform(final software.amazon.awscdk.IResolvable runtimePlatform) {
            this.props().runtimePlatform(runtimePlatform);
            return this;
        }
        /**
         * The operating system that your tasks definitions run on.
         * <p>
         * A platform family is specified only for tasks using the Fargate launch type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-runtimeplatform">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-runtimeplatform</a>
         * @param runtimePlatform The operating system that your tasks definitions run on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimePlatform(final software.amazon.awscdk.services.ecs.CfnTaskDefinition.RuntimePlatformProperty runtimePlatform) {
            this.props().runtimePlatform(runtimePlatform);
            return this;
        }

        /**
         * The metadata that you apply to the task definition to help you categorize and organize them.
         * <p>
         * Each tag consists of a key and an optional value. You define both of them.
         * <p>
         * The following basic restrictions apply to tags:
         * <p>
         * <ul>
         * <li>Maximum number of tags per resource - 50</li>
         * <li>For each resource, each tag key must be unique, and each tag key can have only one value.</li>
         * <li>Maximum key length - 128 Unicode characters in UTF-8</li>
         * <li>Maximum value length - 256 Unicode characters in UTF-8</li>
         * <li>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : /</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-tags</a>
         * @param tags The metadata that you apply to the task definition to help you categorize and organize them. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The short name or full Amazon Resource Name (ARN) of the AWS Identity and Access Management role that grants containers in the task permission to call AWS APIs on your behalf.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">Amazon ECS Task Role</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * IAM roles for tasks on Windows require that the <code>-EnableTaskIAMRole</code> option is set when you launch the Amazon ECS-optimized Windows AMI. Your containers must also run some configuration code to use the feature. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows_task_IAM_roles.html">Windows IAM roles for tasks</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * String validation is done on the ECS side. If an invalid string value is given for <code>TaskRoleArn</code> , it may cause the Cloudformation job to hang.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-taskrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-taskrolearn</a>
         * @param taskRoleArn The short name or full Amazon Resource Name (ARN) of the AWS Identity and Access Management role that grants containers in the task permission to call AWS APIs on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskRoleArn(final java.lang.String taskRoleArn) {
            this.props().taskRoleArn(taskRoleArn);
            return this;
        }

        /**
         * The list of data volume definitions for the task.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html">Using data volumes in tasks</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * The <code>host</code> and <code>sourcePath</code> parameters aren't supported for tasks run on AWS Fargate .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-volumes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-volumes</a>
         * @param volumes The list of data volume definitions for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(final software.amazon.awscdk.IResolvable volumes) {
            this.props().volumes(volumes);
            return this;
        }
        /**
         * The list of data volume definitions for the task.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html">Using data volumes in tasks</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * The <code>host</code> and <code>sourcePath</code> parameters aren't supported for tasks run on AWS Fargate .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-volumes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-volumes</a>
         * @param volumes The list of data volume definitions for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(final java.util.List<? extends java.lang.Object> volumes) {
            this.props().volumes(volumes);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.CfnTaskDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.CfnTaskDefinition build() {
            return new software.amazon.awscdk.services.ecs.CfnTaskDefinition(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.CfnTaskDefinitionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.CfnTaskDefinitionProps.Builder();
            }
            return this.props;
        }
    }
}
