package software.amazon.awscdk.services.ecs;

/**
 * The deployment circuit breaker to use for the service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * TaskDefinition taskDefinition;
 * FargateService service = FargateService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .minHealthyPercent(100)
 *         .circuitBreaker(DeploymentCircuitBreaker.builder()
 *                 .enable(true)
 *                 .rollback(true)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:50.284Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.DeploymentCircuitBreaker")
@software.amazon.jsii.Jsii.Proxy(DeploymentCircuitBreaker.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeploymentCircuitBreaker extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether to enable the deployment circuit breaker logic.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnable() {
        return null;
    }

    /**
     * Whether to enable rollback on deployment failure.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRollback() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DeploymentCircuitBreaker}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeploymentCircuitBreaker}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DeploymentCircuitBreaker> {
        java.lang.Boolean enable;
        java.lang.Boolean rollback;

        /**
         * Sets the value of {@link DeploymentCircuitBreaker#getEnable}
         * @param enable Whether to enable the deployment circuit breaker logic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enable(java.lang.Boolean enable) {
            this.enable = enable;
            return this;
        }

        /**
         * Sets the value of {@link DeploymentCircuitBreaker#getRollback}
         * @param rollback Whether to enable rollback on deployment failure.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rollback(java.lang.Boolean rollback) {
            this.rollback = rollback;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeploymentCircuitBreaker}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DeploymentCircuitBreaker build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DeploymentCircuitBreaker}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentCircuitBreaker {
        private final java.lang.Boolean enable;
        private final java.lang.Boolean rollback;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.enable = software.amazon.jsii.Kernel.get(this, "enable", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.rollback = software.amazon.jsii.Kernel.get(this, "rollback", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.enable = builder.enable;
            this.rollback = builder.rollback;
        }

        @Override
        public final java.lang.Boolean getEnable() {
            return this.enable;
        }

        @Override
        public final java.lang.Boolean getRollback() {
            return this.rollback;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEnable() != null) {
                data.set("enable", om.valueToTree(this.getEnable()));
            }
            if (this.getRollback() != null) {
                data.set("rollback", om.valueToTree(this.getRollback()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.DeploymentCircuitBreaker"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeploymentCircuitBreaker.Jsii$Proxy that = (DeploymentCircuitBreaker.Jsii$Proxy) o;

            if (this.enable != null ? !this.enable.equals(that.enable) : that.enable != null) return false;
            return this.rollback != null ? this.rollback.equals(that.rollback) : that.rollback == null;
        }

        @Override
        public final int hashCode() {
            int result = this.enable != null ? this.enable.hashCode() : 0;
            result = 31 * result + (this.rollback != null ? this.rollback.hashCode() : 0);
            return result;
        }
    }
}
