package software.amazon.awscdk.services.ecs.patterns;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.ecs.patterns.*;
 * CpuArchitecture cpuArchitecture;
 * FargateTaskDefinition fargateTaskDefinition;
 * OperatingSystemFamily operatingSystemFamily;
 * FargateServiceBaseProps fargateServiceBaseProps = FargateServiceBaseProps.builder()
 *         .cpu(123)
 *         .ephemeralStorageGiB(123)
 *         .memoryLimitMiB(123)
 *         .platformVersion(FargatePlatformVersion.LATEST)
 *         .runtimePlatform(RuntimePlatform.builder()
 *                 .cpuArchitecture(cpuArchitecture)
 *                 .operatingSystemFamily(operatingSystemFamily)
 *                 .build())
 *         .taskDefinition(fargateTaskDefinition)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:50.459Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs_patterns.FargateServiceBaseProps")
@software.amazon.jsii.Jsii.Proxy(FargateServiceBaseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FargateServiceBaseProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The number of cpu units used by the task.
     * <p>
     * Valid values, which determines your range of valid values for the memory parameter:
     * <p>
     * 256 (.25 vCPU) - Available memory values: 0.5GB, 1GB, 2GB
     * <p>
     * 512 (.5 vCPU) - Available memory values: 1GB, 2GB, 3GB, 4GB
     * <p>
     * 1024 (1 vCPU) - Available memory values: 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB
     * <p>
     * 2048 (2 vCPU) - Available memory values: Between 4GB and 16GB in 1GB increments
     * <p>
     * 4096 (4 vCPU) - Available memory values: Between 8GB and 30GB in 1GB increments
     * <p>
     * 8192 (8 vCPU) - Available memory values: Between 16GB and 60GB in 4GB increments
     * <p>
     * 16384 (16 vCPU) - Available memory values: Between 32GB and 120GB in 8GB increments
     * <p>
     * This default is set in the underlying FargateTaskDefinition construct.
     * <p>
     * Default: 256
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCpu() {
        return null;
    }

    /**
     * The amount (in GiB) of ephemeral storage to be allocated to the task.
     * <p>
     * The minimum supported value is <code>21</code> GiB and the maximum supported value is <code>200</code> GiB.
     * <p>
     * Only supported in Fargate platform version 1.4.0 or later.
     * <p>
     * Default: Undefined, in which case, the task will receive 20GiB ephemeral storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getEphemeralStorageGiB() {
        return null;
    }

    /**
     * The amount (in MiB) of memory used by the task.
     * <p>
     * This field is required and you must use one of the following values, which determines your range of valid values
     * for the cpu parameter:
     * <p>
     * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25 vCPU)
     * <p>
     * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values: 512 (.5 vCPU)
     * <p>
     * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
     * <p>
     * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available cpu values: 2048 (2 vCPU)
     * <p>
     * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available cpu values: 4096 (4 vCPU)
     * <p>
     * Between 16384 (16 GB) and 61440 (60 GB) in increments of 4096 (4 GB) - Available cpu values: 8192 (8 vCPU)
     * <p>
     * Between 32768 (32 GB) and 122880 (120 GB) in increments of 8192 (8 GB) - Available cpu values: 16384 (16 vCPU)
     * <p>
     * This default is set in the underlying FargateTaskDefinition construct.
     * <p>
     * Default: 512
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMemoryLimitMiB() {
        return null;
    }

    /**
     * The platform version on which to run your service.
     * <p>
     * If one is not specified, the LATEST platform version is used by default. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform Versions</a>
     * in the Amazon Elastic Container Service Developer Guide.
     * <p>
     * Default: Latest
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.FargatePlatformVersion getPlatformVersion() {
        return null;
    }

    /**
     * The runtime platform of the task definition.
     * <p>
     * Default: - If the property is undefined, `operatingSystemFamily` is LINUX and `cpuArchitecture` is X86_64
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.RuntimePlatform getRuntimePlatform() {
        return null;
    }

    /**
     * The task definition to use for tasks in the service. TaskDefinition or TaskImageOptions must be specified, but not both.
     * <p>
     * [disable-awslint:ref-via-interface]
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.FargateTaskDefinition getTaskDefinition() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FargateServiceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FargateServiceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FargateServiceBaseProps> {
        java.lang.Number cpu;
        java.lang.Number ephemeralStorageGiB;
        java.lang.Number memoryLimitMiB;
        software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion;
        software.amazon.awscdk.services.ecs.RuntimePlatform runtimePlatform;
        software.amazon.awscdk.services.ecs.FargateTaskDefinition taskDefinition;

        /**
         * Sets the value of {@link FargateServiceBaseProps#getCpu}
         * @param cpu The number of cpu units used by the task.
         *            Valid values, which determines your range of valid values for the memory parameter:
         *            <p>
         *            256 (.25 vCPU) - Available memory values: 0.5GB, 1GB, 2GB
         *            <p>
         *            512 (.5 vCPU) - Available memory values: 1GB, 2GB, 3GB, 4GB
         *            <p>
         *            1024 (1 vCPU) - Available memory values: 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB
         *            <p>
         *            2048 (2 vCPU) - Available memory values: Between 4GB and 16GB in 1GB increments
         *            <p>
         *            4096 (4 vCPU) - Available memory values: Between 8GB and 30GB in 1GB increments
         *            <p>
         *            8192 (8 vCPU) - Available memory values: Between 16GB and 60GB in 4GB increments
         *            <p>
         *            16384 (16 vCPU) - Available memory values: Between 32GB and 120GB in 8GB increments
         *            <p>
         *            This default is set in the underlying FargateTaskDefinition construct.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(java.lang.Number cpu) {
            this.cpu = cpu;
            return this;
        }

        /**
         * Sets the value of {@link FargateServiceBaseProps#getEphemeralStorageGiB}
         * @param ephemeralStorageGiB The amount (in GiB) of ephemeral storage to be allocated to the task.
         *                            The minimum supported value is <code>21</code> GiB and the maximum supported value is <code>200</code> GiB.
         *                            <p>
         *                            Only supported in Fargate platform version 1.4.0 or later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorageGiB(java.lang.Number ephemeralStorageGiB) {
            this.ephemeralStorageGiB = ephemeralStorageGiB;
            return this;
        }

        /**
         * Sets the value of {@link FargateServiceBaseProps#getMemoryLimitMiB}
         * @param memoryLimitMiB The amount (in MiB) of memory used by the task.
         *                       This field is required and you must use one of the following values, which determines your range of valid values
         *                       for the cpu parameter:
         *                       <p>
         *                       512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25 vCPU)
         *                       <p>
         *                       1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values: 512 (.5 vCPU)
         *                       <p>
         *                       2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
         *                       <p>
         *                       Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available cpu values: 2048 (2 vCPU)
         *                       <p>
         *                       Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available cpu values: 4096 (4 vCPU)
         *                       <p>
         *                       Between 16384 (16 GB) and 61440 (60 GB) in increments of 4096 (4 GB) - Available cpu values: 8192 (8 vCPU)
         *                       <p>
         *                       Between 32768 (32 GB) and 122880 (120 GB) in increments of 8192 (8 GB) - Available cpu values: 16384 (16 vCPU)
         *                       <p>
         *                       This default is set in the underlying FargateTaskDefinition construct.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryLimitMiB(java.lang.Number memoryLimitMiB) {
            this.memoryLimitMiB = memoryLimitMiB;
            return this;
        }

        /**
         * Sets the value of {@link FargateServiceBaseProps#getPlatformVersion}
         * @param platformVersion The platform version on which to run your service.
         *                        If one is not specified, the LATEST platform version is used by default. For more information, see
         *                        <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform Versions</a>
         *                        in the Amazon Elastic Container Service Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformVersion(software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        /**
         * Sets the value of {@link FargateServiceBaseProps#getRuntimePlatform}
         * @param runtimePlatform The runtime platform of the task definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimePlatform(software.amazon.awscdk.services.ecs.RuntimePlatform runtimePlatform) {
            this.runtimePlatform = runtimePlatform;
            return this;
        }

        /**
         * Sets the value of {@link FargateServiceBaseProps#getTaskDefinition}
         * @param taskDefinition The task definition to use for tasks in the service. TaskDefinition or TaskImageOptions must be specified, but not both.
         *                       [disable-awslint:ref-via-interface]
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(software.amazon.awscdk.services.ecs.FargateTaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FargateServiceBaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FargateServiceBaseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FargateServiceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FargateServiceBaseProps {
        private final java.lang.Number cpu;
        private final java.lang.Number ephemeralStorageGiB;
        private final java.lang.Number memoryLimitMiB;
        private final software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion;
        private final software.amazon.awscdk.services.ecs.RuntimePlatform runtimePlatform;
        private final software.amazon.awscdk.services.ecs.FargateTaskDefinition taskDefinition;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cpu = software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.ephemeralStorageGiB = software.amazon.jsii.Kernel.get(this, "ephemeralStorageGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.memoryLimitMiB = software.amazon.jsii.Kernel.get(this, "memoryLimitMiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.platformVersion = software.amazon.jsii.Kernel.get(this, "platformVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FargatePlatformVersion.class));
            this.runtimePlatform = software.amazon.jsii.Kernel.get(this, "runtimePlatform", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.RuntimePlatform.class));
            this.taskDefinition = software.amazon.jsii.Kernel.get(this, "taskDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FargateTaskDefinition.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cpu = builder.cpu;
            this.ephemeralStorageGiB = builder.ephemeralStorageGiB;
            this.memoryLimitMiB = builder.memoryLimitMiB;
            this.platformVersion = builder.platformVersion;
            this.runtimePlatform = builder.runtimePlatform;
            this.taskDefinition = builder.taskDefinition;
        }

        @Override
        public final java.lang.Number getCpu() {
            return this.cpu;
        }

        @Override
        public final java.lang.Number getEphemeralStorageGiB() {
            return this.ephemeralStorageGiB;
        }

        @Override
        public final java.lang.Number getMemoryLimitMiB() {
            return this.memoryLimitMiB;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.FargatePlatformVersion getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.RuntimePlatform getRuntimePlatform() {
            return this.runtimePlatform;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.FargateTaskDefinition getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCpu() != null) {
                data.set("cpu", om.valueToTree(this.getCpu()));
            }
            if (this.getEphemeralStorageGiB() != null) {
                data.set("ephemeralStorageGiB", om.valueToTree(this.getEphemeralStorageGiB()));
            }
            if (this.getMemoryLimitMiB() != null) {
                data.set("memoryLimitMiB", om.valueToTree(this.getMemoryLimitMiB()));
            }
            if (this.getPlatformVersion() != null) {
                data.set("platformVersion", om.valueToTree(this.getPlatformVersion()));
            }
            if (this.getRuntimePlatform() != null) {
                data.set("runtimePlatform", om.valueToTree(this.getRuntimePlatform()));
            }
            if (this.getTaskDefinition() != null) {
                data.set("taskDefinition", om.valueToTree(this.getTaskDefinition()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs_patterns.FargateServiceBaseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FargateServiceBaseProps.Jsii$Proxy that = (FargateServiceBaseProps.Jsii$Proxy) o;

            if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) return false;
            if (this.ephemeralStorageGiB != null ? !this.ephemeralStorageGiB.equals(that.ephemeralStorageGiB) : that.ephemeralStorageGiB != null) return false;
            if (this.memoryLimitMiB != null ? !this.memoryLimitMiB.equals(that.memoryLimitMiB) : that.memoryLimitMiB != null) return false;
            if (this.platformVersion != null ? !this.platformVersion.equals(that.platformVersion) : that.platformVersion != null) return false;
            if (this.runtimePlatform != null ? !this.runtimePlatform.equals(that.runtimePlatform) : that.runtimePlatform != null) return false;
            return this.taskDefinition != null ? this.taskDefinition.equals(that.taskDefinition) : that.taskDefinition == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cpu != null ? this.cpu.hashCode() : 0;
            result = 31 * result + (this.ephemeralStorageGiB != null ? this.ephemeralStorageGiB.hashCode() : 0);
            result = 31 * result + (this.memoryLimitMiB != null ? this.memoryLimitMiB.hashCode() : 0);
            result = 31 * result + (this.platformVersion != null ? this.platformVersion.hashCode() : 0);
            result = 31 * result + (this.runtimePlatform != null ? this.runtimePlatform.hashCode() : 0);
            result = 31 * result + (this.taskDefinition != null ? this.taskDefinition.hashCode() : 0);
            return result;
        }
    }
}
