package software.amazon.awscdk.services.eks;

/**
 * Endpoint access characteristics.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.cdk.lambdalayer.kubectl.v32.KubectlV32Layer;
 * Cluster cluster = Cluster.Builder.create(this, "hello-eks")
 *         .version(KubernetesVersion.V1_32)
 *         .endpointAccess(EndpointAccess.PRIVATE) // No access outside of your VPC.
 *         .kubectlLayer(new KubectlV32Layer(this, "kubectl"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:50.679Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.EndpointAccess")
public class EndpointAccess extends software.amazon.jsii.JsiiObject {

    protected EndpointAccess(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EndpointAccess(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PRIVATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.EndpointAccess.class, "PRIVATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.EndpointAccess.class));
        PUBLIC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.EndpointAccess.class, "PUBLIC", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.EndpointAccess.class));
        PUBLIC_AND_PRIVATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.EndpointAccess.class, "PUBLIC_AND_PRIVATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.EndpointAccess.class));
    }

    /**
     * Restrict public access to specific CIDR blocks.
     * <p>
     * If public access is disabled, this method will result in an error.
     * <p>
     * @param cidr CIDR blocks. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.EndpointAccess onlyFrom(final @org.jetbrains.annotations.NotNull java.lang.String... cidr) {
        return software.amazon.jsii.Kernel.call(this, "onlyFrom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.EndpointAccess.class), java.util.Arrays.<Object>stream(cidr).toArray(Object[]::new));
    }

    /**
     * The cluster endpoint is only accessible through your VPC.
     * <p>
     * Worker node traffic to the endpoint will stay within your VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.EndpointAccess PRIVATE;

    /**
     * The cluster endpoint is accessible from outside of your VPC.
     * <p>
     * Worker node traffic will leave your VPC to connect to the endpoint.
     * <p>
     * By default, the endpoint is exposed to all adresses. You can optionally limit the CIDR blocks that can access the public endpoint using the <code>PUBLIC.onlyFrom</code> method.
     * If you limit access to specific CIDR blocks, you must ensure that the CIDR blocks that you
     * specify include the addresses that worker nodes and Fargate pods (if you use them)
     * access the public endpoint from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.EndpointAccess PUBLIC;

    /**
     * The cluster endpoint is accessible from outside of your VPC.
     * <p>
     * Worker node traffic to the endpoint will stay within your VPC.
     * <p>
     * By default, the endpoint is exposed to all adresses. You can optionally limit the CIDR blocks that can access the public endpoint using the <code>PUBLIC_AND_PRIVATE.onlyFrom</code> method.
     * If you limit access to specific CIDR blocks, you must ensure that the CIDR blocks that you
     * specify include the addresses that worker nodes and Fargate pods (if you use them)
     * access the public endpoint from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.EndpointAccess PUBLIC_AND_PRIVATE;
}
