package software.amazon.awscdk.services.eks;

/**
 * NodeGroup properties interface.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.eks.*;
 * import software.amazon.awscdk.services.iam.*;
 * Cluster cluster;
 * InstanceType instanceType;
 * Role role;
 * SecurityGroup securityGroup;
 * Subnet subnet;
 * SubnetFilter subnetFilter;
 * NodegroupProps nodegroupProps = NodegroupProps.builder()
 *         .cluster(cluster)
 *         // the properties below are optional
 *         .amiType(NodegroupAmiType.AL2_X86_64)
 *         .capacityType(CapacityType.SPOT)
 *         .desiredSize(123)
 *         .diskSize(123)
 *         .enableNodeAutoRepair(false)
 *         .forceUpdate(false)
 *         .instanceTypes(List.of(instanceType))
 *         .labels(Map.of(
 *                 "labelsKey", "labels"))
 *         .launchTemplateSpec(LaunchTemplateSpec.builder()
 *                 .id("id")
 *                 // the properties below are optional
 *                 .version("version")
 *                 .build())
 *         .maxSize(123)
 *         .maxUnavailable(123)
 *         .maxUnavailablePercentage(123)
 *         .minSize(123)
 *         .nodegroupName("nodegroupName")
 *         .nodeRole(role)
 *         .releaseVersion("releaseVersion")
 *         .remoteAccess(NodegroupRemoteAccess.builder()
 *                 .sshKeyName("sshKeyName")
 *                 // the properties below are optional
 *                 .sourceSecurityGroups(List.of(securityGroup))
 *                 .build())
 *         .subnets(SubnetSelection.builder()
 *                 .availabilityZones(List.of("availabilityZones"))
 *                 .onePerAz(false)
 *                 .subnetFilters(List.of(subnetFilter))
 *                 .subnetGroupName("subnetGroupName")
 *                 .subnets(List.of(subnet))
 *                 .subnetType(SubnetType.PRIVATE_ISOLATED)
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .taints(List.of(TaintSpec.builder()
 *                 .effect(TaintEffect.NO_SCHEDULE)
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:50.717Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.NodegroupProps")
@software.amazon.jsii.Jsii.Proxy(NodegroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NodegroupProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.eks.NodegroupOptions {

    /**
     * Cluster resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.ICluster getCluster();

    /**
     * @return a {@link Builder} of {@link NodegroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NodegroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NodegroupProps> {
        software.amazon.awscdk.services.eks.ICluster cluster;
        software.amazon.awscdk.services.eks.NodegroupAmiType amiType;
        software.amazon.awscdk.services.eks.CapacityType capacityType;
        java.lang.Number desiredSize;
        java.lang.Number diskSize;
        java.lang.Boolean enableNodeAutoRepair;
        java.lang.Boolean forceUpdate;
        java.util.List<software.amazon.awscdk.services.ec2.InstanceType> instanceTypes;
        java.util.Map<java.lang.String, java.lang.String> labels;
        software.amazon.awscdk.services.eks.LaunchTemplateSpec launchTemplateSpec;
        java.lang.Number maxSize;
        java.lang.Number maxUnavailable;
        java.lang.Number maxUnavailablePercentage;
        java.lang.Number minSize;
        java.lang.String nodegroupName;
        software.amazon.awscdk.services.iam.IRole nodeRole;
        java.lang.String releaseVersion;
        software.amazon.awscdk.services.eks.NodegroupRemoteAccess remoteAccess;
        software.amazon.awscdk.services.ec2.SubnetSelection subnets;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.util.List<software.amazon.awscdk.services.eks.TaintSpec> taints;

        /**
         * Sets the value of {@link NodegroupProps#getCluster}
         * @param cluster Cluster resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.eks.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link NodegroupProps#getAmiType}
         * @param amiType The AMI type for your node group.
         *                If you explicitly specify the launchTemplate with custom AMI, do not specify this property, or
         *                the node group deployment will fail. In other cases, you will need to specify correct amiType for the nodegroup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amiType(software.amazon.awscdk.services.eks.NodegroupAmiType amiType) {
            this.amiType = amiType;
            return this;
        }

        /**
         * Sets the value of {@link NodegroupProps#getCapacityType}
         * @param capacityType The capacity type of the nodegroup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityType(software.amazon.awscdk.services.eks.CapacityType capacityType) {
            this.capacityType = capacityType;
            return this;
        }

        /**
         * Sets the value of {@link NodegroupProps#getDesiredSize}
         * @param desiredSize The current number of worker nodes that the managed node group should maintain.
         *                    If not specified,
         *                    the nodewgroup will initially create <code>minSize</code> instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredSize(java.lang.Number desiredSize) {
            this.desiredSize = desiredSize;
            return this;
        }

        /**
         * Sets the value of {@link NodegroupProps#getDiskSize}
         * @param diskSize The root device disk size (in GiB) for your node group instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder diskSize(java.lang.Number diskSize) {
            this.diskSize = diskSize;
            return this;
        }

        /**
         * Sets the value of {@link NodegroupProps#getEnableNodeAutoRepair}
         * @param enableNodeAutoRepair Specifies whether to enable node auto repair for the node group.
         *                             Node auto repair is disabled by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableNodeAutoRepair(java.lang.Boolean enableNodeAutoRepair) {
            this.enableNodeAutoRepair = enableNodeAutoRepair;
            return this;
        }

        /**
         * Sets the value of {@link NodegroupProps#getForceUpdate}
         * @param forceUpdate Force the update if the existing node group's pods are unable to be drained due to a pod disruption budget issue.
         *                    If an update fails because pods could not be drained, you can force the update after it fails to terminate the old
         *                    node whether or not any pods are
         *                    running on the node.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forceUpdate(java.lang.Boolean forceUpdate) {
            this.forceUpdate = forceUpdate;
            return this;
        }

        /**
         * Sets the value of {@link NodegroupProps#getInstanceTypes}
         * @param instanceTypes The instance types to use for your node group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder instanceTypes(java.util.List<? extends software.amazon.awscdk.services.ec2.InstanceType> instanceTypes) {
            this.instanceTypes = (java.util.List<software.amazon.awscdk.services.ec2.InstanceType>)instanceTypes;
            return this;
        }

        /**
         * Sets the value of {@link NodegroupProps#getLabels}
         * @param labels The Kubernetes labels to be applied to the nodes in the node group when they are created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(java.util.Map<java.lang.String, java.lang.String> labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Sets the value of {@link NodegroupProps#getLaunchTemplateSpec}
         * @param launchTemplateSpec Launch template specification used for the nodegroup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplateSpec(software.amazon.awscdk.services.eks.LaunchTemplateSpec launchTemplateSpec) {
            this.launchTemplateSpec = launchTemplateSpec;
            return this;
        }

        /**
         * Sets the value of {@link NodegroupProps#getMaxSize}
         * @param maxSize The maximum number of worker nodes that the managed node group can scale out to.
         *                Managed node groups can support up to 100 nodes by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxSize(java.lang.Number maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        /**
         * Sets the value of {@link NodegroupProps#getMaxUnavailable}
         * @param maxUnavailable The maximum number of nodes unavailable at once during a version update.
         *                       Nodes will be updated in parallel. The maximum number is 100.
         *                       <p>
         *                       This value or <code>maxUnavailablePercentage</code> is required to have a value for custom update configurations to be applied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxUnavailable(java.lang.Number maxUnavailable) {
            this.maxUnavailable = maxUnavailable;
            return this;
        }

        /**
         * Sets the value of {@link NodegroupProps#getMaxUnavailablePercentage}
         * @param maxUnavailablePercentage The maximum percentage of nodes unavailable during a version update.
         *                                 This percentage of nodes will be updated in parallel, up to 100 nodes at once.
         *                                 <p>
         *                                 This value or <code>maxUnavailable</code> is required to have a value for custom update configurations to be applied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxUnavailablePercentage(java.lang.Number maxUnavailablePercentage) {
            this.maxUnavailablePercentage = maxUnavailablePercentage;
            return this;
        }

        /**
         * Sets the value of {@link NodegroupProps#getMinSize}
         * @param minSize The minimum number of worker nodes that the managed node group can scale in to.
         *                This number must be greater than or equal to zero.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minSize(java.lang.Number minSize) {
            this.minSize = minSize;
            return this;
        }

        /**
         * Sets the value of {@link NodegroupProps#getNodegroupName}
         * @param nodegroupName Name of the Nodegroup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodegroupName(java.lang.String nodegroupName) {
            this.nodegroupName = nodegroupName;
            return this;
        }

        /**
         * Sets the value of {@link NodegroupProps#getNodeRole}
         * @param nodeRole The IAM role to associate with your node group.
         *                 The Amazon EKS worker node kubelet daemon
         *                 makes calls to AWS APIs on your behalf. Worker nodes receive permissions for these API calls through
         *                 an IAM instance profile and associated policies. Before you can launch worker nodes and register them
         *                 into a cluster, you must create an IAM role for those worker nodes to use when they are launched.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeRole(software.amazon.awscdk.services.iam.IRole nodeRole) {
            this.nodeRole = nodeRole;
            return this;
        }

        /**
         * Sets the value of {@link NodegroupProps#getReleaseVersion}
         * @param releaseVersion The AMI version of the Amazon EKS-optimized AMI to use with your node group (for example, <code>1.14.7-YYYYMMDD</code>).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder releaseVersion(java.lang.String releaseVersion) {
            this.releaseVersion = releaseVersion;
            return this;
        }

        /**
         * Sets the value of {@link NodegroupProps#getRemoteAccess}
         * @param remoteAccess The remote access (SSH) configuration to use with your node group.
         *                     Disabled by default, however, if you
         *                     specify an Amazon EC2 SSH key but do not specify a source security group when you create a managed node group,
         *                     then port 22 on the worker nodes is opened to the internet (0.0.0.0/0)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder remoteAccess(software.amazon.awscdk.services.eks.NodegroupRemoteAccess remoteAccess) {
            this.remoteAccess = remoteAccess;
            return this;
        }

        /**
         * Sets the value of {@link NodegroupProps#getSubnets}
         * @param subnets The subnets to use for the Auto Scaling group that is created for your node group.
         *                By specifying the
         *                SubnetSelection, the selected subnets will automatically apply required tags i.e.
         *                <code>kubernetes.io/cluster/CLUSTER_NAME</code> with a value of <code>shared</code>, where <code>CLUSTER_NAME</code> is replaced with
         *                the name of your cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnets(software.amazon.awscdk.services.ec2.SubnetSelection subnets) {
            this.subnets = subnets;
            return this;
        }

        /**
         * Sets the value of {@link NodegroupProps#getTags}
         * @param tags The metadata to apply to the node group to assist with categorization and organization.
         *             Each tag consists of
         *             a key and an optional value, both of which you define. Node group tags do not propagate to any other resources
         *             associated with the node group, such as the Amazon EC2 instances or subnets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link NodegroupProps#getTaints}
         * @param taints The Kubernetes taints to be applied to the nodes in the node group when they are created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder taints(java.util.List<? extends software.amazon.awscdk.services.eks.TaintSpec> taints) {
            this.taints = (java.util.List<software.amazon.awscdk.services.eks.TaintSpec>)taints;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NodegroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NodegroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NodegroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NodegroupProps {
        private final software.amazon.awscdk.services.eks.ICluster cluster;
        private final software.amazon.awscdk.services.eks.NodegroupAmiType amiType;
        private final software.amazon.awscdk.services.eks.CapacityType capacityType;
        private final java.lang.Number desiredSize;
        private final java.lang.Number diskSize;
        private final java.lang.Boolean enableNodeAutoRepair;
        private final java.lang.Boolean forceUpdate;
        private final java.util.List<software.amazon.awscdk.services.ec2.InstanceType> instanceTypes;
        private final java.util.Map<java.lang.String, java.lang.String> labels;
        private final software.amazon.awscdk.services.eks.LaunchTemplateSpec launchTemplateSpec;
        private final java.lang.Number maxSize;
        private final java.lang.Number maxUnavailable;
        private final java.lang.Number maxUnavailablePercentage;
        private final java.lang.Number minSize;
        private final java.lang.String nodegroupName;
        private final software.amazon.awscdk.services.iam.IRole nodeRole;
        private final java.lang.String releaseVersion;
        private final software.amazon.awscdk.services.eks.NodegroupRemoteAccess remoteAccess;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnets;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.util.List<software.amazon.awscdk.services.eks.TaintSpec> taints;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.ICluster.class));
            this.amiType = software.amazon.jsii.Kernel.get(this, "amiType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.NodegroupAmiType.class));
            this.capacityType = software.amazon.jsii.Kernel.get(this, "capacityType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.CapacityType.class));
            this.desiredSize = software.amazon.jsii.Kernel.get(this, "desiredSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.diskSize = software.amazon.jsii.Kernel.get(this, "diskSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.enableNodeAutoRepair = software.amazon.jsii.Kernel.get(this, "enableNodeAutoRepair", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.forceUpdate = software.amazon.jsii.Kernel.get(this, "forceUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.instanceTypes = software.amazon.jsii.Kernel.get(this, "instanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class)));
            this.labels = software.amazon.jsii.Kernel.get(this, "labels", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.launchTemplateSpec = software.amazon.jsii.Kernel.get(this, "launchTemplateSpec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.LaunchTemplateSpec.class));
            this.maxSize = software.amazon.jsii.Kernel.get(this, "maxSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxUnavailable = software.amazon.jsii.Kernel.get(this, "maxUnavailable", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxUnavailablePercentage = software.amazon.jsii.Kernel.get(this, "maxUnavailablePercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minSize = software.amazon.jsii.Kernel.get(this, "minSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.nodegroupName = software.amazon.jsii.Kernel.get(this, "nodegroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.nodeRole = software.amazon.jsii.Kernel.get(this, "nodeRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.releaseVersion = software.amazon.jsii.Kernel.get(this, "releaseVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.remoteAccess = software.amazon.jsii.Kernel.get(this, "remoteAccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.NodegroupRemoteAccess.class));
            this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.taints = software.amazon.jsii.Kernel.get(this, "taints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.TaintSpec.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.amiType = builder.amiType;
            this.capacityType = builder.capacityType;
            this.desiredSize = builder.desiredSize;
            this.diskSize = builder.diskSize;
            this.enableNodeAutoRepair = builder.enableNodeAutoRepair;
            this.forceUpdate = builder.forceUpdate;
            this.instanceTypes = (java.util.List<software.amazon.awscdk.services.ec2.InstanceType>)builder.instanceTypes;
            this.labels = builder.labels;
            this.launchTemplateSpec = builder.launchTemplateSpec;
            this.maxSize = builder.maxSize;
            this.maxUnavailable = builder.maxUnavailable;
            this.maxUnavailablePercentage = builder.maxUnavailablePercentage;
            this.minSize = builder.minSize;
            this.nodegroupName = builder.nodegroupName;
            this.nodeRole = builder.nodeRole;
            this.releaseVersion = builder.releaseVersion;
            this.remoteAccess = builder.remoteAccess;
            this.subnets = builder.subnets;
            this.tags = builder.tags;
            this.taints = (java.util.List<software.amazon.awscdk.services.eks.TaintSpec>)builder.taints;
        }

        @Override
        public final software.amazon.awscdk.services.eks.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final software.amazon.awscdk.services.eks.NodegroupAmiType getAmiType() {
            return this.amiType;
        }

        @Override
        public final software.amazon.awscdk.services.eks.CapacityType getCapacityType() {
            return this.capacityType;
        }

        @Override
        public final java.lang.Number getDesiredSize() {
            return this.desiredSize;
        }

        @Override
        public final java.lang.Number getDiskSize() {
            return this.diskSize;
        }

        @Override
        public final java.lang.Boolean getEnableNodeAutoRepair() {
            return this.enableNodeAutoRepair;
        }

        @Override
        public final java.lang.Boolean getForceUpdate() {
            return this.forceUpdate;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.InstanceType> getInstanceTypes() {
            return this.instanceTypes;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getLabels() {
            return this.labels;
        }

        @Override
        public final software.amazon.awscdk.services.eks.LaunchTemplateSpec getLaunchTemplateSpec() {
            return this.launchTemplateSpec;
        }

        @Override
        public final java.lang.Number getMaxSize() {
            return this.maxSize;
        }

        @Override
        public final java.lang.Number getMaxUnavailable() {
            return this.maxUnavailable;
        }

        @Override
        public final java.lang.Number getMaxUnavailablePercentage() {
            return this.maxUnavailablePercentage;
        }

        @Override
        public final java.lang.Number getMinSize() {
            return this.minSize;
        }

        @Override
        public final java.lang.String getNodegroupName() {
            return this.nodegroupName;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getNodeRole() {
            return this.nodeRole;
        }

        @Override
        public final java.lang.String getReleaseVersion() {
            return this.releaseVersion;
        }

        @Override
        public final software.amazon.awscdk.services.eks.NodegroupRemoteAccess getRemoteAccess() {
            return this.remoteAccess;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getSubnets() {
            return this.subnets;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.eks.TaintSpec> getTaints() {
            return this.taints;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cluster", om.valueToTree(this.getCluster()));
            if (this.getAmiType() != null) {
                data.set("amiType", om.valueToTree(this.getAmiType()));
            }
            if (this.getCapacityType() != null) {
                data.set("capacityType", om.valueToTree(this.getCapacityType()));
            }
            if (this.getDesiredSize() != null) {
                data.set("desiredSize", om.valueToTree(this.getDesiredSize()));
            }
            if (this.getDiskSize() != null) {
                data.set("diskSize", om.valueToTree(this.getDiskSize()));
            }
            if (this.getEnableNodeAutoRepair() != null) {
                data.set("enableNodeAutoRepair", om.valueToTree(this.getEnableNodeAutoRepair()));
            }
            if (this.getForceUpdate() != null) {
                data.set("forceUpdate", om.valueToTree(this.getForceUpdate()));
            }
            if (this.getInstanceTypes() != null) {
                data.set("instanceTypes", om.valueToTree(this.getInstanceTypes()));
            }
            if (this.getLabels() != null) {
                data.set("labels", om.valueToTree(this.getLabels()));
            }
            if (this.getLaunchTemplateSpec() != null) {
                data.set("launchTemplateSpec", om.valueToTree(this.getLaunchTemplateSpec()));
            }
            if (this.getMaxSize() != null) {
                data.set("maxSize", om.valueToTree(this.getMaxSize()));
            }
            if (this.getMaxUnavailable() != null) {
                data.set("maxUnavailable", om.valueToTree(this.getMaxUnavailable()));
            }
            if (this.getMaxUnavailablePercentage() != null) {
                data.set("maxUnavailablePercentage", om.valueToTree(this.getMaxUnavailablePercentage()));
            }
            if (this.getMinSize() != null) {
                data.set("minSize", om.valueToTree(this.getMinSize()));
            }
            if (this.getNodegroupName() != null) {
                data.set("nodegroupName", om.valueToTree(this.getNodegroupName()));
            }
            if (this.getNodeRole() != null) {
                data.set("nodeRole", om.valueToTree(this.getNodeRole()));
            }
            if (this.getReleaseVersion() != null) {
                data.set("releaseVersion", om.valueToTree(this.getReleaseVersion()));
            }
            if (this.getRemoteAccess() != null) {
                data.set("remoteAccess", om.valueToTree(this.getRemoteAccess()));
            }
            if (this.getSubnets() != null) {
                data.set("subnets", om.valueToTree(this.getSubnets()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTaints() != null) {
                data.set("taints", om.valueToTree(this.getTaints()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.NodegroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NodegroupProps.Jsii$Proxy that = (NodegroupProps.Jsii$Proxy) o;

            if (!cluster.equals(that.cluster)) return false;
            if (this.amiType != null ? !this.amiType.equals(that.amiType) : that.amiType != null) return false;
            if (this.capacityType != null ? !this.capacityType.equals(that.capacityType) : that.capacityType != null) return false;
            if (this.desiredSize != null ? !this.desiredSize.equals(that.desiredSize) : that.desiredSize != null) return false;
            if (this.diskSize != null ? !this.diskSize.equals(that.diskSize) : that.diskSize != null) return false;
            if (this.enableNodeAutoRepair != null ? !this.enableNodeAutoRepair.equals(that.enableNodeAutoRepair) : that.enableNodeAutoRepair != null) return false;
            if (this.forceUpdate != null ? !this.forceUpdate.equals(that.forceUpdate) : that.forceUpdate != null) return false;
            if (this.instanceTypes != null ? !this.instanceTypes.equals(that.instanceTypes) : that.instanceTypes != null) return false;
            if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) return false;
            if (this.launchTemplateSpec != null ? !this.launchTemplateSpec.equals(that.launchTemplateSpec) : that.launchTemplateSpec != null) return false;
            if (this.maxSize != null ? !this.maxSize.equals(that.maxSize) : that.maxSize != null) return false;
            if (this.maxUnavailable != null ? !this.maxUnavailable.equals(that.maxUnavailable) : that.maxUnavailable != null) return false;
            if (this.maxUnavailablePercentage != null ? !this.maxUnavailablePercentage.equals(that.maxUnavailablePercentage) : that.maxUnavailablePercentage != null) return false;
            if (this.minSize != null ? !this.minSize.equals(that.minSize) : that.minSize != null) return false;
            if (this.nodegroupName != null ? !this.nodegroupName.equals(that.nodegroupName) : that.nodegroupName != null) return false;
            if (this.nodeRole != null ? !this.nodeRole.equals(that.nodeRole) : that.nodeRole != null) return false;
            if (this.releaseVersion != null ? !this.releaseVersion.equals(that.releaseVersion) : that.releaseVersion != null) return false;
            if (this.remoteAccess != null ? !this.remoteAccess.equals(that.remoteAccess) : that.remoteAccess != null) return false;
            if (this.subnets != null ? !this.subnets.equals(that.subnets) : that.subnets != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.taints != null ? this.taints.equals(that.taints) : that.taints == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cluster.hashCode();
            result = 31 * result + (this.amiType != null ? this.amiType.hashCode() : 0);
            result = 31 * result + (this.capacityType != null ? this.capacityType.hashCode() : 0);
            result = 31 * result + (this.desiredSize != null ? this.desiredSize.hashCode() : 0);
            result = 31 * result + (this.diskSize != null ? this.diskSize.hashCode() : 0);
            result = 31 * result + (this.enableNodeAutoRepair != null ? this.enableNodeAutoRepair.hashCode() : 0);
            result = 31 * result + (this.forceUpdate != null ? this.forceUpdate.hashCode() : 0);
            result = 31 * result + (this.instanceTypes != null ? this.instanceTypes.hashCode() : 0);
            result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
            result = 31 * result + (this.launchTemplateSpec != null ? this.launchTemplateSpec.hashCode() : 0);
            result = 31 * result + (this.maxSize != null ? this.maxSize.hashCode() : 0);
            result = 31 * result + (this.maxUnavailable != null ? this.maxUnavailable.hashCode() : 0);
            result = 31 * result + (this.maxUnavailablePercentage != null ? this.maxUnavailablePercentage.hashCode() : 0);
            result = 31 * result + (this.minSize != null ? this.minSize.hashCode() : 0);
            result = 31 * result + (this.nodegroupName != null ? this.nodegroupName.hashCode() : 0);
            result = 31 * result + (this.nodeRole != null ? this.nodeRole.hashCode() : 0);
            result = 31 * result + (this.releaseVersion != null ? this.releaseVersion.hashCode() : 0);
            result = 31 * result + (this.remoteAccess != null ? this.remoteAccess.hashCode() : 0);
            result = 31 * result + (this.subnets != null ? this.subnets.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.taints != null ? this.taints.hashCode() : 0);
            return result;
        }
    }
}
