package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining a <code>CfnLoadBalancer</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * CfnLoadBalancerProps cfnLoadBalancerProps = CfnLoadBalancerProps.builder()
 *         .enablePrefixForIpv6SourceNat("enablePrefixForIpv6SourceNat")
 *         .enforceSecurityGroupInboundRulesOnPrivateLinkTraffic("enforceSecurityGroupInboundRulesOnPrivateLinkTraffic")
 *         .ipAddressType("ipAddressType")
 *         .ipv4IpamPoolId("ipv4IpamPoolId")
 *         .loadBalancerAttributes(List.of(LoadBalancerAttributeProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .minimumLoadBalancerCapacity(MinimumLoadBalancerCapacityProperty.builder()
 *                 .capacityUnits(123)
 *                 .build())
 *         .name("name")
 *         .scheme("scheme")
 *         .securityGroups(List.of("securityGroups"))
 *         .subnetMappings(List.of(SubnetMappingProperty.builder()
 *                 .subnetId("subnetId")
 *                 // the properties below are optional
 *                 .allocationId("allocationId")
 *                 .iPv6Address("iPv6Address")
 *                 .privateIPv4Address("privateIPv4Address")
 *                 .sourceNatIpv6Prefix("sourceNatIpv6Prefix")
 *                 .build()))
 *         .subnets(List.of("subnets"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .type("type")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:51.140Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnLoadBalancerProps")
@software.amazon.jsii.Jsii.Proxy(CfnLoadBalancerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLoadBalancerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * [Network Load Balancers with UDP listeners] Indicates whether to use an IPv6 prefix from each subnet for source NAT.
     * <p>
     * The IP address type must be <code>dualstack</code> . The default value is <code>off</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-enableprefixforipv6sourcenat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-enableprefixforipv6sourcenat</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnablePrefixForIpv6SourceNat() {
        return null;
    }

    /**
     * Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer through AWS PrivateLink .
     * <p>
     * The default is <code>on</code> .
     * <p>
     * You can't configure this property on a Network Load Balancer unless you associated a security group with the load balancer when you created it.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-enforcesecuritygroupinboundrulesonprivatelinktraffic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-enforcesecuritygroupinboundrulesonprivatelinktraffic</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnforceSecurityGroupInboundRulesOnPrivateLinkTraffic() {
        return null;
    }

    /**
     * The IP address type. Internal load balancers must use <code>ipv4</code> .
     * <p>
     * [Application Load Balancers] The possible values are <code>ipv4</code> (IPv4 addresses), <code>dualstack</code> (IPv4 and IPv6 addresses), and <code>dualstack-without-public-ipv4</code> (public IPv6 addresses and private IPv4 and IPv6 addresses).
     * <p>
     * Application Load Balancer authentication supports IPv4 addresses only when connecting to an Identity Provider (IdP) or Amazon Cognito endpoint. Without a public IPv4 address the load balancer can't complete the authentication process, resulting in HTTP 500 errors.
     * <p>
     * [Network Load Balancers and Gateway Load Balancers] The possible values are <code>ipv4</code> (IPv4 addresses) and <code>dualstack</code> (IPv4 and IPv6 addresses).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-ipaddresstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-ipaddresstype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpAddressType() {
        return null;
    }

    /**
     * The ID of the IPv4 IPAM pool.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-ipv4ipampoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-ipv4ipampoolid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpv4IpamPoolId() {
        return null;
    }

    /**
     * The load balancer attributes.
     * <p>
     * Attributes that you do not modify retain their current values.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLoadBalancerAttributes() {
        return null;
    }

    /**
     * The minimum capacity for a load balancer.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-minimumloadbalancercapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-minimumloadbalancercapacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMinimumLoadBalancerCapacity() {
        return null;
    }

    /**
     * The name of the load balancer.
     * <p>
     * This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, must not begin or end with a hyphen, and must not begin with "internal-".
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID for the load balancer. If you specify a name, you cannot perform updates that require replacement of this resource, but you can perform other updates. To replace the resource, specify a new name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The nodes of an Internet-facing load balancer have public IP addresses.
     * <p>
     * The DNS name of an Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load balancers can route requests from clients over the internet.
     * <p>
     * The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers can route requests only from clients with access to the VPC for the load balancer.
     * <p>
     * The default is an Internet-facing load balancer.
     * <p>
     * You can't specify a scheme for a Gateway Load Balancer.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-scheme">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-scheme</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getScheme() {
        return null;
    }

    /**
     * [Application Load Balancers and Network Load Balancers] The IDs of the security groups for the load balancer.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-securitygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-securitygroups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
        return null;
    }

    /**
     * The IDs of the subnets.
     * <p>
     * You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both.
     * <p>
     * [Application Load Balancers] You must specify subnets from at least two Availability Zones. You can't specify Elastic IP addresses for your subnets.
     * <p>
     * [Application Load Balancers on Outposts] You must specify one Outpost subnet.
     * <p>
     * [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
     * <p>
     * [Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.
     * <p>
     * [Gateway Load Balancers] You can specify subnets from one or more Availability Zones. You can't specify Elastic IP addresses for your subnets.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmappings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSubnetMappings() {
        return null;
    }

    /**
     * The IDs of the subnets.
     * <p>
     * You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both. To specify an Elastic IP address, specify subnet mappings instead of subnets.
     * <p>
     * [Application Load Balancers] You must specify subnets from at least two Availability Zones.
     * <p>
     * [Application Load Balancers on Outposts] You must specify one Outpost subnet.
     * <p>
     * [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
     * <p>
     * [Network Load Balancers and Gateway Load Balancers] You can specify subnets from one or more Availability Zones.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-subnets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-subnets</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnets() {
        return null;
    }

    /**
     * The tags to assign to the load balancer.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The type of load balancer.
     * <p>
     * The default is <code>application</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLoadBalancerProps> {
        java.lang.String enablePrefixForIpv6SourceNat;
        java.lang.String enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
        java.lang.String ipAddressType;
        java.lang.String ipv4IpamPoolId;
        java.lang.Object loadBalancerAttributes;
        java.lang.Object minimumLoadBalancerCapacity;
        java.lang.String name;
        java.lang.String scheme;
        java.util.List<java.lang.String> securityGroups;
        java.lang.Object subnetMappings;
        java.util.List<java.lang.String> subnets;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String type;

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getEnablePrefixForIpv6SourceNat}
         * @param enablePrefixForIpv6SourceNat [Network Load Balancers with UDP listeners] Indicates whether to use an IPv6 prefix from each subnet for source NAT.
         *                                     The IP address type must be <code>dualstack</code> . The default value is <code>off</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePrefixForIpv6SourceNat(java.lang.String enablePrefixForIpv6SourceNat) {
            this.enablePrefixForIpv6SourceNat = enablePrefixForIpv6SourceNat;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getEnforceSecurityGroupInboundRulesOnPrivateLinkTraffic}
         * @param enforceSecurityGroupInboundRulesOnPrivateLinkTraffic Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer through AWS PrivateLink .
         *                                                             The default is <code>on</code> .
         *                                                             <p>
         *                                                             You can't configure this property on a Network Load Balancer unless you associated a security group with the load balancer when you created it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(java.lang.String enforceSecurityGroupInboundRulesOnPrivateLinkTraffic) {
            this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic = enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getIpAddressType}
         * @param ipAddressType The IP address type. Internal load balancers must use <code>ipv4</code> .
         *                      [Application Load Balancers] The possible values are <code>ipv4</code> (IPv4 addresses), <code>dualstack</code> (IPv4 and IPv6 addresses), and <code>dualstack-without-public-ipv4</code> (public IPv6 addresses and private IPv4 and IPv6 addresses).
         *                      <p>
         *                      Application Load Balancer authentication supports IPv4 addresses only when connecting to an Identity Provider (IdP) or Amazon Cognito endpoint. Without a public IPv4 address the load balancer can't complete the authentication process, resulting in HTTP 500 errors.
         *                      <p>
         *                      [Network Load Balancers and Gateway Load Balancers] The possible values are <code>ipv4</code> (IPv4 addresses) and <code>dualstack</code> (IPv4 and IPv6 addresses).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(java.lang.String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getIpv4IpamPoolId}
         * @param ipv4IpamPoolId The ID of the IPv4 IPAM pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv4IpamPoolId(java.lang.String ipv4IpamPoolId) {
            this.ipv4IpamPoolId = ipv4IpamPoolId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getLoadBalancerAttributes}
         * @param loadBalancerAttributes The load balancer attributes.
         *                               Attributes that you do not modify retain their current values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerAttributes(software.amazon.awscdk.IResolvable loadBalancerAttributes) {
            this.loadBalancerAttributes = loadBalancerAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getLoadBalancerAttributes}
         * @param loadBalancerAttributes The load balancer attributes.
         *                               Attributes that you do not modify retain their current values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerAttributes(java.util.List<? extends java.lang.Object> loadBalancerAttributes) {
            this.loadBalancerAttributes = loadBalancerAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getMinimumLoadBalancerCapacity}
         * @param minimumLoadBalancerCapacity The minimum capacity for a load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumLoadBalancerCapacity(software.amazon.awscdk.IResolvable minimumLoadBalancerCapacity) {
            this.minimumLoadBalancerCapacity = minimumLoadBalancerCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getMinimumLoadBalancerCapacity}
         * @param minimumLoadBalancerCapacity The minimum capacity for a load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumLoadBalancerCapacity(software.amazon.awscdk.services.elasticloadbalancingv2.CfnLoadBalancer.MinimumLoadBalancerCapacityProperty minimumLoadBalancerCapacity) {
            this.minimumLoadBalancerCapacity = minimumLoadBalancerCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getName}
         * @param name The name of the load balancer.
         *             This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, must not begin or end with a hyphen, and must not begin with "internal-".
         *             <p>
         *             If you don't specify a name, AWS CloudFormation generates a unique physical ID for the load balancer. If you specify a name, you cannot perform updates that require replacement of this resource, but you can perform other updates. To replace the resource, specify a new name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getScheme}
         * @param scheme The nodes of an Internet-facing load balancer have public IP addresses.
         *               The DNS name of an Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load balancers can route requests from clients over the internet.
         *               <p>
         *               The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers can route requests only from clients with access to the VPC for the load balancer.
         *               <p>
         *               The default is an Internet-facing load balancer.
         *               <p>
         *               You can't specify a scheme for a Gateway Load Balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheme(java.lang.String scheme) {
            this.scheme = scheme;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getSecurityGroups}
         * @param securityGroups [Application Load Balancers and Network Load Balancers] The IDs of the security groups for the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getSubnetMappings}
         * @param subnetMappings The IDs of the subnets.
         *                       You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both.
         *                       <p>
         *                       [Application Load Balancers] You must specify subnets from at least two Availability Zones. You can't specify Elastic IP addresses for your subnets.
         *                       <p>
         *                       [Application Load Balancers on Outposts] You must specify one Outpost subnet.
         *                       <p>
         *                       [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
         *                       <p>
         *                       [Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.
         *                       <p>
         *                       [Gateway Load Balancers] You can specify subnets from one or more Availability Zones. You can't specify Elastic IP addresses for your subnets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetMappings(software.amazon.awscdk.IResolvable subnetMappings) {
            this.subnetMappings = subnetMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getSubnetMappings}
         * @param subnetMappings The IDs of the subnets.
         *                       You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both.
         *                       <p>
         *                       [Application Load Balancers] You must specify subnets from at least two Availability Zones. You can't specify Elastic IP addresses for your subnets.
         *                       <p>
         *                       [Application Load Balancers on Outposts] You must specify one Outpost subnet.
         *                       <p>
         *                       [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
         *                       <p>
         *                       [Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.
         *                       <p>
         *                       [Gateway Load Balancers] You can specify subnets from one or more Availability Zones. You can't specify Elastic IP addresses for your subnets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetMappings(java.util.List<? extends java.lang.Object> subnetMappings) {
            this.subnetMappings = subnetMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getSubnets}
         * @param subnets The IDs of the subnets.
         *                You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both. To specify an Elastic IP address, specify subnet mappings instead of subnets.
         *                <p>
         *                [Application Load Balancers] You must specify subnets from at least two Availability Zones.
         *                <p>
         *                [Application Load Balancers on Outposts] You must specify one Outpost subnet.
         *                <p>
         *                [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
         *                <p>
         *                [Network Load Balancers and Gateway Load Balancers] You can specify subnets from one or more Availability Zones.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnets(java.util.List<java.lang.String> subnets) {
            this.subnets = subnets;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getTags}
         * @param tags The tags to assign to the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getType}
         * @param type The type of load balancer.
         *             The default is <code>application</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLoadBalancerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLoadBalancerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLoadBalancerProps {
        private final java.lang.String enablePrefixForIpv6SourceNat;
        private final java.lang.String enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
        private final java.lang.String ipAddressType;
        private final java.lang.String ipv4IpamPoolId;
        private final java.lang.Object loadBalancerAttributes;
        private final java.lang.Object minimumLoadBalancerCapacity;
        private final java.lang.String name;
        private final java.lang.String scheme;
        private final java.util.List<java.lang.String> securityGroups;
        private final java.lang.Object subnetMappings;
        private final java.util.List<java.lang.String> subnets;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String type;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.enablePrefixForIpv6SourceNat = software.amazon.jsii.Kernel.get(this, "enablePrefixForIpv6SourceNat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic = software.amazon.jsii.Kernel.get(this, "enforceSecurityGroupInboundRulesOnPrivateLinkTraffic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipAddressType = software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipv4IpamPoolId = software.amazon.jsii.Kernel.get(this, "ipv4IpamPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loadBalancerAttributes = software.amazon.jsii.Kernel.get(this, "loadBalancerAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.minimumLoadBalancerCapacity = software.amazon.jsii.Kernel.get(this, "minimumLoadBalancerCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scheme = software.amazon.jsii.Kernel.get(this, "scheme", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.subnetMappings = software.amazon.jsii.Kernel.get(this, "subnetMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.enablePrefixForIpv6SourceNat = builder.enablePrefixForIpv6SourceNat;
            this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic = builder.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
            this.ipAddressType = builder.ipAddressType;
            this.ipv4IpamPoolId = builder.ipv4IpamPoolId;
            this.loadBalancerAttributes = builder.loadBalancerAttributes;
            this.minimumLoadBalancerCapacity = builder.minimumLoadBalancerCapacity;
            this.name = builder.name;
            this.scheme = builder.scheme;
            this.securityGroups = builder.securityGroups;
            this.subnetMappings = builder.subnetMappings;
            this.subnets = builder.subnets;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.type = builder.type;
        }

        @Override
        public final java.lang.String getEnablePrefixForIpv6SourceNat() {
            return this.enablePrefixForIpv6SourceNat;
        }

        @Override
        public final java.lang.String getEnforceSecurityGroupInboundRulesOnPrivateLinkTraffic() {
            return this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
        }

        @Override
        public final java.lang.String getIpAddressType() {
            return this.ipAddressType;
        }

        @Override
        public final java.lang.String getIpv4IpamPoolId() {
            return this.ipv4IpamPoolId;
        }

        @Override
        public final java.lang.Object getLoadBalancerAttributes() {
            return this.loadBalancerAttributes;
        }

        @Override
        public final java.lang.Object getMinimumLoadBalancerCapacity() {
            return this.minimumLoadBalancerCapacity;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getScheme() {
            return this.scheme;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final java.lang.Object getSubnetMappings() {
            return this.subnetMappings;
        }

        @Override
        public final java.util.List<java.lang.String> getSubnets() {
            return this.subnets;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEnablePrefixForIpv6SourceNat() != null) {
                data.set("enablePrefixForIpv6SourceNat", om.valueToTree(this.getEnablePrefixForIpv6SourceNat()));
            }
            if (this.getEnforceSecurityGroupInboundRulesOnPrivateLinkTraffic() != null) {
                data.set("enforceSecurityGroupInboundRulesOnPrivateLinkTraffic", om.valueToTree(this.getEnforceSecurityGroupInboundRulesOnPrivateLinkTraffic()));
            }
            if (this.getIpAddressType() != null) {
                data.set("ipAddressType", om.valueToTree(this.getIpAddressType()));
            }
            if (this.getIpv4IpamPoolId() != null) {
                data.set("ipv4IpamPoolId", om.valueToTree(this.getIpv4IpamPoolId()));
            }
            if (this.getLoadBalancerAttributes() != null) {
                data.set("loadBalancerAttributes", om.valueToTree(this.getLoadBalancerAttributes()));
            }
            if (this.getMinimumLoadBalancerCapacity() != null) {
                data.set("minimumLoadBalancerCapacity", om.valueToTree(this.getMinimumLoadBalancerCapacity()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getScheme() != null) {
                data.set("scheme", om.valueToTree(this.getScheme()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSubnetMappings() != null) {
                data.set("subnetMappings", om.valueToTree(this.getSubnetMappings()));
            }
            if (this.getSubnets() != null) {
                data.set("subnets", om.valueToTree(this.getSubnets()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getType() != null) {
                data.set("type", om.valueToTree(this.getType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnLoadBalancerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLoadBalancerProps.Jsii$Proxy that = (CfnLoadBalancerProps.Jsii$Proxy) o;

            if (this.enablePrefixForIpv6SourceNat != null ? !this.enablePrefixForIpv6SourceNat.equals(that.enablePrefixForIpv6SourceNat) : that.enablePrefixForIpv6SourceNat != null) return false;
            if (this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic != null ? !this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic.equals(that.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic) : that.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic != null) return false;
            if (this.ipAddressType != null ? !this.ipAddressType.equals(that.ipAddressType) : that.ipAddressType != null) return false;
            if (this.ipv4IpamPoolId != null ? !this.ipv4IpamPoolId.equals(that.ipv4IpamPoolId) : that.ipv4IpamPoolId != null) return false;
            if (this.loadBalancerAttributes != null ? !this.loadBalancerAttributes.equals(that.loadBalancerAttributes) : that.loadBalancerAttributes != null) return false;
            if (this.minimumLoadBalancerCapacity != null ? !this.minimumLoadBalancerCapacity.equals(that.minimumLoadBalancerCapacity) : that.minimumLoadBalancerCapacity != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.scheme != null ? !this.scheme.equals(that.scheme) : that.scheme != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.subnetMappings != null ? !this.subnetMappings.equals(that.subnetMappings) : that.subnetMappings != null) return false;
            if (this.subnets != null ? !this.subnets.equals(that.subnets) : that.subnets != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.type != null ? this.type.equals(that.type) : that.type == null;
        }

        @Override
        public final int hashCode() {
            int result = this.enablePrefixForIpv6SourceNat != null ? this.enablePrefixForIpv6SourceNat.hashCode() : 0;
            result = 31 * result + (this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic != null ? this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic.hashCode() : 0);
            result = 31 * result + (this.ipAddressType != null ? this.ipAddressType.hashCode() : 0);
            result = 31 * result + (this.ipv4IpamPoolId != null ? this.ipv4IpamPoolId.hashCode() : 0);
            result = 31 * result + (this.loadBalancerAttributes != null ? this.loadBalancerAttributes.hashCode() : 0);
            result = 31 * result + (this.minimumLoadBalancerCapacity != null ? this.minimumLoadBalancerCapacity.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.scheme != null ? this.scheme.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.subnetMappings != null ? this.subnetMappings.hashCode() : 0);
            result = 31 * result + (this.subnets != null ? this.subnets.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }
}
