package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * A new Trust Store Revocation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * TrustStore trustStore;
 * Bucket bucket;
 * TrustStoreRevocation.Builder.create(this, "Revocation")
 *         .trustStore(trustStore)
 *         .revocationContents(List.of(RevocationContent.builder()
 *                 .revocationType(RevocationType.CRL)
 *                 .bucket(bucket)
 *                 .key("crl.pem")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:51.315Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.TrustStoreRevocation")
public class TrustStoreRevocation extends software.amazon.awscdk.Resource {

    protected TrustStoreRevocation(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TrustStoreRevocation(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticloadbalancingv2.TrustStoreRevocation.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public TrustStoreRevocation(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.TrustStoreRevocationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancingv2.TrustStoreRevocation}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticloadbalancingv2.TrustStoreRevocation> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.TrustStoreRevocationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticloadbalancingv2.TrustStoreRevocationProps.Builder();
        }

        /**
         * The revocation file to add.
         * <p>
         * @return {@code this}
         * @param revocationContents The revocation file to add. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder revocationContents(final java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.RevocationContent> revocationContents) {
            this.props.revocationContents(revocationContents);
            return this;
        }

        /**
         * The trust store.
         * <p>
         * @return {@code this}
         * @param trustStore The trust store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trustStore(final software.amazon.awscdk.services.elasticloadbalancingv2.ITrustStore trustStore) {
            this.props.trustStore(trustStore);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancingv2.TrustStoreRevocation}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.TrustStoreRevocation build() {
            return new software.amazon.awscdk.services.elasticloadbalancingv2.TrustStoreRevocation(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
