package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for the trust store revocation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * TrustStore trustStore;
 * Bucket bucket;
 * TrustStoreRevocation.Builder.create(this, "Revocation")
 *         .trustStore(trustStore)
 *         .revocationContents(List.of(RevocationContent.builder()
 *                 .revocationType(RevocationType.CRL)
 *                 .bucket(bucket)
 *                 .key("crl.pem")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:51.316Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.TrustStoreRevocationProps")
@software.amazon.jsii.Jsii.Proxy(TrustStoreRevocationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TrustStoreRevocationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The revocation file to add.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.RevocationContent> getRevocationContents();

    /**
     * The trust store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ITrustStore getTrustStore();

    /**
     * @return a {@link Builder} of {@link TrustStoreRevocationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TrustStoreRevocationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TrustStoreRevocationProps> {
        java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.RevocationContent> revocationContents;
        software.amazon.awscdk.services.elasticloadbalancingv2.ITrustStore trustStore;

        /**
         * Sets the value of {@link TrustStoreRevocationProps#getRevocationContents}
         * @param revocationContents The revocation file to add. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder revocationContents(java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.RevocationContent> revocationContents) {
            this.revocationContents = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.RevocationContent>)revocationContents;
            return this;
        }

        /**
         * Sets the value of {@link TrustStoreRevocationProps#getTrustStore}
         * @param trustStore The trust store. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trustStore(software.amazon.awscdk.services.elasticloadbalancingv2.ITrustStore trustStore) {
            this.trustStore = trustStore;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TrustStoreRevocationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TrustStoreRevocationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TrustStoreRevocationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrustStoreRevocationProps {
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.RevocationContent> revocationContents;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ITrustStore trustStore;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.revocationContents = software.amazon.jsii.Kernel.get(this, "revocationContents", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.RevocationContent.class)));
            this.trustStore = software.amazon.jsii.Kernel.get(this, "trustStore", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ITrustStore.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.revocationContents = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.RevocationContent>)java.util.Objects.requireNonNull(builder.revocationContents, "revocationContents is required");
            this.trustStore = java.util.Objects.requireNonNull(builder.trustStore, "trustStore is required");
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.RevocationContent> getRevocationContents() {
            return this.revocationContents;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.ITrustStore getTrustStore() {
            return this.trustStore;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("revocationContents", om.valueToTree(this.getRevocationContents()));
            data.set("trustStore", om.valueToTree(this.getTrustStore()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.TrustStoreRevocationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TrustStoreRevocationProps.Jsii$Proxy that = (TrustStoreRevocationProps.Jsii$Proxy) o;

            if (!revocationContents.equals(that.revocationContents)) return false;
            return this.trustStore.equals(that.trustStore);
        }

        @Override
        public final int hashCode() {
            int result = this.revocationContents.hashCode();
            result = 31 * result + (this.trustStore.hashCode());
            return result;
        }
    }
}
