package software.amazon.awscdk.services.entityresolution;

/**
 * Properties for defining a <code>CfnIdMappingWorkflow</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.entityresolution.*;
 * CfnIdMappingWorkflowProps cfnIdMappingWorkflowProps = CfnIdMappingWorkflowProps.builder()
 *         .idMappingTechniques(IdMappingTechniquesProperty.builder()
 *                 .idMappingType("idMappingType")
 *                 .providerProperties(ProviderPropertiesProperty.builder()
 *                         .providerServiceArn("providerServiceArn")
 *                         // the properties below are optional
 *                         .intermediateSourceConfiguration(IntermediateSourceConfigurationProperty.builder()
 *                                 .intermediateS3Path("intermediateS3Path")
 *                                 .build())
 *                         .providerConfiguration(Map.of(
 *                                 "providerConfigurationKey", "providerConfiguration"))
 *                         .build())
 *                 .ruleBasedProperties(IdMappingRuleBasedPropertiesProperty.builder()
 *                         .attributeMatchingModel("attributeMatchingModel")
 *                         .recordMatchingModel("recordMatchingModel")
 *                         // the properties below are optional
 *                         .ruleDefinitionType("ruleDefinitionType")
 *                         .rules(List.of(RuleProperty.builder()
 *                                 .matchingKeys(List.of("matchingKeys"))
 *                                 .ruleName("ruleName")
 *                                 .build()))
 *                         .build())
 *                 .build())
 *         .inputSourceConfig(List.of(IdMappingWorkflowInputSourceProperty.builder()
 *                 .inputSourceArn("inputSourceArn")
 *                 // the properties below are optional
 *                 .schemaArn("schemaArn")
 *                 .type("type")
 *                 .build()))
 *         .roleArn("roleArn")
 *         .workflowName("workflowName")
 *         // the properties below are optional
 *         .description("description")
 *         .outputSourceConfig(List.of(IdMappingWorkflowOutputSourceProperty.builder()
 *                 .outputS3Path("outputS3Path")
 *                 // the properties below are optional
 *                 .kmsArn("kmsArn")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:51.705Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_entityresolution.CfnIdMappingWorkflowProps")
@software.amazon.jsii.Jsii.Proxy(CfnIdMappingWorkflowProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIdMappingWorkflowProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * An object which defines the ID mapping technique and any additional configurations.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-idmappingtechniques">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-idmappingtechniques</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getIdMappingTechniques();

    /**
     * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-inputsourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-inputsourceconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getInputSourceConfig();

    /**
     * The Amazon Resource Name (ARN) of the IAM role.
     * <p>
     * AWS Entity Resolution assumes this role to create resources on your behalf as part of workflow execution.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * The name of the workflow.
     * <p>
     * There can't be multiple <code>IdMappingWorkflows</code> with the same name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-workflowname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-workflowname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWorkflowName();

    /**
     * A description of the workflow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * A list of <code>IdMappingWorkflowOutputSource</code> objects, each of which contains fields <code>OutputS3Path</code> and <code>Output</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-outputsourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-outputsourceconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOutputSourceConfig() {
        return null;
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-entityresolution-idmappingworkflow.html#cfn-entityresolution-idmappingworkflow-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIdMappingWorkflowProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIdMappingWorkflowProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIdMappingWorkflowProps> {
        java.lang.Object idMappingTechniques;
        java.lang.Object inputSourceConfig;
        java.lang.String roleArn;
        java.lang.String workflowName;
        java.lang.String description;
        java.lang.Object outputSourceConfig;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnIdMappingWorkflowProps#getIdMappingTechniques}
         * @param idMappingTechniques An object which defines the ID mapping technique and any additional configurations. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idMappingTechniques(software.amazon.awscdk.IResolvable idMappingTechniques) {
            this.idMappingTechniques = idMappingTechniques;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdMappingWorkflowProps#getIdMappingTechniques}
         * @param idMappingTechniques An object which defines the ID mapping technique and any additional configurations. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idMappingTechniques(software.amazon.awscdk.services.entityresolution.CfnIdMappingWorkflow.IdMappingTechniquesProperty idMappingTechniques) {
            this.idMappingTechniques = idMappingTechniques;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdMappingWorkflowProps#getInputSourceConfig}
         * @param inputSourceConfig A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputSourceConfig(software.amazon.awscdk.IResolvable inputSourceConfig) {
            this.inputSourceConfig = inputSourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdMappingWorkflowProps#getInputSourceConfig}
         * @param inputSourceConfig A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputSourceConfig(java.util.List<? extends java.lang.Object> inputSourceConfig) {
            this.inputSourceConfig = inputSourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdMappingWorkflowProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role. This parameter is required.
         *                AWS Entity Resolution assumes this role to create resources on your behalf as part of workflow execution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdMappingWorkflowProps#getWorkflowName}
         * @param workflowName The name of the workflow. This parameter is required.
         *                     There can't be multiple <code>IdMappingWorkflows</code> with the same name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflowName(java.lang.String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdMappingWorkflowProps#getDescription}
         * @param description A description of the workflow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdMappingWorkflowProps#getOutputSourceConfig}
         * @param outputSourceConfig A list of <code>IdMappingWorkflowOutputSource</code> objects, each of which contains fields <code>OutputS3Path</code> and <code>Output</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputSourceConfig(software.amazon.awscdk.IResolvable outputSourceConfig) {
            this.outputSourceConfig = outputSourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdMappingWorkflowProps#getOutputSourceConfig}
         * @param outputSourceConfig A list of <code>IdMappingWorkflowOutputSource</code> objects, each of which contains fields <code>OutputS3Path</code> and <code>Output</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputSourceConfig(java.util.List<? extends java.lang.Object> outputSourceConfig) {
            this.outputSourceConfig = outputSourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdMappingWorkflowProps#getTags}
         * @param tags The tags used to organize, track, or control access for this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIdMappingWorkflowProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIdMappingWorkflowProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIdMappingWorkflowProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIdMappingWorkflowProps {
        private final java.lang.Object idMappingTechniques;
        private final java.lang.Object inputSourceConfig;
        private final java.lang.String roleArn;
        private final java.lang.String workflowName;
        private final java.lang.String description;
        private final java.lang.Object outputSourceConfig;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.idMappingTechniques = software.amazon.jsii.Kernel.get(this, "idMappingTechniques", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.inputSourceConfig = software.amazon.jsii.Kernel.get(this, "inputSourceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.workflowName = software.amazon.jsii.Kernel.get(this, "workflowName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputSourceConfig = software.amazon.jsii.Kernel.get(this, "outputSourceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.idMappingTechniques = java.util.Objects.requireNonNull(builder.idMappingTechniques, "idMappingTechniques is required");
            this.inputSourceConfig = java.util.Objects.requireNonNull(builder.inputSourceConfig, "inputSourceConfig is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.workflowName = java.util.Objects.requireNonNull(builder.workflowName, "workflowName is required");
            this.description = builder.description;
            this.outputSourceConfig = builder.outputSourceConfig;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getIdMappingTechniques() {
            return this.idMappingTechniques;
        }

        @Override
        public final java.lang.Object getInputSourceConfig() {
            return this.inputSourceConfig;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getWorkflowName() {
            return this.workflowName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getOutputSourceConfig() {
            return this.outputSourceConfig;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("idMappingTechniques", om.valueToTree(this.getIdMappingTechniques()));
            data.set("inputSourceConfig", om.valueToTree(this.getInputSourceConfig()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            data.set("workflowName", om.valueToTree(this.getWorkflowName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getOutputSourceConfig() != null) {
                data.set("outputSourceConfig", om.valueToTree(this.getOutputSourceConfig()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_entityresolution.CfnIdMappingWorkflowProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIdMappingWorkflowProps.Jsii$Proxy that = (CfnIdMappingWorkflowProps.Jsii$Proxy) o;

            if (!idMappingTechniques.equals(that.idMappingTechniques)) return false;
            if (!inputSourceConfig.equals(that.inputSourceConfig)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (!workflowName.equals(that.workflowName)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.outputSourceConfig != null ? !this.outputSourceConfig.equals(that.outputSourceConfig) : that.outputSourceConfig != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.idMappingTechniques.hashCode();
            result = 31 * result + (this.inputSourceConfig.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.workflowName.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.outputSourceConfig != null ? this.outputSourceConfig.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
