package software.amazon.awscdk.services.events;

/**
 * Standard set of options for <code>onXxx</code> event handlers on construct.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Lambda function containing logic that evaluates compliance with the rule.
 * Function evalComplianceFn = Function.Builder.create(this, "CustomFunction")
 *         .code(AssetCode.fromInline("exports.handler = (event) =&gt; console.log(event);"))
 *         .handler("index.handler")
 *         .runtime(Runtime.NODEJS_18_X)
 *         .build();
 * // A custom rule that runs on configuration changes of EC2 instances
 * CustomRule customRule = CustomRule.Builder.create(this, "Custom")
 *         .configurationChanges(true)
 *         .lambdaFunction(evalComplianceFn)
 *         .ruleScope(RuleScope.fromResource(ResourceType.EC2_INSTANCE))
 *         .build();
 * // A rule to detect stack drifts
 * CloudFormationStackDriftDetectionCheck driftRule = new CloudFormationStackDriftDetectionCheck(this, "Drift");
 * // Topic to which compliance notification events will be published
 * Topic complianceTopic = new Topic(this, "ComplianceTopic");
 * // Send notification on compliance change events
 * driftRule.onComplianceChange("ComplianceChange", OnEventOptions.builder()
 *         .target(new SnsTopic(complianceTopic))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:51.975Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.OnEventOptions")
@software.amazon.jsii.Jsii.Proxy(OnEventOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OnEventOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.events.EventCommonOptions {

    /**
     * The target to register for the event.
     * <p>
     * Default: - No target is added to the rule. Use `addTarget()` to add a target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.IRuleTarget getTarget() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OnEventOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OnEventOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OnEventOptions> {
        software.amazon.awscdk.services.events.IRuleTarget target;
        software.constructs.Construct crossStackScope;
        java.lang.String description;
        software.amazon.awscdk.services.events.EventPattern eventPattern;
        java.lang.String ruleName;

        /**
         * Sets the value of {@link OnEventOptions#getTarget}
         * @param target The target to register for the event.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(software.amazon.awscdk.services.events.IRuleTarget target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link OnEventOptions#getCrossStackScope}
         * @param crossStackScope The scope to use if the source of the rule and its target are in different Stacks (but in the same account &amp; region).
         *                        This helps dealing with cycles that often arise in these situations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossStackScope(software.constructs.Construct crossStackScope) {
            this.crossStackScope = crossStackScope;
            return this;
        }

        /**
         * Sets the value of {@link OnEventOptions#getDescription}
         * @param description A description of the rule's purpose.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link OnEventOptions#getEventPattern}
         * @param eventPattern Additional restrictions for the event to route to the specified target.
         *                     The method that generates the rule probably imposes some type of event
         *                     filtering. The filtering implied by what you pass here is added
         *                     on top of that filtering.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventPattern(software.amazon.awscdk.services.events.EventPattern eventPattern) {
            this.eventPattern = eventPattern;
            return this;
        }

        /**
         * Sets the value of {@link OnEventOptions#getRuleName}
         * @param ruleName A name for the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleName(java.lang.String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OnEventOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OnEventOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OnEventOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OnEventOptions {
        private final software.amazon.awscdk.services.events.IRuleTarget target;
        private final software.constructs.Construct crossStackScope;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.events.EventPattern eventPattern;
        private final java.lang.String ruleName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.IRuleTarget.class));
            this.crossStackScope = software.amazon.jsii.Kernel.get(this, "crossStackScope", software.amazon.jsii.NativeType.forClass(software.constructs.Construct.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventPattern = software.amazon.jsii.Kernel.get(this, "eventPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.EventPattern.class));
            this.ruleName = software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.target = builder.target;
            this.crossStackScope = builder.crossStackScope;
            this.description = builder.description;
            this.eventPattern = builder.eventPattern;
            this.ruleName = builder.ruleName;
        }

        @Override
        public final software.amazon.awscdk.services.events.IRuleTarget getTarget() {
            return this.target;
        }

        @Override
        public final software.constructs.Construct getCrossStackScope() {
            return this.crossStackScope;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.events.EventPattern getEventPattern() {
            return this.eventPattern;
        }

        @Override
        public final java.lang.String getRuleName() {
            return this.ruleName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getTarget() != null) {
                data.set("target", om.valueToTree(this.getTarget()));
            }
            if (this.getCrossStackScope() != null) {
                data.set("crossStackScope", om.valueToTree(this.getCrossStackScope()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEventPattern() != null) {
                data.set("eventPattern", om.valueToTree(this.getEventPattern()));
            }
            if (this.getRuleName() != null) {
                data.set("ruleName", om.valueToTree(this.getRuleName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.OnEventOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OnEventOptions.Jsii$Proxy that = (OnEventOptions.Jsii$Proxy) o;

            if (this.target != null ? !this.target.equals(that.target) : that.target != null) return false;
            if (this.crossStackScope != null ? !this.crossStackScope.equals(that.crossStackScope) : that.crossStackScope != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.eventPattern != null ? !this.eventPattern.equals(that.eventPattern) : that.eventPattern != null) return false;
            return this.ruleName != null ? this.ruleName.equals(that.ruleName) : that.ruleName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.target != null ? this.target.hashCode() : 0;
            result = 31 * result + (this.crossStackScope != null ? this.crossStackScope.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.eventPattern != null ? this.eventPattern.hashCode() : 0);
            result = 31 * result + (this.ruleName != null ? this.ruleName.hashCode() : 0);
            return result;
        }
    }
}
