package software.amazon.awscdk.services.fsx;

/**
 * Class for scheduling a weekly maintenance time.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.fsx.*;
 * LustreMaintenanceTime lustreMaintenanceTime = LustreMaintenanceTime.Builder.create()
 *         .day(Weekday.MONDAY)
 *         .hour(123)
 *         .minute(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:52.487Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.LustreMaintenanceTime")
public class LustreMaintenanceTime extends software.amazon.jsii.JsiiObject {

    protected LustreMaintenanceTime(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LustreMaintenanceTime(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LustreMaintenanceTime(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.fsx.LustreMaintenanceTimeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Converts a day, hour, and minute into a timestamp as used by FSx for Lustre's weeklyMaintenanceStartTime field.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toTimestamp() {
        return software.amazon.jsii.Kernel.call(this, "toTimestamp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.fsx.LustreMaintenanceTime}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.fsx.LustreMaintenanceTime> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.fsx.LustreMaintenanceTimeProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.fsx.LustreMaintenanceTimeProps.Builder();
        }

        /**
         * The day of the week for maintenance to be performed.
         * <p>
         * @return {@code this}
         * @param day The day of the week for maintenance to be performed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder day(final software.amazon.awscdk.services.fsx.Weekday day) {
            this.props.day(day);
            return this;
        }

        /**
         * The hour of the day (from 0-23) for maintenance to be performed.
         * <p>
         * @return {@code this}
         * @param hour The hour of the day (from 0-23) for maintenance to be performed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hour(final java.lang.Number hour) {
            this.props.hour(hour);
            return this;
        }

        /**
         * The minute of the hour (from 0-59) for maintenance to be performed.
         * <p>
         * @return {@code this}
         * @param minute The minute of the hour (from 0-59) for maintenance to be performed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minute(final java.lang.Number minute) {
            this.props.minute(minute);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.fsx.LustreMaintenanceTime}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.fsx.LustreMaintenanceTime build() {
            return new software.amazon.awscdk.services.fsx.LustreMaintenanceTime(
                this.props.build()
            );
        }
    }
}
