package software.amazon.awscdk.services.iam;

/**
 * Options for customizing IAM role creation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App app;
 * Stack stack = new Stack(app, "MyStack");
 * Role.customizeRoles(this, CustomizeRolesOptions.builder()
 *         .usePrecreatedRoles(Map.of(
 *                 "MyStack/MyLambda/ServiceRole", "my-role-name"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:53.053Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.CustomizeRolesOptions")
@software.amazon.jsii.Jsii.Proxy(CustomizeRolesOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CustomizeRolesOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether or not to synthesize the resource into the CFN template.
     * <p>
     * Set this to <code>false</code> if you still want to create the resources <em>and</em>
     * you also want to create the policy report.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPreventSynthesis() {
        return null;
    }

    /**
     * A list of precreated IAM roles to substitute for roles that CDK is creating.
     * <p>
     * The constructPath can be either a relative or absolute path
     * from the scope that <code>customizeRoles</code> is used on to the role being created.
     * <p>
     * Default: - there are no precreated roles. Synthesis will fail if `preventSynthesis=true`
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * App app;
     * Stack stack = new Stack(app, "MyStack");
     * Role.Builder.create(stack, "MyRole")
     *         .assumedBy(new AccountPrincipal("1111111111"))
     *         .build();
     * Role.customizeRoles(stack, CustomizeRolesOptions.builder()
     *         .usePrecreatedRoles(Map.of(
     *                 // absolute path
     *                 "MyStack/MyRole", "my-precreated-role-name",
     *                 // or relative path from `stack`
     *                 "MyRole", "my-precreated-role"))
     *         .build());
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getUsePrecreatedRoles() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CustomizeRolesOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomizeRolesOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CustomizeRolesOptions> {
        java.lang.Boolean preventSynthesis;
        java.util.Map<java.lang.String, java.lang.String> usePrecreatedRoles;

        /**
         * Sets the value of {@link CustomizeRolesOptions#getPreventSynthesis}
         * @param preventSynthesis Whether or not to synthesize the resource into the CFN template.
         *                         Set this to <code>false</code> if you still want to create the resources <em>and</em>
         *                         you also want to create the policy report.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preventSynthesis(java.lang.Boolean preventSynthesis) {
            this.preventSynthesis = preventSynthesis;
            return this;
        }

        /**
         * Sets the value of {@link CustomizeRolesOptions#getUsePrecreatedRoles}
         * @param usePrecreatedRoles A list of precreated IAM roles to substitute for roles that CDK is creating.
         *                           The constructPath can be either a relative or absolute path
         *                           from the scope that <code>customizeRoles</code> is used on to the role being created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder usePrecreatedRoles(java.util.Map<java.lang.String, java.lang.String> usePrecreatedRoles) {
            this.usePrecreatedRoles = usePrecreatedRoles;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomizeRolesOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CustomizeRolesOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CustomizeRolesOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomizeRolesOptions {
        private final java.lang.Boolean preventSynthesis;
        private final java.util.Map<java.lang.String, java.lang.String> usePrecreatedRoles;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.preventSynthesis = software.amazon.jsii.Kernel.get(this, "preventSynthesis", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.usePrecreatedRoles = software.amazon.jsii.Kernel.get(this, "usePrecreatedRoles", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.preventSynthesis = builder.preventSynthesis;
            this.usePrecreatedRoles = builder.usePrecreatedRoles;
        }

        @Override
        public final java.lang.Boolean getPreventSynthesis() {
            return this.preventSynthesis;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getUsePrecreatedRoles() {
            return this.usePrecreatedRoles;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPreventSynthesis() != null) {
                data.set("preventSynthesis", om.valueToTree(this.getPreventSynthesis()));
            }
            if (this.getUsePrecreatedRoles() != null) {
                data.set("usePrecreatedRoles", om.valueToTree(this.getUsePrecreatedRoles()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iam.CustomizeRolesOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomizeRolesOptions.Jsii$Proxy that = (CustomizeRolesOptions.Jsii$Proxy) o;

            if (this.preventSynthesis != null ? !this.preventSynthesis.equals(that.preventSynthesis) : that.preventSynthesis != null) return false;
            return this.usePrecreatedRoles != null ? this.usePrecreatedRoles.equals(that.usePrecreatedRoles) : that.usePrecreatedRoles == null;
        }

        @Override
        public final int hashCode() {
            int result = this.preventSynthesis != null ? this.preventSynthesis.hashCode() : 0;
            result = 31 * result + (this.usePrecreatedRoles != null ? this.usePrecreatedRoles.hashCode() : 0);
            return result;
        }
    }
}
