package software.amazon.awscdk.services.iam;

/**
 * Options for a grant operation that directly adds a policy statement to a resource.
 * <p>
 * This differs from GrantWithResourceOptions in that it requires a pre-constructed
 * PolicyStatement rather than constructing one from individual permissions.
 * Use this when you need fine-grained control over the initial policy statement's contents.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IGrantable grantee;
 * String[] actions;
 * String[] resourceArns;
 * Bucket bucket;
 * PolicyStatement statement = PolicyStatement.Builder.create()
 *         .effect(Effect.ALLOW)
 *         .actions(actions)
 *         .principals(List.of(new ServicePrincipal("lambda.amazonaws.com")))
 *         .conditions(Map.of(
 *                 "StringEquals", Map.of(
 *                         "aws:SourceAccount", Stack.of(this).getAccount())))
 *         .build();
 * Grant.addStatementToResourcePolicy(GrantPolicyWithResourceOptions.builder()
 *         .grantee(grantee)
 *         .actions(actions)
 *         .resourceArns(resourceArns)
 *         .resource(bucket)
 *         .statement(statement)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:53.058Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.GrantPolicyWithResourceOptions")
@software.amazon.jsii.Jsii.Proxy(GrantPolicyWithResourceOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GrantPolicyWithResourceOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.iam.GrantWithResourceOptions {

    /**
     * The policy statement to add to the resource's policy.
     * <p>
     * This statement will be passed to the resource's addToResourcePolicy method.
     * The actual handling of the statement depends on the specific IResourceWithPolicy
     * implementation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement getStatement();

    /**
     * @return a {@link Builder} of {@link GrantPolicyWithResourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GrantPolicyWithResourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GrantPolicyWithResourceOptions> {
        software.amazon.awscdk.services.iam.PolicyStatement statement;
        software.amazon.awscdk.services.iam.IResourceWithPolicy resource;
        java.util.List<java.lang.String> resourceSelfArns;
        java.util.List<java.lang.String> actions;
        software.amazon.awscdk.services.iam.IGrantable grantee;
        java.util.List<java.lang.String> resourceArns;
        java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> conditions;

        /**
         * Sets the value of {@link GrantPolicyWithResourceOptions#getStatement}
         * @param statement The policy statement to add to the resource's policy. This parameter is required.
         *                  This statement will be passed to the resource's addToResourcePolicy method.
         *                  The actual handling of the statement depends on the specific IResourceWithPolicy
         *                  implementation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statement(software.amazon.awscdk.services.iam.PolicyStatement statement) {
            this.statement = statement;
            return this;
        }

        /**
         * Sets the value of {@link GrantPolicyWithResourceOptions#getResource}
         * @param resource The resource with a resource policy. This parameter is required.
         *                 The statement will be added to the resource policy if it couldn't be
         *                 added to the principal policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resource(software.amazon.awscdk.services.iam.IResourceWithPolicy resource) {
            this.resource = resource;
            return this;
        }

        /**
         * Sets the value of {@link GrantPolicyWithResourceOptions#getResourceSelfArns}
         * @param resourceSelfArns When referring to the resource in a resource policy, use this as ARN.
         *                         (Depending on the resource type, this needs to be '*' in a resource policy).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceSelfArns(java.util.List<java.lang.String> resourceSelfArns) {
            this.resourceSelfArns = resourceSelfArns;
            return this;
        }

        /**
         * Sets the value of {@link GrantPolicyWithResourceOptions#getActions}
         * @param actions The actions to grant. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(java.util.List<java.lang.String> actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link GrantPolicyWithResourceOptions#getGrantee}
         * @param grantee The principal to grant to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder grantee(software.amazon.awscdk.services.iam.IGrantable grantee) {
            this.grantee = grantee;
            return this;
        }

        /**
         * Sets the value of {@link GrantPolicyWithResourceOptions#getResourceArns}
         * @param resourceArns The resource ARNs to grant to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceArns(java.util.List<java.lang.String> resourceArns) {
            this.resourceArns = resourceArns;
            return this;
        }

        /**
         * Sets the value of {@link GrantPolicyWithResourceOptions#getConditions}
         * @param conditions Any conditions to attach to the grant.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder conditions(java.util.Map<java.lang.String, ? extends java.util.Map<java.lang.String, ? extends java.lang.Object>> conditions) {
            this.conditions = (java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>>)conditions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GrantPolicyWithResourceOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GrantPolicyWithResourceOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GrantPolicyWithResourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrantPolicyWithResourceOptions {
        private final software.amazon.awscdk.services.iam.PolicyStatement statement;
        private final software.amazon.awscdk.services.iam.IResourceWithPolicy resource;
        private final java.util.List<java.lang.String> resourceSelfArns;
        private final java.util.List<java.lang.String> actions;
        private final software.amazon.awscdk.services.iam.IGrantable grantee;
        private final java.util.List<java.lang.String> resourceArns;
        private final java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> conditions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.statement = software.amazon.jsii.Kernel.get(this, "statement", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class));
            this.resource = software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IResourceWithPolicy.class));
            this.resourceSelfArns = software.amazon.jsii.Kernel.get(this, "resourceSelfArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.grantee = software.amazon.jsii.Kernel.get(this, "grantee", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IGrantable.class));
            this.resourceArns = software.amazon.jsii.Kernel.get(this, "resourceArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.statement = java.util.Objects.requireNonNull(builder.statement, "statement is required");
            this.resource = java.util.Objects.requireNonNull(builder.resource, "resource is required");
            this.resourceSelfArns = builder.resourceSelfArns;
            this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
            this.grantee = java.util.Objects.requireNonNull(builder.grantee, "grantee is required");
            this.resourceArns = java.util.Objects.requireNonNull(builder.resourceArns, "resourceArns is required");
            this.conditions = (java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>>)builder.conditions;
        }

        @Override
        public final software.amazon.awscdk.services.iam.PolicyStatement getStatement() {
            return this.statement;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IResourceWithPolicy getResource() {
            return this.resource;
        }

        @Override
        public final java.util.List<java.lang.String> getResourceSelfArns() {
            return this.resourceSelfArns;
        }

        @Override
        public final java.util.List<java.lang.String> getActions() {
            return this.actions;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IGrantable getGrantee() {
            return this.grantee;
        }

        @Override
        public final java.util.List<java.lang.String> getResourceArns() {
            return this.resourceArns;
        }

        @Override
        public final java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> getConditions() {
            return this.conditions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("statement", om.valueToTree(this.getStatement()));
            data.set("resource", om.valueToTree(this.getResource()));
            if (this.getResourceSelfArns() != null) {
                data.set("resourceSelfArns", om.valueToTree(this.getResourceSelfArns()));
            }
            data.set("actions", om.valueToTree(this.getActions()));
            data.set("grantee", om.valueToTree(this.getGrantee()));
            data.set("resourceArns", om.valueToTree(this.getResourceArns()));
            if (this.getConditions() != null) {
                data.set("conditions", om.valueToTree(this.getConditions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iam.GrantPolicyWithResourceOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GrantPolicyWithResourceOptions.Jsii$Proxy that = (GrantPolicyWithResourceOptions.Jsii$Proxy) o;

            if (!statement.equals(that.statement)) return false;
            if (!resource.equals(that.resource)) return false;
            if (this.resourceSelfArns != null ? !this.resourceSelfArns.equals(that.resourceSelfArns) : that.resourceSelfArns != null) return false;
            if (!actions.equals(that.actions)) return false;
            if (!grantee.equals(that.grantee)) return false;
            if (!resourceArns.equals(that.resourceArns)) return false;
            return this.conditions != null ? this.conditions.equals(that.conditions) : that.conditions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.statement.hashCode();
            result = 31 * result + (this.resource.hashCode());
            result = 31 * result + (this.resourceSelfArns != null ? this.resourceSelfArns.hashCode() : 0);
            result = 31 * result + (this.actions.hashCode());
            result = 31 * result + (this.grantee.hashCode());
            result = 31 * result + (this.resourceArns.hashCode());
            result = 31 * result + (this.conditions != null ? this.conditions.hashCode() : 0);
            return result;
        }
    }
}
