package software.amazon.awscdk.services.iam;

/**
 * Properties for looking up an existing Role.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IRole role = Role.fromLookup(this, "Role", RoleLookupOptions.builder()
 *         .roleName("MyExistingRole")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:53.099Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.RoleLookupOptions")
@software.amazon.jsii.Jsii.Proxy(RoleLookupOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RoleLookupOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.iam.FromRoleArnOptions {

    /**
     * The name of the role to lookup.
     * <p>
     * If the role you want to lookup is a service role, you need to specify
     * the role name without the 'service-role' prefix. For example, if the role arn is
     * 'arn:aws:iam::123456789012:role/service-role/ExampleServiceExecutionRole',
     * you need to specify the role name as 'ExampleServiceExecutionRole'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleName();

    /**
     * @return a {@link Builder} of {@link RoleLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RoleLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RoleLookupOptions> {
        java.lang.String roleName;
        java.lang.Boolean addGrantsToResources;
        java.lang.String defaultPolicyName;
        java.lang.Boolean mutable;

        /**
         * Sets the value of {@link RoleLookupOptions#getRoleName}
         * @param roleName The name of the role to lookup. This parameter is required.
         *                 If the role you want to lookup is a service role, you need to specify
         *                 the role name without the 'service-role' prefix. For example, if the role arn is
         *                 'arn:aws:iam::123456789012:role/service-role/ExampleServiceExecutionRole',
         *                 you need to specify the role name as 'ExampleServiceExecutionRole'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleName(java.lang.String roleName) {
            this.roleName = roleName;
            return this;
        }

        /**
         * Sets the value of {@link RoleLookupOptions#getAddGrantsToResources}
         * @param addGrantsToResources For immutable roles: add grants to resources instead of dropping them.
         *                             If this is <code>false</code> or not specified, grant permissions added to this role are ignored.
         *                             It is your own responsibility to make sure the role has the required permissions.
         *                             <p>
         *                             If this is <code>true</code>, any grant permissions will be added to the resource instead.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addGrantsToResources(java.lang.Boolean addGrantsToResources) {
            this.addGrantsToResources = addGrantsToResources;
            return this;
        }

        /**
         * Sets the value of {@link RoleLookupOptions#getDefaultPolicyName}
         * @param defaultPolicyName Any policies created by this role will use this value as their ID, if specified.
         *                          Specify this if importing the same role in multiple stacks, and granting it
         *                          different permissions in at least two stacks. If this is not specified
         *                          (or if the same name is specified in more than one stack),
         *                          a CloudFormation issue will result in the policy created in whichever stack
         *                          is deployed last overwriting the policies created by the others.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultPolicyName(java.lang.String defaultPolicyName) {
            this.defaultPolicyName = defaultPolicyName;
            return this;
        }

        /**
         * Sets the value of {@link RoleLookupOptions#getMutable}
         * @param mutable Whether the imported role can be modified by attaching policy resources to it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mutable(java.lang.Boolean mutable) {
            this.mutable = mutable;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RoleLookupOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RoleLookupOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RoleLookupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RoleLookupOptions {
        private final java.lang.String roleName;
        private final java.lang.Boolean addGrantsToResources;
        private final java.lang.String defaultPolicyName;
        private final java.lang.Boolean mutable;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.roleName = software.amazon.jsii.Kernel.get(this, "roleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.addGrantsToResources = software.amazon.jsii.Kernel.get(this, "addGrantsToResources", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.defaultPolicyName = software.amazon.jsii.Kernel.get(this, "defaultPolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mutable = software.amazon.jsii.Kernel.get(this, "mutable", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.roleName = java.util.Objects.requireNonNull(builder.roleName, "roleName is required");
            this.addGrantsToResources = builder.addGrantsToResources;
            this.defaultPolicyName = builder.defaultPolicyName;
            this.mutable = builder.mutable;
        }

        @Override
        public final java.lang.String getRoleName() {
            return this.roleName;
        }

        @Override
        public final java.lang.Boolean getAddGrantsToResources() {
            return this.addGrantsToResources;
        }

        @Override
        public final java.lang.String getDefaultPolicyName() {
            return this.defaultPolicyName;
        }

        @Override
        public final java.lang.Boolean getMutable() {
            return this.mutable;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("roleName", om.valueToTree(this.getRoleName()));
            if (this.getAddGrantsToResources() != null) {
                data.set("addGrantsToResources", om.valueToTree(this.getAddGrantsToResources()));
            }
            if (this.getDefaultPolicyName() != null) {
                data.set("defaultPolicyName", om.valueToTree(this.getDefaultPolicyName()));
            }
            if (this.getMutable() != null) {
                data.set("mutable", om.valueToTree(this.getMutable()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iam.RoleLookupOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RoleLookupOptions.Jsii$Proxy that = (RoleLookupOptions.Jsii$Proxy) o;

            if (!roleName.equals(that.roleName)) return false;
            if (this.addGrantsToResources != null ? !this.addGrantsToResources.equals(that.addGrantsToResources) : that.addGrantsToResources != null) return false;
            if (this.defaultPolicyName != null ? !this.defaultPolicyName.equals(that.defaultPolicyName) : that.defaultPolicyName != null) return false;
            return this.mutable != null ? this.mutable.equals(that.mutable) : that.mutable == null;
        }

        @Override
        public final int hashCode() {
            int result = this.roleName.hashCode();
            result = 31 * result + (this.addGrantsToResources != null ? this.addGrantsToResources.hashCode() : 0);
            result = 31 * result + (this.defaultPolicyName != null ? this.defaultPolicyName.hashCode() : 0);
            result = 31 * result + (this.mutable != null ? this.mutable.hashCode() : 0);
            return result;
        }
    }
}
