package software.amazon.awscdk.services.iot;

/**
 * Defines an action that can be applied to audit findings by using StartAuditMitigationActionsTask.
 * <p>
 * For API reference, see <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_CreateMitigationAction.html">CreateMitigationAction</a> and for general information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/dd-mitigation-actions.html">Mitigation actions</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnMitigationAction cfnMitigationAction = CfnMitigationAction.Builder.create(this, "MyCfnMitigationAction")
 *         .actionParams(ActionParamsProperty.builder()
 *                 .addThingsToThingGroupParams(AddThingsToThingGroupParamsProperty.builder()
 *                         .thingGroupNames(List.of("thingGroupNames"))
 *                         // the properties below are optional
 *                         .overrideDynamicGroups(false)
 *                         .build())
 *                 .enableIoTLoggingParams(EnableIoTLoggingParamsProperty.builder()
 *                         .logLevel("logLevel")
 *                         .roleArnForLogging("roleArnForLogging")
 *                         .build())
 *                 .publishFindingToSnsParams(PublishFindingToSnsParamsProperty.builder()
 *                         .topicArn("topicArn")
 *                         .build())
 *                 .replaceDefaultPolicyVersionParams(ReplaceDefaultPolicyVersionParamsProperty.builder()
 *                         .templateName("templateName")
 *                         .build())
 *                 .updateCaCertificateParams(UpdateCACertificateParamsProperty.builder()
 *                         .action("action")
 *                         .build())
 *                 .updateDeviceCertificateParams(UpdateDeviceCertificateParamsProperty.builder()
 *                         .action("action")
 *                         .build())
 *                 .build())
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .actionName("actionName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-mitigationaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-mitigationaction.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:53.275Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnMitigationAction")
public class CfnMitigationAction extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnMitigationAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMitigationAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iot.CfnMitigationAction.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMitigationAction(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.CfnMitigationActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the mitigation action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMitigationActionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrMitigationActionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the mitigation action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMitigationActionId() {
        return software.amazon.jsii.Kernel.get(this, "attrMitigationActionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The set of parameters for this mitigation action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getActionParams() {
        return software.amazon.jsii.Kernel.get(this, "actionParams", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The set of parameters for this mitigation action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActionParams(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "actionParams", java.util.Objects.requireNonNull(value, "actionParams is required"));
    }

    /**
     * The set of parameters for this mitigation action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActionParams(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.CfnMitigationAction.ActionParamsProperty value) {
        software.amazon.jsii.Kernel.set(this, "actionParams", java.util.Objects.requireNonNull(value, "actionParams is required"));
    }

    /**
     * The IAM role ARN used to apply this mitigation action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IAM role ARN used to apply this mitigation action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * The friendly name of the mitigation action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getActionName() {
        return software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The friendly name of the mitigation action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActionName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "actionName", value);
    }

    /**
     * Metadata that can be used to manage the mitigation action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Metadata that can be used to manage the mitigation action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Defines the type of action and the parameters for that action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * ActionParamsProperty actionParamsProperty = ActionParamsProperty.builder()
     *         .addThingsToThingGroupParams(AddThingsToThingGroupParamsProperty.builder()
     *                 .thingGroupNames(List.of("thingGroupNames"))
     *                 // the properties below are optional
     *                 .overrideDynamicGroups(false)
     *                 .build())
     *         .enableIoTLoggingParams(EnableIoTLoggingParamsProperty.builder()
     *                 .logLevel("logLevel")
     *                 .roleArnForLogging("roleArnForLogging")
     *                 .build())
     *         .publishFindingToSnsParams(PublishFindingToSnsParamsProperty.builder()
     *                 .topicArn("topicArn")
     *                 .build())
     *         .replaceDefaultPolicyVersionParams(ReplaceDefaultPolicyVersionParamsProperty.builder()
     *                 .templateName("templateName")
     *                 .build())
     *         .updateCaCertificateParams(UpdateCACertificateParamsProperty.builder()
     *                 .action("action")
     *                 .build())
     *         .updateDeviceCertificateParams(UpdateDeviceCertificateParamsProperty.builder()
     *                 .action("action")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-actionparams.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-actionparams.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnMitigationAction.ActionParamsProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionParamsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionParamsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the group to which you want to add the devices.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-actionparams.html#cfn-iot-mitigationaction-actionparams-addthingstothinggroupparams">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-actionparams.html#cfn-iot-mitigationaction-actionparams-addthingstothinggroupparams</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAddThingsToThingGroupParams() {
            return null;
        }

        /**
         * Specifies the logging level and the role with permissions for logging.
         * <p>
         * You cannot specify a logging level of <code>DISABLED</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-actionparams.html#cfn-iot-mitigationaction-actionparams-enableiotloggingparams">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-actionparams.html#cfn-iot-mitigationaction-actionparams-enableiotloggingparams</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableIoTLoggingParams() {
            return null;
        }

        /**
         * Specifies the topic to which the finding should be published.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-actionparams.html#cfn-iot-mitigationaction-actionparams-publishfindingtosnsparams">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-actionparams.html#cfn-iot-mitigationaction-actionparams-publishfindingtosnsparams</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPublishFindingToSnsParams() {
            return null;
        }

        /**
         * Replaces the policy version with a default or blank policy.
         * <p>
         * You specify the template name. Only a value of <code>BLANK_POLICY</code> is currently supported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-actionparams.html#cfn-iot-mitigationaction-actionparams-replacedefaultpolicyversionparams">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-actionparams.html#cfn-iot-mitigationaction-actionparams-replacedefaultpolicyversionparams</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReplaceDefaultPolicyVersionParams() {
            return null;
        }

        /**
         * Specifies the new state for the CA certificate.
         * <p>
         * Only a value of <code>DEACTIVATE</code> is currently supported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-actionparams.html#cfn-iot-mitigationaction-actionparams-updatecacertificateparams">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-actionparams.html#cfn-iot-mitigationaction-actionparams-updatecacertificateparams</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUpdateCaCertificateParams() {
            return null;
        }

        /**
         * Specifies the new state for a device certificate.
         * <p>
         * Only a value of <code>DEACTIVATE</code> is currently supported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-actionparams.html#cfn-iot-mitigationaction-actionparams-updatedevicecertificateparams">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-actionparams.html#cfn-iot-mitigationaction-actionparams-updatedevicecertificateparams</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUpdateDeviceCertificateParams() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActionParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionParamsProperty> {
            java.lang.Object addThingsToThingGroupParams;
            java.lang.Object enableIoTLoggingParams;
            java.lang.Object publishFindingToSnsParams;
            java.lang.Object replaceDefaultPolicyVersionParams;
            java.lang.Object updateCaCertificateParams;
            java.lang.Object updateDeviceCertificateParams;

            /**
             * Sets the value of {@link ActionParamsProperty#getAddThingsToThingGroupParams}
             * @param addThingsToThingGroupParams Specifies the group to which you want to add the devices.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addThingsToThingGroupParams(software.amazon.awscdk.IResolvable addThingsToThingGroupParams) {
                this.addThingsToThingGroupParams = addThingsToThingGroupParams;
                return this;
            }

            /**
             * Sets the value of {@link ActionParamsProperty#getAddThingsToThingGroupParams}
             * @param addThingsToThingGroupParams Specifies the group to which you want to add the devices.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addThingsToThingGroupParams(software.amazon.awscdk.services.iot.CfnMitigationAction.AddThingsToThingGroupParamsProperty addThingsToThingGroupParams) {
                this.addThingsToThingGroupParams = addThingsToThingGroupParams;
                return this;
            }

            /**
             * Sets the value of {@link ActionParamsProperty#getEnableIoTLoggingParams}
             * @param enableIoTLoggingParams Specifies the logging level and the role with permissions for logging.
             *                               You cannot specify a logging level of <code>DISABLED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableIoTLoggingParams(software.amazon.awscdk.IResolvable enableIoTLoggingParams) {
                this.enableIoTLoggingParams = enableIoTLoggingParams;
                return this;
            }

            /**
             * Sets the value of {@link ActionParamsProperty#getEnableIoTLoggingParams}
             * @param enableIoTLoggingParams Specifies the logging level and the role with permissions for logging.
             *                               You cannot specify a logging level of <code>DISABLED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableIoTLoggingParams(software.amazon.awscdk.services.iot.CfnMitigationAction.EnableIoTLoggingParamsProperty enableIoTLoggingParams) {
                this.enableIoTLoggingParams = enableIoTLoggingParams;
                return this;
            }

            /**
             * Sets the value of {@link ActionParamsProperty#getPublishFindingToSnsParams}
             * @param publishFindingToSnsParams Specifies the topic to which the finding should be published.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publishFindingToSnsParams(software.amazon.awscdk.IResolvable publishFindingToSnsParams) {
                this.publishFindingToSnsParams = publishFindingToSnsParams;
                return this;
            }

            /**
             * Sets the value of {@link ActionParamsProperty#getPublishFindingToSnsParams}
             * @param publishFindingToSnsParams Specifies the topic to which the finding should be published.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publishFindingToSnsParams(software.amazon.awscdk.services.iot.CfnMitigationAction.PublishFindingToSnsParamsProperty publishFindingToSnsParams) {
                this.publishFindingToSnsParams = publishFindingToSnsParams;
                return this;
            }

            /**
             * Sets the value of {@link ActionParamsProperty#getReplaceDefaultPolicyVersionParams}
             * @param replaceDefaultPolicyVersionParams Replaces the policy version with a default or blank policy.
             *                                          You specify the template name. Only a value of <code>BLANK_POLICY</code> is currently supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replaceDefaultPolicyVersionParams(software.amazon.awscdk.IResolvable replaceDefaultPolicyVersionParams) {
                this.replaceDefaultPolicyVersionParams = replaceDefaultPolicyVersionParams;
                return this;
            }

            /**
             * Sets the value of {@link ActionParamsProperty#getReplaceDefaultPolicyVersionParams}
             * @param replaceDefaultPolicyVersionParams Replaces the policy version with a default or blank policy.
             *                                          You specify the template name. Only a value of <code>BLANK_POLICY</code> is currently supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replaceDefaultPolicyVersionParams(software.amazon.awscdk.services.iot.CfnMitigationAction.ReplaceDefaultPolicyVersionParamsProperty replaceDefaultPolicyVersionParams) {
                this.replaceDefaultPolicyVersionParams = replaceDefaultPolicyVersionParams;
                return this;
            }

            /**
             * Sets the value of {@link ActionParamsProperty#getUpdateCaCertificateParams}
             * @param updateCaCertificateParams Specifies the new state for the CA certificate.
             *                                  Only a value of <code>DEACTIVATE</code> is currently supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateCaCertificateParams(software.amazon.awscdk.IResolvable updateCaCertificateParams) {
                this.updateCaCertificateParams = updateCaCertificateParams;
                return this;
            }

            /**
             * Sets the value of {@link ActionParamsProperty#getUpdateCaCertificateParams}
             * @param updateCaCertificateParams Specifies the new state for the CA certificate.
             *                                  Only a value of <code>DEACTIVATE</code> is currently supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateCaCertificateParams(software.amazon.awscdk.services.iot.CfnMitigationAction.UpdateCACertificateParamsProperty updateCaCertificateParams) {
                this.updateCaCertificateParams = updateCaCertificateParams;
                return this;
            }

            /**
             * Sets the value of {@link ActionParamsProperty#getUpdateDeviceCertificateParams}
             * @param updateDeviceCertificateParams Specifies the new state for a device certificate.
             *                                      Only a value of <code>DEACTIVATE</code> is currently supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateDeviceCertificateParams(software.amazon.awscdk.IResolvable updateDeviceCertificateParams) {
                this.updateDeviceCertificateParams = updateDeviceCertificateParams;
                return this;
            }

            /**
             * Sets the value of {@link ActionParamsProperty#getUpdateDeviceCertificateParams}
             * @param updateDeviceCertificateParams Specifies the new state for a device certificate.
             *                                      Only a value of <code>DEACTIVATE</code> is currently supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateDeviceCertificateParams(software.amazon.awscdk.services.iot.CfnMitigationAction.UpdateDeviceCertificateParamsProperty updateDeviceCertificateParams) {
                this.updateDeviceCertificateParams = updateDeviceCertificateParams;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionParamsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionParamsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionParamsProperty {
            private final java.lang.Object addThingsToThingGroupParams;
            private final java.lang.Object enableIoTLoggingParams;
            private final java.lang.Object publishFindingToSnsParams;
            private final java.lang.Object replaceDefaultPolicyVersionParams;
            private final java.lang.Object updateCaCertificateParams;
            private final java.lang.Object updateDeviceCertificateParams;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.addThingsToThingGroupParams = software.amazon.jsii.Kernel.get(this, "addThingsToThingGroupParams", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableIoTLoggingParams = software.amazon.jsii.Kernel.get(this, "enableIoTLoggingParams", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.publishFindingToSnsParams = software.amazon.jsii.Kernel.get(this, "publishFindingToSnsParams", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.replaceDefaultPolicyVersionParams = software.amazon.jsii.Kernel.get(this, "replaceDefaultPolicyVersionParams", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.updateCaCertificateParams = software.amazon.jsii.Kernel.get(this, "updateCaCertificateParams", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.updateDeviceCertificateParams = software.amazon.jsii.Kernel.get(this, "updateDeviceCertificateParams", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.addThingsToThingGroupParams = builder.addThingsToThingGroupParams;
                this.enableIoTLoggingParams = builder.enableIoTLoggingParams;
                this.publishFindingToSnsParams = builder.publishFindingToSnsParams;
                this.replaceDefaultPolicyVersionParams = builder.replaceDefaultPolicyVersionParams;
                this.updateCaCertificateParams = builder.updateCaCertificateParams;
                this.updateDeviceCertificateParams = builder.updateDeviceCertificateParams;
            }

            @Override
            public final java.lang.Object getAddThingsToThingGroupParams() {
                return this.addThingsToThingGroupParams;
            }

            @Override
            public final java.lang.Object getEnableIoTLoggingParams() {
                return this.enableIoTLoggingParams;
            }

            @Override
            public final java.lang.Object getPublishFindingToSnsParams() {
                return this.publishFindingToSnsParams;
            }

            @Override
            public final java.lang.Object getReplaceDefaultPolicyVersionParams() {
                return this.replaceDefaultPolicyVersionParams;
            }

            @Override
            public final java.lang.Object getUpdateCaCertificateParams() {
                return this.updateCaCertificateParams;
            }

            @Override
            public final java.lang.Object getUpdateDeviceCertificateParams() {
                return this.updateDeviceCertificateParams;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAddThingsToThingGroupParams() != null) {
                    data.set("addThingsToThingGroupParams", om.valueToTree(this.getAddThingsToThingGroupParams()));
                }
                if (this.getEnableIoTLoggingParams() != null) {
                    data.set("enableIoTLoggingParams", om.valueToTree(this.getEnableIoTLoggingParams()));
                }
                if (this.getPublishFindingToSnsParams() != null) {
                    data.set("publishFindingToSnsParams", om.valueToTree(this.getPublishFindingToSnsParams()));
                }
                if (this.getReplaceDefaultPolicyVersionParams() != null) {
                    data.set("replaceDefaultPolicyVersionParams", om.valueToTree(this.getReplaceDefaultPolicyVersionParams()));
                }
                if (this.getUpdateCaCertificateParams() != null) {
                    data.set("updateCaCertificateParams", om.valueToTree(this.getUpdateCaCertificateParams()));
                }
                if (this.getUpdateDeviceCertificateParams() != null) {
                    data.set("updateDeviceCertificateParams", om.valueToTree(this.getUpdateDeviceCertificateParams()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnMitigationAction.ActionParamsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionParamsProperty.Jsii$Proxy that = (ActionParamsProperty.Jsii$Proxy) o;

                if (this.addThingsToThingGroupParams != null ? !this.addThingsToThingGroupParams.equals(that.addThingsToThingGroupParams) : that.addThingsToThingGroupParams != null) return false;
                if (this.enableIoTLoggingParams != null ? !this.enableIoTLoggingParams.equals(that.enableIoTLoggingParams) : that.enableIoTLoggingParams != null) return false;
                if (this.publishFindingToSnsParams != null ? !this.publishFindingToSnsParams.equals(that.publishFindingToSnsParams) : that.publishFindingToSnsParams != null) return false;
                if (this.replaceDefaultPolicyVersionParams != null ? !this.replaceDefaultPolicyVersionParams.equals(that.replaceDefaultPolicyVersionParams) : that.replaceDefaultPolicyVersionParams != null) return false;
                if (this.updateCaCertificateParams != null ? !this.updateCaCertificateParams.equals(that.updateCaCertificateParams) : that.updateCaCertificateParams != null) return false;
                return this.updateDeviceCertificateParams != null ? this.updateDeviceCertificateParams.equals(that.updateDeviceCertificateParams) : that.updateDeviceCertificateParams == null;
            }

            @Override
            public final int hashCode() {
                int result = this.addThingsToThingGroupParams != null ? this.addThingsToThingGroupParams.hashCode() : 0;
                result = 31 * result + (this.enableIoTLoggingParams != null ? this.enableIoTLoggingParams.hashCode() : 0);
                result = 31 * result + (this.publishFindingToSnsParams != null ? this.publishFindingToSnsParams.hashCode() : 0);
                result = 31 * result + (this.replaceDefaultPolicyVersionParams != null ? this.replaceDefaultPolicyVersionParams.hashCode() : 0);
                result = 31 * result + (this.updateCaCertificateParams != null ? this.updateCaCertificateParams.hashCode() : 0);
                result = 31 * result + (this.updateDeviceCertificateParams != null ? this.updateDeviceCertificateParams.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Parameters used when defining a mitigation action that move a set of things to a thing group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * AddThingsToThingGroupParamsProperty addThingsToThingGroupParamsProperty = AddThingsToThingGroupParamsProperty.builder()
     *         .thingGroupNames(List.of("thingGroupNames"))
     *         // the properties below are optional
     *         .overrideDynamicGroups(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-addthingstothinggroupparams.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-addthingstothinggroupparams.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnMitigationAction.AddThingsToThingGroupParamsProperty")
    @software.amazon.jsii.Jsii.Proxy(AddThingsToThingGroupParamsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AddThingsToThingGroupParamsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of groups to which you want to add the things that triggered the mitigation action.
         * <p>
         * You can add a thing to a maximum of 10 groups, but you can't add a thing to more than one group in the same hierarchy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-addthingstothinggroupparams.html#cfn-iot-mitigationaction-addthingstothinggroupparams-thinggroupnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-addthingstothinggroupparams.html#cfn-iot-mitigationaction-addthingstothinggroupparams-thinggroupnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getThingGroupNames();

        /**
         * Specifies if this mitigation action can move the things that triggered the mitigation action even if they are part of one or more dynamic thing groups.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-addthingstothinggroupparams.html#cfn-iot-mitigationaction-addthingstothinggroupparams-overridedynamicgroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-addthingstothinggroupparams.html#cfn-iot-mitigationaction-addthingstothinggroupparams-overridedynamicgroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverrideDynamicGroups() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AddThingsToThingGroupParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AddThingsToThingGroupParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AddThingsToThingGroupParamsProperty> {
            java.util.List<java.lang.String> thingGroupNames;
            java.lang.Object overrideDynamicGroups;

            /**
             * Sets the value of {@link AddThingsToThingGroupParamsProperty#getThingGroupNames}
             * @param thingGroupNames The list of groups to which you want to add the things that triggered the mitigation action. This parameter is required.
             *                        You can add a thing to a maximum of 10 groups, but you can't add a thing to more than one group in the same hierarchy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thingGroupNames(java.util.List<java.lang.String> thingGroupNames) {
                this.thingGroupNames = thingGroupNames;
                return this;
            }

            /**
             * Sets the value of {@link AddThingsToThingGroupParamsProperty#getOverrideDynamicGroups}
             * @param overrideDynamicGroups Specifies if this mitigation action can move the things that triggered the mitigation action even if they are part of one or more dynamic thing groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrideDynamicGroups(java.lang.Boolean overrideDynamicGroups) {
                this.overrideDynamicGroups = overrideDynamicGroups;
                return this;
            }

            /**
             * Sets the value of {@link AddThingsToThingGroupParamsProperty#getOverrideDynamicGroups}
             * @param overrideDynamicGroups Specifies if this mitigation action can move the things that triggered the mitigation action even if they are part of one or more dynamic thing groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrideDynamicGroups(software.amazon.awscdk.IResolvable overrideDynamicGroups) {
                this.overrideDynamicGroups = overrideDynamicGroups;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AddThingsToThingGroupParamsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AddThingsToThingGroupParamsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AddThingsToThingGroupParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddThingsToThingGroupParamsProperty {
            private final java.util.List<java.lang.String> thingGroupNames;
            private final java.lang.Object overrideDynamicGroups;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.thingGroupNames = software.amazon.jsii.Kernel.get(this, "thingGroupNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.overrideDynamicGroups = software.amazon.jsii.Kernel.get(this, "overrideDynamicGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.thingGroupNames = java.util.Objects.requireNonNull(builder.thingGroupNames, "thingGroupNames is required");
                this.overrideDynamicGroups = builder.overrideDynamicGroups;
            }

            @Override
            public final java.util.List<java.lang.String> getThingGroupNames() {
                return this.thingGroupNames;
            }

            @Override
            public final java.lang.Object getOverrideDynamicGroups() {
                return this.overrideDynamicGroups;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("thingGroupNames", om.valueToTree(this.getThingGroupNames()));
                if (this.getOverrideDynamicGroups() != null) {
                    data.set("overrideDynamicGroups", om.valueToTree(this.getOverrideDynamicGroups()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnMitigationAction.AddThingsToThingGroupParamsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AddThingsToThingGroupParamsProperty.Jsii$Proxy that = (AddThingsToThingGroupParamsProperty.Jsii$Proxy) o;

                if (!thingGroupNames.equals(that.thingGroupNames)) return false;
                return this.overrideDynamicGroups != null ? this.overrideDynamicGroups.equals(that.overrideDynamicGroups) : that.overrideDynamicGroups == null;
            }

            @Override
            public final int hashCode() {
                int result = this.thingGroupNames.hashCode();
                result = 31 * result + (this.overrideDynamicGroups != null ? this.overrideDynamicGroups.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Parameters used when defining a mitigation action that enable AWS IoT Core logging.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * EnableIoTLoggingParamsProperty enableIoTLoggingParamsProperty = EnableIoTLoggingParamsProperty.builder()
     *         .logLevel("logLevel")
     *         .roleArnForLogging("roleArnForLogging")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-enableiotloggingparams.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-enableiotloggingparams.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnMitigationAction.EnableIoTLoggingParamsProperty")
    @software.amazon.jsii.Jsii.Proxy(EnableIoTLoggingParamsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnableIoTLoggingParamsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the type of information to be logged.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-enableiotloggingparams.html#cfn-iot-mitigationaction-enableiotloggingparams-loglevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-enableiotloggingparams.html#cfn-iot-mitigationaction-enableiotloggingparams-loglevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogLevel();

        /**
         * The Amazon Resource Name (ARN) of the IAM role used for logging.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-enableiotloggingparams.html#cfn-iot-mitigationaction-enableiotloggingparams-rolearnforlogging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-enableiotloggingparams.html#cfn-iot-mitigationaction-enableiotloggingparams-rolearnforlogging</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArnForLogging();

        /**
         * @return a {@link Builder} of {@link EnableIoTLoggingParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnableIoTLoggingParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnableIoTLoggingParamsProperty> {
            java.lang.String logLevel;
            java.lang.String roleArnForLogging;

            /**
             * Sets the value of {@link EnableIoTLoggingParamsProperty#getLogLevel}
             * @param logLevel Specifies the type of information to be logged. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logLevel(java.lang.String logLevel) {
                this.logLevel = logLevel;
                return this;
            }

            /**
             * Sets the value of {@link EnableIoTLoggingParamsProperty#getRoleArnForLogging}
             * @param roleArnForLogging The Amazon Resource Name (ARN) of the IAM role used for logging. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArnForLogging(java.lang.String roleArnForLogging) {
                this.roleArnForLogging = roleArnForLogging;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnableIoTLoggingParamsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnableIoTLoggingParamsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EnableIoTLoggingParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnableIoTLoggingParamsProperty {
            private final java.lang.String logLevel;
            private final java.lang.String roleArnForLogging;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logLevel = software.amazon.jsii.Kernel.get(this, "logLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArnForLogging = software.amazon.jsii.Kernel.get(this, "roleArnForLogging", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logLevel = java.util.Objects.requireNonNull(builder.logLevel, "logLevel is required");
                this.roleArnForLogging = java.util.Objects.requireNonNull(builder.roleArnForLogging, "roleArnForLogging is required");
            }

            @Override
            public final java.lang.String getLogLevel() {
                return this.logLevel;
            }

            @Override
            public final java.lang.String getRoleArnForLogging() {
                return this.roleArnForLogging;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logLevel", om.valueToTree(this.getLogLevel()));
                data.set("roleArnForLogging", om.valueToTree(this.getRoleArnForLogging()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnMitigationAction.EnableIoTLoggingParamsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnableIoTLoggingParamsProperty.Jsii$Proxy that = (EnableIoTLoggingParamsProperty.Jsii$Proxy) o;

                if (!logLevel.equals(that.logLevel)) return false;
                return this.roleArnForLogging.equals(that.roleArnForLogging);
            }

            @Override
            public final int hashCode() {
                int result = this.logLevel.hashCode();
                result = 31 * result + (this.roleArnForLogging.hashCode());
                return result;
            }
        }
    }
    /**
     * Parameters to define a mitigation action that publishes findings to Amazon SNS.
     * <p>
     * You can implement your own custom actions in response to the Amazon SNS messages.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * PublishFindingToSnsParamsProperty publishFindingToSnsParamsProperty = PublishFindingToSnsParamsProperty.builder()
     *         .topicArn("topicArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-publishfindingtosnsparams.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-publishfindingtosnsparams.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnMitigationAction.PublishFindingToSnsParamsProperty")
    @software.amazon.jsii.Jsii.Proxy(PublishFindingToSnsParamsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PublishFindingToSnsParamsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the topic to which you want to publish the findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-publishfindingtosnsparams.html#cfn-iot-mitigationaction-publishfindingtosnsparams-topicarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-publishfindingtosnsparams.html#cfn-iot-mitigationaction-publishfindingtosnsparams-topicarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTopicArn();

        /**
         * @return a {@link Builder} of {@link PublishFindingToSnsParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PublishFindingToSnsParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PublishFindingToSnsParamsProperty> {
            java.lang.String topicArn;

            /**
             * Sets the value of {@link PublishFindingToSnsParamsProperty#getTopicArn}
             * @param topicArn The ARN of the topic to which you want to publish the findings. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicArn(java.lang.String topicArn) {
                this.topicArn = topicArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PublishFindingToSnsParamsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PublishFindingToSnsParamsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PublishFindingToSnsParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PublishFindingToSnsParamsProperty {
            private final java.lang.String topicArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.topicArn = software.amazon.jsii.Kernel.get(this, "topicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.topicArn = java.util.Objects.requireNonNull(builder.topicArn, "topicArn is required");
            }

            @Override
            public final java.lang.String getTopicArn() {
                return this.topicArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("topicArn", om.valueToTree(this.getTopicArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnMitigationAction.PublishFindingToSnsParamsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PublishFindingToSnsParamsProperty.Jsii$Proxy that = (PublishFindingToSnsParamsProperty.Jsii$Proxy) o;

                return this.topicArn.equals(that.topicArn);
            }

            @Override
            public final int hashCode() {
                int result = this.topicArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Parameters to define a mitigation action that adds a blank policy to restrict permissions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * ReplaceDefaultPolicyVersionParamsProperty replaceDefaultPolicyVersionParamsProperty = ReplaceDefaultPolicyVersionParamsProperty.builder()
     *         .templateName("templateName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-replacedefaultpolicyversionparams.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-replacedefaultpolicyversionparams.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnMitigationAction.ReplaceDefaultPolicyVersionParamsProperty")
    @software.amazon.jsii.Jsii.Proxy(ReplaceDefaultPolicyVersionParamsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReplaceDefaultPolicyVersionParamsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the template to be applied.
         * <p>
         * The only supported value is <code>BLANK_POLICY</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-replacedefaultpolicyversionparams.html#cfn-iot-mitigationaction-replacedefaultpolicyversionparams-templatename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-replacedefaultpolicyversionparams.html#cfn-iot-mitigationaction-replacedefaultpolicyversionparams-templatename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTemplateName();

        /**
         * @return a {@link Builder} of {@link ReplaceDefaultPolicyVersionParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReplaceDefaultPolicyVersionParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReplaceDefaultPolicyVersionParamsProperty> {
            java.lang.String templateName;

            /**
             * Sets the value of {@link ReplaceDefaultPolicyVersionParamsProperty#getTemplateName}
             * @param templateName The name of the template to be applied. This parameter is required.
             *                     The only supported value is <code>BLANK_POLICY</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateName(java.lang.String templateName) {
                this.templateName = templateName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReplaceDefaultPolicyVersionParamsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReplaceDefaultPolicyVersionParamsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReplaceDefaultPolicyVersionParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplaceDefaultPolicyVersionParamsProperty {
            private final java.lang.String templateName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.templateName = software.amazon.jsii.Kernel.get(this, "templateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.templateName = java.util.Objects.requireNonNull(builder.templateName, "templateName is required");
            }

            @Override
            public final java.lang.String getTemplateName() {
                return this.templateName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("templateName", om.valueToTree(this.getTemplateName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnMitigationAction.ReplaceDefaultPolicyVersionParamsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReplaceDefaultPolicyVersionParamsProperty.Jsii$Proxy that = (ReplaceDefaultPolicyVersionParamsProperty.Jsii$Proxy) o;

                return this.templateName.equals(that.templateName);
            }

            @Override
            public final int hashCode() {
                int result = this.templateName.hashCode();
                return result;
            }
        }
    }
    /**
     * Parameters to define a mitigation action that changes the state of the CA certificate to inactive.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * UpdateCACertificateParamsProperty updateCACertificateParamsProperty = UpdateCACertificateParamsProperty.builder()
     *         .action("action")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-updatecacertificateparams.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-updatecacertificateparams.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnMitigationAction.UpdateCACertificateParamsProperty")
    @software.amazon.jsii.Jsii.Proxy(UpdateCACertificateParamsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UpdateCACertificateParamsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action that you want to apply to the CA certificate.
         * <p>
         * The only supported value is <code>DEACTIVATE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-updatecacertificateparams.html#cfn-iot-mitigationaction-updatecacertificateparams-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-updatecacertificateparams.html#cfn-iot-mitigationaction-updatecacertificateparams-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAction();

        /**
         * @return a {@link Builder} of {@link UpdateCACertificateParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UpdateCACertificateParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UpdateCACertificateParamsProperty> {
            java.lang.String action;

            /**
             * Sets the value of {@link UpdateCACertificateParamsProperty#getAction}
             * @param action The action that you want to apply to the CA certificate. This parameter is required.
             *               The only supported value is <code>DEACTIVATE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UpdateCACertificateParamsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UpdateCACertificateParamsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UpdateCACertificateParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UpdateCACertificateParamsProperty {
            private final java.lang.String action;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnMitigationAction.UpdateCACertificateParamsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UpdateCACertificateParamsProperty.Jsii$Proxy that = (UpdateCACertificateParamsProperty.Jsii$Proxy) o;

                return this.action.equals(that.action);
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                return result;
            }
        }
    }
    /**
     * Parameters to define a mitigation action that changes the state of the device certificate to inactive.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * UpdateDeviceCertificateParamsProperty updateDeviceCertificateParamsProperty = UpdateDeviceCertificateParamsProperty.builder()
     *         .action("action")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-updatedevicecertificateparams.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-updatedevicecertificateparams.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnMitigationAction.UpdateDeviceCertificateParamsProperty")
    @software.amazon.jsii.Jsii.Proxy(UpdateDeviceCertificateParamsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UpdateDeviceCertificateParamsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action that you want to apply to the device certificate.
         * <p>
         * The only supported value is <code>DEACTIVATE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-updatedevicecertificateparams.html#cfn-iot-mitigationaction-updatedevicecertificateparams-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-updatedevicecertificateparams.html#cfn-iot-mitigationaction-updatedevicecertificateparams-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAction();

        /**
         * @return a {@link Builder} of {@link UpdateDeviceCertificateParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UpdateDeviceCertificateParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UpdateDeviceCertificateParamsProperty> {
            java.lang.String action;

            /**
             * Sets the value of {@link UpdateDeviceCertificateParamsProperty#getAction}
             * @param action The action that you want to apply to the device certificate. This parameter is required.
             *               The only supported value is <code>DEACTIVATE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UpdateDeviceCertificateParamsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UpdateDeviceCertificateParamsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UpdateDeviceCertificateParamsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UpdateDeviceCertificateParamsProperty {
            private final java.lang.String action;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnMitigationAction.UpdateDeviceCertificateParamsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UpdateDeviceCertificateParamsProperty.Jsii$Proxy that = (UpdateDeviceCertificateParamsProperty.Jsii$Proxy) o;

                return this.action.equals(that.action);
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iot.CfnMitigationAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.CfnMitigationAction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iot.CfnMitigationActionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iot.CfnMitigationActionProps.Builder();
        }

        /**
         * The set of parameters for this mitigation action.
         * <p>
         * The parameters vary, depending on the kind of action you apply.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-mitigationaction.html#cfn-iot-mitigationaction-actionparams">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-mitigationaction.html#cfn-iot-mitigationaction-actionparams</a>
         * @param actionParams The set of parameters for this mitigation action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionParams(final software.amazon.awscdk.IResolvable actionParams) {
            this.props.actionParams(actionParams);
            return this;
        }
        /**
         * The set of parameters for this mitigation action.
         * <p>
         * The parameters vary, depending on the kind of action you apply.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-mitigationaction.html#cfn-iot-mitigationaction-actionparams">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-mitigationaction.html#cfn-iot-mitigationaction-actionparams</a>
         * @param actionParams The set of parameters for this mitigation action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionParams(final software.amazon.awscdk.services.iot.CfnMitigationAction.ActionParamsProperty actionParams) {
            this.props.actionParams(actionParams);
            return this;
        }

        /**
         * The IAM role ARN used to apply this mitigation action.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-mitigationaction.html#cfn-iot-mitigationaction-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-mitigationaction.html#cfn-iot-mitigationaction-rolearn</a>
         * @param roleArn The IAM role ARN used to apply this mitigation action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * The friendly name of the mitigation action.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-mitigationaction.html#cfn-iot-mitigationaction-actionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-mitigationaction.html#cfn-iot-mitigationaction-actionname</a>
         * @param actionName The friendly name of the mitigation action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(final java.lang.String actionName) {
            this.props.actionName(actionName);
            return this;
        }

        /**
         * Metadata that can be used to manage the mitigation action.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-mitigationaction.html#cfn-iot-mitigationaction-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-mitigationaction.html#cfn-iot-mitigationaction-tags</a>
         * @param tags Metadata that can be used to manage the mitigation action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iot.CfnMitigationAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iot.CfnMitigationAction build() {
            return new software.amazon.awscdk.services.iot.CfnMitigationAction(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
