package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Configure the data processor.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * // Provide a Lambda function that will transform records before delivery, with custom
 * // buffering and retry configuration
 * Function lambdaFunction = Function.Builder.create(this, "Processor")
 *         .runtime(Runtime.NODEJS_LATEST)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "process-records")))
 *         .build();
 * LambdaFunctionProcessor lambdaProcessor = LambdaFunctionProcessor.Builder.create(lambdaFunction)
 *         .bufferInterval(Duration.minutes(5))
 *         .bufferSize(Size.mebibytes(5))
 *         .retries(5)
 *         .build();
 * S3Bucket s3Destination = S3Bucket.Builder.create(bucket)
 *         .processor(lambdaProcessor)
 *         .build();
 * DeliveryStream.Builder.create(this, "Delivery Stream")
 *         .destination(s3Destination)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:53.984Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.DataProcessorProps")
@software.amazon.jsii.Jsii.Proxy(DataProcessorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DataProcessorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The length of time Amazon Data Firehose will buffer incoming data before calling the processor.
     * <p>
     * s
     * <p>
     * Default: Duration.minutes(1)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getBufferInterval() {
        return null;
    }

    /**
     * The amount of incoming data Amazon Data Firehose will buffer before calling the processor.
     * <p>
     * Default: Size.mebibytes(3)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getBufferSize() {
        return null;
    }

    /**
     * The number of times Amazon Data Firehose will retry the processor invocation after a failure due to network timeout or invocation limits.
     * <p>
     * Default: 3
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRetries() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DataProcessorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DataProcessorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DataProcessorProps> {
        software.amazon.awscdk.Duration bufferInterval;
        software.amazon.awscdk.Size bufferSize;
        java.lang.Number retries;

        /**
         * Sets the value of {@link DataProcessorProps#getBufferInterval}
         * @param bufferInterval The length of time Amazon Data Firehose will buffer incoming data before calling the processor.
         *                       s
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bufferInterval(software.amazon.awscdk.Duration bufferInterval) {
            this.bufferInterval = bufferInterval;
            return this;
        }

        /**
         * Sets the value of {@link DataProcessorProps#getBufferSize}
         * @param bufferSize The amount of incoming data Amazon Data Firehose will buffer before calling the processor.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bufferSize(software.amazon.awscdk.Size bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        /**
         * Sets the value of {@link DataProcessorProps#getRetries}
         * @param retries The number of times Amazon Data Firehose will retry the processor invocation after a failure due to network timeout or invocation limits.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retries(java.lang.Number retries) {
            this.retries = retries;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DataProcessorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DataProcessorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DataProcessorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataProcessorProps {
        private final software.amazon.awscdk.Duration bufferInterval;
        private final software.amazon.awscdk.Size bufferSize;
        private final java.lang.Number retries;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bufferInterval = software.amazon.jsii.Kernel.get(this, "bufferInterval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.bufferSize = software.amazon.jsii.Kernel.get(this, "bufferSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.retries = software.amazon.jsii.Kernel.get(this, "retries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bufferInterval = builder.bufferInterval;
            this.bufferSize = builder.bufferSize;
            this.retries = builder.retries;
        }

        @Override
        public final software.amazon.awscdk.Duration getBufferInterval() {
            return this.bufferInterval;
        }

        @Override
        public final software.amazon.awscdk.Size getBufferSize() {
            return this.bufferSize;
        }

        @Override
        public final java.lang.Number getRetries() {
            return this.retries;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBufferInterval() != null) {
                data.set("bufferInterval", om.valueToTree(this.getBufferInterval()));
            }
            if (this.getBufferSize() != null) {
                data.set("bufferSize", om.valueToTree(this.getBufferSize()));
            }
            if (this.getRetries() != null) {
                data.set("retries", om.valueToTree(this.getRetries()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.DataProcessorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DataProcessorProps.Jsii$Proxy that = (DataProcessorProps.Jsii$Proxy) o;

            if (this.bufferInterval != null ? !this.bufferInterval.equals(that.bufferInterval) : that.bufferInterval != null) return false;
            if (this.bufferSize != null ? !this.bufferSize.equals(that.bufferSize) : that.bufferSize != null) return false;
            return this.retries != null ? this.retries.equals(that.retries) : that.retries == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bufferInterval != null ? this.bufferInterval.hashCode() : 0;
            result = 31 * result + (this.bufferSize != null ? this.bufferSize.hashCode() : 0);
            result = 31 * result + (this.retries != null ? this.retries.hashCode() : 0);
            return result;
        }
    }
}
