package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Use an AWS Lambda function to transform records.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * // Provide a Lambda function that will transform records before delivery, with custom
 * // buffering and retry configuration
 * Function lambdaFunction = Function.Builder.create(this, "Processor")
 *         .runtime(Runtime.NODEJS_LATEST)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "process-records")))
 *         .build();
 * LambdaFunctionProcessor lambdaProcessor = LambdaFunctionProcessor.Builder.create(lambdaFunction)
 *         .bufferInterval(Duration.minutes(5))
 *         .bufferSize(Size.mebibytes(5))
 *         .retries(5)
 *         .build();
 * S3Bucket s3Destination = S3Bucket.Builder.create(bucket)
 *         .processor(lambdaProcessor)
 *         .build();
 * DeliveryStream.Builder.create(this, "Delivery Stream")
 *         .destination(s3Destination)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:53.993Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.LambdaFunctionProcessor")
public class LambdaFunctionProcessor extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisfirehose.IDataProcessor {

    protected LambdaFunctionProcessor(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LambdaFunctionProcessor(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param lambdaFunction This parameter is required.
     * @param props The constructor props of the DataProcessor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LambdaFunctionProcessor(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction lambdaFunction, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.DataProcessorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(lambdaFunction, "lambdaFunction is required"), props });
    }

    /**
     * @param lambdaFunction This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LambdaFunctionProcessor(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction lambdaFunction) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(lambdaFunction, "lambdaFunction is required") });
    }

    /**
     * Binds this processor to a destination of a delivery stream.
     * <p>
     * Implementers should use this method to grant processor invocation permissions to the provided stream and return the
     * necessary configuration to register as a processor.
     * <p>
     * @param _scope This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.DataProcessorConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.DataProcessorBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.DataProcessorConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * The constructor props of the LambdaFunctionProcessor.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.DataProcessorProps getProps() {
        return software.amazon.jsii.Kernel.get(this, "props", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.DataProcessorProps.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kinesisfirehose.LambdaFunctionProcessor}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kinesisfirehose.LambdaFunctionProcessor> {
        /**
         * @return a new instance of {@link Builder}.
         * @param lambdaFunction This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.lambda.IFunction lambdaFunction) {
            return new Builder(lambdaFunction);
        }

        private final software.amazon.awscdk.services.lambda.IFunction lambdaFunction;
        private software.amazon.awscdk.services.kinesisfirehose.DataProcessorProps.Builder props;

        private Builder(final software.amazon.awscdk.services.lambda.IFunction lambdaFunction) {
            this.lambdaFunction = lambdaFunction;
        }

        /**
         * The length of time Amazon Data Firehose will buffer incoming data before calling the processor.
         * <p>
         * s
         * <p>
         * Default: Duration.minutes(1)
         * <p>
         * @return {@code this}
         * @param bufferInterval The length of time Amazon Data Firehose will buffer incoming data before calling the processor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bufferInterval(final software.amazon.awscdk.Duration bufferInterval) {
            this.props().bufferInterval(bufferInterval);
            return this;
        }

        /**
         * The amount of incoming data Amazon Data Firehose will buffer before calling the processor.
         * <p>
         * Default: Size.mebibytes(3)
         * <p>
         * @return {@code this}
         * @param bufferSize The amount of incoming data Amazon Data Firehose will buffer before calling the processor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bufferSize(final software.amazon.awscdk.Size bufferSize) {
            this.props().bufferSize(bufferSize);
            return this;
        }

        /**
         * The number of times Amazon Data Firehose will retry the processor invocation after a failure due to network timeout or invocation limits.
         * <p>
         * Default: 3
         * <p>
         * @return {@code this}
         * @param retries The number of times Amazon Data Firehose will retry the processor invocation after a failure due to network timeout or invocation limits. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retries(final java.lang.Number retries) {
            this.props().retries(retries);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.kinesisfirehose.LambdaFunctionProcessor}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kinesisfirehose.LambdaFunctionProcessor build() {
            return new software.amazon.awscdk.services.kinesisfirehose.LambdaFunctionProcessor(
                this.lambdaFunction,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.kinesisfirehose.DataProcessorProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.kinesisfirehose.DataProcessorProps.Builder();
            }
            return this.props;
        }
    }
}
