package software.amazon.awscdk.services.lakeformation;

/**
 * Properties for defining a <code>CfnTagAssociation</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.glue.alpha.S3Table;
 * import software.amazon.awscdk.services.glue.alpha.Database;
 * import software.amazon.awscdk.services.glue.alpha.DataFormat;
 * import software.amazon.awscdk.services.glue.alpha.Schema;
 * import software.amazon.awscdk.services.lakeformation.CfnDataLakeSettings;
 * import software.amazon.awscdk.services.lakeformation.CfnTag;
 * import software.amazon.awscdk.services.lakeformation.CfnTagAssociation;
 * Stack stack;
 * String accountId;
 * String tagKey = "aws";
 * String[] tagValues = List.of("dev");
 * Database database = new Database(this, "Database");
 * S3Table table = S3Table.Builder.create(this, "Table")
 *         .database(database)
 *         .columns(List.of(Column.builder()
 *                 .name("col1")
 *                 .type(Schema.STRING)
 *                 .build(), Column.builder()
 *                 .name("col2")
 *                 .type(Schema.STRING)
 *                 .build()))
 *         .dataFormat(DataFormat.CSV)
 *         .build();
 * DefaultStackSynthesizer synthesizer = (DefaultStackSynthesizer)stack.getSynthesizer();
 * CfnDataLakeSettings.Builder.create(this, "DataLakeSettings")
 *         .admins(List.of(DataLakePrincipalProperty.builder()
 *                 .dataLakePrincipalIdentifier(stack.formatArn(ArnComponents.builder()
 *                         .service("iam")
 *                         .resource("role")
 *                         .region("")
 *                         .account(accountId)
 *                         .resourceName("Admin")
 *                         .build()))
 *                 .build(), DataLakePrincipalProperty.builder()
 *                 // The CDK cloudformation execution role.
 *                 .dataLakePrincipalIdentifier(synthesizer.cloudFormationExecutionRoleArn.replace("${AWS::Partition}", "aws"))
 *                 .build()))
 *         .build();
 * CfnTag tag = CfnTag.Builder.create(this, "Tag")
 *         .catalogId(accountId)
 *         .tagKey(tagKey)
 *         .tagValues(tagValues)
 *         .build();
 * LFTagPairProperty lfTagPairProperty = LFTagPairProperty.builder()
 *         .catalogId(accountId)
 *         .tagKey(tagKey)
 *         .tagValues(tagValues)
 *         .build();
 * CfnTagAssociation tagAssociation = CfnTagAssociation.Builder.create(this, "TagAssociation")
 *         .lfTags(List.of(lfTagPairProperty))
 *         .resource(ResourceProperty.builder()
 *                 .tableWithColumns(TableWithColumnsResourceProperty.builder()
 *                         .databaseName(database.getDatabaseName())
 *                         .columnNames(List.of("col1", "col2"))
 *                         .catalogId(accountId)
 *                         .name(table.getTableName())
 *                         .build())
 *                 .build())
 *         .build();
 * tagAssociation.node.addDependency(tag);
 * tagAssociation.node.addDependency(table);
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-tagassociation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-tagassociation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:54.080Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnTagAssociationProps")
@software.amazon.jsii.Jsii.Proxy(CfnTagAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTagAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A structure containing an LF-tag key-value pair.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-tagassociation.html#cfn-lakeformation-tagassociation-lftags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-tagassociation.html#cfn-lakeformation-tagassociation-lftags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getLfTags();

    /**
     * UTF-8 string (valid values: <code>DATABASE | TABLE</code> ).
     * <p>
     * The resource for which the LF-tag policy applies.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-tagassociation.html#cfn-lakeformation-tagassociation-resource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-tagassociation.html#cfn-lakeformation-tagassociation-resource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getResource();

    /**
     * @return a {@link Builder} of {@link CfnTagAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTagAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTagAssociationProps> {
        java.lang.Object lfTags;
        java.lang.Object resource;

        /**
         * Sets the value of {@link CfnTagAssociationProps#getLfTags}
         * @param lfTags A structure containing an LF-tag key-value pair. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lfTags(software.amazon.awscdk.IResolvable lfTags) {
            this.lfTags = lfTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnTagAssociationProps#getLfTags}
         * @param lfTags A structure containing an LF-tag key-value pair. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lfTags(java.util.List<? extends java.lang.Object> lfTags) {
            this.lfTags = lfTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnTagAssociationProps#getResource}
         * @param resource UTF-8 string (valid values: <code>DATABASE | TABLE</code> ). This parameter is required.
         *                 The resource for which the LF-tag policy applies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resource(software.amazon.awscdk.IResolvable resource) {
            this.resource = resource;
            return this;
        }

        /**
         * Sets the value of {@link CfnTagAssociationProps#getResource}
         * @param resource UTF-8 string (valid values: <code>DATABASE | TABLE</code> ). This parameter is required.
         *                 The resource for which the LF-tag policy applies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resource(software.amazon.awscdk.services.lakeformation.CfnTagAssociation.ResourceProperty resource) {
            this.resource = resource;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTagAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTagAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTagAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTagAssociationProps {
        private final java.lang.Object lfTags;
        private final java.lang.Object resource;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.lfTags = software.amazon.jsii.Kernel.get(this, "lfTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resource = software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.lfTags = java.util.Objects.requireNonNull(builder.lfTags, "lfTags is required");
            this.resource = java.util.Objects.requireNonNull(builder.resource, "resource is required");
        }

        @Override
        public final java.lang.Object getLfTags() {
            return this.lfTags;
        }

        @Override
        public final java.lang.Object getResource() {
            return this.resource;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("lfTags", om.valueToTree(this.getLfTags()));
            data.set("resource", om.valueToTree(this.getResource()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnTagAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTagAssociationProps.Jsii$Proxy that = (CfnTagAssociationProps.Jsii$Proxy) o;

            if (!lfTags.equals(that.lfTags)) return false;
            return this.resource.equals(that.resource);
        }

        @Override
        public final int hashCode() {
            int result = this.lfTags.hashCode();
            result = 31 * result + (this.resource.hashCode());
            return result;
        }
    }
}
