package software.amazon.awscdk.services.lambda;

/**
 * Defines a new Lambda Layer version.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * LayerVersion.Builder.create(this, "MyLayer")
 *         .removalPolicy(RemovalPolicy.RETAIN)
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .compatibleArchitectures(List.of(Architecture.X86_64, Architecture.ARM_64))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:54.258Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.LayerVersion")
public class LayerVersion extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.lambda.ILayerVersion {

    protected LayerVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LayerVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.LayerVersion.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LayerVersion(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.LayerVersionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports a layer version by ARN.
     * <p>
     * Assumes it is compatible with all Lambda runtimes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param layerVersionArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.ILayerVersion fromLayerVersionArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String layerVersionArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.LayerVersion.class, "fromLayerVersionArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ILayerVersion.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(layerVersionArn, "layerVersionArn is required") });
    }

    /**
     * Imports a Layer that has been defined externally.
     * <p>
     * @param scope the parent Construct that will use the imported layer. This parameter is required.
     * @param id the id of the imported layer in the construct tree. This parameter is required.
     * @param attrs the properties of the imported layer. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.ILayerVersion fromLayerVersionAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.LayerVersionAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.LayerVersion.class, "fromLayerVersionAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ILayerVersion.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Add permission for this layer version to specific entities.
     * <p>
     * Usage within
     * the same account where the layer is defined is always allowed and does not
     * require calling this method. Note that the principal that creates the
     * Lambda function using the layer (for example, a CloudFormation changeset
     * execution role) also needs to have the <code>lambda:GetLayerVersion</code>
     * permission on the layer version.
     * <p>
     * @param id This parameter is required.
     * @param permission This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addPermission(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.LayerVersionPermission permission) {
        software.amazon.jsii.Kernel.call(this, "addPermission", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(permission, "permission is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The ARN of the Lambda Layer version that this Layer defines.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLayerVersionArn() {
        return software.amazon.jsii.Kernel.get(this, "layerVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The runtimes compatible with this Layer.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.lambda.Runtime> getCompatibleRuntimes() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.lambda.Runtime>)(software.amazon.jsii.Kernel.get(this, "compatibleRuntimes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Runtime.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.LayerVersion}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.LayerVersion> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.LayerVersionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lambda.LayerVersionProps.Builder();
        }

        /**
         * The description the this Lambda Layer.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description The description the this Lambda Layer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the layer.
         * <p>
         * Default: - A name will be generated.
         * <p>
         * @return {@code this}
         * @param layerVersionName The name of the layer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder layerVersionName(final java.lang.String layerVersionName) {
            this.props.layerVersionName(layerVersionName);
            return this;
        }

        /**
         * The SPDX licence identifier or URL to the license file for this layer.
         * <p>
         * Default: - No license information will be recorded.
         * <p>
         * @return {@code this}
         * @param license The SPDX licence identifier or URL to the license file for this layer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder license(final java.lang.String license) {
            this.props.license(license);
            return this;
        }

        /**
         * Whether to retain this version of the layer when a new version is added or when the stack is deleted.
         * <p>
         * Default: RemovalPolicy.DESTROY
         * <p>
         * @return {@code this}
         * @param removalPolicy Whether to retain this version of the layer when a new version is added or when the stack is deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * The content of this Layer.
         * <p>
         * Using <code>Code.fromInline</code> is not supported.
         * <p>
         * @return {@code this}
         * @param code The content of this Layer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(final software.amazon.awscdk.services.lambda.Code code) {
            this.props.code(code);
            return this;
        }

        /**
         * The system architectures compatible with this layer.
         * <p>
         * Default: [Architecture.X86_64]
         * <p>
         * @return {@code this}
         * @param compatibleArchitectures The system architectures compatible with this layer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compatibleArchitectures(final java.util.List<? extends software.amazon.awscdk.services.lambda.Architecture> compatibleArchitectures) {
            this.props.compatibleArchitectures(compatibleArchitectures);
            return this;
        }

        /**
         * The runtimes compatible with this Layer.
         * <p>
         * Default: - All runtimes are supported.
         * <p>
         * @return {@code this}
         * @param compatibleRuntimes The runtimes compatible with this Layer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compatibleRuntimes(final java.util.List<? extends software.amazon.awscdk.services.lambda.Runtime> compatibleRuntimes) {
            this.props.compatibleRuntimes(compatibleRuntimes);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lambda.LayerVersion}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.LayerVersion build() {
            return new software.amazon.awscdk.services.lambda.LayerVersion(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
