package software.amazon.awscdk.services.mediaconnect;

/**
 * Properties for defining a <code>CfnBridgeSource</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediaconnect.*;
 * CfnBridgeSourceProps cfnBridgeSourceProps = CfnBridgeSourceProps.builder()
 *         .bridgeArn("bridgeArn")
 *         .name("name")
 *         // the properties below are optional
 *         .flowSource(BridgeFlowSourceProperty.builder()
 *                 .flowArn("flowArn")
 *                 // the properties below are optional
 *                 .flowVpcInterfaceAttachment(VpcInterfaceAttachmentProperty.builder()
 *                         .vpcInterfaceName("vpcInterfaceName")
 *                         .build())
 *                 .build())
 *         .networkSource(BridgeNetworkSourceProperty.builder()
 *                 .multicastIp("multicastIp")
 *                 .networkName("networkName")
 *                 .port(123)
 *                 .protocol("protocol")
 *                 // the properties below are optional
 *                 .multicastSourceSettings(MulticastSourceSettingsProperty.builder()
 *                         .multicastSourceIp("multicastSourceIp")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridgesource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridgesource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:54.744Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnBridgeSourceProps")
@software.amazon.jsii.Jsii.Proxy(CfnBridgeSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnBridgeSourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the bridge feeding this flow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridgesource.html#cfn-mediaconnect-bridgesource-bridgearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridgesource.html#cfn-mediaconnect-bridgesource-bridgearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBridgeArn();

    /**
     * The name of the flow source.
     * <p>
     * This name is used to reference the source and must be unique among sources in this bridge.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridgesource.html#cfn-mediaconnect-bridgesource-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridgesource.html#cfn-mediaconnect-bridgesource-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The source of the flow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridgesource.html#cfn-mediaconnect-bridgesource-flowsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridgesource.html#cfn-mediaconnect-bridgesource-flowsource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFlowSource() {
        return null;
    }

    /**
     * The source of the network.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridgesource.html#cfn-mediaconnect-bridgesource-networksource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridgesource.html#cfn-mediaconnect-bridgesource-networksource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkSource() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnBridgeSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnBridgeSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnBridgeSourceProps> {
        java.lang.String bridgeArn;
        java.lang.String name;
        java.lang.Object flowSource;
        java.lang.Object networkSource;

        /**
         * Sets the value of {@link CfnBridgeSourceProps#getBridgeArn}
         * @param bridgeArn The ARN of the bridge feeding this flow. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bridgeArn(java.lang.String bridgeArn) {
            this.bridgeArn = bridgeArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnBridgeSourceProps#getName}
         * @param name The name of the flow source. This parameter is required.
         *             This name is used to reference the source and must be unique among sources in this bridge.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnBridgeSourceProps#getFlowSource}
         * @param flowSource The source of the flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowSource(software.amazon.awscdk.IResolvable flowSource) {
            this.flowSource = flowSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnBridgeSourceProps#getFlowSource}
         * @param flowSource The source of the flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowSource(software.amazon.awscdk.services.mediaconnect.CfnBridgeSource.BridgeFlowSourceProperty flowSource) {
            this.flowSource = flowSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnBridgeSourceProps#getNetworkSource}
         * @param networkSource The source of the network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkSource(software.amazon.awscdk.IResolvable networkSource) {
            this.networkSource = networkSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnBridgeSourceProps#getNetworkSource}
         * @param networkSource The source of the network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkSource(software.amazon.awscdk.services.mediaconnect.CfnBridgeSource.BridgeNetworkSourceProperty networkSource) {
            this.networkSource = networkSource;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnBridgeSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnBridgeSourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnBridgeSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnBridgeSourceProps {
        private final java.lang.String bridgeArn;
        private final java.lang.String name;
        private final java.lang.Object flowSource;
        private final java.lang.Object networkSource;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bridgeArn = software.amazon.jsii.Kernel.get(this, "bridgeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.flowSource = software.amazon.jsii.Kernel.get(this, "flowSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.networkSource = software.amazon.jsii.Kernel.get(this, "networkSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bridgeArn = java.util.Objects.requireNonNull(builder.bridgeArn, "bridgeArn is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.flowSource = builder.flowSource;
            this.networkSource = builder.networkSource;
        }

        @Override
        public final java.lang.String getBridgeArn() {
            return this.bridgeArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getFlowSource() {
            return this.flowSource;
        }

        @Override
        public final java.lang.Object getNetworkSource() {
            return this.networkSource;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bridgeArn", om.valueToTree(this.getBridgeArn()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getFlowSource() != null) {
                data.set("flowSource", om.valueToTree(this.getFlowSource()));
            }
            if (this.getNetworkSource() != null) {
                data.set("networkSource", om.valueToTree(this.getNetworkSource()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnBridgeSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnBridgeSourceProps.Jsii$Proxy that = (CfnBridgeSourceProps.Jsii$Proxy) o;

            if (!bridgeArn.equals(that.bridgeArn)) return false;
            if (!name.equals(that.name)) return false;
            if (this.flowSource != null ? !this.flowSource.equals(that.flowSource) : that.flowSource != null) return false;
            return this.networkSource != null ? this.networkSource.equals(that.networkSource) : that.networkSource == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bridgeArn.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.flowSource != null ? this.flowSource.hashCode() : 0);
            result = 31 * result + (this.networkSource != null ? this.networkSource.hashCode() : 0);
            return result;
        }
    }
}
