package software.amazon.awscdk.services.mediaconnect;

/**
 * Properties for defining a <code>CfnFlowOutput</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediaconnect.*;
 * CfnFlowOutputProps cfnFlowOutputProps = CfnFlowOutputProps.builder()
 *         .flowArn("flowArn")
 *         .protocol("protocol")
 *         // the properties below are optional
 *         .cidrAllowList(List.of("cidrAllowList"))
 *         .description("description")
 *         .destination("destination")
 *         .encryption(EncryptionProperty.builder()
 *                 .roleArn("roleArn")
 *                 .secretArn("secretArn")
 *                 // the properties below are optional
 *                 .algorithm("algorithm")
 *                 .keyType("keyType")
 *                 .build())
 *         .maxLatency(123)
 *         .mediaStreamOutputConfigurations(List.of(MediaStreamOutputConfigurationProperty.builder()
 *                 .encodingName("encodingName")
 *                 .mediaStreamName("mediaStreamName")
 *                 // the properties below are optional
 *                 .destinationConfigurations(List.of(DestinationConfigurationProperty.builder()
 *                         .destinationIp("destinationIp")
 *                         .destinationPort(123)
 *                         .interface(InterfaceProperty.builder()
 *                                 .name("name")
 *                                 .build())
 *                         .build()))
 *                 .encodingParameters(EncodingParametersProperty.builder()
 *                         .compressionFactor(123)
 *                         // the properties below are optional
 *                         .encoderProfile("encoderProfile")
 *                         .build())
 *                 .build()))
 *         .minLatency(123)
 *         .name("name")
 *         .ndiProgramName("ndiProgramName")
 *         .ndiSpeedHqQuality(123)
 *         .outputStatus("outputStatus")
 *         .port(123)
 *         .remoteId("remoteId")
 *         .smoothingLatency(123)
 *         .streamId("streamId")
 *         .vpcInterfaceAttachment(VpcInterfaceAttachmentProperty.builder()
 *                 .vpcInterfaceName("vpcInterfaceName")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:54.764Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlowOutputProps")
@software.amazon.jsii.Jsii.Proxy(CfnFlowOutputProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFlowOutputProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the flow this output is attached to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-flowarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-flowarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFlowArn();

    /**
     * The protocol to use for the output.
     * <p>
     * <blockquote>
     * <p>
     * AWS Elemental MediaConnect no longer supports the Fujitsu QoS protocol. This reference is maintained for legacy purposes only.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-protocol</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProtocol();

    /**
     * The range of IP addresses that should be allowed to initiate output requests to this flow.
     * <p>
     * These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-cidrallowlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-cidrallowlist</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCidrAllowList() {
        return null;
    }

    /**
     * A description of the output.
     * <p>
     * This description appears only on the MediaConnect console and will not be seen by the end user.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The IP address where you want to send the output.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-destination</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestination() {
        return null;
    }

    /**
     * The type of key used for the encryption.
     * <p>
     * If no <code>keyType</code> is provided, the service will use the default setting (static-key). Allowable encryption types: static-key.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-encryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-encryption</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncryption() {
        return null;
    }

    /**
     * The maximum latency in milliseconds.
     * <p>
     * This parameter applies only to RIST-based and Zixi-based streams.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-maxlatency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-maxlatency</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxLatency() {
        return null;
    }

    /**
     * The media streams that are associated with the output, and the parameters for those associations.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-mediastreamoutputconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-mediastreamoutputconfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMediaStreamOutputConfigurations() {
        return null;
    }

    /**
     * The minimum latency in milliseconds for SRT-based streams.
     * <p>
     * In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-minlatency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-minlatency</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinLatency() {
        return null;
    }

    /**
     * The name of the bridge's output.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * A suffix for the names of the NDI sources that the flow creates.
     * <p>
     * If a custom name isn't specified, MediaConnect uses the output name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-ndiprogramname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-ndiprogramname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNdiProgramName() {
        return null;
    }

    /**
     * A quality setting for the NDI Speed HQ encoder.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-ndispeedhqquality">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-ndispeedhqquality</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getNdiSpeedHqQuality() {
        return null;
    }

    /**
     * An indication of whether the output should transmit data or not.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-outputstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-outputstatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutputStatus() {
        return null;
    }

    /**
     * The port to use when content is distributed to this output.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-port</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * The remote ID for the Zixi-pull stream.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-remoteid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-remoteid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRemoteId() {
        return null;
    }

    /**
     * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-smoothinglatency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-smoothinglatency</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSmoothingLatency() {
        return null;
    }

    /**
     * The stream ID that you want to use for this transport.
     * <p>
     * This parameter applies only to Zixi and SRT caller-based streams.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-streamid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-streamid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStreamId() {
        return null;
    }

    /**
     * The name of the VPC interface attachment to use for this output.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-vpcinterfaceattachment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html#cfn-mediaconnect-flowoutput-vpcinterfaceattachment</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpcInterfaceAttachment() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFlowOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFlowOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFlowOutputProps> {
        java.lang.String flowArn;
        java.lang.String protocol;
        java.util.List<java.lang.String> cidrAllowList;
        java.lang.String description;
        java.lang.String destination;
        java.lang.Object encryption;
        java.lang.Number maxLatency;
        java.lang.Object mediaStreamOutputConfigurations;
        java.lang.Number minLatency;
        java.lang.String name;
        java.lang.String ndiProgramName;
        java.lang.Number ndiSpeedHqQuality;
        java.lang.String outputStatus;
        java.lang.Number port;
        java.lang.String remoteId;
        java.lang.Number smoothingLatency;
        java.lang.String streamId;
        java.lang.Object vpcInterfaceAttachment;

        /**
         * Sets the value of {@link CfnFlowOutputProps#getFlowArn}
         * @param flowArn The Amazon Resource Name (ARN) of the flow this output is attached to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowArn(java.lang.String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowOutputProps#getProtocol}
         * @param protocol The protocol to use for the output. This parameter is required.
         *                 <blockquote>
         *                 <p>
         *                 AWS Elemental MediaConnect no longer supports the Fujitsu QoS protocol. This reference is maintained for legacy purposes only.
         *                 <p>
         *                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(java.lang.String protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowOutputProps#getCidrAllowList}
         * @param cidrAllowList The range of IP addresses that should be allowed to initiate output requests to this flow.
         *                      These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrAllowList(java.util.List<java.lang.String> cidrAllowList) {
            this.cidrAllowList = cidrAllowList;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowOutputProps#getDescription}
         * @param description A description of the output.
         *                    This description appears only on the MediaConnect console and will not be seen by the end user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowOutputProps#getDestination}
         * @param destination The IP address where you want to send the output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destination(java.lang.String destination) {
            this.destination = destination;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowOutputProps#getEncryption}
         * @param encryption The type of key used for the encryption.
         *                   If no <code>keyType</code> is provided, the service will use the default setting (static-key). Allowable encryption types: static-key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(software.amazon.awscdk.IResolvable encryption) {
            this.encryption = encryption;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowOutputProps#getEncryption}
         * @param encryption The type of key used for the encryption.
         *                   If no <code>keyType</code> is provided, the service will use the default setting (static-key). Allowable encryption types: static-key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(software.amazon.awscdk.services.mediaconnect.CfnFlowOutput.EncryptionProperty encryption) {
            this.encryption = encryption;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowOutputProps#getMaxLatency}
         * @param maxLatency The maximum latency in milliseconds.
         *                   This parameter applies only to RIST-based and Zixi-based streams.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxLatency(java.lang.Number maxLatency) {
            this.maxLatency = maxLatency;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowOutputProps#getMediaStreamOutputConfigurations}
         * @param mediaStreamOutputConfigurations The media streams that are associated with the output, and the parameters for those associations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mediaStreamOutputConfigurations(software.amazon.awscdk.IResolvable mediaStreamOutputConfigurations) {
            this.mediaStreamOutputConfigurations = mediaStreamOutputConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowOutputProps#getMediaStreamOutputConfigurations}
         * @param mediaStreamOutputConfigurations The media streams that are associated with the output, and the parameters for those associations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mediaStreamOutputConfigurations(java.util.List<? extends java.lang.Object> mediaStreamOutputConfigurations) {
            this.mediaStreamOutputConfigurations = mediaStreamOutputConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowOutputProps#getMinLatency}
         * @param minLatency The minimum latency in milliseconds for SRT-based streams.
         *                   In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minLatency(java.lang.Number minLatency) {
            this.minLatency = minLatency;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowOutputProps#getName}
         * @param name The name of the bridge's output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowOutputProps#getNdiProgramName}
         * @param ndiProgramName A suffix for the names of the NDI sources that the flow creates.
         *                       If a custom name isn't specified, MediaConnect uses the output name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ndiProgramName(java.lang.String ndiProgramName) {
            this.ndiProgramName = ndiProgramName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowOutputProps#getNdiSpeedHqQuality}
         * @param ndiSpeedHqQuality A quality setting for the NDI Speed HQ encoder.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ndiSpeedHqQuality(java.lang.Number ndiSpeedHqQuality) {
            this.ndiSpeedHqQuality = ndiSpeedHqQuality;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowOutputProps#getOutputStatus}
         * @param outputStatus An indication of whether the output should transmit data or not.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputStatus(java.lang.String outputStatus) {
            this.outputStatus = outputStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowOutputProps#getPort}
         * @param port The port to use when content is distributed to this output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowOutputProps#getRemoteId}
         * @param remoteId The remote ID for the Zixi-pull stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder remoteId(java.lang.String remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowOutputProps#getSmoothingLatency}
         * @param smoothingLatency The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smoothingLatency(java.lang.Number smoothingLatency) {
            this.smoothingLatency = smoothingLatency;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowOutputProps#getStreamId}
         * @param streamId The stream ID that you want to use for this transport.
         *                 This parameter applies only to Zixi and SRT caller-based streams.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamId(java.lang.String streamId) {
            this.streamId = streamId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowOutputProps#getVpcInterfaceAttachment}
         * @param vpcInterfaceAttachment The name of the VPC interface attachment to use for this output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcInterfaceAttachment(software.amazon.awscdk.IResolvable vpcInterfaceAttachment) {
            this.vpcInterfaceAttachment = vpcInterfaceAttachment;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowOutputProps#getVpcInterfaceAttachment}
         * @param vpcInterfaceAttachment The name of the VPC interface attachment to use for this output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcInterfaceAttachment(software.amazon.awscdk.services.mediaconnect.CfnFlowOutput.VpcInterfaceAttachmentProperty vpcInterfaceAttachment) {
            this.vpcInterfaceAttachment = vpcInterfaceAttachment;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFlowOutputProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFlowOutputProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFlowOutputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFlowOutputProps {
        private final java.lang.String flowArn;
        private final java.lang.String protocol;
        private final java.util.List<java.lang.String> cidrAllowList;
        private final java.lang.String description;
        private final java.lang.String destination;
        private final java.lang.Object encryption;
        private final java.lang.Number maxLatency;
        private final java.lang.Object mediaStreamOutputConfigurations;
        private final java.lang.Number minLatency;
        private final java.lang.String name;
        private final java.lang.String ndiProgramName;
        private final java.lang.Number ndiSpeedHqQuality;
        private final java.lang.String outputStatus;
        private final java.lang.Number port;
        private final java.lang.String remoteId;
        private final java.lang.Number smoothingLatency;
        private final java.lang.String streamId;
        private final java.lang.Object vpcInterfaceAttachment;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.flowArn = software.amazon.jsii.Kernel.get(this, "flowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cidrAllowList = software.amazon.jsii.Kernel.get(this, "cidrAllowList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.maxLatency = software.amazon.jsii.Kernel.get(this, "maxLatency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.mediaStreamOutputConfigurations = software.amazon.jsii.Kernel.get(this, "mediaStreamOutputConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.minLatency = software.amazon.jsii.Kernel.get(this, "minLatency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ndiProgramName = software.amazon.jsii.Kernel.get(this, "ndiProgramName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ndiSpeedHqQuality = software.amazon.jsii.Kernel.get(this, "ndiSpeedHqQuality", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.outputStatus = software.amazon.jsii.Kernel.get(this, "outputStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.remoteId = software.amazon.jsii.Kernel.get(this, "remoteId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.smoothingLatency = software.amazon.jsii.Kernel.get(this, "smoothingLatency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.streamId = software.amazon.jsii.Kernel.get(this, "streamId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcInterfaceAttachment = software.amazon.jsii.Kernel.get(this, "vpcInterfaceAttachment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.flowArn = java.util.Objects.requireNonNull(builder.flowArn, "flowArn is required");
            this.protocol = java.util.Objects.requireNonNull(builder.protocol, "protocol is required");
            this.cidrAllowList = builder.cidrAllowList;
            this.description = builder.description;
            this.destination = builder.destination;
            this.encryption = builder.encryption;
            this.maxLatency = builder.maxLatency;
            this.mediaStreamOutputConfigurations = builder.mediaStreamOutputConfigurations;
            this.minLatency = builder.minLatency;
            this.name = builder.name;
            this.ndiProgramName = builder.ndiProgramName;
            this.ndiSpeedHqQuality = builder.ndiSpeedHqQuality;
            this.outputStatus = builder.outputStatus;
            this.port = builder.port;
            this.remoteId = builder.remoteId;
            this.smoothingLatency = builder.smoothingLatency;
            this.streamId = builder.streamId;
            this.vpcInterfaceAttachment = builder.vpcInterfaceAttachment;
        }

        @Override
        public final java.lang.String getFlowArn() {
            return this.flowArn;
        }

        @Override
        public final java.lang.String getProtocol() {
            return this.protocol;
        }

        @Override
        public final java.util.List<java.lang.String> getCidrAllowList() {
            return this.cidrAllowList;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDestination() {
            return this.destination;
        }

        @Override
        public final java.lang.Object getEncryption() {
            return this.encryption;
        }

        @Override
        public final java.lang.Number getMaxLatency() {
            return this.maxLatency;
        }

        @Override
        public final java.lang.Object getMediaStreamOutputConfigurations() {
            return this.mediaStreamOutputConfigurations;
        }

        @Override
        public final java.lang.Number getMinLatency() {
            return this.minLatency;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getNdiProgramName() {
            return this.ndiProgramName;
        }

        @Override
        public final java.lang.Number getNdiSpeedHqQuality() {
            return this.ndiSpeedHqQuality;
        }

        @Override
        public final java.lang.String getOutputStatus() {
            return this.outputStatus;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getRemoteId() {
            return this.remoteId;
        }

        @Override
        public final java.lang.Number getSmoothingLatency() {
            return this.smoothingLatency;
        }

        @Override
        public final java.lang.String getStreamId() {
            return this.streamId;
        }

        @Override
        public final java.lang.Object getVpcInterfaceAttachment() {
            return this.vpcInterfaceAttachment;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("flowArn", om.valueToTree(this.getFlowArn()));
            data.set("protocol", om.valueToTree(this.getProtocol()));
            if (this.getCidrAllowList() != null) {
                data.set("cidrAllowList", om.valueToTree(this.getCidrAllowList()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDestination() != null) {
                data.set("destination", om.valueToTree(this.getDestination()));
            }
            if (this.getEncryption() != null) {
                data.set("encryption", om.valueToTree(this.getEncryption()));
            }
            if (this.getMaxLatency() != null) {
                data.set("maxLatency", om.valueToTree(this.getMaxLatency()));
            }
            if (this.getMediaStreamOutputConfigurations() != null) {
                data.set("mediaStreamOutputConfigurations", om.valueToTree(this.getMediaStreamOutputConfigurations()));
            }
            if (this.getMinLatency() != null) {
                data.set("minLatency", om.valueToTree(this.getMinLatency()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getNdiProgramName() != null) {
                data.set("ndiProgramName", om.valueToTree(this.getNdiProgramName()));
            }
            if (this.getNdiSpeedHqQuality() != null) {
                data.set("ndiSpeedHqQuality", om.valueToTree(this.getNdiSpeedHqQuality()));
            }
            if (this.getOutputStatus() != null) {
                data.set("outputStatus", om.valueToTree(this.getOutputStatus()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getRemoteId() != null) {
                data.set("remoteId", om.valueToTree(this.getRemoteId()));
            }
            if (this.getSmoothingLatency() != null) {
                data.set("smoothingLatency", om.valueToTree(this.getSmoothingLatency()));
            }
            if (this.getStreamId() != null) {
                data.set("streamId", om.valueToTree(this.getStreamId()));
            }
            if (this.getVpcInterfaceAttachment() != null) {
                data.set("vpcInterfaceAttachment", om.valueToTree(this.getVpcInterfaceAttachment()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlowOutputProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFlowOutputProps.Jsii$Proxy that = (CfnFlowOutputProps.Jsii$Proxy) o;

            if (!flowArn.equals(that.flowArn)) return false;
            if (!protocol.equals(that.protocol)) return false;
            if (this.cidrAllowList != null ? !this.cidrAllowList.equals(that.cidrAllowList) : that.cidrAllowList != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.destination != null ? !this.destination.equals(that.destination) : that.destination != null) return false;
            if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
            if (this.maxLatency != null ? !this.maxLatency.equals(that.maxLatency) : that.maxLatency != null) return false;
            if (this.mediaStreamOutputConfigurations != null ? !this.mediaStreamOutputConfigurations.equals(that.mediaStreamOutputConfigurations) : that.mediaStreamOutputConfigurations != null) return false;
            if (this.minLatency != null ? !this.minLatency.equals(that.minLatency) : that.minLatency != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.ndiProgramName != null ? !this.ndiProgramName.equals(that.ndiProgramName) : that.ndiProgramName != null) return false;
            if (this.ndiSpeedHqQuality != null ? !this.ndiSpeedHqQuality.equals(that.ndiSpeedHqQuality) : that.ndiSpeedHqQuality != null) return false;
            if (this.outputStatus != null ? !this.outputStatus.equals(that.outputStatus) : that.outputStatus != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.remoteId != null ? !this.remoteId.equals(that.remoteId) : that.remoteId != null) return false;
            if (this.smoothingLatency != null ? !this.smoothingLatency.equals(that.smoothingLatency) : that.smoothingLatency != null) return false;
            if (this.streamId != null ? !this.streamId.equals(that.streamId) : that.streamId != null) return false;
            return this.vpcInterfaceAttachment != null ? this.vpcInterfaceAttachment.equals(that.vpcInterfaceAttachment) : that.vpcInterfaceAttachment == null;
        }

        @Override
        public final int hashCode() {
            int result = this.flowArn.hashCode();
            result = 31 * result + (this.protocol.hashCode());
            result = 31 * result + (this.cidrAllowList != null ? this.cidrAllowList.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.destination != null ? this.destination.hashCode() : 0);
            result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
            result = 31 * result + (this.maxLatency != null ? this.maxLatency.hashCode() : 0);
            result = 31 * result + (this.mediaStreamOutputConfigurations != null ? this.mediaStreamOutputConfigurations.hashCode() : 0);
            result = 31 * result + (this.minLatency != null ? this.minLatency.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.ndiProgramName != null ? this.ndiProgramName.hashCode() : 0);
            result = 31 * result + (this.ndiSpeedHqQuality != null ? this.ndiSpeedHqQuality.hashCode() : 0);
            result = 31 * result + (this.outputStatus != null ? this.outputStatus.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.remoteId != null ? this.remoteId.hashCode() : 0);
            result = 31 * result + (this.smoothingLatency != null ? this.smoothingLatency.hashCode() : 0);
            result = 31 * result + (this.streamId != null ? this.streamId.hashCode() : 0);
            result = 31 * result + (this.vpcInterfaceAttachment != null ? this.vpcInterfaceAttachment.hashCode() : 0);
            return result;
        }
    }
}
