package software.amazon.awscdk.services.networkfirewall;

/**
 * Properties for defining a <code>CfnRuleGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkfirewall.*;
 * CfnRuleGroupProps cfnRuleGroupProps = CfnRuleGroupProps.builder()
 *         .capacity(123)
 *         .ruleGroupName("ruleGroupName")
 *         .type("type")
 *         // the properties below are optional
 *         .description("description")
 *         .ruleGroup(RuleGroupProperty.builder()
 *                 .rulesSource(RulesSourceProperty.builder()
 *                         .rulesSourceList(RulesSourceListProperty.builder()
 *                                 .generatedRulesType("generatedRulesType")
 *                                 .targets(List.of("targets"))
 *                                 .targetTypes(List.of("targetTypes"))
 *                                 .build())
 *                         .rulesString("rulesString")
 *                         .statefulRules(List.of(StatefulRuleProperty.builder()
 *                                 .action("action")
 *                                 .header(HeaderProperty.builder()
 *                                         .destination("destination")
 *                                         .destinationPort("destinationPort")
 *                                         .direction("direction")
 *                                         .protocol("protocol")
 *                                         .source("source")
 *                                         .sourcePort("sourcePort")
 *                                         .build())
 *                                 .ruleOptions(List.of(RuleOptionProperty.builder()
 *                                         .keyword("keyword")
 *                                         // the properties below are optional
 *                                         .settings(List.of("settings"))
 *                                         .build()))
 *                                 .build()))
 *                         .statelessRulesAndCustomActions(StatelessRulesAndCustomActionsProperty.builder()
 *                                 .statelessRules(List.of(StatelessRuleProperty.builder()
 *                                         .priority(123)
 *                                         .ruleDefinition(RuleDefinitionProperty.builder()
 *                                                 .actions(List.of("actions"))
 *                                                 .matchAttributes(MatchAttributesProperty.builder()
 *                                                         .destinationPorts(List.of(PortRangeProperty.builder()
 *                                                                 .fromPort(123)
 *                                                                 .toPort(123)
 *                                                                 .build()))
 *                                                         .destinations(List.of(AddressProperty.builder()
 *                                                                 .addressDefinition("addressDefinition")
 *                                                                 .build()))
 *                                                         .protocols(List.of(123))
 *                                                         .sourcePorts(List.of(PortRangeProperty.builder()
 *                                                                 .fromPort(123)
 *                                                                 .toPort(123)
 *                                                                 .build()))
 *                                                         .sources(List.of(AddressProperty.builder()
 *                                                                 .addressDefinition("addressDefinition")
 *                                                                 .build()))
 *                                                         .tcpFlags(List.of(TCPFlagFieldProperty.builder()
 *                                                                 .flags(List.of("flags"))
 *                                                                 // the properties below are optional
 *                                                                 .masks(List.of("masks"))
 *                                                                 .build()))
 *                                                         .build())
 *                                                 .build())
 *                                         .build()))
 *                                 // the properties below are optional
 *                                 .customActions(List.of(CustomActionProperty.builder()
 *                                         .actionDefinition(ActionDefinitionProperty.builder()
 *                                                 .publishMetricAction(PublishMetricActionProperty.builder()
 *                                                         .dimensions(List.of(DimensionProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .build())
 *                                                 .build())
 *                                         .actionName("actionName")
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .referenceSets(ReferenceSetsProperty.builder()
 *                         .ipSetReferences(Map.of(
 *                                 "ipSetReferencesKey", Map.of(
 *                                         "referenceArn", "referenceArn")))
 *                         .build())
 *                 .ruleVariables(RuleVariablesProperty.builder()
 *                         .ipSets(Map.of(
 *                                 "ipSetsKey", Map.of(
 *                                         "definition", List.of("definition"))))
 *                         .portSets(Map.of(
 *                                 "portSetsKey", PortSetProperty.builder()
 *                                         .definition(List.of("definition"))
 *                                         .build()))
 *                         .build())
 *                 .statefulRuleOptions(StatefulRuleOptionsProperty.builder()
 *                         .ruleOrder("ruleOrder")
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:55.265Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnRuleGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnRuleGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRuleGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum operating resources that this rule group can use.
     * <p>
     * You can't change a rule group's capacity setting after you create the rule group. When you update a rule group, you are limited to this capacity. When you reference a rule group from a firewall policy, Network Firewall reserves this capacity for the rule group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-capacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-capacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getCapacity();

    /**
     * The descriptive name of the rule group.
     * <p>
     * You can't change the name of a rule group after you create it.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRuleGroupName();

    /**
     * Indicates whether the rule group is stateless or stateful.
     * <p>
     * If the rule group is stateless, it contains
     * stateless rules. If it is stateful, it contains stateful rules.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * A description of the rule group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * An object that defines the rule group rules.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-rulegroup</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRuleGroup() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkfirewall-rulegroup.html#cfn-networkfirewall-rulegroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRuleGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRuleGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRuleGroupProps> {
        java.lang.Number capacity;
        java.lang.String ruleGroupName;
        java.lang.String type;
        java.lang.String description;
        java.lang.Object ruleGroup;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnRuleGroupProps#getCapacity}
         * @param capacity The maximum operating resources that this rule group can use. This parameter is required.
         *                 You can't change a rule group's capacity setting after you create the rule group. When you update a rule group, you are limited to this capacity. When you reference a rule group from a firewall policy, Network Firewall reserves this capacity for the rule group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacity(java.lang.Number capacity) {
            this.capacity = capacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleGroupProps#getRuleGroupName}
         * @param ruleGroupName The descriptive name of the rule group. This parameter is required.
         *                      You can't change the name of a rule group after you create it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleGroupName(java.lang.String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleGroupProps#getType}
         * @param type Indicates whether the rule group is stateless or stateful. This parameter is required.
         *             If the rule group is stateless, it contains
         *             stateless rules. If it is stateful, it contains stateful rules.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleGroupProps#getDescription}
         * @param description A description of the rule group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleGroupProps#getRuleGroup}
         * @param ruleGroup An object that defines the rule group rules.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleGroup(software.amazon.awscdk.IResolvable ruleGroup) {
            this.ruleGroup = ruleGroup;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleGroupProps#getRuleGroup}
         * @param ruleGroup An object that defines the rule group rules.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleGroup(software.amazon.awscdk.services.networkfirewall.CfnRuleGroup.RuleGroupProperty ruleGroup) {
            this.ruleGroup = ruleGroup;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleGroupProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRuleGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRuleGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRuleGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRuleGroupProps {
        private final java.lang.Number capacity;
        private final java.lang.String ruleGroupName;
        private final java.lang.String type;
        private final java.lang.String description;
        private final java.lang.Object ruleGroup;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.capacity = software.amazon.jsii.Kernel.get(this, "capacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.ruleGroupName = software.amazon.jsii.Kernel.get(this, "ruleGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ruleGroup = software.amazon.jsii.Kernel.get(this, "ruleGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.capacity = java.util.Objects.requireNonNull(builder.capacity, "capacity is required");
            this.ruleGroupName = java.util.Objects.requireNonNull(builder.ruleGroupName, "ruleGroupName is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.description = builder.description;
            this.ruleGroup = builder.ruleGroup;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Number getCapacity() {
            return this.capacity;
        }

        @Override
        public final java.lang.String getRuleGroupName() {
            return this.ruleGroupName;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getRuleGroup() {
            return this.ruleGroup;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("capacity", om.valueToTree(this.getCapacity()));
            data.set("ruleGroupName", om.valueToTree(this.getRuleGroupName()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getRuleGroup() != null) {
                data.set("ruleGroup", om.valueToTree(this.getRuleGroup()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnRuleGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRuleGroupProps.Jsii$Proxy that = (CfnRuleGroupProps.Jsii$Proxy) o;

            if (!capacity.equals(that.capacity)) return false;
            if (!ruleGroupName.equals(that.ruleGroupName)) return false;
            if (!type.equals(that.type)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.ruleGroup != null ? !this.ruleGroup.equals(that.ruleGroup) : that.ruleGroup != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.capacity.hashCode();
            result = 31 * result + (this.ruleGroupName.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.ruleGroup != null ? this.ruleGroup.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
