package software.amazon.awscdk.services.nimblestudio;

/**
 * The <code>AWS::NimbleStudio::LaunchProfile</code> resource represents access permissions for a set of studio components, including types of workstations, render farms, and shared file systems.
 * <p>
 * Launch profiles are shared with studio users to give them access to the set of studio components.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.nimblestudio.*;
 * CfnLaunchProfile cfnLaunchProfile = CfnLaunchProfile.Builder.create(this, "MyCfnLaunchProfile")
 *         .ec2SubnetIds(List.of("ec2SubnetIds"))
 *         .launchProfileProtocolVersions(List.of("launchProfileProtocolVersions"))
 *         .name("name")
 *         .streamConfiguration(StreamConfigurationProperty.builder()
 *                 .clipboardMode("clipboardMode")
 *                 .ec2InstanceTypes(List.of("ec2InstanceTypes"))
 *                 .streamingImageIds(List.of("streamingImageIds"))
 *                 // the properties below are optional
 *                 .automaticTerminationMode("automaticTerminationMode")
 *                 .maxSessionLengthInMinutes(123)
 *                 .maxStoppedSessionLengthInMinutes(123)
 *                 .sessionBackup(StreamConfigurationSessionBackupProperty.builder()
 *                         .maxBackupsToRetain(123)
 *                         .mode("mode")
 *                         .build())
 *                 .sessionPersistenceMode("sessionPersistenceMode")
 *                 .sessionStorage(StreamConfigurationSessionStorageProperty.builder()
 *                         .mode(List.of("mode"))
 *                         // the properties below are optional
 *                         .root(StreamingSessionStorageRootProperty.builder()
 *                                 .linux("linux")
 *                                 .windows("windows")
 *                                 .build())
 *                         .build())
 *                 .volumeConfiguration(VolumeConfigurationProperty.builder()
 *                         .iops(123)
 *                         .size(123)
 *                         .throughput(123)
 *                         .build())
 *                 .build())
 *         .studioComponentIds(List.of("studioComponentIds"))
 *         .studioId("studioId")
 *         // the properties below are optional
 *         .description("description")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:55.329Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_nimblestudio.CfnLaunchProfile")
public class CfnLaunchProfile extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnLaunchProfile(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLaunchProfile(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLaunchProfile(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.nimblestudio.CfnLaunchProfileProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The unique identifier for the launch profile resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLaunchProfileId() {
        return software.amazon.jsii.Kernel.get(this, "attrLaunchProfileId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Unique identifiers for a collection of EC2 subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getEc2SubnetIds() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "ec2SubnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Unique identifiers for a collection of EC2 subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEc2SubnetIds(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "ec2SubnetIds", java.util.Objects.requireNonNull(value, "ec2SubnetIds is required"));
    }

    /**
     * The version number of the protocol that is used by the launch profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getLaunchProfileProtocolVersions() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "launchProfileProtocolVersions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The version number of the protocol that is used by the launch profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLaunchProfileProtocolVersions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "launchProfileProtocolVersions", java.util.Objects.requireNonNull(value, "launchProfileProtocolVersions is required"));
    }

    /**
     * A friendly name for the launch profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A friendly name for the launch profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * A configuration for a streaming session.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getStreamConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "streamConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A configuration for a streaming session.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStreamConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "streamConfiguration", java.util.Objects.requireNonNull(value, "streamConfiguration is required"));
    }

    /**
     * A configuration for a streaming session.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStreamConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile.StreamConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "streamConfiguration", java.util.Objects.requireNonNull(value, "streamConfiguration is required"));
    }

    /**
     * Unique identifiers for a collection of studio components that can be used with this launch profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getStudioComponentIds() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "studioComponentIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Unique identifiers for a collection of studio components that can be used with this launch profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStudioComponentIds(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "studioComponentIds", java.util.Objects.requireNonNull(value, "studioComponentIds is required"));
    }

    /**
     * The unique identifier for a studio resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStudioId() {
        return software.amazon.jsii.Kernel.get(this, "studioId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for a studio resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStudioId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "studioId", java.util.Objects.requireNonNull(value, "studioId is required"));
    }

    /**
     * A human-readable description of the launch profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A human-readable description of the launch profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * A configuration for a streaming session.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.nimblestudio.*;
     * StreamConfigurationProperty streamConfigurationProperty = StreamConfigurationProperty.builder()
     *         .clipboardMode("clipboardMode")
     *         .ec2InstanceTypes(List.of("ec2InstanceTypes"))
     *         .streamingImageIds(List.of("streamingImageIds"))
     *         // the properties below are optional
     *         .automaticTerminationMode("automaticTerminationMode")
     *         .maxSessionLengthInMinutes(123)
     *         .maxStoppedSessionLengthInMinutes(123)
     *         .sessionBackup(StreamConfigurationSessionBackupProperty.builder()
     *                 .maxBackupsToRetain(123)
     *                 .mode("mode")
     *                 .build())
     *         .sessionPersistenceMode("sessionPersistenceMode")
     *         .sessionStorage(StreamConfigurationSessionStorageProperty.builder()
     *                 .mode(List.of("mode"))
     *                 // the properties below are optional
     *                 .root(StreamingSessionStorageRootProperty.builder()
     *                         .linux("linux")
     *                         .windows("windows")
     *                         .build())
     *                 .build())
     *         .volumeConfiguration(VolumeConfigurationProperty.builder()
     *                 .iops(123)
     *                 .size(123)
     *                 .throughput(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_nimblestudio.CfnLaunchProfile.StreamConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(StreamConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StreamConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Allows or deactivates the use of the system clipboard to copy and paste between the streaming session and streaming client.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-clipboardmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-clipboardmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClipboardMode();

        /**
         * The EC2 instance types that users can select from when launching a streaming session with this launch profile.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-ec2instancetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-ec2instancetypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getEc2InstanceTypes();

        /**
         * The streaming images that users can select from when launching a streaming session with this launch profile.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-streamingimageids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-streamingimageids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getStreamingImageIds();

        /**
         * Indicates if a streaming session created from this launch profile should be terminated automatically or retained without termination after being in a <code>STOPPED</code> state.
         * <p>
         * <ul>
         * <li>When <code>ACTIVATED</code> , the streaming session is scheduled for termination after being in the <code>STOPPED</code> state for the time specified in <code>maxStoppedSessionLengthInMinutes</code> .</li>
         * <li>When <code>DEACTIVATED</code> , the streaming session can remain in the <code>STOPPED</code> state indefinitely.</li>
         * </ul>
         * <p>
         * This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code> . When allowed, the default value for this parameter is <code>DEACTIVATED</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-automaticterminationmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-automaticterminationmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAutomaticTerminationMode() {
            return null;
        }

        /**
         * The length of time, in minutes, that a streaming session can be active before it is stopped or terminated.
         * <p>
         * After this point, Nimble Studio automatically terminates or stops the session. The default length of time is 690 minutes, and the maximum length of time is 30 days.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-maxsessionlengthinminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-maxsessionlengthinminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxSessionLengthInMinutes() {
            return null;
        }

        /**
         * Integer that determines if you can start and stop your sessions and how long a session can stay in the <code>STOPPED</code> state.
         * <p>
         * The default value is 0. The maximum value is 5760.
         * <p>
         * This field is allowed only when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code> and <code>automaticTerminationMode</code> is <code>ACTIVATED</code> .
         * <p>
         * If the value is set to 0, your sessions can’t be <code>STOPPED</code> . If you then call <code>StopStreamingSession</code> , the session fails. If the time that a session stays in the <code>READY</code> state exceeds the <code>maxSessionLengthInMinutes</code> value, the session will automatically be terminated (instead of <code>STOPPED</code> ).
         * <p>
         * If the value is set to a positive number, the session can be stopped. You can call <code>StopStreamingSession</code> to stop sessions in the <code>READY</code> state. If the time that a session stays in the <code>READY</code> state exceeds the <code>maxSessionLengthInMinutes</code> value, the session will automatically be stopped (instead of terminated).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-maxstoppedsessionlengthinminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-maxstoppedsessionlengthinminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxStoppedSessionLengthInMinutes() {
            return null;
        }

        /**
         * Information about the streaming session backup.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-sessionbackup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-sessionbackup</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSessionBackup() {
            return null;
        }

        /**
         * Determine if a streaming session created from this launch profile can configure persistent storage.
         * <p>
         * This means that <code>volumeConfiguration</code> and <code>automaticTerminationMode</code> are configured.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-sessionpersistencemode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-sessionpersistencemode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSessionPersistenceMode() {
            return null;
        }

        /**
         * The upload storage for a streaming session.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-sessionstorage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-sessionstorage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSessionStorage() {
            return null;
        }

        /**
         * Custom volume configuration for the root volumes that are attached to streaming sessions.
         * <p>
         * This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-volumeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfiguration.html#cfn-nimblestudio-launchprofile-streamconfiguration-volumeconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVolumeConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StreamConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StreamConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StreamConfigurationProperty> {
            java.lang.String clipboardMode;
            java.util.List<java.lang.String> ec2InstanceTypes;
            java.util.List<java.lang.String> streamingImageIds;
            java.lang.String automaticTerminationMode;
            java.lang.Number maxSessionLengthInMinutes;
            java.lang.Number maxStoppedSessionLengthInMinutes;
            java.lang.Object sessionBackup;
            java.lang.String sessionPersistenceMode;
            java.lang.Object sessionStorage;
            java.lang.Object volumeConfiguration;

            /**
             * Sets the value of {@link StreamConfigurationProperty#getClipboardMode}
             * @param clipboardMode Allows or deactivates the use of the system clipboard to copy and paste between the streaming session and streaming client. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clipboardMode(java.lang.String clipboardMode) {
                this.clipboardMode = clipboardMode;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationProperty#getEc2InstanceTypes}
             * @param ec2InstanceTypes The EC2 instance types that users can select from when launching a streaming session with this launch profile. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2InstanceTypes(java.util.List<java.lang.String> ec2InstanceTypes) {
                this.ec2InstanceTypes = ec2InstanceTypes;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationProperty#getStreamingImageIds}
             * @param streamingImageIds The streaming images that users can select from when launching a streaming session with this launch profile. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamingImageIds(java.util.List<java.lang.String> streamingImageIds) {
                this.streamingImageIds = streamingImageIds;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationProperty#getAutomaticTerminationMode}
             * @param automaticTerminationMode Indicates if a streaming session created from this launch profile should be terminated automatically or retained without termination after being in a <code>STOPPED</code> state.
             *                                 <ul>
             *                                 <li>When <code>ACTIVATED</code> , the streaming session is scheduled for termination after being in the <code>STOPPED</code> state for the time specified in <code>maxStoppedSessionLengthInMinutes</code> .</li>
             *                                 <li>When <code>DEACTIVATED</code> , the streaming session can remain in the <code>STOPPED</code> state indefinitely.</li>
             *                                 </ul>
             *                                 <p>
             *                                 This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code> . When allowed, the default value for this parameter is <code>DEACTIVATED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automaticTerminationMode(java.lang.String automaticTerminationMode) {
                this.automaticTerminationMode = automaticTerminationMode;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationProperty#getMaxSessionLengthInMinutes}
             * @param maxSessionLengthInMinutes The length of time, in minutes, that a streaming session can be active before it is stopped or terminated.
             *                                  After this point, Nimble Studio automatically terminates or stops the session. The default length of time is 690 minutes, and the maximum length of time is 30 days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxSessionLengthInMinutes(java.lang.Number maxSessionLengthInMinutes) {
                this.maxSessionLengthInMinutes = maxSessionLengthInMinutes;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationProperty#getMaxStoppedSessionLengthInMinutes}
             * @param maxStoppedSessionLengthInMinutes Integer that determines if you can start and stop your sessions and how long a session can stay in the <code>STOPPED</code> state.
             *                                         The default value is 0. The maximum value is 5760.
             *                                         <p>
             *                                         This field is allowed only when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code> and <code>automaticTerminationMode</code> is <code>ACTIVATED</code> .
             *                                         <p>
             *                                         If the value is set to 0, your sessions can’t be <code>STOPPED</code> . If you then call <code>StopStreamingSession</code> , the session fails. If the time that a session stays in the <code>READY</code> state exceeds the <code>maxSessionLengthInMinutes</code> value, the session will automatically be terminated (instead of <code>STOPPED</code> ).
             *                                         <p>
             *                                         If the value is set to a positive number, the session can be stopped. You can call <code>StopStreamingSession</code> to stop sessions in the <code>READY</code> state. If the time that a session stays in the <code>READY</code> state exceeds the <code>maxSessionLengthInMinutes</code> value, the session will automatically be stopped (instead of terminated).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxStoppedSessionLengthInMinutes(java.lang.Number maxStoppedSessionLengthInMinutes) {
                this.maxStoppedSessionLengthInMinutes = maxStoppedSessionLengthInMinutes;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationProperty#getSessionBackup}
             * @param sessionBackup Information about the streaming session backup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionBackup(software.amazon.awscdk.IResolvable sessionBackup) {
                this.sessionBackup = sessionBackup;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationProperty#getSessionBackup}
             * @param sessionBackup Information about the streaming session backup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionBackup(software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile.StreamConfigurationSessionBackupProperty sessionBackup) {
                this.sessionBackup = sessionBackup;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationProperty#getSessionPersistenceMode}
             * @param sessionPersistenceMode Determine if a streaming session created from this launch profile can configure persistent storage.
             *                               This means that <code>volumeConfiguration</code> and <code>automaticTerminationMode</code> are configured.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionPersistenceMode(java.lang.String sessionPersistenceMode) {
                this.sessionPersistenceMode = sessionPersistenceMode;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationProperty#getSessionStorage}
             * @param sessionStorage The upload storage for a streaming session.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionStorage(software.amazon.awscdk.IResolvable sessionStorage) {
                this.sessionStorage = sessionStorage;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationProperty#getSessionStorage}
             * @param sessionStorage The upload storage for a streaming session.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionStorage(software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile.StreamConfigurationSessionStorageProperty sessionStorage) {
                this.sessionStorage = sessionStorage;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationProperty#getVolumeConfiguration}
             * @param volumeConfiguration Custom volume configuration for the root volumes that are attached to streaming sessions.
             *                            This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeConfiguration(software.amazon.awscdk.IResolvable volumeConfiguration) {
                this.volumeConfiguration = volumeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationProperty#getVolumeConfiguration}
             * @param volumeConfiguration Custom volume configuration for the root volumes that are attached to streaming sessions.
             *                            This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeConfiguration(software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile.VolumeConfigurationProperty volumeConfiguration) {
                this.volumeConfiguration = volumeConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StreamConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StreamConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamConfigurationProperty {
            private final java.lang.String clipboardMode;
            private final java.util.List<java.lang.String> ec2InstanceTypes;
            private final java.util.List<java.lang.String> streamingImageIds;
            private final java.lang.String automaticTerminationMode;
            private final java.lang.Number maxSessionLengthInMinutes;
            private final java.lang.Number maxStoppedSessionLengthInMinutes;
            private final java.lang.Object sessionBackup;
            private final java.lang.String sessionPersistenceMode;
            private final java.lang.Object sessionStorage;
            private final java.lang.Object volumeConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clipboardMode = software.amazon.jsii.Kernel.get(this, "clipboardMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ec2InstanceTypes = software.amazon.jsii.Kernel.get(this, "ec2InstanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.streamingImageIds = software.amazon.jsii.Kernel.get(this, "streamingImageIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.automaticTerminationMode = software.amazon.jsii.Kernel.get(this, "automaticTerminationMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxSessionLengthInMinutes = software.amazon.jsii.Kernel.get(this, "maxSessionLengthInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxStoppedSessionLengthInMinutes = software.amazon.jsii.Kernel.get(this, "maxStoppedSessionLengthInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sessionBackup = software.amazon.jsii.Kernel.get(this, "sessionBackup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sessionPersistenceMode = software.amazon.jsii.Kernel.get(this, "sessionPersistenceMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sessionStorage = software.amazon.jsii.Kernel.get(this, "sessionStorage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.volumeConfiguration = software.amazon.jsii.Kernel.get(this, "volumeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clipboardMode = java.util.Objects.requireNonNull(builder.clipboardMode, "clipboardMode is required");
                this.ec2InstanceTypes = java.util.Objects.requireNonNull(builder.ec2InstanceTypes, "ec2InstanceTypes is required");
                this.streamingImageIds = java.util.Objects.requireNonNull(builder.streamingImageIds, "streamingImageIds is required");
                this.automaticTerminationMode = builder.automaticTerminationMode;
                this.maxSessionLengthInMinutes = builder.maxSessionLengthInMinutes;
                this.maxStoppedSessionLengthInMinutes = builder.maxStoppedSessionLengthInMinutes;
                this.sessionBackup = builder.sessionBackup;
                this.sessionPersistenceMode = builder.sessionPersistenceMode;
                this.sessionStorage = builder.sessionStorage;
                this.volumeConfiguration = builder.volumeConfiguration;
            }

            @Override
            public final java.lang.String getClipboardMode() {
                return this.clipboardMode;
            }

            @Override
            public final java.util.List<java.lang.String> getEc2InstanceTypes() {
                return this.ec2InstanceTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getStreamingImageIds() {
                return this.streamingImageIds;
            }

            @Override
            public final java.lang.String getAutomaticTerminationMode() {
                return this.automaticTerminationMode;
            }

            @Override
            public final java.lang.Number getMaxSessionLengthInMinutes() {
                return this.maxSessionLengthInMinutes;
            }

            @Override
            public final java.lang.Number getMaxStoppedSessionLengthInMinutes() {
                return this.maxStoppedSessionLengthInMinutes;
            }

            @Override
            public final java.lang.Object getSessionBackup() {
                return this.sessionBackup;
            }

            @Override
            public final java.lang.String getSessionPersistenceMode() {
                return this.sessionPersistenceMode;
            }

            @Override
            public final java.lang.Object getSessionStorage() {
                return this.sessionStorage;
            }

            @Override
            public final java.lang.Object getVolumeConfiguration() {
                return this.volumeConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clipboardMode", om.valueToTree(this.getClipboardMode()));
                data.set("ec2InstanceTypes", om.valueToTree(this.getEc2InstanceTypes()));
                data.set("streamingImageIds", om.valueToTree(this.getStreamingImageIds()));
                if (this.getAutomaticTerminationMode() != null) {
                    data.set("automaticTerminationMode", om.valueToTree(this.getAutomaticTerminationMode()));
                }
                if (this.getMaxSessionLengthInMinutes() != null) {
                    data.set("maxSessionLengthInMinutes", om.valueToTree(this.getMaxSessionLengthInMinutes()));
                }
                if (this.getMaxStoppedSessionLengthInMinutes() != null) {
                    data.set("maxStoppedSessionLengthInMinutes", om.valueToTree(this.getMaxStoppedSessionLengthInMinutes()));
                }
                if (this.getSessionBackup() != null) {
                    data.set("sessionBackup", om.valueToTree(this.getSessionBackup()));
                }
                if (this.getSessionPersistenceMode() != null) {
                    data.set("sessionPersistenceMode", om.valueToTree(this.getSessionPersistenceMode()));
                }
                if (this.getSessionStorage() != null) {
                    data.set("sessionStorage", om.valueToTree(this.getSessionStorage()));
                }
                if (this.getVolumeConfiguration() != null) {
                    data.set("volumeConfiguration", om.valueToTree(this.getVolumeConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_nimblestudio.CfnLaunchProfile.StreamConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StreamConfigurationProperty.Jsii$Proxy that = (StreamConfigurationProperty.Jsii$Proxy) o;

                if (!clipboardMode.equals(that.clipboardMode)) return false;
                if (!ec2InstanceTypes.equals(that.ec2InstanceTypes)) return false;
                if (!streamingImageIds.equals(that.streamingImageIds)) return false;
                if (this.automaticTerminationMode != null ? !this.automaticTerminationMode.equals(that.automaticTerminationMode) : that.automaticTerminationMode != null) return false;
                if (this.maxSessionLengthInMinutes != null ? !this.maxSessionLengthInMinutes.equals(that.maxSessionLengthInMinutes) : that.maxSessionLengthInMinutes != null) return false;
                if (this.maxStoppedSessionLengthInMinutes != null ? !this.maxStoppedSessionLengthInMinutes.equals(that.maxStoppedSessionLengthInMinutes) : that.maxStoppedSessionLengthInMinutes != null) return false;
                if (this.sessionBackup != null ? !this.sessionBackup.equals(that.sessionBackup) : that.sessionBackup != null) return false;
                if (this.sessionPersistenceMode != null ? !this.sessionPersistenceMode.equals(that.sessionPersistenceMode) : that.sessionPersistenceMode != null) return false;
                if (this.sessionStorage != null ? !this.sessionStorage.equals(that.sessionStorage) : that.sessionStorage != null) return false;
                return this.volumeConfiguration != null ? this.volumeConfiguration.equals(that.volumeConfiguration) : that.volumeConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clipboardMode.hashCode();
                result = 31 * result + (this.ec2InstanceTypes.hashCode());
                result = 31 * result + (this.streamingImageIds.hashCode());
                result = 31 * result + (this.automaticTerminationMode != null ? this.automaticTerminationMode.hashCode() : 0);
                result = 31 * result + (this.maxSessionLengthInMinutes != null ? this.maxSessionLengthInMinutes.hashCode() : 0);
                result = 31 * result + (this.maxStoppedSessionLengthInMinutes != null ? this.maxStoppedSessionLengthInMinutes.hashCode() : 0);
                result = 31 * result + (this.sessionBackup != null ? this.sessionBackup.hashCode() : 0);
                result = 31 * result + (this.sessionPersistenceMode != null ? this.sessionPersistenceMode.hashCode() : 0);
                result = 31 * result + (this.sessionStorage != null ? this.sessionStorage.hashCode() : 0);
                result = 31 * result + (this.volumeConfiguration != null ? this.volumeConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configures how streaming sessions are backed up when launched from this launch profile.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.nimblestudio.*;
     * StreamConfigurationSessionBackupProperty streamConfigurationSessionBackupProperty = StreamConfigurationSessionBackupProperty.builder()
     *         .maxBackupsToRetain(123)
     *         .mode("mode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfigurationsessionbackup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfigurationsessionbackup.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_nimblestudio.CfnLaunchProfile.StreamConfigurationSessionBackupProperty")
    @software.amazon.jsii.Jsii.Proxy(StreamConfigurationSessionBackupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StreamConfigurationSessionBackupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of backups that each streaming session created from this launch profile can have.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfigurationsessionbackup.html#cfn-nimblestudio-launchprofile-streamconfigurationsessionbackup-maxbackupstoretain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfigurationsessionbackup.html#cfn-nimblestudio-launchprofile-streamconfigurationsessionbackup-maxbackupstoretain</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxBackupsToRetain() {
            return null;
        }

        /**
         * Specifies how artists sessions are backed up.
         * <p>
         * Configures backups for streaming sessions launched with this launch profile. The default value is <code>DEACTIVATED</code> , which means that backups are deactivated. To allow backups, set this value to <code>AUTOMATIC</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfigurationsessionbackup.html#cfn-nimblestudio-launchprofile-streamconfigurationsessionbackup-mode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfigurationsessionbackup.html#cfn-nimblestudio-launchprofile-streamconfigurationsessionbackup-mode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StreamConfigurationSessionBackupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StreamConfigurationSessionBackupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StreamConfigurationSessionBackupProperty> {
            java.lang.Number maxBackupsToRetain;
            java.lang.String mode;

            /**
             * Sets the value of {@link StreamConfigurationSessionBackupProperty#getMaxBackupsToRetain}
             * @param maxBackupsToRetain The maximum number of backups that each streaming session created from this launch profile can have.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxBackupsToRetain(java.lang.Number maxBackupsToRetain) {
                this.maxBackupsToRetain = maxBackupsToRetain;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationSessionBackupProperty#getMode}
             * @param mode Specifies how artists sessions are backed up.
             *             Configures backups for streaming sessions launched with this launch profile. The default value is <code>DEACTIVATED</code> , which means that backups are deactivated. To allow backups, set this value to <code>AUTOMATIC</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamConfigurationSessionBackupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StreamConfigurationSessionBackupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StreamConfigurationSessionBackupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamConfigurationSessionBackupProperty {
            private final java.lang.Number maxBackupsToRetain;
            private final java.lang.String mode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxBackupsToRetain = software.amazon.jsii.Kernel.get(this, "maxBackupsToRetain", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxBackupsToRetain = builder.maxBackupsToRetain;
                this.mode = builder.mode;
            }

            @Override
            public final java.lang.Number getMaxBackupsToRetain() {
                return this.maxBackupsToRetain;
            }

            @Override
            public final java.lang.String getMode() {
                return this.mode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxBackupsToRetain() != null) {
                    data.set("maxBackupsToRetain", om.valueToTree(this.getMaxBackupsToRetain()));
                }
                if (this.getMode() != null) {
                    data.set("mode", om.valueToTree(this.getMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_nimblestudio.CfnLaunchProfile.StreamConfigurationSessionBackupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StreamConfigurationSessionBackupProperty.Jsii$Proxy that = (StreamConfigurationSessionBackupProperty.Jsii$Proxy) o;

                if (this.maxBackupsToRetain != null ? !this.maxBackupsToRetain.equals(that.maxBackupsToRetain) : that.maxBackupsToRetain != null) return false;
                return this.mode != null ? this.mode.equals(that.mode) : that.mode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxBackupsToRetain != null ? this.maxBackupsToRetain.hashCode() : 0;
                result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for a streaming session’s upload storage.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.nimblestudio.*;
     * StreamConfigurationSessionStorageProperty streamConfigurationSessionStorageProperty = StreamConfigurationSessionStorageProperty.builder()
     *         .mode(List.of("mode"))
     *         // the properties below are optional
     *         .root(StreamingSessionStorageRootProperty.builder()
     *                 .linux("linux")
     *                 .windows("windows")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfigurationsessionstorage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfigurationsessionstorage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_nimblestudio.CfnLaunchProfile.StreamConfigurationSessionStorageProperty")
    @software.amazon.jsii.Jsii.Proxy(StreamConfigurationSessionStorageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StreamConfigurationSessionStorageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Allows artists to upload files to their workstations.
         * <p>
         * The only valid option is <code>UPLOAD</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfigurationsessionstorage.html#cfn-nimblestudio-launchprofile-streamconfigurationsessionstorage-mode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfigurationsessionstorage.html#cfn-nimblestudio-launchprofile-streamconfigurationsessionstorage-mode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getMode();

        /**
         * The configuration for the upload storage root of the streaming session.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfigurationsessionstorage.html#cfn-nimblestudio-launchprofile-streamconfigurationsessionstorage-root">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamconfigurationsessionstorage.html#cfn-nimblestudio-launchprofile-streamconfigurationsessionstorage-root</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRoot() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StreamConfigurationSessionStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StreamConfigurationSessionStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StreamConfigurationSessionStorageProperty> {
            java.util.List<java.lang.String> mode;
            java.lang.Object root;

            /**
             * Sets the value of {@link StreamConfigurationSessionStorageProperty#getMode}
             * @param mode Allows artists to upload files to their workstations. This parameter is required.
             *             The only valid option is <code>UPLOAD</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.util.List<java.lang.String> mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationSessionStorageProperty#getRoot}
             * @param root The configuration for the upload storage root of the streaming session.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder root(software.amazon.awscdk.IResolvable root) {
                this.root = root;
                return this;
            }

            /**
             * Sets the value of {@link StreamConfigurationSessionStorageProperty#getRoot}
             * @param root The configuration for the upload storage root of the streaming session.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder root(software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile.StreamingSessionStorageRootProperty root) {
                this.root = root;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamConfigurationSessionStorageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StreamConfigurationSessionStorageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StreamConfigurationSessionStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamConfigurationSessionStorageProperty {
            private final java.util.List<java.lang.String> mode;
            private final java.lang.Object root;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.root = software.amazon.jsii.Kernel.get(this, "root", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mode = java.util.Objects.requireNonNull(builder.mode, "mode is required");
                this.root = builder.root;
            }

            @Override
            public final java.util.List<java.lang.String> getMode() {
                return this.mode;
            }

            @Override
            public final java.lang.Object getRoot() {
                return this.root;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mode", om.valueToTree(this.getMode()));
                if (this.getRoot() != null) {
                    data.set("root", om.valueToTree(this.getRoot()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_nimblestudio.CfnLaunchProfile.StreamConfigurationSessionStorageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StreamConfigurationSessionStorageProperty.Jsii$Proxy that = (StreamConfigurationSessionStorageProperty.Jsii$Proxy) o;

                if (!mode.equals(that.mode)) return false;
                return this.root != null ? this.root.equals(that.root) : that.root == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mode.hashCode();
                result = 31 * result + (this.root != null ? this.root.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The upload storage root location (folder) on streaming workstations where files are uploaded.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.nimblestudio.*;
     * StreamingSessionStorageRootProperty streamingSessionStorageRootProperty = StreamingSessionStorageRootProperty.builder()
     *         .linux("linux")
     *         .windows("windows")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamingsessionstorageroot.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamingsessionstorageroot.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_nimblestudio.CfnLaunchProfile.StreamingSessionStorageRootProperty")
    @software.amazon.jsii.Jsii.Proxy(StreamingSessionStorageRootProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StreamingSessionStorageRootProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The folder path in Linux workstations where files are uploaded.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamingsessionstorageroot.html#cfn-nimblestudio-launchprofile-streamingsessionstorageroot-linux">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamingsessionstorageroot.html#cfn-nimblestudio-launchprofile-streamingsessionstorageroot-linux</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLinux() {
            return null;
        }

        /**
         * The folder path in Windows workstations where files are uploaded.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamingsessionstorageroot.html#cfn-nimblestudio-launchprofile-streamingsessionstorageroot-windows">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-streamingsessionstorageroot.html#cfn-nimblestudio-launchprofile-streamingsessionstorageroot-windows</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWindows() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StreamingSessionStorageRootProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StreamingSessionStorageRootProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StreamingSessionStorageRootProperty> {
            java.lang.String linux;
            java.lang.String windows;

            /**
             * Sets the value of {@link StreamingSessionStorageRootProperty#getLinux}
             * @param linux The folder path in Linux workstations where files are uploaded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder linux(java.lang.String linux) {
                this.linux = linux;
                return this;
            }

            /**
             * Sets the value of {@link StreamingSessionStorageRootProperty#getWindows}
             * @param windows The folder path in Windows workstations where files are uploaded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder windows(java.lang.String windows) {
                this.windows = windows;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamingSessionStorageRootProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StreamingSessionStorageRootProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StreamingSessionStorageRootProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamingSessionStorageRootProperty {
            private final java.lang.String linux;
            private final java.lang.String windows;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.linux = software.amazon.jsii.Kernel.get(this, "linux", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.windows = software.amazon.jsii.Kernel.get(this, "windows", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.linux = builder.linux;
                this.windows = builder.windows;
            }

            @Override
            public final java.lang.String getLinux() {
                return this.linux;
            }

            @Override
            public final java.lang.String getWindows() {
                return this.windows;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLinux() != null) {
                    data.set("linux", om.valueToTree(this.getLinux()));
                }
                if (this.getWindows() != null) {
                    data.set("windows", om.valueToTree(this.getWindows()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_nimblestudio.CfnLaunchProfile.StreamingSessionStorageRootProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StreamingSessionStorageRootProperty.Jsii$Proxy that = (StreamingSessionStorageRootProperty.Jsii$Proxy) o;

                if (this.linux != null ? !this.linux.equals(that.linux) : that.linux != null) return false;
                return this.windows != null ? this.windows.equals(that.windows) : that.windows == null;
            }

            @Override
            public final int hashCode() {
                int result = this.linux != null ? this.linux.hashCode() : 0;
                result = 31 * result + (this.windows != null ? this.windows.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Custom volume configuration for the root volumes that are attached to streaming sessions.
     * <p>
     * This parameter is only allowed when <code>sessionPersistenceMode</code> is <code>ACTIVATED</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.nimblestudio.*;
     * VolumeConfigurationProperty volumeConfigurationProperty = VolumeConfigurationProperty.builder()
     *         .iops(123)
     *         .size(123)
     *         .throughput(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-volumeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-volumeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_nimblestudio.CfnLaunchProfile.VolumeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VolumeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VolumeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of I/O operations per second for the root volume that is attached to streaming session.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-volumeconfiguration.html#cfn-nimblestudio-launchprofile-volumeconfiguration-iops">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-volumeconfiguration.html#cfn-nimblestudio-launchprofile-volumeconfiguration-iops</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
            return null;
        }

        /**
         * The size of the root volume that is attached to the streaming session.
         * <p>
         * The root volume size is measured in GiBs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-volumeconfiguration.html#cfn-nimblestudio-launchprofile-volumeconfiguration-size">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-volumeconfiguration.html#cfn-nimblestudio-launchprofile-volumeconfiguration-size</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSize() {
            return null;
        }

        /**
         * The throughput to provision for the root volume that is attached to the streaming session.
         * <p>
         * The throughput is measured in MiB/s.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-volumeconfiguration.html#cfn-nimblestudio-launchprofile-volumeconfiguration-throughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-nimblestudio-launchprofile-volumeconfiguration.html#cfn-nimblestudio-launchprofile-volumeconfiguration-throughput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThroughput() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VolumeConfigurationProperty> {
            java.lang.Number iops;
            java.lang.Number size;
            java.lang.Number throughput;

            /**
             * Sets the value of {@link VolumeConfigurationProperty#getIops}
             * @param iops The number of I/O operations per second for the root volume that is attached to streaming session.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Sets the value of {@link VolumeConfigurationProperty#getSize}
             * @param size The size of the root volume that is attached to the streaming session.
             *             The root volume size is measured in GiBs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder size(java.lang.Number size) {
                this.size = size;
                return this;
            }

            /**
             * Sets the value of {@link VolumeConfigurationProperty#getThroughput}
             * @param throughput The throughput to provision for the root volume that is attached to the streaming session.
             *                   The throughput is measured in MiB/s.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throughput(java.lang.Number throughput) {
                this.throughput = throughput;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VolumeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VolumeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VolumeConfigurationProperty {
            private final java.lang.Number iops;
            private final java.lang.Number size;
            private final java.lang.Number throughput;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.size = software.amazon.jsii.Kernel.get(this, "size", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.throughput = software.amazon.jsii.Kernel.get(this, "throughput", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.iops = builder.iops;
                this.size = builder.size;
                this.throughput = builder.throughput;
            }

            @Override
            public final java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            public final java.lang.Number getSize() {
                return this.size;
            }

            @Override
            public final java.lang.Number getThroughput() {
                return this.throughput;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }
                if (this.getSize() != null) {
                    data.set("size", om.valueToTree(this.getSize()));
                }
                if (this.getThroughput() != null) {
                    data.set("throughput", om.valueToTree(this.getThroughput()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_nimblestudio.CfnLaunchProfile.VolumeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VolumeConfigurationProperty.Jsii$Proxy that = (VolumeConfigurationProperty.Jsii$Proxy) o;

                if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
                if (this.size != null ? !this.size.equals(that.size) : that.size != null) return false;
                return this.throughput != null ? this.throughput.equals(that.throughput) : that.throughput == null;
            }

            @Override
            public final int hashCode() {
                int result = this.iops != null ? this.iops.hashCode() : 0;
                result = 31 * result + (this.size != null ? this.size.hashCode() : 0);
                result = 31 * result + (this.throughput != null ? this.throughput.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.nimblestudio.CfnLaunchProfileProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.nimblestudio.CfnLaunchProfileProps.Builder();
        }

        /**
         * Unique identifiers for a collection of EC2 subnets.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-ec2subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-ec2subnetids</a>
         * @param ec2SubnetIds Unique identifiers for a collection of EC2 subnets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2SubnetIds(final java.util.List<java.lang.String> ec2SubnetIds) {
            this.props.ec2SubnetIds(ec2SubnetIds);
            return this;
        }

        /**
         * The version number of the protocol that is used by the launch profile.
         * <p>
         * The only valid version is "2021-03-31".
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-launchprofileprotocolversions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-launchprofileprotocolversions</a>
         * @param launchProfileProtocolVersions The version number of the protocol that is used by the launch profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchProfileProtocolVersions(final java.util.List<java.lang.String> launchProfileProtocolVersions) {
            this.props.launchProfileProtocolVersions(launchProfileProtocolVersions);
            return this;
        }

        /**
         * A friendly name for the launch profile.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-name</a>
         * @param name A friendly name for the launch profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A configuration for a streaming session.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-streamconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-streamconfiguration</a>
         * @param streamConfiguration A configuration for a streaming session. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamConfiguration(final software.amazon.awscdk.IResolvable streamConfiguration) {
            this.props.streamConfiguration(streamConfiguration);
            return this;
        }
        /**
         * A configuration for a streaming session.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-streamconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-streamconfiguration</a>
         * @param streamConfiguration A configuration for a streaming session. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamConfiguration(final software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile.StreamConfigurationProperty streamConfiguration) {
            this.props.streamConfiguration(streamConfiguration);
            return this;
        }

        /**
         * Unique identifiers for a collection of studio components that can be used with this launch profile.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-studiocomponentids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-studiocomponentids</a>
         * @param studioComponentIds Unique identifiers for a collection of studio components that can be used with this launch profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder studioComponentIds(final java.util.List<java.lang.String> studioComponentIds) {
            this.props.studioComponentIds(studioComponentIds);
            return this;
        }

        /**
         * The unique identifier for a studio resource.
         * <p>
         * In Nimble Studio, all other resources are contained in a studio resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-studioid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-studioid</a>
         * @param studioId The unique identifier for a studio resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder studioId(final java.lang.String studioId) {
            this.props.studioId(studioId);
            return this;
        }

        /**
         * A human-readable description of the launch profile.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-description</a>
         * @param description A human-readable description of the launch profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-launchprofile.html#cfn-nimblestudio-launchprofile-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile build() {
            return new software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
