package software.amazon.awscdk.services.rds;

/**
 * The versions for the Aurora MySQL cluster engine (those returned by <code>DatabaseClusterEngine.auroraMysql</code>).
 * <p>
 * https://docs.aws.amazon.com/AmazonRDS/latest/AuroraMySQLReleaseNotes/Welcome.html
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .engine(DatabaseClusterEngine.auroraMysql(AuroraMysqlClusterEngineProps.builder().version(AuroraMysqlEngineVersion.VER_3_01_0).build()))
 *         .writer(ClusterInstance.provisioned("writer", ProvisionedClusterInstanceProps.builder()
 *                 .caCertificate(CaCertificate.RDS_CA_RSA2048_G1)
 *                 .build()))
 *         .readers(List.of(ClusterInstance.serverlessV2("reader", ServerlessV2ClusterInstanceProps.builder()
 *                 .caCertificate(CaCertificate.of("custom-ca"))
 *                 .build())))
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:57.665Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.AuroraMysqlEngineVersion")
public class AuroraMysqlEngineVersion extends software.amazon.jsii.JsiiObject {

    protected AuroraMysqlEngineVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AuroraMysqlEngineVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        VER_2_02_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_02_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_03_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_03_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_03_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_03_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_03_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_03_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_04_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_04_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_04_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_04_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_04_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_04_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_04_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_04_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_04_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_04_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_04_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_04_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_04_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_04_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_04_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_04_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_04_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_04_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_04_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_04_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_05_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_05_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_05_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_05_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_06_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_06_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_07_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_07_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_07_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_07_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_07_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_07_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_07_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_07_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_07_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_07_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_07_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_07_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_07_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_07_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_07_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_07_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_07_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_07_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_07_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_07_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_07_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_07_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_08_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_08_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_08_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_08_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_08_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_08_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_08_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_08_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_08_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_08_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_09_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_09_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_09_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_09_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_09_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_09_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_09_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_09_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_10_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_10_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_10_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_10_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_10_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_10_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_10_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_10_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_11_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_11_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_11_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_11_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_11_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_11_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_11_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_11_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_11_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_11_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_11_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_11_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_11_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_11_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_12_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_12_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_12_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_12_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_12_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_12_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_12_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_12_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_12_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_12_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_2_12_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_2_12_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_01_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_01_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_01_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_01_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_02_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_02_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_02_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_02_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_02_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_02_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_02_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_02_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_03_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_03_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_03_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_03_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_03_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_03_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_03_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_03_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_04_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_04_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_04_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_04_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_04_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_04_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_04_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_04_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_04_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_04_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_05_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_05_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_05_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_05_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_05_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_05_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_06_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_06_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_06_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_06_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_07_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_07_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_07_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_07_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_08_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_08_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_08_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_08_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_3_08_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_3_08_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
        VER_5_7_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "VER_5_7_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class));
    }

    /**
     * Create a new AuroraMysqlEngineVersion with an arbitrary version.
     * <p>
     * @param auroraMysqlFullVersion the full version string, for example "5.7.mysql_aurora.2.78.3.6". This parameter is required.
     * @param auroraMysqlMajorVersion the major version of the engine, defaults to "5.7".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion of(final @org.jetbrains.annotations.NotNull java.lang.String auroraMysqlFullVersion, final @org.jetbrains.annotations.Nullable java.lang.String auroraMysqlMajorVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class), new Object[] { java.util.Objects.requireNonNull(auroraMysqlFullVersion, "auroraMysqlFullVersion is required"), auroraMysqlMajorVersion });
    }

    /**
     * Create a new AuroraMysqlEngineVersion with an arbitrary version.
     * <p>
     * @param auroraMysqlFullVersion the full version string, for example "5.7.mysql_aurora.2.78.3.6". This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion of(final @org.jetbrains.annotations.NotNull java.lang.String auroraMysqlFullVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion.class), new Object[] { java.util.Objects.requireNonNull(auroraMysqlFullVersion, "auroraMysqlFullVersion is required") });
    }

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.02.3".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.02.3 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_02_3;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.03.2".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.03.2 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_03_2;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.03.3".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.03.3 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_03_3;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.03.4".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.03.4 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_03_4;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.04.0".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.04.0 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_04_0;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.04.1".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.04.1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_04_1;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.04.2".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.04.2 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_04_2;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.04.3".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.04.3 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_04_3;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.04.4".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.04.4 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_04_4;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.04.5".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.04.5 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_04_5;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.04.6".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.04.6 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_04_6;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.04.7".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.04.7 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_04_7;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.04.8".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.04.8 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_04_8;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.04.9".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.04.9 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_04_9;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.05.0".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.05.0 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_05_0;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.05.1".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.05.1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_05_1;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.06.0".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.06.0 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_06_0;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.07.0".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.07.0 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_07_0;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.07.1".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.07.1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_07_1;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.07.10".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.07.10 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_07_10;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.07.2".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.07.2 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_07_2;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.07.3".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.07.3 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_07_3;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.07.4".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.07.4 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_07_4;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.07.5".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.07.5 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_07_5;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.07.6".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.07.6 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_07_6;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.07.7".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.07.7 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_07_7;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.07.8".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.07.8 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_07_8;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.07.9".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.07.9 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_07_9;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.08.0".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.08.0 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_08_0;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.08.1".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.08.1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_08_1;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.08.2".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.08.2 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_08_2;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.08.3".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.08.3 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_08_3;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.08.4".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.08.4 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_08_4;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.09.0".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.09.0 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_09_0;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.09.1".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.09.1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_09_1;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.09.2".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.09.2 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_09_2;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.09.3".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.09.3 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_09_3;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.10.0".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.10.0 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_10_0;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.10.1".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.10.1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_10_1;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.10.2".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.10.2 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_10_2;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.10.3".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.10.3 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_10_3;

    /**
     * (deprecated) Version "5.7.mysql_aurora.2.11.0".
     * <p>
     * @deprecated Version 5.7.mysql_aurora.2.11.0 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_11_0;

    /**
     * Version "5.7.mysql_aurora.2.11.1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_11_1;

    /**
     * Version "5.7.mysql_aurora.2.11.2".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_11_2;

    /**
     * Version "5.7.mysql_aurora.2.11.3".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_11_3;

    /**
     * Version "5.7.mysql_aurora.2.11.4".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_11_4;

    /**
     * Version "5.7.mysql_aurora.2.11.5".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_11_5;

    /**
     * Version "5.7.mysql_aurora.2.11.6".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_11_6;

    /**
     * Version "5.7.mysql_aurora.2.12.0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_12_0;

    /**
     * Version "5.7.mysql_aurora.2.12.1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_12_1;

    /**
     * Version "5.7.mysql_aurora.2.12.2".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_12_2;

    /**
     * Version "5.7.mysql_aurora.2.12.3".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_12_3;

    /**
     * Version "5.7.mysql_aurora.2.12.4".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_12_4;

    /**
     * Version "5.7.mysql_aurora.2.12.5".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_2_12_5;

    /**
     * (deprecated) Version "8.0.mysql_aurora.3.01.0".
     * <p>
     * @deprecated Aurora MySQL 8.0.mysql_aurora.3.01.0 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_01_0;

    /**
     * (deprecated) Version "8.0.mysql_aurora.3.01.1".
     * <p>
     * @deprecated Aurora MySQL 8.0.mysql_aurora.3.01.1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_01_1;

    /**
     * (deprecated) Version "8.0.mysql_aurora.3.02.0".
     * <p>
     * @deprecated Aurora MySQL 8.0.mysql_aurora.3.02.0 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_02_0;

    /**
     * (deprecated) Version "8.0.mysql_aurora.3.02.1".
     * <p>
     * @deprecated Aurora MySQL 8.0.mysql_aurora.3.02.1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_02_1;

    /**
     * (deprecated) Version "8.0.mysql_aurora.3.02.2".
     * <p>
     * @deprecated Aurora MySQL 8.0.mysql_aurora.3.02.2 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_02_2;

    /**
     * (deprecated) Version "8.0.mysql_aurora.3.02.3".
     * <p>
     * @deprecated Aurora MySQL 8.0.mysql_aurora.3.02.3 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_02_3;

    /**
     * (deprecated) Version "8.0.mysql_aurora.3.03.0".
     * <p>
     * @deprecated Aurora MySQL 8.0.mysql_aurora.3.03.0 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_03_0;

    /**
     * (deprecated) Version "8.0.mysql_aurora.3.03.1".
     * <p>
     * @deprecated Aurora MySQL 8.0.mysql_aurora.3.03.1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_03_1;

    /**
     * (deprecated) Version "8.0.mysql_aurora.3.03.2".
     * <p>
     * @deprecated Aurora MySQL 8.0.mysql_aurora.3.03.2 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_03_2;

    /**
     * (deprecated) Version "8.0.mysql_aurora.3.03.3".
     * <p>
     * @deprecated Aurora MySQL 8.0.mysql_aurora.3.03.3 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_03_3;

    /**
     * Version "8.0.mysql_aurora.3.04.0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_04_0;

    /**
     * Version "8.0.mysql_aurora.3.04.1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_04_1;

    /**
     * Version "8.0.mysql_aurora.3.04.2".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_04_2;

    /**
     * Version "8.0.mysql_aurora.3.04.3".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_04_3;

    /**
     * Version "8.0.mysql_aurora.3.04.4".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_04_4;

    /**
     * (deprecated) Version "8.0.mysql_aurora.3.05.0".
     * <p>
     * @deprecated Aurora MySQL 8.0.mysql_aurora.3.05.0 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_05_0;

    /**
     * (deprecated) Version "8.0.mysql_aurora.3.05.1".
     * <p>
     * @deprecated Aurora MySQL 8.0.mysql_aurora.3.05.1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_05_1;

    /**
     * Version "8.0.mysql_aurora.3.05.2".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_05_2;

    /**
     * Version "8.0.mysql_aurora.3.06.0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_06_0;

    /**
     * Version "8.0.mysql_aurora.3.06.1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_06_1;

    /**
     * Version "8.0.mysql_aurora.3.07.0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_07_0;

    /**
     * Version "8.0.mysql_aurora.3.07.1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_07_1;

    /**
     * Version "8.0.mysql_aurora.3.08.0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_08_0;

    /**
     * Version "8.0.mysql_aurora.3.08.1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_08_1;

    /**
     * Version "8.0.mysql_aurora.3.08.2".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_3_08_2;

    /**
     * (deprecated) Version "5.7.12".
     * <p>
     * @deprecated Version 5.7.12 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraMysqlEngineVersion VER_5_7_12;

    /**
     * The full version string, for example, "5.7.mysql_aurora.1.78.3.6".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuroraMysqlFullVersion() {
        return software.amazon.jsii.Kernel.get(this, "auroraMysqlFullVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The major version of the engine.
     * <p>
     * Currently, it's either "5.7", or "8.0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuroraMysqlMajorVersion() {
        return software.amazon.jsii.Kernel.get(this, "auroraMysqlMajorVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
