package software.amazon.awscdk.services.resiliencehub;

/**
 * Properties for defining a <code>CfnResiliencyPolicy</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.resiliencehub.*;
 * CfnResiliencyPolicyProps cfnResiliencyPolicyProps = CfnResiliencyPolicyProps.builder()
 *         .policy(Map.of(
 *                 "policyKey", FailurePolicyProperty.builder()
 *                         .rpoInSecs(123)
 *                         .rtoInSecs(123)
 *                         .build()))
 *         .policyName("policyName")
 *         .tier("tier")
 *         // the properties below are optional
 *         .dataLocationConstraint("dataLocationConstraint")
 *         .policyDescription("policyDescription")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:58.096Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_resiliencehub.CfnResiliencyPolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnResiliencyPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnResiliencyPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The resiliency policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-policy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-policy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getPolicy();

    /**
     * The name of the policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-policyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-policyname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPolicyName();

    /**
     * The tier for this resiliency policy, ranging from the highest severity ( <code>MissionCritical</code> ) to lowest ( <code>NonCritical</code> ).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-tier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-tier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTier();

    /**
     * Specifies a high-level geographical location constraint for where your resilience policy data can be stored.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-datalocationconstraint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-datalocationconstraint</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDataLocationConstraint() {
        return null;
    }

    /**
     * Description of the resiliency policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-policydescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-policydescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPolicyDescription() {
        return null;
    }

    /**
     * Tags assigned to the resource.
     * <p>
     * A tag is a label that you assign to an AWS resource. Each tag consists of a key/value pair.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnResiliencyPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResiliencyPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnResiliencyPolicyProps> {
        java.lang.Object policy;
        java.lang.String policyName;
        java.lang.String tier;
        java.lang.String dataLocationConstraint;
        java.lang.String policyDescription;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnResiliencyPolicyProps#getPolicy}
         * @param policy The resiliency policy. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(software.amazon.awscdk.IResolvable policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of {@link CfnResiliencyPolicyProps#getPolicy}
         * @param policy The resiliency policy. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(java.util.Map<java.lang.String, ? extends java.lang.Object> policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of {@link CfnResiliencyPolicyProps#getPolicyName}
         * @param policyName The name of the policy. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyName(java.lang.String policyName) {
            this.policyName = policyName;
            return this;
        }

        /**
         * Sets the value of {@link CfnResiliencyPolicyProps#getTier}
         * @param tier The tier for this resiliency policy, ranging from the highest severity ( <code>MissionCritical</code> ) to lowest ( <code>NonCritical</code> ). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tier(java.lang.String tier) {
            this.tier = tier;
            return this;
        }

        /**
         * Sets the value of {@link CfnResiliencyPolicyProps#getDataLocationConstraint}
         * @param dataLocationConstraint Specifies a high-level geographical location constraint for where your resilience policy data can be stored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataLocationConstraint(java.lang.String dataLocationConstraint) {
            this.dataLocationConstraint = dataLocationConstraint;
            return this;
        }

        /**
         * Sets the value of {@link CfnResiliencyPolicyProps#getPolicyDescription}
         * @param policyDescription Description of the resiliency policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDescription(java.lang.String policyDescription) {
            this.policyDescription = policyDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnResiliencyPolicyProps#getTags}
         * @param tags Tags assigned to the resource.
         *             A tag is a label that you assign to an AWS resource. Each tag consists of a key/value pair.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResiliencyPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnResiliencyPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnResiliencyPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResiliencyPolicyProps {
        private final java.lang.Object policy;
        private final java.lang.String policyName;
        private final java.lang.String tier;
        private final java.lang.String dataLocationConstraint;
        private final java.lang.String policyDescription;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.policy = software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.policyName = software.amazon.jsii.Kernel.get(this, "policyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tier = software.amazon.jsii.Kernel.get(this, "tier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataLocationConstraint = software.amazon.jsii.Kernel.get(this, "dataLocationConstraint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policyDescription = software.amazon.jsii.Kernel.get(this, "policyDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.policy = java.util.Objects.requireNonNull(builder.policy, "policy is required");
            this.policyName = java.util.Objects.requireNonNull(builder.policyName, "policyName is required");
            this.tier = java.util.Objects.requireNonNull(builder.tier, "tier is required");
            this.dataLocationConstraint = builder.dataLocationConstraint;
            this.policyDescription = builder.policyDescription;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.Object getPolicy() {
            return this.policy;
        }

        @Override
        public final java.lang.String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final java.lang.String getTier() {
            return this.tier;
        }

        @Override
        public final java.lang.String getDataLocationConstraint() {
            return this.dataLocationConstraint;
        }

        @Override
        public final java.lang.String getPolicyDescription() {
            return this.policyDescription;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("policy", om.valueToTree(this.getPolicy()));
            data.set("policyName", om.valueToTree(this.getPolicyName()));
            data.set("tier", om.valueToTree(this.getTier()));
            if (this.getDataLocationConstraint() != null) {
                data.set("dataLocationConstraint", om.valueToTree(this.getDataLocationConstraint()));
            }
            if (this.getPolicyDescription() != null) {
                data.set("policyDescription", om.valueToTree(this.getPolicyDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_resiliencehub.CfnResiliencyPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResiliencyPolicyProps.Jsii$Proxy that = (CfnResiliencyPolicyProps.Jsii$Proxy) o;

            if (!policy.equals(that.policy)) return false;
            if (!policyName.equals(that.policyName)) return false;
            if (!tier.equals(that.tier)) return false;
            if (this.dataLocationConstraint != null ? !this.dataLocationConstraint.equals(that.dataLocationConstraint) : that.dataLocationConstraint != null) return false;
            if (this.policyDescription != null ? !this.policyDescription.equals(that.policyDescription) : that.policyDescription != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.policy.hashCode();
            result = 31 * result + (this.policyName.hashCode());
            result = 31 * result + (this.tier.hashCode());
            result = 31 * result + (this.dataLocationConstraint != null ? this.dataLocationConstraint.hashCode() : 0);
            result = 31 * result + (this.policyDescription != null ? this.policyDescription.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
