package software.amazon.awscdk.services.route53;

/**
 * Reference to a public hosted zone.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IPublicHostedZone zoneFromAttributes = PublicHostedZone.fromPublicHostedZoneAttributes(this, "MyZone", PublicHostedZoneAttributes.builder()
 *         .zoneName("example.com")
 *         .hostedZoneId("ZOJJZC49E0EPZ")
 *         .build());
 * // Does not know zoneName
 * IPublicHostedZone zoneFromId = PublicHostedZone.fromPublicHostedZoneId(this, "MyZone", "ZOJJZC49E0EPZ");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:58.261Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.PublicHostedZoneAttributes")
@software.amazon.jsii.Jsii.Proxy(PublicHostedZoneAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PublicHostedZoneAttributes extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.route53.HostedZoneAttributes {

    /**
     * @return a {@link Builder} of {@link PublicHostedZoneAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PublicHostedZoneAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PublicHostedZoneAttributes> {
        java.lang.String hostedZoneId;
        java.lang.String zoneName;

        /**
         * Sets the value of {@link PublicHostedZoneAttributes#getHostedZoneId}
         * @param hostedZoneId Identifier of the hosted zone. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneId(java.lang.String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        /**
         * Sets the value of {@link PublicHostedZoneAttributes#getZoneName}
         * @param zoneName Name of the hosted zone. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zoneName(java.lang.String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PublicHostedZoneAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PublicHostedZoneAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PublicHostedZoneAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PublicHostedZoneAttributes {
        private final java.lang.String hostedZoneId;
        private final java.lang.String zoneName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hostedZoneId = software.amazon.jsii.Kernel.get(this, "hostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.zoneName = software.amazon.jsii.Kernel.get(this, "zoneName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hostedZoneId = java.util.Objects.requireNonNull(builder.hostedZoneId, "hostedZoneId is required");
            this.zoneName = java.util.Objects.requireNonNull(builder.zoneName, "zoneName is required");
        }

        @Override
        public final java.lang.String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final java.lang.String getZoneName() {
            return this.zoneName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("hostedZoneId", om.valueToTree(this.getHostedZoneId()));
            data.set("zoneName", om.valueToTree(this.getZoneName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.PublicHostedZoneAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PublicHostedZoneAttributes.Jsii$Proxy that = (PublicHostedZoneAttributes.Jsii$Proxy) o;

            if (!hostedZoneId.equals(that.hostedZoneId)) return false;
            return this.zoneName.equals(that.zoneName);
        }

        @Override
        public final int hashCode() {
            int result = this.hostedZoneId.hashCode();
            result = 31 * result + (this.zoneName.hashCode());
            return result;
        }
    }
}
