package software.amazon.awscdk.services.s3;

/**
 * The bucket policy for an Amazon S3 bucket.
 * <p>
 * Policies define the operations that are allowed on this resource.
 * <p>
 * You almost never need to define this construct directly.
 * <p>
 * All AWS resources that support resource policies have a method called
 * <code>addToResourcePolicy()</code>, which will automatically create a new resource
 * policy if one doesn't exist yet, otherwise it will add to the existing
 * policy.
 * <p>
 * The bucket policy method is implemented differently than <code>addToResourcePolicy()</code>
 * as <code>BucketPolicy()</code> creates a new policy without knowing one earlier existed.
 * e.g. if during Bucket creation, if <code>autoDeleteObject:true</code>, these policies are
 * added to the bucket policy:
 * ["s3:DeleteObject*", "s3:GetBucket*", "s3:List*", "s3:PutBucketPolicy"],
 * and when you add a new BucketPolicy with ["s3:GetObject", "s3:ListBucket"] on
 * this existing bucket, invoking <code>BucketPolicy()</code> will create a new Policy
 * without knowing one earlier exists already, so it creates a new one.
 * In this case, the custom resource handler will not have access to
 * <code>s3:GetBucketTagging</code> action which will cause failure during deletion of stack.
 * <p>
 * Hence its strongly recommended to use <code>addToResourcePolicy()</code> method to add
 * new permissions to existing policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * String bucketName = "amzn-s3-demo-bucket";
 * Bucket accessLogsBucket = Bucket.Builder.create(this, "AccessLogsBucket")
 *         .objectOwnership(ObjectOwnership.BUCKET_OWNER_ENFORCED)
 *         .bucketName(bucketName)
 *         .build();
 * CfnBucketPolicy bucketPolicy = CfnBucketPolicy.Builder.create(this, "BucketPolicy")
 *         .bucket(bucketName)
 *         .policyDocument(Map.of(
 *                 "Statement", List.of(Map.of(
 *                         "Action", "s3:*",
 *                         "Effect", "Deny",
 *                         "Principal", Map.of(
 *                                 "AWS", "*"),
 *                         "Resource", List.of(accessLogsBucket.getBucketArn(), String.format("%s/*", accessLogsBucket.getBucketArn())))),
 *                 "Version", "2012-10-17"))
 *         .build();
 * // Wrap L1 Construct with L2 Bucket Policy Construct. Subsequent
 * // generated bucket policy to allow access log delivery would append
 * // to the current policy.
 * BucketPolicy.fromCfnBucketPolicy(bucketPolicy);
 * Bucket bucket = Bucket.Builder.create(this, "MyBucket")
 *         .serverAccessLogsBucket(accessLogsBucket)
 *         .serverAccessLogsPrefix("logs")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:58.397Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.BucketPolicy")
public class BucketPolicy extends software.amazon.awscdk.Resource {

    protected BucketPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BucketPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.s3.BucketPolicy.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public BucketPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.BucketPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Create a mutable <code>BucketPolicy</code> from a <code>CfnBucketPolicy</code>.
     * <p>
     * @param cfnBucketPolicy This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.BucketPolicy fromCfnBucketPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.CfnBucketPolicy cfnBucketPolicy) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.BucketPolicy.class, "fromCfnBucketPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.BucketPolicy.class), new Object[] { java.util.Objects.requireNonNull(cfnBucketPolicy, "cfnBucketPolicy is required") });
    }

    /**
     * Sets the removal policy for the BucketPolicy.
     * <p>
     * @param removalPolicy the RemovalPolicy to set. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy removalPolicy) {
        software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(removalPolicy, "removalPolicy is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The Bucket this Policy applies to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getBucket() {
        return software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
    }

    /**
     * A policy document containing permissions to add to the specified bucket.
     * <p>
     * For more information, see Access Policy Language Overview in the Amazon
     * Simple Storage Service Developer Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyDocument getDocument() {
        return software.amazon.jsii.Kernel.get(this, "document", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.s3.BucketPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.s3.BucketPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.s3.BucketPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.s3.BucketPolicyProps.Builder();
        }

        /**
         * The Amazon S3 bucket that the policy applies to.
         * <p>
         * @return {@code this}
         * @param bucket The Amazon S3 bucket that the policy applies to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(final software.amazon.awscdk.services.s3.IBucket bucket) {
            this.props.bucket(bucket);
            return this;
        }

        /**
         * Policy to apply when the policy is removed from this stack.
         * <p>
         * Default: - RemovalPolicy.DESTROY.
         * <p>
         * @return {@code this}
         * @param removalPolicy Policy to apply when the policy is removed from this stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.s3.BucketPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.s3.BucketPolicy build() {
            return new software.amazon.awscdk.services.s3.BucketPolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
