package software.amazon.awscdk.services.s3;

/**
 * Properties for defining a <code>CfnStorageLensGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3.*;
 * CfnStorageLensGroupProps cfnStorageLensGroupProps = CfnStorageLensGroupProps.builder()
 *         .filter(FilterProperty.builder()
 *                 .and(AndProperty.builder()
 *                         .matchAnyPrefix(List.of("matchAnyPrefix"))
 *                         .matchAnySuffix(List.of("matchAnySuffix"))
 *                         .matchAnyTag(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .matchObjectAge(MatchObjectAgeProperty.builder()
 *                                 .daysGreaterThan(123)
 *                                 .daysLessThan(123)
 *                                 .build())
 *                         .matchObjectSize(MatchObjectSizeProperty.builder()
 *                                 .bytesGreaterThan(123)
 *                                 .bytesLessThan(123)
 *                                 .build())
 *                         .build())
 *                 .matchAnyPrefix(List.of("matchAnyPrefix"))
 *                 .matchAnySuffix(List.of("matchAnySuffix"))
 *                 .matchAnyTag(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .matchObjectAge(MatchObjectAgeProperty.builder()
 *                         .daysGreaterThan(123)
 *                         .daysLessThan(123)
 *                         .build())
 *                 .matchObjectSize(MatchObjectSizeProperty.builder()
 *                         .bytesGreaterThan(123)
 *                         .bytesLessThan(123)
 *                         .build())
 *                 .or(OrProperty.builder()
 *                         .matchAnyPrefix(List.of("matchAnyPrefix"))
 *                         .matchAnySuffix(List.of("matchAnySuffix"))
 *                         .matchAnyTag(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .matchObjectAge(MatchObjectAgeProperty.builder()
 *                                 .daysGreaterThan(123)
 *                                 .daysLessThan(123)
 *                                 .build())
 *                         .matchObjectSize(MatchObjectSizeProperty.builder()
 *                                 .bytesGreaterThan(123)
 *                                 .bytesLessThan(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .name("name")
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelensgroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelensgroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:58.495Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.CfnStorageLensGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnStorageLensGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStorageLensGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * This property contains the criteria for the Storage Lens group data that is displayed.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelensgroup.html#cfn-s3-storagelensgroup-filter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelensgroup.html#cfn-s3-storagelensgroup-filter</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getFilter();

    /**
     * This property contains the Storage Lens group name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelensgroup.html#cfn-s3-storagelensgroup-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelensgroup.html#cfn-s3-storagelensgroup-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * This property contains the AWS resource tags that you're adding to your Storage Lens group.
     * <p>
     * This parameter is optional.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelensgroup.html#cfn-s3-storagelensgroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelensgroup.html#cfn-s3-storagelensgroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStorageLensGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStorageLensGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStorageLensGroupProps> {
        java.lang.Object filter;
        java.lang.String name;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnStorageLensGroupProps#getFilter}
         * @param filter This property contains the criteria for the Storage Lens group data that is displayed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filter(software.amazon.awscdk.IResolvable filter) {
            this.filter = filter;
            return this;
        }

        /**
         * Sets the value of {@link CfnStorageLensGroupProps#getFilter}
         * @param filter This property contains the criteria for the Storage Lens group data that is displayed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filter(software.amazon.awscdk.services.s3.CfnStorageLensGroup.FilterProperty filter) {
            this.filter = filter;
            return this;
        }

        /**
         * Sets the value of {@link CfnStorageLensGroupProps#getName}
         * @param name This property contains the Storage Lens group name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnStorageLensGroupProps#getTags}
         * @param tags This property contains the AWS resource tags that you're adding to your Storage Lens group.
         *             This parameter is optional.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStorageLensGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStorageLensGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStorageLensGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStorageLensGroupProps {
        private final java.lang.Object filter;
        private final java.lang.String name;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.filter = software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.filter = java.util.Objects.requireNonNull(builder.filter, "filter is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getFilter() {
            return this.filter;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("filter", om.valueToTree(this.getFilter()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3.CfnStorageLensGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStorageLensGroupProps.Jsii$Proxy that = (CfnStorageLensGroupProps.Jsii$Proxy) o;

            if (!filter.equals(that.filter)) return false;
            if (!name.equals(that.name)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.filter.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
