package software.amazon.awscdk.services.s3.deployment;

/**
 * Storage class used for storing the object.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket websiteBucket = Bucket.Builder.create(this, "WebsiteBucket")
 *         .websiteIndexDocument("index.html")
 *         .publicReadAccess(true)
 *         .build();
 * BucketDeployment.Builder.create(this, "DeployWebsite")
 *         .sources(List.of(Source.asset("./website-dist")))
 *         .destinationBucket(websiteBucket)
 *         .destinationKeyPrefix("web/static") // optional prefix in destination bucket
 *         .metadata(Map.of("A", "1", "b", "2")) // user-defined metadata
 *         // system-defined metadata
 *         .contentType("text/html")
 *         .contentLanguage("en")
 *         .storageClass(StorageClass.INTELLIGENT_TIERING)
 *         .serverSideEncryption(ServerSideEncryption.AES_256)
 *         .cacheControl(List.of(CacheControl.setPublic(), CacheControl.maxAge(Duration.hours(1))))
 *         .accessControl(BucketAccessControl.BUCKET_OWNER_FULL_CONTROL)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:58.560Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3_deployment.StorageClass")
public enum StorageClass {
    /**
     * 'STANDARD'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
    /**
     * 'REDUCED_REDUNDANCY'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REDUCED_REDUNDANCY,
    /**
     * 'STANDARD_IA'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD_IA,
    /**
     * 'ONEZONE_IA'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ONEZONE_IA,
    /**
     * 'INTELLIGENT_TIERING'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INTELLIGENT_TIERING,
    /**
     * 'GLACIER'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GLACIER,
    /**
     * 'DEEP_ARCHIVE'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DEEP_ARCHIVE,
}
