package software.amazon.awscdk.services.s3express;

/**
 * Properties for defining a <code>CfnDirectoryBucket</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3express.*;
 * CfnDirectoryBucketProps cfnDirectoryBucketProps = CfnDirectoryBucketProps.builder()
 *         .dataRedundancy("dataRedundancy")
 *         .locationName("locationName")
 *         // the properties below are optional
 *         .bucketEncryption(BucketEncryptionProperty.builder()
 *                 .serverSideEncryptionConfiguration(List.of(ServerSideEncryptionRuleProperty.builder()
 *                         .bucketKeyEnabled(false)
 *                         .serverSideEncryptionByDefault(ServerSideEncryptionByDefaultProperty.builder()
 *                                 .sseAlgorithm("sseAlgorithm")
 *                                 // the properties below are optional
 *                                 .kmsMasterKeyId("kmsMasterKeyId")
 *                                 .build())
 *                         .build()))
 *                 .build())
 *         .bucketName("bucketName")
 *         .lifecycleConfiguration(LifecycleConfigurationProperty.builder()
 *                 .rules(List.of(RuleProperty.builder()
 *                         .status("status")
 *                         // the properties below are optional
 *                         .abortIncompleteMultipartUpload(AbortIncompleteMultipartUploadProperty.builder()
 *                                 .daysAfterInitiation(123)
 *                                 .build())
 *                         .expirationInDays(123)
 *                         .id("id")
 *                         .objectSizeGreaterThan("objectSizeGreaterThan")
 *                         .objectSizeLessThan("objectSizeLessThan")
 *                         .prefix("prefix")
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:58.570Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3express.CfnDirectoryBucketProps")
@software.amazon.jsii.Jsii.Proxy(CfnDirectoryBucketProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDirectoryBucketProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The number of Zone (Availability Zone or Local Zone) that's used for redundancy for the bucket.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-dataredundancy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-dataredundancy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataRedundancy();

    /**
     * The name of the location where the bucket will be created.
     * <p>
     * For directory buckets, the name of the location is the Zone ID of the Availability Zone (AZ) or Local Zone (LZ) where the bucket will be created. An example AZ ID value is <code>usw2-az1</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-locationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-locationname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLocationName();

    /**
     * Specifies default encryption for a bucket using server-side encryption with Amazon S3 managed keys (SSE-S3) or AWS KMS keys (SSE-KMS).
     * <p>
     * For information about default encryption for directory buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-bucket-encryption.html">Setting and monitoring default encryption for directory buckets</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-bucketencryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-bucketencryption</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBucketEncryption() {
        return null;
    }

    /**
     * A name for the bucket.
     * <p>
     * The bucket name must contain only lowercase letters, numbers, and hyphens (-). A directory bucket name must be unique in the chosen Zone (Availability Zone or Local Zone). The bucket name must also follow the format <code>*bucket_base_name* -- *zone_id* --x-s3</code> (for example, <code>*bucket_base_name* -- *usw2-az1* --x-s3</code> ). If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the bucket name. For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you need to replace the resource, specify a new name.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-bucketname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBucketName() {
        return null;
    }

    /**
     * Container for lifecycle rules. You can add as many as 1000 rules.
     * <p>
     * For more information see, <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-objects-lifecycle.html">Creating and managing a lifecycle configuration for directory buckets</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-lifecycleconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-lifecycleconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLifecycleConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDirectoryBucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDirectoryBucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDirectoryBucketProps> {
        java.lang.String dataRedundancy;
        java.lang.String locationName;
        java.lang.Object bucketEncryption;
        java.lang.String bucketName;
        java.lang.Object lifecycleConfiguration;

        /**
         * Sets the value of {@link CfnDirectoryBucketProps#getDataRedundancy}
         * @param dataRedundancy The number of Zone (Availability Zone or Local Zone) that's used for redundancy for the bucket. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataRedundancy(java.lang.String dataRedundancy) {
            this.dataRedundancy = dataRedundancy;
            return this;
        }

        /**
         * Sets the value of {@link CfnDirectoryBucketProps#getLocationName}
         * @param locationName The name of the location where the bucket will be created. This parameter is required.
         *                     For directory buckets, the name of the location is the Zone ID of the Availability Zone (AZ) or Local Zone (LZ) where the bucket will be created. An example AZ ID value is <code>usw2-az1</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locationName(java.lang.String locationName) {
            this.locationName = locationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDirectoryBucketProps#getBucketEncryption}
         * @param bucketEncryption Specifies default encryption for a bucket using server-side encryption with Amazon S3 managed keys (SSE-S3) or AWS KMS keys (SSE-KMS).
         *                         For information about default encryption for directory buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-bucket-encryption.html">Setting and monitoring default encryption for directory buckets</a> in the <em>Amazon S3 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketEncryption(software.amazon.awscdk.IResolvable bucketEncryption) {
            this.bucketEncryption = bucketEncryption;
            return this;
        }

        /**
         * Sets the value of {@link CfnDirectoryBucketProps#getBucketEncryption}
         * @param bucketEncryption Specifies default encryption for a bucket using server-side encryption with Amazon S3 managed keys (SSE-S3) or AWS KMS keys (SSE-KMS).
         *                         For information about default encryption for directory buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-bucket-encryption.html">Setting and monitoring default encryption for directory buckets</a> in the <em>Amazon S3 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketEncryption(software.amazon.awscdk.services.s3express.CfnDirectoryBucket.BucketEncryptionProperty bucketEncryption) {
            this.bucketEncryption = bucketEncryption;
            return this;
        }

        /**
         * Sets the value of {@link CfnDirectoryBucketProps#getBucketName}
         * @param bucketName A name for the bucket.
         *                   The bucket name must contain only lowercase letters, numbers, and hyphens (-). A directory bucket name must be unique in the chosen Zone (Availability Zone or Local Zone). The bucket name must also follow the format <code>*bucket_base_name* -- *zone_id* --x-s3</code> (for example, <code>*bucket_base_name* -- *usw2-az1* --x-s3</code> ). If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the bucket name. For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <em>Amazon S3 User Guide</em> .
         *                   <p>
         *                   <blockquote>
         *                   <p>
         *                   If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you need to replace the resource, specify a new name.
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(java.lang.String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDirectoryBucketProps#getLifecycleConfiguration}
         * @param lifecycleConfiguration Container for lifecycle rules. You can add as many as 1000 rules.
         *                               For more information see, <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-objects-lifecycle.html">Creating and managing a lifecycle configuration for directory buckets</a> in the <em>Amazon S3 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleConfiguration(software.amazon.awscdk.IResolvable lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDirectoryBucketProps#getLifecycleConfiguration}
         * @param lifecycleConfiguration Container for lifecycle rules. You can add as many as 1000 rules.
         *                               For more information see, <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-objects-lifecycle.html">Creating and managing a lifecycle configuration for directory buckets</a> in the <em>Amazon S3 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleConfiguration(software.amazon.awscdk.services.s3express.CfnDirectoryBucket.LifecycleConfigurationProperty lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDirectoryBucketProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDirectoryBucketProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDirectoryBucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDirectoryBucketProps {
        private final java.lang.String dataRedundancy;
        private final java.lang.String locationName;
        private final java.lang.Object bucketEncryption;
        private final java.lang.String bucketName;
        private final java.lang.Object lifecycleConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataRedundancy = software.amazon.jsii.Kernel.get(this, "dataRedundancy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.locationName = software.amazon.jsii.Kernel.get(this, "locationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bucketEncryption = software.amazon.jsii.Kernel.get(this, "bucketEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lifecycleConfiguration = software.amazon.jsii.Kernel.get(this, "lifecycleConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataRedundancy = java.util.Objects.requireNonNull(builder.dataRedundancy, "dataRedundancy is required");
            this.locationName = java.util.Objects.requireNonNull(builder.locationName, "locationName is required");
            this.bucketEncryption = builder.bucketEncryption;
            this.bucketName = builder.bucketName;
            this.lifecycleConfiguration = builder.lifecycleConfiguration;
        }

        @Override
        public final java.lang.String getDataRedundancy() {
            return this.dataRedundancy;
        }

        @Override
        public final java.lang.String getLocationName() {
            return this.locationName;
        }

        @Override
        public final java.lang.Object getBucketEncryption() {
            return this.bucketEncryption;
        }

        @Override
        public final java.lang.String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final java.lang.Object getLifecycleConfiguration() {
            return this.lifecycleConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataRedundancy", om.valueToTree(this.getDataRedundancy()));
            data.set("locationName", om.valueToTree(this.getLocationName()));
            if (this.getBucketEncryption() != null) {
                data.set("bucketEncryption", om.valueToTree(this.getBucketEncryption()));
            }
            if (this.getBucketName() != null) {
                data.set("bucketName", om.valueToTree(this.getBucketName()));
            }
            if (this.getLifecycleConfiguration() != null) {
                data.set("lifecycleConfiguration", om.valueToTree(this.getLifecycleConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3express.CfnDirectoryBucketProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDirectoryBucketProps.Jsii$Proxy that = (CfnDirectoryBucketProps.Jsii$Proxy) o;

            if (!dataRedundancy.equals(that.dataRedundancy)) return false;
            if (!locationName.equals(that.locationName)) return false;
            if (this.bucketEncryption != null ? !this.bucketEncryption.equals(that.bucketEncryption) : that.bucketEncryption != null) return false;
            if (this.bucketName != null ? !this.bucketName.equals(that.bucketName) : that.bucketName != null) return false;
            return this.lifecycleConfiguration != null ? this.lifecycleConfiguration.equals(that.lifecycleConfiguration) : that.lifecycleConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dataRedundancy.hashCode();
            result = 31 * result + (this.locationName.hashCode());
            result = 31 * result + (this.bucketEncryption != null ? this.bucketEncryption.hashCode() : 0);
            result = 31 * result + (this.bucketName != null ? this.bucketName.hashCode() : 0);
            result = 31 * result + (this.lifecycleConfiguration != null ? this.lifecycleConfiguration.hashCode() : 0);
            return result;
        }
    }
}
