package software.amazon.awscdk.services.scheduler.targets;

/**
 * Schedule an ECS Task on Fargate using AWS EventBridge Scheduler.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ecs.*;
 * ICluster cluster;
 * FargateTaskDefinition taskDefinition;
 * Schedule.Builder.create(this, "Schedule")
 *         .schedule(ScheduleExpression.rate(Duration.minutes(60)))
 *         .target(EcsRunFargateTask.Builder.create(cluster)
 *                 .taskDefinition(taskDefinition)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:59.078Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler_targets.EcsRunFargateTask")
public class EcsRunFargateTask extends software.amazon.awscdk.services.scheduler.targets.EcsRunTask {

    protected EcsRunFargateTask(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcsRunFargateTask(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param cluster This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EcsRunFargateTask(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ICluster cluster, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.targets.FargateTaskProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(cluster, "cluster is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param _schedule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.ScheduleTargetConfig bindBaseTargetConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.ISchedule _schedule) {
        return software.amazon.jsii.Kernel.call(this, "bindBaseTargetConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.ScheduleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_schedule, "_schedule is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.scheduler.targets.EcsRunFargateTask}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.scheduler.targets.EcsRunFargateTask> {
        /**
         * @return a new instance of {@link Builder}.
         * @param cluster This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.ecs.ICluster cluster) {
            return new Builder(cluster);
        }

        private final software.amazon.awscdk.services.ecs.ICluster cluster;
        private final software.amazon.awscdk.services.scheduler.targets.FargateTaskProps.Builder props;

        private Builder(final software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.cluster = cluster;
            this.props = new software.amazon.awscdk.services.scheduler.targets.FargateTaskProps.Builder();
        }

        /**
         * The SQS queue to be used as deadLetterQueue.
         * <p>
         * The events not successfully delivered are automatically retried for a specified period of time,
         * depending on the retry policy of the target.
         * If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
         * <p>
         * Default: - no dead-letter queue
         * <p>
         * @return {@code this}
         * @param deadLetterQueue The SQS queue to be used as deadLetterQueue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * Input passed to the target.
         * <p>
         * Default: - no input.
         * <p>
         * @return {@code this}
         * @param input Input passed to the target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(final software.amazon.awscdk.services.scheduler.ScheduleTargetInput input) {
            this.props.input(input);
            return this;
        }

        /**
         * The maximum age of a request that Scheduler sends to a target for processing.
         * <p>
         * Minimum value of 60.
         * Maximum value of 86400.
         * <p>
         * Default: Duration.hours(24)
         * <p>
         * @return {@code this}
         * @param maxEventAge The maximum age of a request that Scheduler sends to a target for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(final software.amazon.awscdk.Duration maxEventAge) {
            this.props.maxEventAge(maxEventAge);
            return this;
        }

        /**
         * The maximum number of times to retry when the target returns an error.
         * <p>
         * Minimum value of 0.
         * Maximum value of 185.
         * <p>
         * Default: 185
         * <p>
         * @return {@code this}
         * @param retryAttempts The maximum number of times to retry when the target returns an error. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        /**
         * An execution role is an IAM role that EventBridge Scheduler assumes in order to interact with other AWS services on your behalf.
         * <p>
         * If none provided templates target will automatically create an IAM role with all the minimum necessary
         * permissions to interact with the templated target. If you wish you may specify your own IAM role, then the templated targets
         * will grant minimal required permissions.
         * <p>
         * Default: - created by target
         * <p>
         * @return {@code this}
         * @param role An execution role is an IAM role that EventBridge Scheduler assumes in order to interact with other AWS services on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * The task definition to use for scheduled tasks.
         * <p>
         * Note: this must be TaskDefinition, and not ITaskDefinition,
         * as it requires properties that are not known for imported task definitions
         * If you want to run a RunTask with an imported task definition,
         * consider using a Universal target.
         * <p>
         * @return {@code this}
         * @param taskDefinition The task definition to use for scheduled tasks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(final software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition) {
            this.props.taskDefinition(taskDefinition);
            return this;
        }

        /**
         * The capacity provider strategy to use for the task.
         * <p>
         * Default: - No capacity provider strategy
         * <p>
         * @return {@code this}
         * @param capacityProviderStrategies The capacity provider strategy to use for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviderStrategies(final java.util.List<? extends software.amazon.awscdk.services.ecs.CapacityProviderStrategy> capacityProviderStrategies) {
            this.props.capacityProviderStrategies(capacityProviderStrategies);
            return this;
        }

        /**
         * Specifies whether to enable Amazon ECS managed tags for the task.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsManagedTags(final java.lang.Boolean enableEcsManagedTags) {
            this.props.enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }

        /**
         * Whether to enable execute command functionality for the containers in this task.
         * <p>
         * If true, this enables execute command functionality on all containers in the task.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param enableExecuteCommand Whether to enable execute command functionality for the containers in this task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableExecuteCommand(final java.lang.Boolean enableExecuteCommand) {
            this.props.enableExecuteCommand(enableExecuteCommand);
            return this;
        }

        /**
         * Specifies an ECS task group for the task.
         * <p>
         * Default: - No group
         * <p>
         * @return {@code this}
         * @param group Specifies an ECS task group for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder group(final java.lang.String group) {
            this.props.group(group);
            return this;
        }

        /**
         * Specifies whether to propagate the tags from the task definition to the task.
         * <p>
         * If no value is specified, the tags are not propagated.
         * <p>
         * Default: - No tag propagation
         * <p>
         * @return {@code this}
         * @param propagateTags Specifies whether to propagate the tags from the task definition to the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(final java.lang.Boolean propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }

        /**
         * The reference ID to use for the task.
         * <p>
         * Default: - No reference ID.
         * <p>
         * @return {@code this}
         * @param referenceId The reference ID to use for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder referenceId(final java.lang.String referenceId) {
            this.props.referenceId(referenceId);
            return this;
        }

        /**
         * The security groups associated with the task.
         * <p>
         * These security groups must all be in the same VPC.
         * Controls inbound and outbound network access for the task.
         * <p>
         * Default: - The security group for the VPC is used.
         * <p>
         * @return {@code this}
         * @param securityGroups The security groups associated with the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * The metadata that you apply to the task to help you categorize and organize them.
         * <p>
         * Each tag consists of a key and an optional value, both of which you define.
         * <p>
         * Default: - No tags
         * <p>
         * @return {@code this}
         * @param tags The metadata that you apply to the task to help you categorize and organize them. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.services.scheduler.targets.Tag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The number of tasks to create based on TaskDefinition.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param taskCount The number of tasks to create based on TaskDefinition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskCount(final java.lang.Number taskCount) {
            this.props.taskCount(taskCount);
            return this;
        }

        /**
         * The subnets associated with the task.
         * <p>
         * These subnets must all be in the same VPC.
         * The task will be launched in these subnets.
         * <p>
         * Default: - all private subnets of the VPC are selected.
         * <p>
         * @return {@code this}
         * @param vpcSubnets The subnets associated with the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * Specifies whether the task's elastic network interface receives a public IP address.
         * <p>
         * If true, the task will receive a public IP address and be accessible from the internet.
         * Should only be set to true when using public subnets.
         * <p>
         * Default: - true if the subnet type is PUBLIC, otherwise false
         * <p>
         * @return {@code this}
         * @param assignPublicIp Specifies whether the task's elastic network interface receives a public IP address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assignPublicIp(final java.lang.Boolean assignPublicIp) {
            this.props.assignPublicIp(assignPublicIp);
            return this;
        }

        /**
         * Specifies the platform version for the task.
         * <p>
         * Specify only the numeric portion of the platform version, such as 1.1.0.
         * Platform versions determine the underlying runtime environment for the task.
         * <p>
         * Default: - LATEST
         * <p>
         * @return {@code this}
         * @param platformVersion Specifies the platform version for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformVersion(final software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion) {
            this.props.platformVersion(platformVersion);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.scheduler.targets.EcsRunFargateTask}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.scheduler.targets.EcsRunFargateTask build() {
            return new software.amazon.awscdk.services.scheduler.targets.EcsRunFargateTask(
                this.cluster,
                this.props.build()
            );
        }
    }
}
