package software.amazon.awscdk.services.securityhub;

/**
 * Properties for defining a <code>CfnHub</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.securityhub.*;
 * Object tags;
 * CfnHubProps cfnHubProps = CfnHubProps.builder()
 *         .autoEnableControls(false)
 *         .controlFindingGenerator("controlFindingGenerator")
 *         .enableDefaultStandards(false)
 *         .tags(tags)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-hub.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-hub.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:59.190Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnHubProps")
@software.amazon.jsii.Jsii.Proxy(CfnHubProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnHubProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether to automatically enable new controls when they are added to standards that are enabled.
     * <p>
     * By default, this is set to <code>true</code> , and new controls are enabled automatically. To not automatically enable new controls, set this to <code>false</code> .
     * <p>
     * When you automatically enable new controls, you can interact with the controls in the console and programmatically immediately after release. However, automatically enabled controls have a temporary default status of <code>DISABLED</code> . It can take up to several days for Security Hub to process the control release and designate the control as <code>ENABLED</code> in your account. During the processing period, you can manually enable or disable a control, and Security Hub will maintain that designation regardless of whether you have <code>AutoEnableControls</code> set to <code>true</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-hub.html#cfn-securityhub-hub-autoenablecontrols">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-hub.html#cfn-securityhub-hub-autoenablecontrols</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoEnableControls() {
        return null;
    }

    /**
     * Specifies whether an account has consolidated control findings turned on or off.
     * <p>
     * If the value for this field is set to <code>SECURITY_CONTROL</code> , Security Hub generates a single finding for a control check even when the check applies to multiple enabled standards.
     * <p>
     * If the value for this field is set to <code>STANDARD_CONTROL</code> , Security Hub generates separate findings for a control check when the check applies to multiple enabled standards.
     * <p>
     * The value for this field in a member account matches the value in the administrator account. For accounts that aren't part of an organization, the default value of this field is <code>SECURITY_CONTROL</code> if you enabled Security Hub on or after February 23, 2023.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-hub.html#cfn-securityhub-hub-controlfindinggenerator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-hub.html#cfn-securityhub-hub-controlfindinggenerator</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getControlFindingGenerator() {
        return null;
    }

    /**
     * Whether to enable the security standards that Security Hub has designated as automatically enabled.
     * <p>
     * If you don't provide a value for <code>EnableDefaultStandards</code> , it is set to <code>true</code> , and the designated standards are automatically enabled in each AWS Region where you enable Security Hub . If you don't want to enable the designated standards, set <code>EnableDefaultStandards</code> to <code>false</code> .
     * <p>
     * Currently, the automatically enabled standards are the Center for Internet Security (CIS) AWS Foundations Benchmark v1.2.0 and AWS Foundational Security Best Practices (FSBP).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-hub.html#cfn-securityhub-hub-enabledefaultstandards">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-hub.html#cfn-securityhub-hub-enabledefaultstandards</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableDefaultStandards() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-hub.html#cfn-securityhub-hub-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-hub.html#cfn-securityhub-hub-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnHubProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnHubProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnHubProps> {
        java.lang.Object autoEnableControls;
        java.lang.String controlFindingGenerator;
        java.lang.Object enableDefaultStandards;
        java.lang.Object tags;

        /**
         * Sets the value of {@link CfnHubProps#getAutoEnableControls}
         * @param autoEnableControls Whether to automatically enable new controls when they are added to standards that are enabled.
         *                           By default, this is set to <code>true</code> , and new controls are enabled automatically. To not automatically enable new controls, set this to <code>false</code> .
         *                           <p>
         *                           When you automatically enable new controls, you can interact with the controls in the console and programmatically immediately after release. However, automatically enabled controls have a temporary default status of <code>DISABLED</code> . It can take up to several days for Security Hub to process the control release and designate the control as <code>ENABLED</code> in your account. During the processing period, you can manually enable or disable a control, and Security Hub will maintain that designation regardless of whether you have <code>AutoEnableControls</code> set to <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoEnableControls(java.lang.Boolean autoEnableControls) {
            this.autoEnableControls = autoEnableControls;
            return this;
        }

        /**
         * Sets the value of {@link CfnHubProps#getAutoEnableControls}
         * @param autoEnableControls Whether to automatically enable new controls when they are added to standards that are enabled.
         *                           By default, this is set to <code>true</code> , and new controls are enabled automatically. To not automatically enable new controls, set this to <code>false</code> .
         *                           <p>
         *                           When you automatically enable new controls, you can interact with the controls in the console and programmatically immediately after release. However, automatically enabled controls have a temporary default status of <code>DISABLED</code> . It can take up to several days for Security Hub to process the control release and designate the control as <code>ENABLED</code> in your account. During the processing period, you can manually enable or disable a control, and Security Hub will maintain that designation regardless of whether you have <code>AutoEnableControls</code> set to <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoEnableControls(software.amazon.awscdk.IResolvable autoEnableControls) {
            this.autoEnableControls = autoEnableControls;
            return this;
        }

        /**
         * Sets the value of {@link CfnHubProps#getControlFindingGenerator}
         * @param controlFindingGenerator Specifies whether an account has consolidated control findings turned on or off.
         *                                If the value for this field is set to <code>SECURITY_CONTROL</code> , Security Hub generates a single finding for a control check even when the check applies to multiple enabled standards.
         *                                <p>
         *                                If the value for this field is set to <code>STANDARD_CONTROL</code> , Security Hub generates separate findings for a control check when the check applies to multiple enabled standards.
         *                                <p>
         *                                The value for this field in a member account matches the value in the administrator account. For accounts that aren't part of an organization, the default value of this field is <code>SECURITY_CONTROL</code> if you enabled Security Hub on or after February 23, 2023.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder controlFindingGenerator(java.lang.String controlFindingGenerator) {
            this.controlFindingGenerator = controlFindingGenerator;
            return this;
        }

        /**
         * Sets the value of {@link CfnHubProps#getEnableDefaultStandards}
         * @param enableDefaultStandards Whether to enable the security standards that Security Hub has designated as automatically enabled.
         *                               If you don't provide a value for <code>EnableDefaultStandards</code> , it is set to <code>true</code> , and the designated standards are automatically enabled in each AWS Region where you enable Security Hub . If you don't want to enable the designated standards, set <code>EnableDefaultStandards</code> to <code>false</code> .
         *                               <p>
         *                               Currently, the automatically enabled standards are the Center for Internet Security (CIS) AWS Foundations Benchmark v1.2.0 and AWS Foundational Security Best Practices (FSBP).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDefaultStandards(java.lang.Boolean enableDefaultStandards) {
            this.enableDefaultStandards = enableDefaultStandards;
            return this;
        }

        /**
         * Sets the value of {@link CfnHubProps#getEnableDefaultStandards}
         * @param enableDefaultStandards Whether to enable the security standards that Security Hub has designated as automatically enabled.
         *                               If you don't provide a value for <code>EnableDefaultStandards</code> , it is set to <code>true</code> , and the designated standards are automatically enabled in each AWS Region where you enable Security Hub . If you don't want to enable the designated standards, set <code>EnableDefaultStandards</code> to <code>false</code> .
         *                               <p>
         *                               Currently, the automatically enabled standards are the Center for Internet Security (CIS) AWS Foundations Benchmark v1.2.0 and AWS Foundational Security Best Practices (FSBP).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDefaultStandards(software.amazon.awscdk.IResolvable enableDefaultStandards) {
            this.enableDefaultStandards = enableDefaultStandards;
            return this;
        }

        /**
         * Sets the value of {@link CfnHubProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnHubProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnHubProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnHubProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnHubProps {
        private final java.lang.Object autoEnableControls;
        private final java.lang.String controlFindingGenerator;
        private final java.lang.Object enableDefaultStandards;
        private final java.lang.Object tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoEnableControls = software.amazon.jsii.Kernel.get(this, "autoEnableControls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.controlFindingGenerator = software.amazon.jsii.Kernel.get(this, "controlFindingGenerator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableDefaultStandards = software.amazon.jsii.Kernel.get(this, "enableDefaultStandards", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoEnableControls = builder.autoEnableControls;
            this.controlFindingGenerator = builder.controlFindingGenerator;
            this.enableDefaultStandards = builder.enableDefaultStandards;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.Object getAutoEnableControls() {
            return this.autoEnableControls;
        }

        @Override
        public final java.lang.String getControlFindingGenerator() {
            return this.controlFindingGenerator;
        }

        @Override
        public final java.lang.Object getEnableDefaultStandards() {
            return this.enableDefaultStandards;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAutoEnableControls() != null) {
                data.set("autoEnableControls", om.valueToTree(this.getAutoEnableControls()));
            }
            if (this.getControlFindingGenerator() != null) {
                data.set("controlFindingGenerator", om.valueToTree(this.getControlFindingGenerator()));
            }
            if (this.getEnableDefaultStandards() != null) {
                data.set("enableDefaultStandards", om.valueToTree(this.getEnableDefaultStandards()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnHubProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnHubProps.Jsii$Proxy that = (CfnHubProps.Jsii$Proxy) o;

            if (this.autoEnableControls != null ? !this.autoEnableControls.equals(that.autoEnableControls) : that.autoEnableControls != null) return false;
            if (this.controlFindingGenerator != null ? !this.controlFindingGenerator.equals(that.controlFindingGenerator) : that.controlFindingGenerator != null) return false;
            if (this.enableDefaultStandards != null ? !this.enableDefaultStandards.equals(that.enableDefaultStandards) : that.enableDefaultStandards != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoEnableControls != null ? this.autoEnableControls.hashCode() : 0;
            result = 31 * result + (this.controlFindingGenerator != null ? this.controlFindingGenerator.hashCode() : 0);
            result = 31 * result + (this.enableDefaultStandards != null ? this.enableDefaultStandards.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
