package software.amazon.awscdk.services.ses;

/**
 * Properties for a dedicated IP pool.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * DedicatedIpPool.Builder.create(this, "Pool")
 *         .dedicatedIpPoolName("mypool")
 *         .scalingMode(ScalingMode.STANDARD)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:59.484Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.DedicatedIpPoolProps")
@software.amazon.jsii.Jsii.Proxy(DedicatedIpPoolProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DedicatedIpPoolProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A name for the dedicated IP pool.
     * <p>
     * The name must adhere to specific constraints: it can only include
     * lowercase letters (a-z), numbers (0-9), underscores (_), and hyphens (-),
     * and must not exceed 64 characters in length.
     * <p>
     * Default: - a CloudFormation generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDedicatedIpPoolName() {
        return null;
    }

    /**
     * The type of scailing mode to use for this IP pool.
     * <p>
     * Updating ScalingMode doesn't require a replacement if you're updating its value from <code>STANDARD</code> to <code>MANAGED</code>.
     * However, updating ScalingMode from <code>MANAGED</code> to <code>STANDARD</code> is not supported.
     * <p>
     * Default: ScalingMode.STANDARD
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.ScalingMode getScalingMode() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DedicatedIpPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DedicatedIpPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DedicatedIpPoolProps> {
        java.lang.String dedicatedIpPoolName;
        software.amazon.awscdk.services.ses.ScalingMode scalingMode;

        /**
         * Sets the value of {@link DedicatedIpPoolProps#getDedicatedIpPoolName}
         * @param dedicatedIpPoolName A name for the dedicated IP pool.
         *                            The name must adhere to specific constraints: it can only include
         *                            lowercase letters (a-z), numbers (0-9), underscores (_), and hyphens (-),
         *                            and must not exceed 64 characters in length.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dedicatedIpPoolName(java.lang.String dedicatedIpPoolName) {
            this.dedicatedIpPoolName = dedicatedIpPoolName;
            return this;
        }

        /**
         * Sets the value of {@link DedicatedIpPoolProps#getScalingMode}
         * @param scalingMode The type of scailing mode to use for this IP pool.
         *                    Updating ScalingMode doesn't require a replacement if you're updating its value from <code>STANDARD</code> to <code>MANAGED</code>.
         *                    However, updating ScalingMode from <code>MANAGED</code> to <code>STANDARD</code> is not supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingMode(software.amazon.awscdk.services.ses.ScalingMode scalingMode) {
            this.scalingMode = scalingMode;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DedicatedIpPoolProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DedicatedIpPoolProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DedicatedIpPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DedicatedIpPoolProps {
        private final java.lang.String dedicatedIpPoolName;
        private final software.amazon.awscdk.services.ses.ScalingMode scalingMode;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dedicatedIpPoolName = software.amazon.jsii.Kernel.get(this, "dedicatedIpPoolName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scalingMode = software.amazon.jsii.Kernel.get(this, "scalingMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.ScalingMode.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dedicatedIpPoolName = builder.dedicatedIpPoolName;
            this.scalingMode = builder.scalingMode;
        }

        @Override
        public final java.lang.String getDedicatedIpPoolName() {
            return this.dedicatedIpPoolName;
        }

        @Override
        public final software.amazon.awscdk.services.ses.ScalingMode getScalingMode() {
            return this.scalingMode;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDedicatedIpPoolName() != null) {
                data.set("dedicatedIpPoolName", om.valueToTree(this.getDedicatedIpPoolName()));
            }
            if (this.getScalingMode() != null) {
                data.set("scalingMode", om.valueToTree(this.getScalingMode()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.DedicatedIpPoolProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DedicatedIpPoolProps.Jsii$Proxy that = (DedicatedIpPoolProps.Jsii$Proxy) o;

            if (this.dedicatedIpPoolName != null ? !this.dedicatedIpPoolName.equals(that.dedicatedIpPoolName) : that.dedicatedIpPoolName != null) return false;
            return this.scalingMode != null ? this.scalingMode.equals(that.scalingMode) : that.scalingMode == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dedicatedIpPoolName != null ? this.dedicatedIpPoolName.hashCode() : 0;
            result = 31 * result + (this.scalingMode != null ? this.scalingMode.hashCode() : 0);
            return result;
        }
    }
}
