package software.amazon.awscdk.services.sns;

/**
 * Options for customising AWS SNS HTTP/S delivery throttling.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Topic myTopic = new Topic(this, "MyTopic");
 * myTopic.addSubscription(
 * UrlSubscription.Builder.create("https://foobar.com/")
 *         .deliveryPolicy(DeliveryPolicy.builder()
 *                 .healthyRetryPolicy(HealthyRetryPolicy.builder()
 *                         .minDelayTarget(Duration.seconds(5))
 *                         .maxDelayTarget(Duration.seconds(10))
 *                         .numRetries(6)
 *                         .backoffFunction(BackoffFunction.EXPONENTIAL)
 *                         .build())
 *                 .throttlePolicy(ThrottlePolicy.builder()
 *                         .maxReceivesPerSecond(10)
 *                         .build())
 *                 .requestPolicy(RequestPolicy.builder()
 *                         .headerContentType("application/json")
 *                         .build())
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:59.574Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.ThrottlePolicy")
@software.amazon.jsii.Jsii.Proxy(ThrottlePolicy.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ThrottlePolicy extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum number of deliveries per second, per subscription.
     * <p>
     * Default: - no throttling
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxReceivesPerSecond() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ThrottlePolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ThrottlePolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ThrottlePolicy> {
        java.lang.Number maxReceivesPerSecond;

        /**
         * Sets the value of {@link ThrottlePolicy#getMaxReceivesPerSecond}
         * @param maxReceivesPerSecond The maximum number of deliveries per second, per subscription.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxReceivesPerSecond(java.lang.Number maxReceivesPerSecond) {
            this.maxReceivesPerSecond = maxReceivesPerSecond;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ThrottlePolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ThrottlePolicy build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ThrottlePolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThrottlePolicy {
        private final java.lang.Number maxReceivesPerSecond;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxReceivesPerSecond = software.amazon.jsii.Kernel.get(this, "maxReceivesPerSecond", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxReceivesPerSecond = builder.maxReceivesPerSecond;
        }

        @Override
        public final java.lang.Number getMaxReceivesPerSecond() {
            return this.maxReceivesPerSecond;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMaxReceivesPerSecond() != null) {
                data.set("maxReceivesPerSecond", om.valueToTree(this.getMaxReceivesPerSecond()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sns.ThrottlePolicy"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ThrottlePolicy.Jsii$Proxy that = (ThrottlePolicy.Jsii$Proxy) o;

            return this.maxReceivesPerSecond != null ? this.maxReceivesPerSecond.equals(that.maxReceivesPerSecond) : that.maxReceivesPerSecond == null;
        }

        @Override
        public final int hashCode() {
            int result = this.maxReceivesPerSecond != null ? this.maxReceivesPerSecond.hashCode() : 0;
            return result;
        }
    }
}
